/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.web.view.component.semester;

import com.opensymphony.xwork2.util.ValueStack;
import freemarker.ext.beans.HashAdapter;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.beanutils.BeanUtils;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.lang.Strings;
import org.beangle.struts2.view.component.Form;
import org.beangle.struts2.view.component.UIBean;
import org.beangle.struts2.view.template.Theme;
import org.openurp.base.edu.model.Project;
import org.openurp.base.edu.model.SchoolYear;
import org.openurp.base.edu.model.Semester;
import org.openurp.web.view.component.semester.ui.SemesterCalendarUI;
import org.openurp.web.view.component.semester.ui.SemesterUIFactory;

public abstract class AbstractSemesterCalendarUI
extends UIBean {
    protected String name;
    protected String label;
    protected String title;
    protected String check;
    protected String multi;
    protected String format;
    protected String uiType;
    protected List<Integer> indexes = CollectUtils.newArrayList();
    protected List<Rule> tRules = CollectUtils.newArrayList();
    protected List<Rule> yRules = CollectUtils.newArrayList();
    public static final SemesterCalendarConfig config = new SemesterCalendarConfig();
    protected String onChange;
    protected String onClick;
    protected String onKeyup;
    protected String onKeypress;
    protected String onKeydown;
    protected String onFocus;
    protected String onBlur;
    protected String beforeInit;
    protected String initCallback;
    protected Object empty;
    protected Object required;
    protected Object value;
    protected Object items;
    protected Object yearRules;
    protected Object termRules;
    protected int valueIndex;
    protected int termIndex;
    protected Project project;
    protected Semester defaultValue;
    protected Map<String, List<Semester>> semesterTree = new TreeMap<String, List<Semester>>(new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            if (o1.equals(o2)) {
                return 0;
            }
            if (o1.equals("")) {
                return -1;
            }
            if (o2.equals("")) {
                return 1;
            }
            return o1.compareTo(o2);
        }
    });

    public AbstractSemesterCalendarUI(ValueStack stack) {
        super(stack);
        try {
            this.loadProperties();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    protected void evaluateParams() {
        Form myform;
        block45: {
            Object newItems;
            if (null == this.id) {
                this.generateIdIfEmpty();
            }
            if (null != this.label) {
                this.label = this.getText(this.label, this.label);
            }
            this.title = null != this.title ? this.getText(this.title) : this.label;
            try {
                if (null != this.yearRules) {
                    this.yRules = Rule.getRules((String)this.yearRules, AbstractSemesterCalendarUI.config.paramTypeMap);
                }
                if (null != this.termRules) {
                    this.tRules.addAll(Rule.getRules((String)this.termRules, AbstractSemesterCalendarUI.config.paramTypeMap));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.required = "true".equals(String.valueOf(this.required));
            this.empty = !"false".equals(String.valueOf(this.empty));
            SemesterCalendarUI semesterCalendarUI = null;
            if (Strings.isBlank((CharSequence)this.uiType)) {
                this.uiType = AbstractSemesterCalendarUI.config.defaultUiType;
            } else {
                semesterCalendarUI = SemesterUIFactory.get(this.uiType);
            }
            if (null != this.items && this.items instanceof Collection) {
                List c = CollectUtils.newArrayList((Collection)((Collection)this.items));
                Collections.sort(c);
                boolean termFormat = null != this.format && this.format.contains("T");
                boolean yearFormat = null != this.format && this.format.matches("^yy(-T)?$");
                boolean formatIsBlank = Strings.isBlank((CharSequence)this.format);
                if (!formatIsBlank && null != this.value) {
                    try {
                        this.value = BeanUtils.cloneBean((Object)this.value);
                        Semester colneValue = (Semester)this.value;
                        if (yearFormat) {
                            colneValue.setYear(new SchoolYear());
                            colneValue.getYear().setName(this.editSchoolYear(colneValue.getSchoolYear()));
                        }
                        if (termFormat) {
                            colneValue.setName(this.editTerm(colneValue.getName()));
                        }
                    }
                    catch (Exception e1) {
                        throw new RuntimeException(e1);
                    }
                }
                for (Semester semester : c) {
                    Semester colneSemester = null;
                    try {
                        colneSemester = termFormat ? (Semester)BeanUtils.cloneBean((Object)semester) : semester;
                    }
                    catch (Exception e1) {
                        throw new RuntimeException(e1);
                    }
                    Object key = "";
                    try {
                        if (!formatIsBlank) {
                            key = (String)key + (yearFormat ? this.editSchoolYear(colneSemester.getSchoolYear()) : colneSemester.getSchoolYear());
                            if (termFormat) {
                                colneSemester.setName(this.editTerm(colneSemester.getName()));
                            }
                        } else {
                            key = (String)key + colneSemester.getSchoolYear();
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    List terms = this.semesterTree.get(key);
                    if (null == terms) {
                        terms = CollectUtils.newArrayList();
                    }
                    this.semesterTree.put((String)key, terms);
                    terms.add(colneSemester);
                }
            }
            if (null != semesterCalendarUI && null != (newItems = semesterCalendarUI.adapteItems(this.semesterTree))) {
                this.items = newItems;
            }
            if (null != this.value) {
                if (this.value instanceof Semester) {
                    semester = (Semester)this.value;
                    for (String schoolYear : this.semesterTree.keySet()) {
                        if (schoolYear.equals(semester.getSchoolYear())) {
                            List<Semester> semesters = this.semesterTree.get(schoolYear);
                            for (Semester semester2 : semesters) {
                                if (semester.equals((Object)semester2)) {
                                    this.defaultValue = semester2;
                                    break block45;
                                }
                                ++this.termIndex;
                            }
                        }
                        ++this.valueIndex;
                    }
                } else if (this.value instanceof HashAdapter) {
                    semester = (HashAdapter)this.value;
                    for (String schoolYear : this.semesterTree.keySet()) {
                        if (schoolYear.equals(semester.get((Object)"schoolYear"))) {
                            List<Semester> semesters = this.semesterTree.get(schoolYear);
                            for (Semester semester2 : semesters) {
                                if (semester.equals((Object)semester2)) {
                                    this.defaultValue = semester2;
                                    break block45;
                                }
                                ++this.termIndex;
                            }
                        }
                        ++this.valueIndex;
                    }
                }
            } else if (Boolean.FALSE.equals(this.empty)) {
                this.valueIndex = 0;
                this.termIndex = 0;
                if (!this.semesterTree.entrySet().isEmpty()) {
                    this.defaultValue = this.semesterTree.entrySet().iterator().next().getValue().get(0);
                }
            } else {
                this.valueIndex = -1;
                this.termIndex = -1;
            }
        }
        if (null != (myform = (Form)this.findAncestor(Form.class))) {
            if ("true".equals(this.required)) {
                myform.addCheck(this.id, "require()");
            }
            if (null != this.check) {
                myform.addCheck(this.id, this.check);
            }
        }
        if (Strings.isNotBlank((CharSequence)this.uiType)) {
            SemesterUIFactory.get(this.uiType);
        }
        if (null == this.project) {
            this.project = (Project)this.getRequest().getAttribute("project");
        }
    }

    private String editSchoolYear(String schoolYear) throws Exception {
        int j = 0;
        StringBuilder schoolYearBuilder = new StringBuilder();
        for (int i = 0; i < schoolYear.length(); ++i) {
            if (j < this.indexes.size()) {
                if (i == this.indexes.get(j)) {
                    i += 2;
                    ++j;
                }
                schoolYearBuilder.append(schoolYear.charAt(i));
                continue;
            }
            schoolYearBuilder.append(schoolYear.charAt(i));
        }
        String result = schoolYearBuilder.toString();
        for (Rule rule : this.yRules) {
            result = rule.invoke(result);
        }
        return result;
    }

    private String editTerm(String term) throws Exception {
        for (Rule rule : this.tRules) {
            term = rule.invoke(term);
        }
        return term;
    }

    private void loadProperties() throws Exception {
        if (!config.isExpired()) {
            return;
        }
        Properties properties = new Properties();
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/eams-ui-default.properties");
        if (null != is) {
            properties.load(is);
        }
        if (null != (is = ((Object)((Object)this)).getClass().getResourceAsStream("/eams-ui.properties"))) {
            properties.load(is);
        }
        Long timeToLiveMills = null;
        String defaultUiType = null;
        for (Map.Entry<Object, Object> property : properties.entrySet()) {
            String key = (String)property.getKey();
            String value = (String)property.getValue();
            if (key.equals("semesterCalendar.properties.timeToLiveSeconds")) {
                timeToLiveMills = Long.parseLong(value.trim()) * 1000L;
                continue;
            }
            if (key.equals("semesterCalendar.type")) {
                defaultUiType = value.trim();
                continue;
            }
            if (key.equals("semesterCalendar.year.indexes")) {
                String[] indexes;
                for (String index : indexes = value.split(",")) {
                    this.indexes.add(Integer.valueOf(index));
                }
                continue;
            }
            if (!key.contains("semesterCalendar.term.method.")) continue;
            String name = key.replace("semesterCalendar.term.method.", "");
            String[] paramsStr = value.split(",");
            Class<?> clazz = AbstractSemesterCalendarUI.config.paramTypeMap.get(name);
            Object[] params = null;
            Class[] parameterTypes = null;
            if (null == clazz) {
                parameterTypes = new Class[]{};
                params = paramsStr;
            } else if (Integer.TYPE == clazz) {
                parameterTypes = new Class[paramsStr.length];
                params = new Integer[paramsStr.length];
                for (int i = 0; i < paramsStr.length; ++i) {
                    parameterTypes[i] = Integer.TYPE;
                    params[i] = Integer.valueOf(paramsStr[i]);
                }
            } else {
                parameterTypes = new Class[paramsStr.length];
                for (int i = 0; i < parameterTypes.length; ++i) {
                    parameterTypes[i] = String.class;
                }
                params = paramsStr;
            }
            Method m = String.class.getDeclaredMethod(name, parameterTypes);
            this.tRules.add(Rule.getRule(m, params));
        }
        config.updateConfig(timeToLiveMills, defaultUiType);
    }

    public boolean isEmptyTree() {
        if (null == this.items) {
            return true;
        }
        if (this.items instanceof Collection) {
            return ((Collection)this.items).isEmpty();
        }
        return this.semesterTree.isEmpty();
    }

    public Map<String, List<Semester>> getSemesterTree() {
        if (this.semesterTree.isEmpty()) {
            this.evaluateParams();
        }
        return this.semesterTree;
    }

    public String getTemplateName() {
        return Theme.getTemplateName(((Object)((Object)this)).getClass());
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Object getRequired() {
        return this.required;
    }

    public void setRequired(Object required) {
        this.required = required;
    }

    public String getCheck() {
        return this.check;
    }

    public void setCheck(String check) {
        this.check = check;
    }

    public Object getEmpty() {
        return this.empty;
    }

    public void setEmpty(Object empty) {
        this.empty = empty;
    }

    public String getMulti() {
        return this.multi;
    }

    public void setMulti(String multi) {
        this.multi = multi;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setItems(Object items) {
        this.items = items;
    }

    public Object getItems() {
        return this.items;
    }

    public void setSemesterTree(Map<String, List<Semester>> semesterTree) {
        this.semesterTree = semesterTree;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public List<Integer> getIndexes() {
        return this.indexes;
    }

    public void setIndexes(List<Integer> indexes) {
        this.indexes = indexes;
    }

    public void setYearRules(Object yearRules) {
        this.yearRules = yearRules;
    }

    public void setTermRules(Object termRules) {
        this.termRules = termRules;
    }

    public String getOnChange() {
        return this.onChange;
    }

    public void setOnChange(String onChange) {
        this.onChange = onChange;
    }

    public int getValueIndex() {
        return this.valueIndex;
    }

    public void setValueIndex(int valueIndex) {
        this.valueIndex = valueIndex;
    }

    public int getTermIndex() {
        return this.termIndex;
    }

    public void setTermIndex(int termIndex) {
        this.termIndex = termIndex;
    }

    public Semester getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Semester defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getInitCallback() {
        return this.initCallback;
    }

    public void setInitCallback(String initCallback) {
        this.initCallback = initCallback;
    }

    public String getUiType() {
        return this.uiType;
    }

    public void setUiType(String uiType) {
        this.uiType = uiType;
    }

    public String getOnClick() {
        return this.onClick;
    }

    public void setOnClick(String onClick) {
        this.onClick = onClick;
    }

    public String getOnKeyup() {
        return this.onKeyup;
    }

    public void setOnKeyup(String onKeyup) {
        this.onKeyup = onKeyup;
    }

    public String getOnKeypress() {
        return this.onKeypress;
    }

    public void setOnKeypress(String onKeypress) {
        this.onKeypress = onKeypress;
    }

    public String getOnKeydown() {
        return this.onKeydown;
    }

    public void setOnKeydown(String onKeydown) {
        this.onKeydown = onKeydown;
    }

    public String getOnFocus() {
        return this.onFocus;
    }

    public void setOnFocus(String onFocus) {
        this.onFocus = onFocus;
    }

    public String getOnBlur() {
        return this.onBlur;
    }

    public void setOnBlur(String onBlur) {
        this.onBlur = onBlur;
    }

    public String getBeforeInit() {
        return this.beforeInit;
    }

    public void setBeforeInit(String beforeInit) {
        this.beforeInit = beforeInit;
    }

    private static class SemesterCalendarConfig {
        private String defaultUiType = "";
        private long timeToLiveMills;
        private long loadAt = -1L;
        protected Map<String, Class<?>> paramTypeMap = CollectUtils.newHashMap();

        private SemesterCalendarConfig() {
            this.paramTypeMap.put("concat", String.class);
            this.paramTypeMap.put("replace", CharSequence.class);
            this.paramTypeMap.put("replaceAll", String.class);
            this.paramTypeMap.put("replaceFirst", String.class);
            this.paramTypeMap.put("substring", Integer.TYPE);
            this.paramTypeMap.put("subSequence", Integer.TYPE);
            this.paramTypeMap.put("charAt", Integer.TYPE);
        }

        private void updateConfig(Long timeToLiveMills, String defaultUiType) {
            if (null == timeToLiveMills) {
                timeToLiveMills = TimeUnit.MINUTES.toMillis(30L);
            }
            this.timeToLiveMills = timeToLiveMills;
            if (null == defaultUiType) {
                this.defaultUiType = "";
            } else {
                try {
                    SemesterUIFactory.get(defaultUiType);
                    this.defaultUiType = defaultUiType;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.loadAt = System.currentTimeMillis();
        }

        private boolean isExpired() {
            return System.currentTimeMillis() - (this.loadAt + this.timeToLiveMills) > 0L;
        }
    }

    private static class Rule {
        private Method method;
        private Object[] params;

        public Rule(Method method, Object[] params) {
            this.method = method;
            this.params = params;
        }

        public static Rule getRule(Method method, Object[] params) {
            return new Rule(method, params);
        }

        public static List<Rule> getRules(String rulesStr, Map<String, Class<?>> paramTypeMap) throws Exception {
            String[] rules;
            List result = CollectUtils.newArrayList();
            for (String s : rules = rulesStr.split(":")) {
                String[] entry = s.substring(0, s.length() - 1).split("\\(");
                String name = entry[0];
                String[] paramsStr = entry[1].split(",");
                Class<?> c = paramTypeMap.get(name);
                Object[] params = null;
                Class[] parameterTypes = null;
                if (null == c) {
                    parameterTypes = new Class[]{};
                    params = paramsStr;
                } else if (Integer.TYPE == c) {
                    parameterTypes = new Class[paramsStr.length];
                    params = new Integer[paramsStr.length];
                    for (int i = 0; i < paramsStr.length; ++i) {
                        parameterTypes[i] = c;
                        params[i] = Integer.valueOf(paramsStr[i]);
                    }
                } else {
                    parameterTypes = new Class[paramsStr.length];
                    for (int i = 0; i < parameterTypes.length; ++i) {
                        parameterTypes[i] = c;
                    }
                    params = paramsStr;
                }
                Method m = String.class.getDeclaredMethod(name, parameterTypes);
                result.add(Rule.getRule(m, params));
            }
            return result;
        }

        public String invoke(Object obj) throws Exception {
            return String.valueOf(this.method.invoke(obj, this.params));
        }
    }
}

