/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.ws.grade;

import java.io.Serializable;
import java.time.LocalDate;
import org.beangle.commons.lang.time.Stopwatch;
import org.beangle.commons.logging.Logger$;
import org.beangle.commons.logging.Logging;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryPage;
import org.beangle.data.dao.QueryPage$;
import org.beangle.data.orm.hibernate.DaoJob;
import org.beangle.data.orm.hibernate.SessionHelper$;
import org.openurp.base.model.Project;
import org.openurp.base.service.ProjectConfigService;
import org.openurp.base.std.model.Student;
import org.openurp.edu.grade.service.AuditPlanService;
import org.openurp.edu.service.Features;
import org.slf4j.Logger;
import scala.Function1;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public class AutoAuditJob
extends DaoJob
implements Logging {
    private Logger logger;
    private AuditPlanService auditPlanService;
    private ProjectConfigService projectConfigService;

    public AutoAuditJob() {
        Logging.$init$((Logging)this);
        Statics.releaseFence();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public AuditPlanService auditPlanService() {
        return this.auditPlanService;
    }

    public void auditPlanService_$eq(AuditPlanService x$1) {
        this.auditPlanService = x$1;
    }

    public ProjectConfigService projectConfigService() {
        return this.projectConfigService;
    }

    public void projectConfigService_$eq(ProjectConfigService x$1) {
        this.projectConfigService = x$1;
    }

    public void execute() {
        Seq projects = (Seq)this.entityDao().getAll(Project.class).filter((Function1 & Serializable)_$3 -> _$3.active());
        projects.foreach((Function1)(JProcedure1 & Serializable)p -> {
            boolean autoAudit = BoxesRunTime.unboxToBoolean((Object)this.projectConfigService().get(p, Features.Grade$.MODULE$.AutoAuditPlan(), ClassTag$.MODULE$.apply(Boolean.TYPE)));
            if (autoAudit) {
                Logger$.MODULE$.info$extension(this.logger(), () -> AutoAuditJob.execute$$anonfun$1$$anonfun$1(p));
                OqlBuilder query = OqlBuilder$.MODULE$.from(Student.class, "s");
                query.where("s.state.beginOn <= :now and s.state.endOn >=:now", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
                query.where("s.state.inschool=true", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                query.where("s.project=:project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{p}));
                query.orderBy("s.code");
                query.limit(1, 100);
                Stopwatch sw0 = new Stopwatch(true);
                Stopwatch sw = new Stopwatch(true);
                IntRef cnt = IntRef.create((int)0);
                boolean i = false;
                ObjectRef startCode = ObjectRef.create(null);
                QueryPage results = QueryPage$.MODULE$.apply(query, this.entityDao());
                results.foreach((Function1)(JProcedure1 & Serializable)std -> {
                    int n;
                    if ((String)startCode$1.elem == null) {
                        String string = std.code();
                        startCode$1.elem = string;
                        string = null;
                    }
                    this.auditPlanService().audit(std, (Map)Predef$.MODULE$.Map().empty(), true);
                    cnt$1.elem = n = cnt$1.elem + 1;
                    if (cnt$1.elem % 100 == 0) {
                        SessionHelper$.MODULE$.currentSession(this.sessionFactory()).session().clear();
                        Logger$.MODULE$.info$extension(this.logger(), () -> AutoAuditJob.execute$$anonfun$1$$anonfun$2$$anonfun$1(startCode, std, sw));
                        sw.reset().start();
                        Object var7_7 = null;
                        startCode$1.elem = null;
                        return;
                    }
                });
                Logger$.MODULE$.info$extension(this.logger(), () -> AutoAuditJob.execute$$anonfun$1$$anonfun$3(cnt, sw0));
                return;
            }
        });
    }

    private static final String execute$$anonfun$1$$anonfun$1(Project p$1) {
        return "start auto auditing project " + p$1.code();
    }

    private static final String execute$$anonfun$1$$anonfun$2$$anonfun$1(ObjectRef startCode$2, Student std$1, Stopwatch sw$2) {
        return "audit " + (String)startCode$2.elem + "~" + std$1.code() + " using " + sw$2;
    }

    private static final String execute$$anonfun$1$$anonfun$3(IntRef cnt$2, Stopwatch sw0$1) {
        return "end auto auditing, total " + cnt$2.elem + " using " + sw0$1;
    }
}

