/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.plan.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.pojo.LongIdObject;
import org.beangle.commons.lang.Numbers;
import org.beangle.commons.lang.Strings;
import org.openurp.edu.base.code.model.CourseType;
import org.openurp.edu.program.plan.model.CourseGroup;
import org.openurp.edu.program.plan.model.CoursePlan;
import org.openurp.edu.program.plan.model.PlanCourse;
import org.openurp.edu.program.plan.util.PlanUtils;

@MappedSuperclass
public abstract class AbstractCourseGroup
extends LongIdObject
implements CourseGroup,
Cloneable {
    private static final long serialVersionUID = 1347767253840431206L;
    protected short subCount;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    protected CourseType courseType;
    private float credits;
    private short courseCount;
    @Size(max=2000)
    private String remark;
    private String termCredits;
    @Size(max=30)
    @NotNull
    private String indexno;

    @Override
    public String getName() {
        return null == this.courseType ? null : this.courseType.getName();
    }

    @Override
    public int getIndex() {
        int idx;
        String index = Strings.substringAfterLast((String)this.indexno, (String)".");
        if (Strings.isEmpty((CharSequence)index)) {
            index = this.indexno;
        }
        if ((idx = Numbers.toInt((String)index)) <= 0) {
            idx = 1;
        }
        return idx;
    }

    @Override
    public boolean isCompulsory() {
        if (CollectUtils.isEmpty((Collection)this.getChildren()) && CollectUtils.isEmpty((Collection)this.getPlanCourses())) {
            return false;
        }
        boolean isCompulsory = true;
        if (CollectUtils.isNotEmpty((Collection)this.getChildren()) && this.getChildren().size() > 1) {
            isCompulsory &= this.getChildren().size() == this.subCount;
        }
        if (!isCompulsory) {
            return isCompulsory;
        }
        if (CollectUtils.isNotEmpty((Collection)this.getPlanCourses())) {
            for (PlanCourse pcourse : this.getPlanCourses()) {
                isCompulsory &= pcourse.isCompulsory();
            }
        }
        return isCompulsory;
    }

    @Override
    public short getSubCount() {
        return this.subCount;
    }

    @Override
    public void setSubCount(short subCount) {
        this.subCount = subCount;
    }

    @Override
    public void addChildGroup(CourseGroup group) {
        group.setParent(this);
        this.getChildren().add(group);
    }

    @Override
    public void addPlanCourse(PlanCourse planCourse) {
        for (PlanCourse planCourse1 : this.getPlanCourses()) {
            if (!planCourse.getCourse().equals((Object)planCourse1.getCourse())) continue;
            return;
        }
        planCourse.setGroup(this);
        this.getPlanCourses().add(planCourse);
    }

    @Override
    public void removePlanCourse(PlanCourse course) {
        this.getPlanCourses().remove(course);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AbstractCourseGroup courseGroup = (AbstractCourseGroup)super.clone();
        courseGroup.setId(null);
        List groups = courseGroup.getChildren();
        List groupClones = CollectUtils.newArrayList();
        for (CourseGroup cg : groups) {
            CourseGroup groupClone = (CourseGroup)cg.clone();
            groupClones.add(groupClone);
            groupClone.setParent(courseGroup);
        }
        courseGroup.setChildren(groupClones);
        courseGroup.setPlanCourses(new ArrayList());
        for (PlanCourse planCourse : this.getPlanCourses()) {
            courseGroup.addPlanCourse((PlanCourse)planCourse.clone());
        }
        return courseGroup;
    }

    @Override
    public CourseType getCourseType() {
        return this.courseType;
    }

    @Override
    public void setCourseType(CourseType courseType) {
        this.courseType = courseType;
    }

    @Override
    public String getRemark() {
        return this.remark;
    }

    @Override
    public void setRemark(String remark) {
        this.remark = remark;
    }

    @Override
    public float getCredits() {
        return this.credits;
    }

    @Override
    public void setCredits(float credits) {
        this.credits = credits;
    }

    @Override
    public short getCourseCount() {
        return this.courseCount;
    }

    @Override
    public void setCourseCount(short courseCount) {
        this.courseCount = courseCount;
    }

    @Override
    public String getTermCredits() {
        return this.termCredits;
    }

    @Override
    public void setTermCredits(String termCredits) {
        this.termCredits = termCredits;
    }

    @Override
    public String getIndexno() {
        return this.indexno;
    }

    @Override
    public void setIndexno(String indexno) {
        this.indexno = indexno;
    }

    @Override
    public void addPlanCourses(List<PlanCourse> planCourses) {
        for (PlanCourse element : planCourses) {
            boolean finded = false;
            for (PlanCourse element2 : planCourses) {
                if (!((Long)element.getCourse().getId()).equals(element2.getCourse().getId())) continue;
                finded = true;
                break;
            }
            if (finded) continue;
            element.setGroup(this);
            planCourses.add(element);
        }
    }

    @Override
    public void updateCoursePlan(CoursePlan plan) {
        this.setPlan(plan);
        if (this.getChildren() != null) {
            for (CourseGroup group : this.getChildren()) {
                group.updateCoursePlan(plan);
            }
        }
    }

    public List<PlanCourse> getPlanCourses(String terms) {
        if (Strings.isEmpty((CharSequence)terms)) {
            return new ArrayList<PlanCourse>(this.getPlanCourses());
        }
        Set result = CollectUtils.newHashSet();
        Integer[] termSeq = Strings.splitToInt((String)terms);
        for (int i = 0; i < termSeq.length; ++i) {
            result.addAll(PlanUtils.getPlanCourses(this, (int)termSeq[i]));
        }
        return new ArrayList<PlanCourse>(result);
    }

    @Override
    public int compareTo(CourseGroup o) {
        return this.getIndexno().compareTo(o.getIndexno());
    }
}

