/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.service.impl;

import java.io.Serializable;
import org.beangle.commons.bean.Properties$;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Numbers$;
import org.beangle.commons.lang.Objects$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.model.Entity;
import org.openurp.base.edu.model.Course;
import org.openurp.code.edu.model.TeachingNature;
import org.openurp.code.service.CodeService;
import org.openurp.edu.program.model.AbstractCourseGroup;
import org.openurp.edu.program.model.AbstractCoursePlan;
import org.openurp.edu.program.model.AbstractPlanCourse;
import org.openurp.edu.program.model.CourseGroup;
import org.openurp.edu.program.model.CoursePlan;
import org.openurp.edu.program.model.CreditHours$;
import org.openurp.edu.program.model.PlanCourse;
import org.openurp.edu.program.model.PlanCourseOrdering$;
import org.openurp.edu.program.service.PlanDiff;
import org.openurp.edu.program.service.PlanDiff$Group$;
import org.openurp.edu.program.service.PlanDiff$GroupDiff$;
import org.openurp.edu.program.service.PlanGroupStat;
import org.openurp.edu.program.service.PlanGroupStat$;
import org.openurp.edu.program.service.PlanService;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class PlanServiceImpl
implements PlanService {
    private EntityDao entityDao;
    private CodeService codeService;

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public CodeService codeService() {
        return this.codeService;
    }

    public void codeService_$eq(CodeService x$1) {
        this.codeService = x$1;
    }

    @Override
    public void move(CourseGroup node, CourseGroup location, int index) {
        if (Objects$.MODULE$.equals(node.parent().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)location)) {
            if (Numbers$.MODULE$.toInt(node.indexno(), Numbers$.MODULE$.toInt$default$2()) != index) {
                this.shiftCode(node, location, index);
                return;
            }
            return;
        }
        Properties$.MODULE$.set((Object)node, "parent", (Object)location);
        this.entityDao().saveOrUpdate((Object)node, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CourseGroup[0]));
        this.entityDao().refresh((Object)node);
        this.entityDao().refresh((Object)location);
        this.entityDao().refresh((Object)location.plan());
        this.shiftCode(node, location, index);
    }

    @Override
    public float statPlanCredits(CoursePlan plan) {
        this.entityDao().refresh((Object)plan);
        PlanGroupStat stat = PlanGroupStat$.MODULE$.stat(plan, (Seq<TeachingNature>)this.codeService().get(TeachingNature.class));
        stat.updates().foreach((Function1)(JProcedure1 & Serializable)gs -> {
            AbstractCourseGroup group = (AbstractCourseGroup)gs.group();
            group.credits_$eq(gs.credits());
            group.creditHours_$eq(gs.creditHours());
            group.hourRatios_$eq(gs.hourRatios());
            group.termCredits_$eq(gs.termCreditString());
            group.terms_$eq(gs.terms());
        });
        Properties$.MODULE$.set((Object)plan, "credits", (Object)BoxesRunTime.boxToFloat((float)stat.credits()));
        CoursePlan coursePlan = plan;
        if (coursePlan instanceof AbstractCoursePlan) {
            AbstractCoursePlan mp = (AbstractCoursePlan)coursePlan;
            mp.credits_$eq(stat.credits());
            mp.creditHours_$eq(stat.creditHours());
            mp.hourRatios_$eq(CreditHours$.MODULE$.toRatios(stat.hours()));
            mp.program().credits_$eq(plan.credits());
        }
        this.entityDao().saveOrUpdate((Object)plan, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Cloneable[]{plan.program()}));
        this.entityDao().evict((Entity)plan);
        this.entityDao().evict((Entity)plan.program());
        return plan.credits();
    }

    @Override
    public void addCourseGroupToPlan(CourseGroup group, CourseGroup parent, CoursePlan plan) {
        plan.addGroup(group, Option$.MODULE$.apply((Object)parent));
        this.entityDao().saveOrUpdate((Object)group, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CourseGroup[0]));
        this.entityDao().saveOrUpdate((Object)plan, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CoursePlan[0]));
        this.statPlanCredits(plan);
    }

    private void addCourse(PlanCourse planCourse, AbstractCourseGroup group) {
        Buffer buf = group.planCourses();
        buf.subtractOne((Object)planCourse);
        buf = (Buffer)buf.sorted((Ordering)PlanCourseOrdering$.MODULE$);
        int firstTerm = planCourse.terms().first();
        int idx = planCourse.idx();
        if (idx < 0) {
            idx = 0;
        }
        if (idx >= buf.size()) {
            idx = buf.size() + 1;
        } else if (idx == 0) {
            for (int i = 0; i < buf.size(); ++i) {
                PlanCourse pc2 = (PlanCourse)buf.apply(i);
                int myFirst = pc2.terms().first();
                if (myFirst < firstTerm || myFirst == firstTerm && StringOps$.MODULE$.compare$extension(Predef$.MODULE$.augmentString(pc2.course().code()), planCourse.course().code()) < 0) continue;
                idx = i + 1;
                i = buf.size();
            }
            if (idx == 0) {
                idx = buf.size() + 1;
            }
        }
        buf.insert(idx - 1, (Object)planCourse);
        IntRef i = IntRef.create((int)1);
        buf.foreach((Function1)(JProcedure1 & Serializable)pc -> {
            int n;
            ((AbstractPlanCourse)pc).idx_$eq((short)i$1.elem);
            i$1.elem = n = i$1.elem + 1;
        });
        group.planCourses().addOne((Object)planCourse);
    }

    @Override
    public void addPlanCourse(PlanCourse planCourse, CourseGroup group) {
        AbstractCourseGroup cg = (AbstractCourseGroup)group;
        AbstractPlanCourse pc = (AbstractPlanCourse)planCourse;
        pc.course_$eq((Course)this.entityDao().get(Course.class, pc.course().id()));
        pc.group_$eq((CourseGroup)cg);
        this.addCourse((PlanCourse)pc, cg);
        this.entityDao().saveOrUpdate((Object)cg, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractCourseGroup[0]));
        this.statPlanCredits(cg.plan());
    }

    @Override
    public void removePlanCourse(PlanCourse planCourse, CourseGroup group) {
        AbstractCourseGroup cg = (AbstractCourseGroup)group;
        cg.planCourses().subtractOne((Object)planCourse);
        this.entityDao().saveOrUpdate((Object)cg, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractCourseGroup[0]));
        this.statPlanCredits(cg.plan());
    }

    @Override
    public void updatePlanCourse(PlanCourse planCourse, CourseGroup group) {
        AbstractCourseGroup cg = (AbstractCourseGroup)group;
        this.addCourse(planCourse, cg);
        this.entityDao().saveOrUpdate((Object)cg, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractCourseGroup[0]));
        this.statPlanCredits(cg.plan());
    }

    private void shiftCode(CourseGroup node, CourseGroup newParent, int index2) {
        Buffer sibling = newParent != null ? (Buffer)newParent.children().toBuffer().sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())) : (Buffer)node.plan().topGroups().toBuffer().sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        sibling.subtractOne((Object)node);
        int index = index2;
        if (--index > sibling.size()) {
            index = sibling.size();
        }
        sibling.insert(index, (Object)node);
        int nolength = String.valueOf(sibling.size()).length();
        scala.collection.mutable.Set nodes = Collections$.MODULE$.newSet();
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), sibling.size()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)seqno -> {
            CourseGroup one = (CourseGroup)sibling.apply(seqno - 1);
            this.generateCode(one, Strings$.MODULE$.leftPad(String.valueOf(seqno), nolength, '0'), (scala.collection.mutable.Set<CourseGroup>)nodes);
        });
        this.entityDao().saveOrUpdate((Iterable)nodes);
        this.entityDao().refresh((Object)node);
        this.entityDao().refresh((Object)node.plan());
    }

    public void genIndexno(CourseGroup group, String indexno) {
        String newIndexno = group.parent().isEmpty() ? indexno : (Strings$.MODULE$.isEmpty((CharSequence)indexno) ? Strings$.MODULE$.concat((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{((CourseGroup)group.parent().get()).indexno(), ".", String.valueOf(this.index(group))})) : Strings$.MODULE$.concat((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{((CourseGroup)group.parent().get()).indexno(), ".", indexno})));
        Properties$.MODULE$.set((Object)group, "indexno", (Object)newIndexno);
    }

    private void generateCode(CourseGroup node, String indexno, scala.collection.mutable.Set<CourseGroup> nodes) {
        if (!nodes.contains((Object)node)) {
            nodes.add((Object)node);
            if (indexno != null) {
                this.genIndexno(node, indexno);
            } else {
                this.genIndexno(node, null);
            }
            node.children().foreach((Function1)(JProcedure1 & Serializable)c -> this.generateCode((CourseGroup)c, null, nodes));
            return;
        }
    }

    private int index(CourseGroup group) {
        int idx;
        String index = Strings$.MODULE$.substringAfterLast(group.indexno(), ".");
        if (Strings$.MODULE$.isEmpty((CharSequence)index)) {
            index = group.indexno();
        }
        if ((idx = Numbers$.MODULE$.toInt(index, Numbers$.MODULE$.toInt$default$2())) <= 0) {
            idx = 1;
        }
        return idx;
    }

    @Override
    public scala.collection.immutable.Seq<PlanDiff.GroupDiff> diff(CoursePlan left, CoursePlan right) {
        Buffer diffs = Collections$.MODULE$.newBuffer();
        ((IterableOnceOps)left.groups().sortBy((Function1 & Serializable)_$3 -> _$3.indexno(), (Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable)g -> {
            Option matched = right.getGroup(g.name());
            if (matched.isEmpty()) {
                return diffs.addOne((Object)PlanDiff$GroupDiff$.MODULE$.apply(g.indexno(), g.name(), (scala.collection.immutable.Seq<Tuple2<PlanCourse, PlanCourse>>)package$.MODULE$.List().empty(), (Option<PlanDiff.Group>)Some$.MODULE$.apply((Object)PlanDiff$Group$.MODULE$.apply(g.credits(), (scala.collection.immutable.Seq<PlanCourse>)g.planCourses().toSeq())), (Option<PlanDiff.Group>)None$.MODULE$));
            }
            Map leftPcs = ((IterableOnceOps)g.planCourses().map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply((Object)x.course(), x))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Map rightPcs = ((IterableOnceOps)((CourseGroup)matched.get()).planCourses().map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply((Object)x.course(), x))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            scala.collection.immutable.Set leftCourses = (scala.collection.immutable.Set)leftPcs.keys().toSet().$minus$minus((IterableOnce)rightPcs.keys());
            scala.collection.immutable.Set rightCourses = (scala.collection.immutable.Set)rightPcs.keys().toSet().$minus$minus((IterableOnce)leftPcs.keys());
            Buffer leftPlanCourses = ((MapOps)leftPcs.filter((Function1 & Serializable)x -> leftCourses.contains(x._1()))).values().toBuffer();
            Buffer rightPlanCourses = ((MapOps)rightPcs.filter((Function1 & Serializable)x -> rightCourses.contains(x._1()))).values().toBuffer();
            scala.collection.immutable.Set commons = (scala.collection.immutable.Set)leftPcs.keys().toSet().intersect((Set)rightPcs.keys().toSet());
            Buffer commonsPcs = Collections$.MODULE$.newBuffer();
            commons.foreach((Function1)(JProcedure1 & Serializable)common -> {
                PlanCourse lpc = (PlanCourse)leftPcs.apply(common);
                PlanCourse rpc = (PlanCourse)rightPcs.apply(common);
                if (lpc.terms().value() != rpc.terms().value()) {
                    commonsPcs.addOne((Object)Tuple2$.MODULE$.apply((Object)lpc, (Object)rpc));
                    return;
                }
            });
            if (leftPlanCourses.nonEmpty() || rightPlanCourses.nonEmpty()) {
                diffs.addOne((Object)PlanDiff$GroupDiff$.MODULE$.apply(g.indexno(), g.name(), (scala.collection.immutable.Seq<Tuple2<PlanCourse, PlanCourse>>)commonsPcs.toSeq(), (Option<PlanDiff.Group>)Some$.MODULE$.apply((Object)PlanDiff$Group$.MODULE$.apply(g.credits(), (scala.collection.immutable.Seq<PlanCourse>)leftPlanCourses.toSeq())), (Option<PlanDiff.Group>)Some$.MODULE$.apply((Object)PlanDiff$Group$.MODULE$.apply(((CourseGroup)matched.get()).credits(), (scala.collection.immutable.Seq<PlanCourse>)rightPlanCourses.toSeq()))));
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        });
        ((IterableOnceOps)right.groups().sortBy((Function1 & Serializable)_$4 -> _$4.indexno(), (Ordering)Ordering.String$.MODULE$)).foreach((Function1)(JProcedure1 & Serializable)g -> {
            Option matched = left.getGroup(g.name());
            if (matched.isEmpty()) {
                diffs.addOne((Object)PlanDiff$GroupDiff$.MODULE$.apply(g.indexno(), g.name(), (scala.collection.immutable.Seq<Tuple2<PlanCourse, PlanCourse>>)package$.MODULE$.List().empty(), (Option<PlanDiff.Group>)None$.MODULE$, (Option<PlanDiff.Group>)Some$.MODULE$.apply((Object)PlanDiff$Group$.MODULE$.apply(g.credits(), (scala.collection.immutable.Seq<PlanCourse>)g.planCourses().toSeq()))));
                return;
            }
        });
        return ((IterableOnceOps)diffs.sortBy((Function1 & Serializable)_$5 -> _$5.indexno(), (Ordering)Ordering.String$.MODULE$)).toSeq();
    }
}

