/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.web.helper;

import org.beangle.data.dao.EntityDao;
import org.beangle.template.freemarker.ProfileTemplateLoader$;
import org.beangle.web.action.context.ActionContext$;
import org.openurp.base.model.Project;
import org.openurp.base.service.Feature;
import org.openurp.base.service.ProjectConfigService;
import org.openurp.code.Code;
import org.openurp.code.edu.model.ProgramCourseTag;
import org.openurp.code.edu.model.TeachingNature;
import org.openurp.code.service.CodeService;
import org.openurp.edu.program.model.CoursePlan;
import org.openurp.edu.program.model.MajorPlan;
import org.openurp.edu.program.model.Program;
import org.openurp.edu.program.model.ProgramDoc;
import org.openurp.edu.program.service.PlanCategoryStat;
import org.openurp.edu.program.service.PlanCategoryStat$;
import org.openurp.edu.program.service.TermHelper;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.LazyRef;

public class ProgramInfoHelper {
    private final EntityDao entityDao;
    private final ProjectConfigService configService;
    private final CodeService codeService;

    public ProgramInfoHelper(EntityDao entityDao, ProjectConfigService configService, CodeService codeService) {
        this.entityDao = entityDao;
        this.configService = configService;
        this.codeService = codeService;
    }

    public void prepareData(Program program) {
        LazyRef lazyRef = new LazyRef();
        this.put("program", program);
        MajorPlan plan = (MajorPlan)this.entityDao.findBy(MajorPlan.class, "program", (Object)program).head();
        this.put("plan", plan);
        this.put("doc", this.entityDao.findBy(ProgramDoc.class, "program", (Object)program).headOption());
        ProfileTemplateLoader$.MODULE$.setProfile((Object)(ProgramInfoHelper.project$1(lazyRef, program).school().id() + "/" + ProgramInfoHelper.project$1(lazyRef, program).id()));
        Seq<TeachingNature> natures = this.getCodes(TeachingNature.class, ProgramInfoHelper.project$1(lazyRef, program));
        this.put("natures", natures);
        this.put("tags", this.getCodes(ProgramCourseTag.class, ProgramInfoHelper.project$1(lazyRef, program)));
        this.put("termHelper", new TermHelper());
        PlanCategoryStat stat = PlanCategoryStat$.MODULE$.stat((CoursePlan)plan, natures);
        this.put("stat", stat);
    }

    public <T extends Code> Seq<T> getCodes(Class<T> clazz, Project project) {
        return this.codeService.get(clazz);
    }

    public Object getConfig(Feature f, Project project) {
        return this.configService.get(project, f, ClassTag$.MODULE$.Any());
    }

    private void put(String name, Object v) {
        ActionContext$.MODULE$.current().attribute(name, v);
    }

    private static final Project project$lzyINIT1$1(LazyRef project$lzy1$1, Program program$1) {
        Project project;
        LazyRef lazyRef = project$lzy1$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy1$1.initialized() ? project$lzy1$1.value() : project$lzy1$1.initialize((Object)program$1.project()));
        }
        return project;
    }

    private static final Project project$1(LazyRef project$lzy1$2, Program program$2) {
        return (Project)(project$lzy1$2.initialized() ? project$lzy1$2.value() : ProgramInfoHelper.project$lzyINIT1$1(project$lzy1$2, program$2));
    }
}

