/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.service;

import java.io.Serializable;
import org.beangle.commons.collection.Collections$;
import org.openurp.base.edu.model.Course;
import org.openurp.base.edu.model.CourseJournal;
import org.openurp.base.edu.model.Terms$;
import org.openurp.base.std.model.Grade;
import org.openurp.code.edu.model.EducationLevel;
import org.openurp.edu.program.model.CourseGroup;
import org.openurp.edu.program.model.MajorPlanCourse;
import org.openurp.edu.program.model.PlanCourse;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public class PlanCourseCluster {
    public Iterable<PlanCourse> cluster(CourseGroup group) {
        Seq planCourses = group.orderedPlanCourses();
        Set clusters = ((IterableOnceOps)planCourses.flatten((Function1 & Serializable)_$1 -> _$1.course().cluster())).toSet();
        if (clusters.isEmpty()) {
            return planCourses;
        }
        Map courseMap = ((IterableOnceOps)planCourses.map((Function1 & Serializable)pc -> Tuple2$.MODULE$.apply((Object)pc.course(), pc))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Set courseSet = courseMap.keySet();
        Set filterClusters = (Set)clusters.filter((Function1 & Serializable)c -> c.courses().forall((Function1 & Serializable)elem -> courseSet.contains(elem)));
        if (filterClusters.isEmpty()) {
            return planCourses;
        }
        EducationLevel level = group.plan().program().level();
        Grade grade = group.plan().program().grade();
        scala.collection.mutable.Map course2Clusters = Collections$.MODULE$.newMap();
        filterClusters.map((Function1 & Serializable)c -> {
            Iterable fcs = ((MapOps)courseMap.filter((Function1 & Serializable)x -> c.courses().contains(x._1()))).values();
            Iterable journals = (Iterable)fcs.map((Function1 & Serializable)_$2 -> _$2.course().getJournal(grade));
            CourseJournal first = (CourseJournal)journals.head();
            Course tc = new Course();
            scala.collection.immutable.Seq codes = (scala.collection.immutable.Seq)((IterableOnceOps)fcs.map((Function1 & Serializable)_$3 -> _$3.course().code())).toSeq().sorted((Ordering)Ordering.String$.MODULE$);
            if (codes.size() > 2) {
                tc.code_$eq(codes.head() + "\n~\n" + codes.last());
            } else if (codes.size() == 2) {
                tc.code_$eq(codes.head() + "\n" + codes.last());
            } else {
                tc.code_$eq((String)codes.head());
            }
            tc.name_$eq(c.name());
            tc.nature_$eq(((PlanCourse)fcs.head()).course().nature());
            tc.enName_$eq(c.enName());
            tc.defaultCredits_$eq(BoxesRunTime.unboxToFloat((Object)((IterableOnceOps)fcs.map((Function1 & Serializable)_$4 -> _$4.course().getCredits(level))).sum((Numeric)Numeric.FloatIsFractional$.MODULE$)));
            tc.examMode_$eq(first.examMode());
            tc.department_$eq(first.department());
            tc.creditHours_$eq(BoxesRunTime.unboxToInt((Object)((IterableOnceOps)journals.map((Function1 & Serializable)_$5 -> _$5.creditHours())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)));
            tc.weekHours_$eq(first.weekHours());
            journals.foreach((Function1)(JProcedure1 & Serializable)j -> j.hours().foreach((Function1)(JProcedure1 & Serializable)jh -> tc.addHour(jh.nature(), jh.creditHours())));
            MajorPlanCourse npc = new MajorPlanCourse();
            npc.course_$eq(tc);
            npc.terms_$eq(Terms$.MODULE$.apply(((IterableOnceOps)fcs.map((Function1 & Serializable)_$6 -> _$6.terms().toString())).mkString(",")));
            npc.group_$eq(group);
            npc.remark_$eq(((MajorPlanCourse)fcs.head()).remark());
            return course2Clusters.put((Object)first.course(), (Object)npc);
        });
        Buffer rs = Collections$.MODULE$.newBuffer();
        planCourses.foreach((Function1 & Serializable)pc -> {
            if (pc.course().cluster().isEmpty()) {
                return (Buffer)rs.addOne(pc);
            }
            if (filterClusters.contains(pc.course().cluster().get())) {
                return (Buffer)rs.addAll((IterableOnce)course2Clusters.get((Object)pc.course()));
            }
            return (Buffer)rs.addOne(pc);
        });
        return rs;
    }
}

