/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.service.impl;

import java.io.Serializable;
import java.util.List;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Strings$;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.rules.RuleMatch;
import org.openurp.base.edu.model.CourseJournal;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

public class EnNameChecker {
    private final Set preps = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"of", "for", "a", "an", "with", "on", "in", "at"}));
    private final Set symbols = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{'(', '&', '\"'}));
    private final Language lang = Languages.getLanguageForShortCode((String)"en-US");
    private final Map<String, String> msgs;

    public EnNameChecker() {
        Object[] objectArray = new Tuple2[5];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"It appears that a white space is missing.");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"\u5c11\u4e00\u4e2a\u7a7a\u683c");
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Possible spelling mistake found.");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)"\u6709\u53ef\u80fd\u62fc\u5199\u9519\u8bef");
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"It seems like there are too many consecutive spaces here.");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)"\u8fde\u7eed\u7a7a\u683c");
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Possible typo: you repeated a whitespace");
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)"\u8fde\u7eed\u7a7a\u683c");
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Don't put a space after the opening parenthesis.");
        objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)"\u62ec\u5f27\u540e\u4e0d\u8981\u653e\u7a7a\u683c");
        this.msgs = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    public Set<String> preps() {
        return this.preps;
    }

    public Set<Object> symbols() {
        return this.symbols;
    }

    public Map<CourseJournal, String> check(Iterable<CourseJournal> journals) {
        scala.collection.mutable.Map rs = Collections$.MODULE$.newMap();
        journals.foreach((Function1 & Serializable)journal -> {
            Option option = journal.enName();
            if (None$.MODULE$.equals(option)) {
                return rs.put(journal, (Object)"\u7f3a\u5c11\u82f1\u6587\u540d");
            }
            if (option instanceof Some) {
                String enName = (String)((Some)option).value();
                Tuple2 formatOK = this.isFormatCorrect(enName);
                if (!BoxesRunTime.unboxToBoolean((Object)formatOK._1())) {
                    return rs.put(journal, (Object)("\u683c\u5f0f\u9519\u8bef:" + formatOK._2()));
                }
                JLanguageTool tool = new JLanguageTool(this.lang);
                List matches = tool.check(enName);
                StringBuilder suggested = new StringBuilder();
                if (!matches.isEmpty()) {
                    for (RuleMatch m : matches) {
                        String msg = (String)this.msgs.getOrElse((Object)m.getMessage(), () -> EnNameChecker.$anonfun$1(m));
                        suggested.append(msg);
                        String string = msg;
                        String string2 = "\u8fde\u7eed\u7a7a\u683c";
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            int from = m.getFromPos();
                            int to = m.getToPos();
                            if (from - 3 >= 0) {
                                from -= 3;
                            }
                            if (to + 3 < enName.length()) {
                                to += 3;
                            }
                            suggested.append(enName.substring(from, to).replace(" ", "&bull;"));
                            continue;
                        }
                        List replacements = m.getSuggestedReplacements();
                        if (replacements.isEmpty()) continue;
                        suggested.append(enName.substring(m.getFromPos(), m.getToPos()) + "=>" + replacements.get(0));
                    }
                    rs.put(journal, (Object)String.valueOf(suggested));
                    return BoxedUnit.UNIT;
                }
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)option);
        });
        return rs.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Tuple2<Object, String> isFormatCorrect(String enName) {
        Object[] parts = Strings$.MODULE$.split(enName);
        Buffer names = Collections$.MODULE$.newBuffer();
        IntRef errors = IntRef.create((int)0);
        Object object = Predef$.MODULE$.refArrayOps(parts);
        ArrayOps$.MODULE$.foreach$extension(object, arg_0 -> this.isFormatCorrect$$anonfun$1((String[])parts, names, enName, errors, arg_0));
        if (errors.elem > 0) {
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)names.mkString(" "));
        }
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true), null);
    }

    private static final String $anonfun$1(RuleMatch m$1) {
        return m$1.getMessage();
    }

    private final /* synthetic */ Buffer isFormatCorrect$$anonfun$1(String[] parts$1, Buffer names$1, String enName$1, IntRef errors$1, String part) {
        int n;
        String lp = part.toLowerCase();
        Object object = Predef$.MODULE$.refArrayOps((Object[])parts$1);
        if (ArrayOps$.MODULE$.contains$extension(object, (Object)lp)) {
            int n2;
            String string = lp;
            String string2 = part;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return (Buffer)names$1.addOne((Object)part);
            }
            String string3 = lp;
            String string4 = "the";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                String string5 = part;
                String string6 = "The";
                if (!(string5 != null ? !string5.equals(string6) : string6 != null) && enName$1.startsWith("The ")) {
                    return (Buffer)names$1.addOne((Object)part);
                }
            }
            errors$1.elem = n2 = errors$1.elem + 1;
            return (Buffer)names$1.addOne((Object)("*" + part + "*"));
        }
        if (Character.isUpperCase(part.charAt(0)) || this.symbols().contains((Object)BoxesRunTime.boxToCharacter((char)part.charAt(0)))) {
            return (Buffer)names$1.addOne((Object)part);
        }
        errors$1.elem = n = errors$1.elem + 1;
        return (Buffer)names$1.addOne((Object)("*" + part + "*"));
    }
}

