/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.web.action.info;

import java.io.Serializable;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.web.action.support.ActionSupport;
import org.beangle.web.action.support.ServletSupport;
import org.beangle.web.action.view.View;
import org.openurp.base.model.Department;
import org.openurp.base.model.Project;
import org.openurp.base.service.ProjectConfigService;
import org.openurp.base.service.SemesterService;
import org.openurp.base.std.model.Grade;
import org.openurp.code.service.CodeService;
import org.openurp.edu.program.model.Program;
import org.openurp.edu.program.web.helper.ProgramReportHelper;
import org.openurp.starter.web.support.ProjectSupport;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;

public class ProgramAction
extends ActionSupport
implements ServletSupport,
ProjectSupport {
    private CodeService codeService;
    private ProjectConfigService configService;
    private SemesterService semesterService;
    private EntityDao entityDao;

    public ProgramAction() {
        ProjectSupport.$init$((ProjectSupport)this);
    }

    public CodeService codeService() {
        return this.codeService;
    }

    public ProjectConfigService configService() {
        return this.configService;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void codeService_$eq(CodeService x$1) {
        this.codeService = x$1;
    }

    public void configService_$eq(ProjectConfigService x$1) {
        this.configService = x$1;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public View index() {
        LazyRef lazyRef = new LazyRef();
        Seq grades = this.getGrades(this.project$1(lazyRef));
        Grade grade = (Grade)this.getLong("grade.id").map((Function1 & Serializable)id -> this.$anonfun$1(BoxesRunTime.unboxToLong((Object)id))).getOrElse(() -> ProgramAction.$anonfun$2(grades));
        Seq departs = this.project$1(lazyRef).departments().toSeq();
        OqlBuilder q = OqlBuilder$.MODULE$.from(Program.class.getName(), "program");
        q.where("program.project=:project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.project$1(lazyRef)}));
        q.where("program.grade=:grade", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{grade}));
        q.select("program.department.id,program.department.name,count(*)");
        q.groupBy("program.department.id,program.department.code,program.department.name");
        q.orderBy("program.department.code,program.department.name");
        Seq departStats = this.entityDao().search((QueryBuilder)q);
        Set programDepartIds = ((IterableOnceOps)departStats.map((Function1 & Serializable)x -> ((Number)x[0]).intValue())).toSet();
        departs = (Seq)departs.filter((Function1 & Serializable)d -> programDepartIds.contains(d.id()));
        this.put("departs", (Object)departs);
        this.put("grades", (Object)grades);
        this.put("grade", (Object)grade);
        this.put("departStats", (Object)departStats);
        return this.forward(this.forward$default$1());
    }

    public View programs() {
        LazyRef lazyRef = new LazyRef();
        Grade grade = (Grade)this.entityDao().get(Grade.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("grade")));
        Department depart = (Department)this.entityDao().get(Department.class, (Object)BoxesRunTime.boxToInteger((int)this.getIntId("department")));
        Object[] objectArray = new Tuple2[3];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"project");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.project$2(lazyRef));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"grade");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)grade);
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"department");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)depart);
        Seq programs = this.entityDao().findBy(Program.class, (Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        this.put("depart", (Object)depart);
        this.put("grade", (Object)grade);
        this.put("programs", (Object)programs);
        return this.forward(this.forward$default$1());
    }

    public View report() {
        Program program = (Program)this.entityDao().get(Program.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("program")));
        ProgramReportHelper helper = new ProgramReportHelper(this.entityDao(), this.configService(), this.codeService());
        helper.prepareData(program);
        return this.forward(this.forward$default$1());
    }

    private Seq<Grade> getGrades(Project project) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(Grade.class, "g");
        query.where("g.project=:project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project}));
        query.orderBy("g.code desc");
        return this.entityDao().search((QueryBuilder)query);
    }

    private final Project project$lzyINIT1$1(LazyRef project$lzy1$1) {
        Project project;
        LazyRef lazyRef = project$lzy1$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy1$1.initialized() ? project$lzy1$1.value() : project$lzy1$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$1(LazyRef project$lzy1$2) {
        return (Project)(project$lzy1$2.initialized() ? project$lzy1$2.value() : this.project$lzyINIT1$1(project$lzy1$2));
    }

    private final /* synthetic */ Grade $anonfun$1(long id) {
        return (Grade)this.entityDao().get(Grade.class, (Object)BoxesRunTime.boxToLong((long)id));
    }

    private static final Grade $anonfun$2(Seq grades$1) {
        return (Grade)grades$1.head();
    }

    private final Project project$lzyINIT2$1(LazyRef project$lzy2$1) {
        Project project;
        LazyRef lazyRef = project$lzy2$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy2$1.initialized() ? project$lzy2$1.value() : project$lzy2$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$2(LazyRef project$lzy2$2) {
        return (Project)(project$lzy2$2.initialized() ? project$lzy2$2.value() : this.project$lzyINIT2$1(project$lzy2$2));
    }
}

