/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.web.action.major;

import com.google.gson.Gson;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.util.HashMap;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.Entity;
import org.beangle.template.freemarker.ProfileTemplateLoader$;
import org.beangle.web.action.To;
import org.beangle.web.action.annotation.mapping;
import org.beangle.web.action.annotation.param;
import org.beangle.web.action.context.ActionContext$;
import org.beangle.web.action.view.View;
import org.beangle.webmvc.support.action.EntityAction;
import org.beangle.webmvc.support.action.RestfulAction;
import org.openurp.base.edu.model.Direction;
import org.openurp.base.edu.model.Major;
import org.openurp.base.model.AuditStatus;
import org.openurp.base.model.AuditStatus$;
import org.openurp.base.model.Project;
import org.openurp.base.service.ProjectConfigService;
import org.openurp.base.service.SemesterService;
import org.openurp.base.std.model.Grade;
import org.openurp.code.edu.model.Certificate;
import org.openurp.code.edu.model.Degree;
import org.openurp.code.edu.model.EducationType;
import org.openurp.code.edu.model.ProgramCourseTag;
import org.openurp.code.edu.model.TeachingNature;
import org.openurp.code.service.CodeService;
import org.openurp.code.std.model.StdType;
import org.openurp.edu.program.model.MajorPlan;
import org.openurp.edu.program.model.Program;
import org.openurp.edu.program.model.ProgramDoc;
import org.openurp.edu.program.service.ProgramNamingHelper;
import org.openurp.edu.program.service.TermHelper;
import org.openurp.edu.program.web.action.major.DocAction;
import org.openurp.edu.program.web.action.major.PlanAction;
import org.openurp.edu.program.web.action.major.ReviseAction;
import org.openurp.starter.web.support.ProjectSupport;
import scala.Function1;
import scala.Int$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

/*
 * Exception performing whole class analysis ignored.
 */
public class AdminAction
extends RestfulAction<Program>
implements ProjectSupport {
    private CodeService codeService;
    private ProjectConfigService configService;
    private SemesterService semesterService;

    public AdminAction() {
        ProjectSupport.$init$((ProjectSupport)this);
    }

    public CodeService codeService() {
        return this.codeService;
    }

    public ProjectConfigService configService() {
        return this.configService;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void codeService_$eq(CodeService x$1) {
        this.codeService = x$1;
    }

    public void configService_$eq(ProjectConfigService x$1) {
        this.configService = x$1;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public void indexSetting() {
        LazyRef lazyRef = new LazyRef();
        Seq departmentList = this.getDeparts(this.project$1(lazyRef));
        this.put("departments", (Object)departmentList);
        this.put("educationTypes", (Object)this.getCodes(EducationType.class, this.project$1(lazyRef)));
        this.put("stdTypes", (Object)this.getCodes(StdType.class, this.project$1(lazyRef)));
        OqlBuilder query = OqlBuilder$.MODULE$.from(Major.class, "m");
        query.where("m.project=:project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.project$1(lazyRef)}));
        query.where("exists(from m.journals as mj where mj.depart in(:departs))", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{departmentList}));
        query.orderBy("m.code");
        Seq majors = this.entityDao().search((QueryBuilder)query);
        this.put("majors", (Object)majors);
        this.put("statuses", package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AuditStatus[]{AuditStatus$.Submited, AuditStatus$.PassedByDepart, AuditStatus$.RejectedByDepart, AuditStatus$.Passed, AuditStatus$.Rejected})));
        super.indexSetting();
    }

    public OqlBuilder<Program> getQueryBuilder() {
        OqlBuilder q = EntityAction.getQueryBuilder$((EntityAction)this);
        Project project = this.getProject();
        this.put("displayEducationType", (Object)BoxesRunTime.boxToBoolean((project.eduTypes().size() > 1 ? 1 : 0) != 0));
        this.queryByDepart(q, "program.department");
        this.getBoolean("fake.valid").foreach((Function1 & Serializable)active -> AdminAction.getQueryBuilder$$anonfun$1((OqlBuilder)q, (boolean)BoxesRunTime.unboxToBoolean((Object)active)));
        return (OqlBuilder)q.where("program.project=:project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project}));
    }

    public void editSetting(Program program) {
        LazyRef lazyRef = new LazyRef();
        Seq departs = this.getDeparts(this.project$2(lazyRef));
        OqlBuilder query = OqlBuilder$.MODULE$.from(Major.class, "m");
        query.where("m.project=:project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.project$2(lazyRef)}));
        query.where("exists(from m.journals as mj where mj.depart in(:departs))", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{departs}));
        query.orderBy("m.code");
        Seq majors = this.entityDao().search((QueryBuilder)query);
        OqlBuilder query2 = OqlBuilder$.MODULE$.from(Direction.class, "m");
        query2.where("m.project=:project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.project$2(lazyRef)}));
        query2.where("exists(from m.journals as mj where mj.depart in(:departs))", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{departs}));
        query2.orderBy("m.code");
        Seq directions = this.entityDao().search((QueryBuilder)query);
        this.put("grades", (Object)this.getGrades(this.project$2(lazyRef)));
        this.put("departs", (Object)departs);
        this.put("majors", (Object)majors);
        this.put("directions", (Object)directions);
        this.put("project", (Object)this.project$2(lazyRef));
        if (program.persisted()) {
            this.put("docs", (Object)this.entityDao().findBy(ProgramDoc.class, "program", (Object)program));
        }
        this.put("degrees", (Object)this.getCodes(Degree.class, this.project$2(lazyRef)));
        this.put("certificates", (Object)this.getCodes(Certificate.class, this.project$2(lazyRef)));
        super.editSetting((Entity)program);
    }

    private Seq<Grade> getGrades(Project project) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(Grade.class, "g");
        query.where("g.project=:project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project}));
        query.orderBy("g.code desc");
        return this.entityDao().search((QueryBuilder)query);
    }

    public View editDoc() {
        return this.redirect((To)this.to(DocAction.class, "edit", "program.id=" + this.getLongId("program")), "");
    }

    public View editPlan() {
        return this.redirect((To)this.to(PlanAction.class, "edit", "program.id=" + this.getLongId("program")), "");
    }

    public View saveAndRedirect(Program program) {
        boolean autoname = this.getBoolean("autoname", true);
        if (autoname) {
            program.name_$eq(new ProgramNamingHelper(this.entityDao()).name(program.grade(), program.major(), program.direction()));
        }
        program.updatedAt_$eq(Instant.now());
        program.project_$eq(this.getProject());
        program.degreeCertificates().clear();
        program.degreeCertificates().addAll((IterableOnce)this.entityDao().find(Certificate.class, (Iterable)this.getIntIds("degreeCertificate")));
        return super.saveAndRedirect((Entity)program);
    }

    public View duration() {
        HttpServletResponse response2 = ActionContext$.MODULE$.current().response();
        long majorId = BoxesRunTime.unboxToLong((Object)this.get("majorId", (Object)BoxesRunTime.boxToLong((long)0L)));
        int levelId = BoxesRunTime.unboxToInt((Object)this.get("levelId", (Object)BoxesRunTime.boxToInteger((int)0)));
        LocalDate start = (LocalDate)this.getDate("start").get();
        ObjectRef duration = ObjectRef.create((Object)None$.MODULE$);
        this.entityDao().find(Major.class, (Object)BoxesRunTime.boxToLong((long)majorId)).foreach((Function1)(JProcedure1 & Serializable)major -> major.schoolLengths().find((Function1 & Serializable)x -> BoxesRunTime.unboxToInt((Object)x.level().id()) == levelId).foreach((Function1)(JProcedure1 & Serializable)s -> {
            Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)s.normal()));
            duration$2.elem = some;
            some = null;
        }));
        if (((Option)duration.elem).isEmpty()) {
            Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)4.0f));
            duration.elem = some;
            some = null;
        }
        float d = BoxesRunTime.unboxToFloat((Object)((Option)duration.elem).get());
        int mnum = (int)(d * (float)12);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("endOn", start.plusMonths(Int$.MODULE$.int2long(mnum)).toString());
        result.put("duration", BoxesRunTime.boxToFloat((float)d));
        response2.setContentType("text/plain;charset=UTF-8");
        response2.getWriter().write(new Gson().toJson(result));
        response2.getWriter().close();
        return null;
    }

    @mapping(value="{id}")
    public View info(@param(value="id") String id) {
        LazyRef lazyRef = new LazyRef();
        Program program = (Program)this.entityDao().get(Program.class, (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(id))));
        this.put("program", (Object)program);
        this.put("plan", (Object)this.entityDao().findBy(MajorPlan.class, "program", (Object)program).headOption());
        this.put("doc", (Object)this.entityDao().findBy(ProgramDoc.class, "program", (Object)program).headOption());
        ProfileTemplateLoader$.MODULE$.setProfile((Object)(AdminAction.project$3((LazyRef)lazyRef, (Program)program).school().id() + "/" + AdminAction.project$3((LazyRef)lazyRef, (Program)program).id()));
        this.put("natures", (Object)this.getCodes(TeachingNature.class, AdminAction.project$3((LazyRef)lazyRef, (Program)program)));
        this.put("tags", (Object)this.getCodes(ProgramCourseTag.class, AdminAction.project$3((LazyRef)lazyRef, (Program)program)));
        this.put("termHelper", (Object)new TermHelper());
        return this.forward(this.forward$default$1());
    }

    public View report() {
        return this.redirect((To)this.to(ReviseAction.class, "report", "program.id=" + this.getLongId("program")), "");
    }

    public View removeAndRedirect(Seq<Program> programs) {
        Seq removables = (Seq)programs.filter((Function1 & Serializable)_$1 -> {
            AuditStatus auditStatus = _$1.status();
            AuditStatus auditStatus2 = AuditStatus$.Passed;
            return auditStatus == null ? auditStatus2 != null : !auditStatus.equals(auditStatus2);
        });
        Seq docs = this.entityDao().findBy(ProgramDoc.class, "program", (Object)removables);
        Seq plans = this.entityDao().findBy(MajorPlan.class, "program", (Object)removables);
        this.entityDao().remove((Iterable)docs);
        this.entityDao().remove((Iterable)plans);
        return super.removeAndRedirect(removables);
    }

    private final Project project$lzyINIT1$1(LazyRef project$lzy1$1) {
        Project project;
        LazyRef lazyRef = project$lzy1$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy1$1.initialized() ? project$lzy1$1.value() : project$lzy1$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$1(LazyRef project$lzy1$2) {
        return (Project)(project$lzy1$2.initialized() ? project$lzy1$2.value() : this.project$lzyINIT1$1(project$lzy1$2));
    }

    private static final /* synthetic */ OqlBuilder getQueryBuilder$$anonfun$1(OqlBuilder q$1, boolean active) {
        if (active) {
            return (OqlBuilder)q$1.where("(" + q$1.alias() + ".endOn >= :now)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        }
        return (OqlBuilder)q$1.where(" (" + q$1.alias() + ".endOn <= :now)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
    }

    private final Project project$lzyINIT2$1(LazyRef project$lzy2$1) {
        Project project;
        LazyRef lazyRef = project$lzy2$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy2$1.initialized() ? project$lzy2$1.value() : project$lzy2$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$2(LazyRef project$lzy2$2) {
        return (Project)(project$lzy2$2.initialized() ? project$lzy2$2.value() : this.project$lzyINIT2$1(project$lzy2$2));
    }

    private static final Project project$lzyINIT3$1(LazyRef project$lzy3$1, Program program$1) {
        Project project;
        LazyRef lazyRef = project$lzy3$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy3$1.initialized() ? project$lzy3$1.value() : project$lzy3$1.initialize((Object)program$1.project()));
        }
        return project;
    }

    private static final Project project$3(LazyRef project$lzy3$2, Program program$2) {
        return (Project)(project$lzy3$2.initialized() ? project$lzy3$2.value() : AdminAction.project$lzyINIT3$1((LazyRef)project$lzy3$2, (Program)program$2));
    }
}

