/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.web.action.major;

import java.io.Serializable;
import java.time.LocalDate;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.web.action.support.ActionSupport;
import org.beangle.web.action.support.EntitySupport;
import org.beangle.web.action.view.View;
import org.beangle.webmvc.support.action.EntityAction;
import org.openurp.base.edu.model.Major;
import org.openurp.base.model.AuditStatus;
import org.openurp.base.model.AuditStatus$;
import org.openurp.base.model.Department;
import org.openurp.base.model.EduLevelBased;
import org.openurp.base.model.Project;
import org.openurp.base.service.ProjectConfigService;
import org.openurp.base.service.SemesterService;
import org.openurp.base.std.model.Grade;
import org.openurp.code.edu.model.EducationLevel;
import org.openurp.code.service.CodeService;
import org.openurp.edu.program.model.CoursePlan;
import org.openurp.edu.program.model.MajorPlan;
import org.openurp.edu.program.model.Program;
import org.openurp.edu.program.service.PlanService;
import org.openurp.edu.program.service.ProgramChecker;
import org.openurp.edu.program.service.TermHelper;
import org.openurp.edu.program.web.helper.ProgramInfoHelper;
import org.openurp.edu.program.web.helper.ProgramReportHelper;
import org.openurp.starter.web.support.ProjectSupport;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class AuditAction
extends ActionSupport
implements EntityAction<Program>,
ProjectSupport {
    private Class entityClass;
    private CodeService codeService;
    private ProjectConfigService configService;
    private SemesterService semesterService;
    private EntityDao entityDao;
    private ProgramChecker programChecker;
    private PlanService planService;

    public AuditAction() {
        EntitySupport.$init$((EntitySupport)this);
        ProjectSupport.$init$((ProjectSupport)this);
        Statics.releaseFence();
    }

    public Class entityClass() {
        return this.entityClass;
    }

    public void org$beangle$web$action$support$EntitySupport$_setter_$entityClass_$eq(Class x$0) {
        this.entityClass = x$0;
    }

    public CodeService codeService() {
        return this.codeService;
    }

    public ProjectConfigService configService() {
        return this.configService;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void codeService_$eq(CodeService x$1) {
        this.codeService = x$1;
    }

    public void configService_$eq(ProjectConfigService x$1) {
        this.configService = x$1;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public ProgramChecker programChecker() {
        return this.programChecker;
    }

    public void programChecker_$eq(ProgramChecker x$1) {
        this.programChecker = x$1;
    }

    public PlanService planService() {
        return this.planService;
    }

    public void planService_$eq(PlanService x$1) {
        this.planService = x$1;
    }

    public View index() {
        LazyRef lazyRef = new LazyRef();
        scala.collection.immutable.Seq grades = this.getGrades(this.project$1(lazyRef));
        Grade grade = (Grade)this.getLong("grade.id").map((Function1 & Serializable)id -> this.$anonfun$1(BoxesRunTime.unboxToLong((Object)id))).getOrElse(() -> AuditAction.$anonfun$2(grades));
        ObjectRef departs = ObjectRef.create((Object)this.getDeparts(this.project$1(lazyRef)));
        if (((scala.collection.immutable.Seq)departs.elem).size() > 1) {
            OqlBuilder q = OqlBuilder$.MODULE$.from(Program.class.getName(), "program");
            q.where("program.project=:project", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.project$1(lazyRef)}));
            q.where("program.grade=:grade", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{grade}));
            q.select("distinct program.department");
            scala.collection.immutable.Seq programDeparts = this.entityDao().search((QueryBuilder)q);
            scala.collection.immutable.Seq diffs = (scala.collection.immutable.Seq)((scala.collection.immutable.Seq)departs.elem).diff((Seq)programDeparts);
            scala.collection.immutable.Seq myProgramDeparts = ((IterableOnceOps)((SeqOps)((scala.collection.immutable.Seq)departs.elem).toBuffer().subtractAll((IterableOnce)diffs)).sortBy((Function1 & Serializable)_$4 -> _$4.code(), (Ordering)Ordering.String$.MODULE$)).toSeq();
            if (myProgramDeparts.nonEmpty()) {
                scala.collection.immutable.Seq seq = myProgramDeparts;
                departs.elem = seq;
                seq = null;
            }
        }
        this.put("departs", (Object)((scala.collection.immutable.Seq)departs.elem));
        this.put("grades", (Object)grades);
        Department depart = (Department)this.getInt("department.id").map((Function1 & Serializable)id -> this.$anonfun$4(BoxesRunTime.unboxToInt((Object)id))).getOrElse(() -> AuditAction.$anonfun$5(departs));
        Object[] objectArray = new Tuple2[3];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"project");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.project$1(lazyRef));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"grade");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)grade);
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"department");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)depart);
        scala.collection.immutable.Seq programs = this.entityDao().findBy(Program.class, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        this.put("reviseOpening", (Object)BoxesRunTime.boxToBoolean((boolean)grade.beginOn().isAfter(LocalDate.now())));
        Map auditMessages = ((IterableOnceOps)programs.map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply(x, (Object)this.programChecker().check(x)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.put("programs", (Object)programs);
        this.put("auditMessages", (Object)auditMessages);
        this.put("depart", (Object)depart);
        this.put("grade", (Object)grade);
        this.put("auditables", Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AuditStatus[]{AuditStatus$.Submited, AuditStatus$.RejectedByDepart})));
        return this.forward(this.forward$default$1());
    }

    private scala.collection.immutable.Seq<Grade> getGrades(Project project) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(Grade.class, "g");
        query.where("g.project=:project", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project}));
        query.orderBy("g.code desc");
        return this.entityDao().search((QueryBuilder)query);
    }

    public View auditSetting() {
        Program program = (Program)this.entityDao().get(Program.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("program")));
        ProgramInfoHelper helper = new ProgramInfoHelper(this.entityDao(), this.configService(), this.codeService());
        helper.prepareData(program);
        return this.forward(this.forward$default$1());
    }

    public View audit() {
        Program program = (Program)this.entityDao().get(Program.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("program")));
        AuditStatus auditStatus = program.status();
        AuditStatus auditStatus2 = AuditStatus$.Passed;
        if (!(auditStatus != null ? !auditStatus.equals(auditStatus2) : auditStatus2 != null)) {
            return this.redirect("auditSetting", "\u5df2\u7ecf\u901a\u8fc7\u65e0\u9700\u518d\u5ba1");
        }
        boolean passed = this.getBoolean("passed", false);
        if (passed) {
            program.status_$eq(AuditStatus$.PassedByDepart);
        } else {
            program.status_$eq(AuditStatus$.RejectedByDepart);
        }
        program.opinions_$eq(this.get("program.opinions"));
        this.entityDao().saveOrUpdate((Object)program, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Program[0]));
        return this.redirect("auditSetting", "program.id=" + program.id(), "\u5ba1\u6838\u6210\u529f");
    }

    public View report() {
        Program program = (Program)this.entityDao().get(Program.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("program")));
        ProgramReportHelper helper = new ProgramReportHelper(this.entityDao(), this.configService(), this.codeService());
        helper.prepareData(program);
        return this.forward(this.forward$default$1());
    }

    public View diffIndex() {
        LazyRef lazyRef = new LazyRef();
        OqlBuilder q = OqlBuilder$.MODULE$.from(Program.class, "program");
        q.where("program.project=:project", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.project$2(lazyRef)}));
        this.queryByDepart(q, "program.department");
        q.orderBy("program.grade.beginOn desc,program.department.code,program.major.name");
        scala.collection.immutable.Seq plans = this.entityDao().search((QueryBuilder)q);
        scala.collection.immutable.Seq lefts = plans.toSeq();
        ObjectRef rights = ObjectRef.create((Object)plans.toSeq());
        this.getLong("right.grade.id").foreach((Function1)(JFunction1.mcVJ.sp & Serializable)gradeId -> {
            scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)((scala.collection.immutable.Seq)rights$1.elem).filter((Function1 & Serializable)_$5 -> BoxesRunTime.unboxToLong((Object)_$5.grade().id()) == gradeId);
            rights$1.elem = seq;
            seq = null;
        });
        ObjectRef right = ObjectRef.create((Object)((scala.collection.immutable.Seq)rights.elem).headOption());
        this.getLong("right.id").foreach((Function1)(JFunction1.mcVJ.sp & Serializable)id -> {
            Option option = ((scala.collection.immutable.Seq)rights$2.elem).find((Function1 & Serializable)_$6 -> BoxesRunTime.unboxToLong((Object)_$6.id()) == id);
            right$1.elem = option;
            option = null;
        });
        ObjectRef left = ObjectRef.create((Object)None$.MODULE$);
        this.get("left.id").foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            String string = x$1;
            if ("last".equals(string)) {
                if (((Option)right$2.elem).nonEmpty()) {
                    scala.collection.immutable.Seq sameMajors = (scala.collection.immutable.Seq)lefts.filter((Function1 & Serializable)x -> {
                        Department department = x.department();
                        Department department2 = ((Program)((Option)right$3.elem).get()).department();
                        if (department == null) {
                            if (department2 != null) {
                                return false;
                            }
                        } else if (!department.equals(department2)) return false;
                        EducationLevel educationLevel = x.level();
                        EducationLevel educationLevel2 = ((EduLevelBased)((Option)right$3.elem).get()).level();
                        if (educationLevel == null) {
                            if (educationLevel2 != null) {
                                return false;
                            }
                        } else if (!educationLevel.equals(educationLevel2)) return false;
                        Major major = x.major();
                        Major major2 = ((Program)((Option)right$3.elem).get()).major();
                        if (major == null) {
                            if (major2 != null) {
                                return false;
                            }
                        } else if (!major.equals(major2)) return false;
                        Option option = x.direction();
                        Option option2 = ((Program)((Option)right$3.elem).get()).direction();
                        if (option == null) {
                            if (option2 != null) {
                                return false;
                            }
                        } else if (!option.equals(option2)) return false;
                        if (((Option)right$3.elem).contains(x)) return false;
                        if (!x.grade().beginOn().isBefore(((Program)((Option)right$3.elem).get()).grade().beginOn())) return false;
                        return true;
                    });
                    Option option = ((IterableOps)((SeqOps)sameMajors.sortBy((Function1 & Serializable)_$7 -> _$7.grade().beginOn(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).reverse()).headOption();
                    left$1.elem = option;
                    option = null;
                    return;
                }
                return;
            }
            String i = string;
            String id = string;
            Option option = lefts.find((Function1 & Serializable)_$8 -> {
                String string = _$8.id().toString();
                String string2 = id;
                return !(string != null ? !string.equals(string2) : string2 != null);
            });
            left$1.elem = option;
            option = null;
        });
        this.put("lefts", (Object)lefts);
        this.put("rights", (Object)((scala.collection.immutable.Seq)rights.elem));
        this.put("left", (Object)((Option)left.elem));
        this.put("right", (Object)((Option)right.elem));
        return this.forward("../plan/diffIndex");
    }

    public View diff() {
        MajorPlan left = (MajorPlan)this.entityDao().findBy(MajorPlan.class, "program.id", (Object)BoxesRunTime.boxToLong((long)this.getLongId("left"))).head();
        MajorPlan right = (MajorPlan)this.entityDao().findBy(MajorPlan.class, "program.id", (Object)BoxesRunTime.boxToLong((long)this.getLongId("right"))).head();
        this.put("left", (Object)left);
        this.put("right", (Object)right);
        this.put("diffResults", (Object)this.planService().diff((CoursePlan)left, (CoursePlan)right));
        this.put("termHelper", (Object)new TermHelper());
        return this.forward("../plan/diff");
    }

    private final Project project$lzyINIT1$1(LazyRef project$lzy1$1) {
        Project project;
        LazyRef lazyRef = project$lzy1$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy1$1.initialized() ? project$lzy1$1.value() : project$lzy1$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$1(LazyRef project$lzy1$2) {
        return (Project)(project$lzy1$2.initialized() ? project$lzy1$2.value() : this.project$lzyINIT1$1(project$lzy1$2));
    }

    private final /* synthetic */ Grade $anonfun$1(long id) {
        return (Grade)this.entityDao().get(Grade.class, (Object)BoxesRunTime.boxToLong((long)id));
    }

    private static final Grade $anonfun$2(scala.collection.immutable.Seq grades$1) {
        return (Grade)grades$1.head();
    }

    private final /* synthetic */ Department $anonfun$4(int id) {
        return (Department)this.entityDao().get(Department.class, (Object)BoxesRunTime.boxToInteger((int)id));
    }

    private static final Department $anonfun$5(ObjectRef departs$1) {
        return (Department)((scala.collection.immutable.Seq)departs$1.elem).head();
    }

    private final Project project$lzyINIT2$1(LazyRef project$lzy2$1) {
        Project project;
        LazyRef lazyRef = project$lzy2$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy2$1.initialized() ? project$lzy2$1.value() : project$lzy2$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$2(LazyRef project$lzy2$2) {
        return (Project)(project$lzy2$2.initialized() ? project$lzy2$2.value() : this.project$lzyINIT2$1(project$lzy2$2));
    }
}

