/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.web.action.major;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.time.LocalDate;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.beangle.commons.bean.PropertyExtractor;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.doc.core.PrintOptions;
import org.beangle.doc.excel.html.TableWriter$;
import org.beangle.doc.pdf.SPDConverter$;
import org.beangle.doc.transfer.exporter.ExportContext;
import org.beangle.doc.transfer.exporter.ExportContext$;
import org.beangle.ems.app.Ems$;
import org.beangle.security.Securities$;
import org.beangle.web.action.context.ActionContext$;
import org.beangle.web.action.support.ActionSupport;
import org.beangle.web.action.support.EntitySupport;
import org.beangle.web.action.view.Status$;
import org.beangle.web.action.view.Stream$;
import org.beangle.web.action.view.View;
import org.beangle.web.servlet.util.RequestUtils$;
import org.beangle.webmvc.support.action.EntityAction;
import org.openurp.base.model.AuditStatus;
import org.openurp.base.model.AuditStatus$;
import org.openurp.base.model.Department;
import org.openurp.base.model.Project;
import org.openurp.base.service.ProjectConfigService;
import org.openurp.base.service.SemesterService;
import org.openurp.base.std.model.Grade;
import org.openurp.code.edu.model.TeachingNature;
import org.openurp.code.service.CodeService;
import org.openurp.edu.program.model.Program;
import org.openurp.edu.program.web.helper.PlanCourseHelper;
import org.openurp.edu.program.web.helper.PlanCourseStatPropertyExtractor;
import org.openurp.edu.program.web.helper.ProgramInfoHelper;
import org.openurp.edu.program.web.helper.ProgramReportHelper;
import org.openurp.starter.web.support.ProjectSupport;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.mutable.Buffer;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

public class ReviseAction
extends ActionSupport
implements EntityAction<Program>,
ProjectSupport {
    private Class entityClass;
    private CodeService codeService;
    private ProjectConfigService configService;
    private SemesterService semesterService;
    private EntityDao entityDao;

    public ReviseAction() {
        EntitySupport.$init$((EntitySupport)this);
        ProjectSupport.$init$((ProjectSupport)this);
        Statics.releaseFence();
    }

    public Class entityClass() {
        return this.entityClass;
    }

    public void org$beangle$web$action$support$EntitySupport$_setter_$entityClass_$eq(Class x$0) {
        this.entityClass = x$0;
    }

    public CodeService codeService() {
        return this.codeService;
    }

    public ProjectConfigService configService() {
        return this.configService;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void codeService_$eq(CodeService x$1) {
        this.codeService = x$1;
    }

    public void configService_$eq(ProjectConfigService x$1) {
        this.configService = x$1;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public View index() {
        LazyRef lazyRef = new LazyRef();
        scala.collection.immutable.Seq grades = this.getGrades(this.project$1(lazyRef));
        Grade grade = (Grade)this.getLong("grade.id").map((Function1 & Serializable)id -> this.$anonfun$1(BoxesRunTime.unboxToLong((Object)id))).getOrElse(() -> ReviseAction.$anonfun$2(grades));
        ObjectRef departs = ObjectRef.create((Object)this.getDeparts(this.project$1(lazyRef)));
        if (((scala.collection.immutable.Seq)departs.elem).size() > 1) {
            OqlBuilder q = OqlBuilder$.MODULE$.from(Program.class.getName(), "program");
            q.where("program.project=:project", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.project$1(lazyRef)}));
            q.where("program.grade=:grade", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{grade}));
            q.select("distinct program.department");
            scala.collection.immutable.Seq programDeparts = this.entityDao().search((QueryBuilder)q);
            scala.collection.immutable.Seq diffs = (scala.collection.immutable.Seq)((scala.collection.immutable.Seq)departs.elem).diff((Seq)programDeparts);
            scala.collection.immutable.Seq myProgramDeparts = ((IterableOnceOps)((SeqOps)((scala.collection.immutable.Seq)departs.elem).toBuffer().subtractAll((IterableOnce)diffs)).sortBy((Function1 & Serializable)_$2 -> _$2.code(), (Ordering)Ordering.String$.MODULE$)).toSeq();
            if (myProgramDeparts.nonEmpty()) {
                scala.collection.immutable.Seq seq = myProgramDeparts;
                departs.elem = seq;
                seq = null;
            }
        }
        this.put("departs", (Object)((scala.collection.immutable.Seq)departs.elem));
        this.put("grades", (Object)grades);
        Department depart = (Department)this.getInt("department.id").map((Function1 & Serializable)id -> this.$anonfun$4(BoxesRunTime.unboxToInt((Object)id))).getOrElse(() -> ReviseAction.$anonfun$5(departs));
        Object[] objectArray = new Tuple2[3];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"project");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.project$1(lazyRef));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"grade");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)grade);
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"department");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)depart);
        scala.collection.immutable.Seq programs = this.entityDao().findBy(Program.class, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        this.put("reviseOpening", (Object)BoxesRunTime.boxToBoolean((boolean)grade.beginOn().isAfter(LocalDate.now())));
        this.put("programs", (Object)programs);
        this.put("depart", (Object)depart);
        this.put("grade", (Object)grade);
        this.put("editables", Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AuditStatus[]{AuditStatus$.Draft, AuditStatus$.Submited, AuditStatus$.RejectedByDirector, AuditStatus$.RejectedByDepart})));
        this.put("teachingNatures", (Object)this.getCodes(TeachingNature.class, this.project$1(lazyRef)));
        return this.forward(this.forward$default$1());
    }

    private scala.collection.immutable.Seq<Grade> getGrades(Project project) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(Grade.class, "g");
        query.where("g.project=:project", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project}));
        query.orderBy("g.code desc");
        return this.entityDao().search((QueryBuilder)query);
    }

    public View info() {
        Program program = (Program)this.entityDao().get(Program.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("program")));
        ProgramInfoHelper helper = new ProgramInfoHelper(this.entityDao(), this.configService(), this.codeService());
        helper.prepareData(program);
        return this.forward(this.forward$default$1());
    }

    public View report() {
        Program program = (Program)this.entityDao().get(Program.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("program")));
        ProgramReportHelper helper = new ProgramReportHelper(this.entityDao(), this.configService(), this.codeService());
        helper.prepareData(program);
        return this.forward(this.forward$default$1());
    }

    public View plans() {
        LazyRef lazyRef = new LazyRef();
        Grade grade = (Grade)this.entityDao().get(Grade.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("grade")));
        Department department = (Department)this.entityDao().get(Department.class, (Object)BoxesRunTime.boxToInteger((int)this.getIntId("department")));
        ProgramReportHelper helper = new ProgramReportHelper(this.entityDao(), this.configService(), this.codeService());
        helper.prepareData(this.project$2(lazyRef), grade, department);
        this.put("grade", (Object)grade);
        this.put("department", (Object)department);
        return this.forward(this.forward$default$1());
    }

    public View excel() {
        Grade grade = (Grade)this.entityDao().get(Grade.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("grade")));
        Department department = (Department)this.entityDao().get(Department.class, (Object)BoxesRunTime.boxToInteger((int)this.getIntId("department")));
        String style = (String)this.get("style", (Object)"");
        String tableHtml = (String)this.get("tableHtml", (Object)"");
        String html = "<body>" + style + tableHtml + "</body>";
        XSSFWorkbook workbook = TableWriter$.MODULE$.writer(html);
        ServletOutputStream os = this.response().getOutputStream();
        RequestUtils$.MODULE$.setContentDisposition(this.response(), grade.name() + " " + department.name() + " \u6559\u5b66\u8ba1\u5212.xlsx");
        workbook.write((OutputStream)os);
        return Status$.MODULE$.Ok();
    }

    public View pdf() {
        long id = this.getLongId("program");
        Program program = (Program)this.entityDao().get(Program.class, (Object)BoxesRunTime.boxToLong((long)id));
        String url = Ems$.MODULE$.base() + ActionContext$.MODULE$.current().request().getContextPath() + ("/info/program/report?program.id=" + id + "&URP_SID=") + Securities$.MODULE$.session().map((Function1 & Serializable)_$3 -> _$3.id()).getOrElse(ReviseAction::$anonfun$7);
        File pdf = File.createTempFile("doc", ".pdf");
        PrintOptions options = new PrintOptions();
        options.scale_$eq(0.95);
        SPDConverter$.MODULE$.getInstance().convert(URI.create(url), pdf, options);
        return Stream$.MODULE$.apply(pdf, program.grade().code() + "\u7ea7 " + program.name() + " \u57f9\u517b\u65b9\u6848.pdf").cleanup((Function0)(JFunction0.mcV.sp & Serializable)() -> pdf.delete());
    }

    public View exportCourses() {
        LazyRef lazyRef = new LazyRef();
        Grade grade = (Grade)this.entityDao().get(Grade.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("grade")));
        Department depart = (Department)this.entityDao().get(Department.class, (Object)BoxesRunTime.boxToInteger((int)this.getIntId("department")));
        PlanCourseHelper helper = new PlanCourseHelper(this.entityDao());
        Buffer planCourseStats = Collections$.MODULE$.newBuffer();
        planCourseStats.addAll((IterableOnce)helper.coursesOwn(grade, depart));
        planCourseStats.addAll((IterableOnce)helper.coursesForOther(grade, depart));
        String titles = (String)this.get("titles", (Object)"");
        Object object = Predef$.MODULE$.refArrayOps((Object[])Strings$.MODULE$.split(titles));
        scala.collection.immutable.Seq properties = ArrayOps$.MODULE$.toSeq$extension(object);
        ExportContext ctx = ExportContext$.MODULE$.excel((Option)None$.MODULE$, properties);
        ctx.header((Option)None$.MODULE$, properties).exportAsString(this.getBoolean("convertToString", false));
        ctx.setItems((Iterable)planCourseStats);
        ctx.extractor_$eq((PropertyExtractor)new PlanCourseStatPropertyExtractor(grade));
        HttpServletResponse response2 = ActionContext$.MODULE$.current().response();
        String fileName = grade.name() + " " + depart.name() + " \u5f00\u8bfe\u4fe1\u606f";
        RequestUtils$.MODULE$.setContentDisposition(response2, ctx.buildFileName((Option)Some$.MODULE$.apply((Object)fileName)));
        ctx.writeTo((OutputStream)response2.getOutputStream());
        return Status$.MODULE$.Ok();
    }

    public View courses() {
        LazyRef lazyRef = new LazyRef();
        Grade grade = (Grade)this.entityDao().get(Grade.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("grade")));
        Department depart = (Department)this.entityDao().get(Department.class, (Object)BoxesRunTime.boxToInteger((int)this.getIntId("department")));
        PlanCourseHelper helper = new PlanCourseHelper(this.entityDao());
        this.put("coursesOwn", (Object)helper.coursesOwn(grade, depart));
        this.put("coursesForOther", (Object)helper.coursesForOther(grade, depart));
        this.put("grade", (Object)grade);
        this.put("depart", (Object)depart);
        this.put("teachingNatures", (Object)this.getCodes(TeachingNature.class, this.project$4(lazyRef)));
        return this.forward(this.forward$default$1());
    }

    public View submit() {
        Program program = (Program)this.entityDao().get(Program.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("program")));
        AuditStatus auditStatus = program.status();
        AuditStatus auditStatus2 = AuditStatus$.PassedByDepart;
        if (auditStatus == null ? auditStatus2 != null : !auditStatus.equals(auditStatus2)) {
            AuditStatus auditStatus3 = program.status();
            AuditStatus auditStatus4 = AuditStatus$.Passed;
            if (auditStatus3 == null ? auditStatus4 != null : !auditStatus3.equals(auditStatus4)) {
                program.status_$eq(AuditStatus$.Submited);
            }
        }
        this.entityDao().saveOrUpdate((Object)program, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Program[0]));
        return this.redirect("index", "\u63d0\u4ea4\u6210\u529f");
    }

    public View revoke() {
        Program program = (Program)this.entityDao().get(Program.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("program")));
        AuditStatus auditStatus = program.status();
        AuditStatus auditStatus2 = AuditStatus$.Submited;
        if (!(auditStatus != null ? !auditStatus.equals(auditStatus2) : auditStatus2 != null)) {
            program.status_$eq(AuditStatus$.Draft);
        }
        this.entityDao().saveOrUpdate((Object)program, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Program[0]));
        return this.redirect("index", "\u64a4\u56de\u6210\u529f");
    }

    private final Project project$lzyINIT1$1(LazyRef project$lzy1$1) {
        Project project;
        LazyRef lazyRef = project$lzy1$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy1$1.initialized() ? project$lzy1$1.value() : project$lzy1$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$1(LazyRef project$lzy1$2) {
        return (Project)(project$lzy1$2.initialized() ? project$lzy1$2.value() : this.project$lzyINIT1$1(project$lzy1$2));
    }

    private final /* synthetic */ Grade $anonfun$1(long id) {
        return (Grade)this.entityDao().get(Grade.class, (Object)BoxesRunTime.boxToLong((long)id));
    }

    private static final Grade $anonfun$2(scala.collection.immutable.Seq grades$1) {
        return (Grade)grades$1.head();
    }

    private final /* synthetic */ Department $anonfun$4(int id) {
        return (Department)this.entityDao().get(Department.class, (Object)BoxesRunTime.boxToInteger((int)id));
    }

    private static final Department $anonfun$5(ObjectRef departs$1) {
        return (Department)((scala.collection.immutable.Seq)departs$1.elem).head();
    }

    private final Project project$lzyINIT2$1(LazyRef project$lzy2$1) {
        Project project;
        LazyRef lazyRef = project$lzy2$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy2$1.initialized() ? project$lzy2$1.value() : project$lzy2$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$2(LazyRef project$lzy2$2) {
        return (Project)(project$lzy2$2.initialized() ? project$lzy2$2.value() : this.project$lzyINIT2$1(project$lzy2$2));
    }

    private static final String $anonfun$7() {
        return "";
    }

    private final Project project$lzyINIT3$1(LazyRef project$lzy3$1) {
        Project project;
        LazyRef lazyRef = project$lzy3$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy3$1.initialized() ? project$lzy3$1.value() : project$lzy3$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$3(LazyRef project$lzy3$2) {
        return (Project)(project$lzy3$2.initialized() ? project$lzy3$2.value() : this.project$lzyINIT3$1(project$lzy3$2));
    }

    private final Project project$lzyINIT4$1(LazyRef project$lzy4$1) {
        Project project;
        LazyRef lazyRef = project$lzy4$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy4$1.initialized() ? project$lzy4$1.value() : project$lzy4$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$4(LazyRef project$lzy4$2) {
        return (Project)(project$lzy4$2.initialized() ? project$lzy4$2.value() : this.project$lzyINIT4$1(project$lzy4$2));
    }
}

