/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.web.helper;

import org.beangle.commons.lang.Strings$;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.ems.app.Ems$;
import org.beangle.template.freemarker.ProfileTemplateLoader$;
import org.beangle.web.action.context.ActionContext$;
import org.openurp.base.model.Department;
import org.openurp.base.model.Project;
import org.openurp.base.service.Feature;
import org.openurp.base.service.ProjectConfigService;
import org.openurp.base.std.model.Grade;
import org.openurp.code.Code;
import org.openurp.code.edu.model.ProgramCourseTag;
import org.openurp.code.edu.model.TeachingNature;
import org.openurp.code.service.CodeService;
import org.openurp.edu.program.model.CoursePlan;
import org.openurp.edu.program.model.CreditHours$;
import org.openurp.edu.program.model.MajorPlan;
import org.openurp.edu.program.model.Program;
import org.openurp.edu.program.model.ProgramDoc;
import org.openurp.edu.program.service.PlanCategoryStat;
import org.openurp.edu.program.service.PlanCategoryStat$;
import org.openurp.edu.program.service.PlanCourseCluster;
import org.openurp.edu.program.service.PlanGroupStat;
import org.openurp.edu.program.service.PlanGroupStat$;
import org.openurp.edu.program.service.PlanRender$;
import org.openurp.edu.program.service.TermHelper;
import org.openurp.edu.service.Features;
import scala.collection.Map;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;

/*
 * Exception performing whole class analysis ignored.
 */
public class ProgramReportHelper {
    private final EntityDao entityDao;
    private final ProjectConfigService configService;
    private final CodeService codeService;

    public ProgramReportHelper(EntityDao entityDao, ProjectConfigService configService, CodeService codeService) {
        this.entityDao = entityDao;
        this.configService = configService;
        this.codeService = codeService;
    }

    public void prepareData(Program program) {
        LazyRef lazyRef = new LazyRef();
        this.put("program", (Object)program);
        MajorPlan plan = (MajorPlan)this.entityDao.findBy(MajorPlan.class, "program", (Object)program).head();
        this.put("plan", (Object)plan);
        this.put("doc", (Object)this.entityDao.findBy(ProgramDoc.class, "program", (Object)program).headOption());
        this.put("displayCreditHour", this.getConfig(Features.Program$.MODULE$.DisplayCreditHour(), ProgramReportHelper.project$2((LazyRef)lazyRef, (Program)program)));
        this.put("enableLinkCourseInfo", this.getConfig(Features.Program$.MODULE$.LinkCourseEnabled(), ProgramReportHelper.project$2((LazyRef)lazyRef, (Program)program)));
        this.put("ems_base", (Object)Ems$.MODULE$.base());
        ProfileTemplateLoader$.MODULE$.setProfile((Object)(ProgramReportHelper.project$2((LazyRef)lazyRef, (Program)program).school().id() + "/" + ProgramReportHelper.project$2((LazyRef)lazyRef, (Program)program).id()));
        Seq natures = this.getCodes(TeachingNature.class, ProgramReportHelper.project$2((LazyRef)lazyRef, (Program)program));
        this.put("natures", (Object)natures);
        this.put("tags", (Object)this.getCodes(ProgramCourseTag.class, ProgramReportHelper.project$2((LazyRef)lazyRef, (Program)program)));
        this.put("cluster", (Object)new PlanCourseCluster());
        this.put("termHelper", (Object)new TermHelper());
        this.put("planRender", (Object)PlanRender$.MODULE$);
        PlanCategoryStat stat = PlanCategoryStat$.MODULE$.stat((CoursePlan)plan, natures);
        PlanGroupStat planGroupStat = PlanGroupStat$.MODULE$.stat((CoursePlan)plan, natures);
        if (plan.creditHours() == 0 || Strings$.MODULE$.isEmpty((CharSequence)plan.hourRatios())) {
            plan.creditHours_$eq(planGroupStat.creditHours());
            plan.credits_$eq(planGroupStat.credits());
            plan.program().credits_$eq(plan.credits());
            plan.hourRatios_$eq(CreditHours$.MODULE$.toRatios((Map)planGroupStat.hours()));
            this.entityDao.saveOrUpdate((Object)plan, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MajorPlan[0]));
            this.entityDao.saveOrUpdate((Object)plan.program(), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Program[0]));
        }
        this.put("stat", (Object)stat);
    }

    public void prepareData(Project project, Grade grade, Department depart) {
        ProfileTemplateLoader$.MODULE$.setProfile((Object)(project.school().id() + "/" + project.id()));
        OqlBuilder query = OqlBuilder$.MODULE$.from(MajorPlan.class, "plan");
        query.where("plan.program.project=:project", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project}));
        query.where("plan.program.department=:depart", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{depart}));
        query.where("plan.program.grade=:grade", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{grade}));
        scala.collection.immutable.Seq plans = this.entityDao.search((QueryBuilder)query);
        this.put("plans", (Object)plans);
        this.put("displayCreditHour", this.getConfig(Features.Program$.MODULE$.DisplayCreditHour(), ProgramReportHelper.p$1((Project)project)));
        this.put("enableLinkCourseInfo", this.getConfig(Features.Program$.MODULE$.LinkCourseEnabled(), ProgramReportHelper.p$1((Project)project)));
        this.put("ems_base", (Object)Ems$.MODULE$.base());
        Seq natures = this.getCodes(TeachingNature.class, ProgramReportHelper.p$1((Project)project));
        this.put("natures", (Object)natures);
        this.put("tags", (Object)this.getCodes(ProgramCourseTag.class, ProgramReportHelper.p$1((Project)project)));
        this.put("cluster", (Object)new PlanCourseCluster());
        this.put("termHelper", (Object)new TermHelper());
        this.put("planRender", (Object)PlanRender$.MODULE$);
    }

    public <T extends Code> Seq<T> getCodes(Class<T> clazz, Project project) {
        return this.codeService.get(clazz);
    }

    public Object getConfig(Feature f, Project project) {
        return this.configService.get(project, f, ClassTag$.MODULE$.Any());
    }

    private void put(String name, Object v) {
        ActionContext$.MODULE$.current().attribute(name, v);
    }

    private static final Project project$lzyINIT1$1(LazyRef project$lzy1$1, Program program$1) {
        Project project;
        LazyRef lazyRef = project$lzy1$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy1$1.initialized() ? project$lzy1$1.value() : project$lzy1$1.initialize((Object)program$1.project()));
        }
        return project;
    }

    private static final Project project$2(LazyRef project$lzy1$2, Program program$2) {
        return (Project)(project$lzy1$2.initialized() ? project$lzy1$2.value() : ProgramReportHelper.project$lzyINIT1$1((LazyRef)project$lzy1$2, (Program)program$2));
    }

    private static final Project p$1(Project project$1) {
        return project$1;
    }
}

