/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.service;

import java.io.InputStream;
import java.io.Serializable;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.io.DataType$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.logging.Logger$;
import org.beangle.commons.logging.Logging;
import org.beangle.data.dao.EntityDao;
import org.beangle.doc.excel.CellOps$;
import org.openurp.base.edu.model.Course;
import org.openurp.base.edu.model.CourseJournal;
import org.openurp.base.edu.model.Terms;
import org.openurp.base.edu.model.Terms$;
import org.openurp.base.model.CalendarStage;
import org.openurp.code.edu.model.CourseRank;
import org.openurp.code.edu.model.CourseRank$;
import org.openurp.code.edu.model.CourseTag;
import org.openurp.code.edu.model.CourseType;
import org.openurp.code.edu.model.ExamMode;
import org.openurp.code.edu.model.ProgramCourseTag;
import org.openurp.code.edu.model.TeachingNature;
import org.openurp.edu.program.model.AbstractPlanCourse;
import org.openurp.edu.program.model.MajorCourseGroup;
import org.openurp.edu.program.model.MajorPlan;
import org.openurp.edu.program.model.MajorPlanCourse;
import org.openurp.edu.program.model.Program;
import org.openurp.edu.program.service.LixinPlanExcelReader$;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Float$;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple12$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple6$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Set;
import scala.jdk.javaapi.CollectionConverters$;
import scala.math.Numeric;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class LixinPlanExcelReader
implements Logging {
    private Logger logger;
    private final InputStream in;
    private Seq regions;
    private int lastRowNum;
    private int lastColNum;
    private int moduleSpan;
    private ExcelPlan plan;
    private Buffer messages;
    private boolean zhuanke;
    private boolean zhuanShengben;
    private final CalendarStage longStage;
    private final CalendarStage shortStage;
    private ExcelCourseGroup longTermGroup;
    private final ExcelCourseGroup shortTermGroup;

    public static String convertRemarkToGroupName(String string) {
        return LixinPlanExcelReader$.MODULE$.convertRemarkToGroupName(string);
    }

    public static Seq<String> fixedCourseCodes() {
        return LixinPlanExcelReader$.MODULE$.fixedCourseCodes();
    }

    public static Option<String> givenNameOf(String[] stringArray) {
        return LixinPlanExcelReader$.MODULE$.givenNameOf(stringArray);
    }

    public static void main(String[] stringArray) {
        LixinPlanExcelReader$.MODULE$.main(stringArray);
    }

    public static Terms toTerms(String string) {
        return LixinPlanExcelReader$.MODULE$.toTerms(string);
    }

    public static String typeNameOf(String string) {
        return LixinPlanExcelReader$.MODULE$.typeNameOf(string);
    }

    public static String typeNameOf(String[] stringArray) {
        return LixinPlanExcelReader$.MODULE$.typeNameOf(stringArray);
    }

    public LixinPlanExcelReader(InputStream in) {
        this.in = in;
        Logging.$init$((Logging)this);
        this.moduleSpan = 1;
        this.messages = Collections$.MODULE$.newBuffer();
        this.zhuanke = false;
        this.zhuanShengben = false;
        this.longStage = new CalendarStage();
        this.longStage().id_$eq((Object)BoxesRunTime.boxToInteger((int)1));
        this.longStage().name_$eq("\u957f\u5b66\u6bb5");
        this.shortStage = new CalendarStage();
        this.shortStage().id_$eq((Object)BoxesRunTime.boxToInteger((int)2));
        this.shortStage().name_$eq("\u77ed\u5b66\u6bb5");
        this.longTermGroup = new ExcelCourseGroup("1", "\u957f\u5b66\u6bb5\u6559\u5b66", (Option<String>)None$.MODULE$);
        this.longTermGroup().stage_$eq((Option<CalendarStage>)Some$.MODULE$.apply((Object)this.longStage()));
        this.shortTermGroup = new ExcelCourseGroup("2", "\u77ed\u5b66\u6bb5\u6559\u5b66", (Option<String>)None$.MODULE$);
        this.shortTermGroup().stage_$eq((Option<CalendarStage>)Some$.MODULE$.apply((Object)this.shortStage()));
        Statics.releaseFence();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public Seq<CellRangeAddress> regions() {
        return this.regions;
    }

    public void regions_$eq(Seq<CellRangeAddress> x$1) {
        this.regions = x$1;
    }

    public int lastRowNum() {
        return this.lastRowNum;
    }

    public void lastRowNum_$eq(int x$1) {
        this.lastRowNum = x$1;
    }

    public int lastColNum() {
        return this.lastColNum;
    }

    public void lastColNum_$eq(int x$1) {
        this.lastColNum = x$1;
    }

    public int moduleSpan() {
        return this.moduleSpan;
    }

    public void moduleSpan_$eq(int x$1) {
        this.moduleSpan = x$1;
    }

    public ExcelPlan plan() {
        return this.plan;
    }

    public void plan_$eq(ExcelPlan x$1) {
        this.plan = x$1;
    }

    public Buffer<String> messages() {
        return this.messages;
    }

    public void messages_$eq(Buffer<String> x$1) {
        this.messages = x$1;
    }

    public boolean zhuanke() {
        return this.zhuanke;
    }

    public void zhuanke_$eq(boolean x$1) {
        this.zhuanke = x$1;
    }

    public boolean zhuanShengben() {
        return this.zhuanShengben;
    }

    public void zhuanShengben_$eq(boolean x$1) {
        this.zhuanShengben = x$1;
    }

    public CalendarStage longStage() {
        return this.longStage;
    }

    public CalendarStage shortStage() {
        return this.shortStage;
    }

    public ExcelCourseGroup longTermGroup() {
        return this.longTermGroup;
    }

    public void longTermGroup_$eq(ExcelCourseGroup x$1) {
        this.longTermGroup = x$1;
    }

    public ExcelCourseGroup shortTermGroup() {
        return this.shortTermGroup;
    }

    public int findLastRowNum(XSSFSheet sheet) {
        int last = sheet.getLastRowNum();
        String text = this.getFirst(sheet.getRow(last), this.getFirst$default$2());
        while (!(last <= 1 || text != null && text.contains("\u5b66\u5206\u8981\u6c42\u5408\u8ba1"))) {
            text = this.getFirst(sheet.getRow(--last), this.getFirst$default$2());
        }
        return last;
    }

    public void process() {
        XSSFWorkbook wb = new XSSFWorkbook(this.in);
        XSSFSheet sheet = wb.getSheetAt(0);
        this.regions_$eq((Seq<CellRangeAddress>)CollectionConverters$.MODULE$.asScala(sheet.getMergedRegions()).toSeq());
        CellRangeAddress region = this.getMergeRegion((short)0);
        this.lastColNum_$eq(region.getLastColumn());
        XSSFCell name = sheet.getRow(1).getCell(0);
        XSSFCell department = sheet.getRow(0).getCell(0);
        this.zhuanke_$eq(name.toString().contains("\u4e13\u79d1"));
        this.zhuanShengben_$eq(name.toString().contains("\u4e13\u5347\u672c"));
        this.plan_$eq(new ExcelPlan(name.toString()));
        this.plan().groups().addOne((Object)this.longTermGroup());
        this.plan().groups().addOne((Object)this.shortTermGroup());
        this.plan().department_$eq(department.toString());
        XSSFRow titleRow = sheet.getRow(3);
        XSSFCell module = titleRow.getCell(0);
        while (true) {
            CellType cellType = titleRow.getCell(this.moduleSpan()).getCellType();
            CellType cellType2 = CellType.BLANK;
            if (cellType != null ? !cellType.equals(cellType2) : cellType2 != null) break;
            this.moduleSpan_$eq(this.moduleSpan() + 1);
        }
        int startRowNum = 5;
        this.lastRowNum_$eq(this.findLastRowNum(sheet));
        ObjectRef topModule = ObjectRef.create((Object)"");
        ObjectRef topGroup = ObjectRef.create(null);
        ObjectRef modules = ObjectRef.create((Object)new String[this.moduleSpan()]);
        ObjectRef group = ObjectRef.create(null);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(startRowNum), this.lastRowNum()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)rowIdx -> {
            block38: {
                XSSFRow row = sheet.getRow(rowIdx);
                try {
                    ExcelPlanCourse pc;
                    ExcelCourseGroup remarkGroup;
                    block40: {
                        block39: {
                            String firstCellText = this.getFirst(row, this.getFirst$default$2());
                            if (firstCellText == null) break block38;
                            if (this.isMergeRow(row)) {
                                topModule$1.elem = row.getCell(0).getStringCellValue();
                                if (((String)topModule$1.elem).contains("\u5b66\u6bb5\u6559\u5b66")) {
                                    String indexTypeName = Strings$.MODULE$.substringAfter((String)topModule$1.elem, "|").trim();
                                    indexTypeName = Strings$.MODULE$.substringBefore(indexTypeName, " ");
                                    String indexNo = indexTypeName.substring(0, indexTypeName.indexOf("\u5b66\u6bb5") - 1);
                                    String typeName = LixinPlanExcelReader$.MODULE$.typeNameOf(Strings$.MODULE$.replace(indexTypeName.substring(indexNo.length()), "\u2014", "-"));
                                    topGroup$1.elem = new ExcelCourseGroup(indexNo, typeName, (Option<String>)None$.MODULE$);
                                    if (((String)topModule$1.elem).contains("\u957f\u5b66\u6bb5")) {
                                        ((ExcelCourseGroup)topGroup$1.elem).stage_$eq((Option<CalendarStage>)Some$.MODULE$.apply((Object)this.longStage()));
                                        ((ExcelCourseGroup)topGroup$1.elem).parent_$eq((Option<ExcelCourseGroup>)Some$.MODULE$.apply((Object)this.longTermGroup()));
                                        this.longTermGroup().children().addOne((Object)((ExcelCourseGroup)topGroup$1.elem));
                                    } else {
                                        ((ExcelCourseGroup)topGroup$1.elem).stage_$eq((Option<CalendarStage>)Some$.MODULE$.apply((Object)this.shortStage()));
                                        ((ExcelCourseGroup)topGroup$1.elem).parent_$eq((Option<ExcelCourseGroup>)Some$.MODULE$.apply((Object)this.shortTermGroup()));
                                        this.shortTermGroup().children().addOne((Object)((ExcelCourseGroup)topGroup$1.elem));
                                    }
                                } else if (((String)topModule$1.elem).contains("\u80fd\u529b\u7d20\u8d28")) {
                                    topModule$1.elem = "\u7efc\u5408\u80fd\u529b\u7d20\u8d28\u6d4b\u8bc4";
                                    topGroup$1.elem = new ExcelCourseGroup(BoxesRunTime.boxToInteger((int)(this.plan().groups().size() + 1)).toString(), (String)topModule$1.elem, (Option<String>)None$.MODULE$);
                                    group$1.elem = (ExcelCourseGroup)topGroup$1.elem;
                                    this.plan().groups().addOne((Object)((ExcelCourseGroup)topGroup$1.elem));
                                } else {
                                    topGroup$1.elem = new ExcelCourseGroup(BoxesRunTime.boxToInteger((int)(this.plan().groups().size() + 1)).toString(), (String)topModule$1.elem, (Option<String>)None$.MODULE$);
                                    this.plan().groups().addOne((Object)((ExcelCourseGroup)topGroup$1.elem));
                                }
                                break block38;
                            }
                            if (firstCellText.contains("\u5b66\u5206\u8981\u6c42") || firstCellText.contains("\u5b66\u5206\u5e94\u9009\u8981\u6c42")) {
                                if (firstCellText.contains("\u5408\u8ba1")) break block38;
                                this.readGroupStat(row, (ExcelCourseGroup)group$1.elem);
                                break block38;
                            }
                            if (firstCellText.contains("\u5c0f\u8ba1")) {
                                if (!firstCellText.contains("\u5b9e\u8df5\u8bfe") && !firstCellText.contains("\u957f\u5b66\u6bb5")) {
                                    this.readGroupStat(row, (ExcelCourseGroup)topGroup$1.elem);
                                    break block38;
                                }
                                if (!firstCellText.contains("\u957f\u5b66\u6bb5")) break block38;
                                this.readGroupStat(row, this.longTermGroup());
                                break block38;
                            }
                            if (firstCellText.contains("\u8981\u6c42\u5408\u8ba1")) {
                                this.readPlanStat(row, this.plan());
                                break block38;
                            }
                            short start = row.getFirstCellNum();
                            remarkGroup = null;
                            boolean remarkAsGroupName = false;
                            if (!this.zhuanke()) {
                                String remark;
                                String remarkGroupName;
                                String string = ((ExcelCourseGroup)topGroup$1.elem).typeName();
                                String string2 = "\u77ed\u5b66\u6bb5-\u4e13\u4e1a\u4e0e\u521b\u65b0\u5b9e\u8df5";
                                if (!(string != null ? !string.equals(string2) : string2 != null) && Strings$.MODULE$.isNotEmpty((CharSequence)(remarkGroupName = LixinPlanExcelReader$.MODULE$.convertRemarkToGroupName(remark = this.getText(row.getCell(this.lastColNum())))))) {
                                    remarkAsGroupName = true;
                                    remarkGroup = ((ExcelCourseGroup)topGroup$1.elem).addGroup(remarkGroupName, (Option<String>)None$.MODULE$);
                                    group$1.elem = (ExcelCourseGroup)topGroup$1.elem;
                                }
                            }
                            if (!remarkAsGroupName) {
                                Object[] groupNames = (String[])((String[])modules$1.elem).clone();
                                BooleanRef groupNameOccured = BooleanRef.create((boolean)false);
                                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.moduleSpan()).foreach((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> LixinPlanExcelReader.process$$anonfun$1$$anonfun$1(row, (String[])groupNames, groupNameOccured, arg_0)));
                                Object object = Predef$.MODULE$.refArrayOps((Object[])((String[])modules$1.elem));
                                Seq seq = ArrayOps$.MODULE$.toSeq$extension(object);
                                Object object2 = Predef$.MODULE$.refArrayOps(groupNames);
                                Seq seq2 = ArrayOps$.MODULE$.toSeq$extension(object2);
                                if (seq == null ? seq2 != null : !seq.equals(seq2)) {
                                    modules$1.elem = groupNames;
                                    String groupTypeName = LixinPlanExcelReader$.MODULE$.typeNameOf((String[])modules$1.elem);
                                    if (groupTypeName.contains("\u65b9\u5411")) {
                                        ExcelCourseGroup optionMajorGroup = ((ExcelCourseGroup)topGroup$1.elem).addGroup("\u957f\u5b66\u6bb5-\u4e13\u4e1a\u9009\u4fee\u8bfe", (Option<String>)None$.MODULE$);
                                        group$1.elem = optionMajorGroup.addGroup(groupTypeName, (Option<String>)None$.MODULE$);
                                    } else {
                                        group$1.elem = ((ExcelCourseGroup)topGroup$1.elem).addGroup(groupTypeName, LixinPlanExcelReader$.MODULE$.givenNameOf((String[])modules$1.elem));
                                    }
                                }
                            }
                            String startText = this.getFirst(row, this.moduleSpan());
                            XSSFCell nameCell = row.getCell(this.moduleSpan() + 2);
                            CellType cellType = nameCell.getCellType();
                            CellType cellType2 = CellType.BLANK;
                            if (!(cellType != null ? !cellType.equals(cellType2) : cellType2 != null)) {
                                if (startText.contains("\u5b66\u5206")) {
                                    this.readGroupStat(row, (ExcelCourseGroup)group$1.elem);
                                } else {
                                    this.readLeafGroup(row, (ExcelCourseGroup)group$1.elem);
                                }
                                break block38;
                            }
                            pc = this.readCourse(row);
                            if (remarkAsGroupName) {
                                pc.remark_$eq((Option<String>)None$.MODULE$);
                            }
                            Logger$.MODULE$.debug$extension(this.logger(), () -> LixinPlanExcelReader.process$$anonfun$1$$anonfun$2(pc));
                            String string = pc.courseName();
                            String string3 = "\u521b\u65b0\u521b\u4e1a\u5b9e\u8df5";
                            if (!(string == null ? string3 != null : !string.equals(string3))) break block39;
                            String string4 = pc.courseCode();
                            String string5 = "123910214";
                            if (string4 != null ? !string4.equals(string5) : string5 != null) break block40;
                        }
                        ExcelCourseGroup cxsj = ((ExcelCourseGroup)group$1.elem).addGroup("\u521b\u65b0\u521b\u4e1a\u5b9e\u8df5", (Option<String>)None$.MODULE$);
                        cxsj.credits_$eq(pc.credits());
                        cxsj.creditHours_$eq(pc.creditHours());
                        cxsj.weeks_$eq((Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)pc.weeks())));
                        cxsj.terms_$eq(pc.toTerms());
                        break block38;
                    }
                    if (pc.courseCode() == null || pc.courseCode().contains("\u65b0")) {
                        this.addError(rowIdx, "\u65b0\u8bfe\u7a0b:" + pc.courseName());
                        break block38;
                    }
                    if (pc.courseCode().contains("310190H11") && pc.courseCode().contains("310181H11")) {
                        this.addCluster("\u52b3\u52a8\u6559\u80b2\u4e0e\u5b9e\u8df5", (List<String>)((List)new .colon.colon((Object)"310190H11", (List)new .colon.colon((Object)"310181H11", (List)Nil$.MODULE$))), (List<String>)((List)new .colon.colon((Object)"\uff08\u4e00\uff09", (List)new .colon.colon((Object)"\uff08\u4e8c\uff09", (List)Nil$.MODULE$))), (List<Object>)((List)new .colon.colon((Object)BoxesRunTime.boxToFloat((float)0.5f), (List)new .colon.colon((Object)BoxesRunTime.boxToFloat((float)1.5f), (List)Nil$.MODULE$))), pc, (ExcelCourseGroup)group$1.elem);
                        break block38;
                    }
                    if (pc.courseCode().contains("310190H14") && pc.courseCode().contains("310181H14")) {
                        this.addCluster("\u52b3\u52a8\u6559\u80b2\u4e0e\u5b9e\u8df5", (List<String>)((List)new .colon.colon((Object)"310190H14", (List)new .colon.colon((Object)"310181H14", (List)Nil$.MODULE$))), (List<String>)((List)new .colon.colon((Object)"\uff08\u4e00\uff09", (List)new .colon.colon((Object)"\uff08\u4e8c\uff09", (List)Nil$.MODULE$))), (List<Object>)((List)new .colon.colon((Object)BoxesRunTime.boxToFloat((float)0.5f), (List)new .colon.colon((Object)BoxesRunTime.boxToFloat((float)1.5f), (List)Nil$.MODULE$))), pc, (ExcelCourseGroup)group$1.elem);
                        break block38;
                    }
                    if (pc.courseCode().contains("134660H10") && pc.courseCode().contains("134670H10")) {
                        this.addCluster("\u804c\u4e1a\u89c4\u5212\u4e0e\u5c31\u4e1a\u6307\u5bfc", (List<String>)((List)new .colon.colon((Object)"134660H10", (List)new .colon.colon((Object)"134670H10", (List)Nil$.MODULE$))), (List<String>)((List)new .colon.colon((Object)"\u2460", (List)new .colon.colon((Object)"\u2461", (List)Nil$.MODULE$))), (List<Object>)((List)new .colon.colon((Object)BoxesRunTime.boxToFloat((float)0.5f), (List)new .colon.colon((Object)BoxesRunTime.boxToFloat((float)0.5f), (List)Nil$.MODULE$))), pc, (ExcelCourseGroup)group$1.elem);
                        break block38;
                    }
                    if (pc.courseCode().contains("310220110") && pc.courseCode().contains("310230110")) {
                        this.addCluster("\u5fc3\u7406\u5065\u5eb7", (List<String>)((List)new .colon.colon((Object)"310220110", (List)new .colon.colon((Object)"310230110", (List)Nil$.MODULE$))), (List<String>)((List)new .colon.colon((Object)"\u2460", (List)new .colon.colon((Object)"\u2461", (List)Nil$.MODULE$))), (List<Object>)((List)new .colon.colon((Object)BoxesRunTime.boxToFloat((float)1.0f), (List)new .colon.colon((Object)BoxesRunTime.boxToFloat((float)1.0f), (List)Nil$.MODULE$))), pc, (ExcelCourseGroup)group$1.elem);
                        break block38;
                    }
                    String string = pc.courseName();
                    String string6 = "\u5f62\u52bf\u4e0e\u653f\u7b56";
                    if (!(string != null ? !string.equals(string6) : string6 != null)) {
                        if (this.zhuanShengben()) {
                            List codes = (List)new .colon.colon((Object)"210590Q10", (List)new .colon.colon((Object)"210600Q10", (List)new .colon.colon((Object)"210610Q10", (List)new .colon.colon((Object)"210620Q10", (List)Nil$.MODULE$))));
                            List seqs = (List)new .colon.colon((Object)"\u2460", (List)new .colon.colon((Object)"\u2461", (List)new .colon.colon((Object)"\u2462", (List)new .colon.colon((Object)"\u2463", (List)Nil$.MODULE$))));
                            if (pc.courseCode().contains("210630Q10")) {
                                codes = (List)new .colon.colon((Object)"210630Q10", (List)new .colon.colon((Object)"210640Q10", (List)new .colon.colon((Object)"210650Q10", (List)new .colon.colon((Object)"210050Q10", (List)Nil$.MODULE$))));
                                seqs = (List)new .colon.colon((Object)"\u2464", (List)new .colon.colon((Object)"\u2465", (List)new .colon.colon((Object)"\u2466", (List)new .colon.colon((Object)"\u2467", (List)Nil$.MODULE$))));
                            }
                            this.addCluster("\u5f62\u52bf\u4e0e\u653f\u7b56", (List<String>)codes, (List<String>)seqs, (List<Object>)((List)new .colon.colon((Object)BoxesRunTime.boxToFloat((float)0.25f), (List)new .colon.colon((Object)BoxesRunTime.boxToFloat((float)0.25f), (List)new .colon.colon((Object)BoxesRunTime.boxToFloat((float)0.25f), (List)new .colon.colon((Object)BoxesRunTime.boxToFloat((float)0.25f), (List)Nil$.MODULE$))))), pc, (ExcelCourseGroup)group$1.elem);
                        } else if (!this.zhuanke()) {
                            this.addCluster("\u5f62\u52bf\u4e0e\u653f\u7b56", (List<String>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"210590Q10", "210600Q10", "210610Q10", "210620Q10", "210630Q10", "210640Q10", "210650Q10", "210050Q10"}))), (List<String>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\u2460", "\u2461", "\u2462", "\u2463", "\u2464", "\u2465", "\u2466", "\u2467"}))), (List<Object>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapFloatArray(new float[]{0.25f, 0.25f, 0.25f, 0.25f, 0.25f, 0.25f, 0.25f, 0.25f}))), pc, (ExcelCourseGroup)group$1.elem);
                        } else {
                            ((ExcelCourseGroup)group$1.elem).courses().addOne((Object)pc);
                        }
                        break block38;
                    }
                    if (((ExcelCourseGroup)group$1.elem).typeName().contains("\u901a\u8bc6\u9650\u5b9a\u9009\u4fee\u8bfe")) {
                        ExcelCourseGroup yuedu = ((ExcelCourseGroup)group$1.elem).addGroup("\u9605\u8bfb\u4e0e\u5199\u4f5c\u7c7b\u8bfe\u7a0b", (Option<String>)None$.MODULE$);
                        yuedu.credits_$eq(pc.credits());
                        yuedu.creditHours_$eq(pc.creditHours());
                        yuedu.weeks_$eq((Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)pc.weeks())));
                        yuedu.terms_$eq(pc.toTerms());
                        yuedu.courses().addOne((Object)pc);
                        break block38;
                    }
                    if (remarkGroup == null) {
                        ((ExcelCourseGroup)group$1.elem).courses().addOne((Object)pc);
                        break block38;
                    }
                    remarkGroup.courses().addOne((Object)pc);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.addError(rowIdx, e.getMessage());
                }
            }
        });
        wb.close();
        if (this.longTermGroup().credits() == 0.0) {
            this.longTermGroup().credits_$eq(BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)this.longTermGroup().children().map((Function1 & Serializable)_$14 -> _$14.credits())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)));
        }
        this.plan().credits_$eq(BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)this.plan().groups().map((Function1 & Serializable)_$15 -> _$15.credits())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)));
    }

    private void addError(int rowIdx, String message) {
        this.messages().addOne((Object)(rowIdx + 1 + "\u884c " + message));
    }

    private void addCluster(String name, List<String> codes, List<String> seqs, List<Object> credits, ExcelPlanCourse pc, ExcelCourseGroup group) {
        List terms = pc.toTerms().termList();
        codes.indices().foreach((Function1 & Serializable)i -> LixinPlanExcelReader.addCluster$$anonfun$1(codes, name, seqs, credits, terms, pc, group, BoxesRunTime.unboxToInt((Object)i)));
    }

    private void readPlanStat(XSSFRow row, ExcelPlan plan) {
        float credits = this.getFloat(row.getCell(this.moduleSpan() + 3));
        int creditHours = this.getInt(row.getCell(this.moduleSpan() + 4));
        int theoreticalHours = this.getInt(row.getCell(this.moduleSpan() + 5));
        int practicalHours = this.getInt(row.getCell(this.moduleSpan() + 6));
        plan.credits_$eq(Float$.MODULE$.float2double(credits));
        plan.creditHours_$eq(creditHours);
        plan.theoreticalHours_$eq(theoreticalHours);
        plan.practicalHours_$eq(practicalHours);
    }

    private void readGroupStat(XSSFRow row, ExcelCourseGroup group) {
        float credits = this.getFloat(row.getCell(this.moduleSpan() + 3));
        int creditHours = this.getInt(row.getCell(this.moduleSpan() + 4));
        int theoreticalHours = this.getInt(row.getCell(this.moduleSpan() + 5));
        int practicalHours = this.getInt(row.getCell(this.moduleSpan() + 6));
        if (group.typeName().contains("\u901a\u8bc6\u81ea\u7531\u9009\u4fee\u8bfe")) {
            ((ExcelCourseGroup)group.parent().get()).findGroup("\u957f\u5b66\u6bb5-\u901a\u8bc6\u9650\u5b9a\u9009\u4fee\u8bfe", (Option<String>)None$.MODULE$).foreach((Function1)(JProcedure1 & Serializable)g -> {
                g.credits_$eq((double)credits - group.credits());
                g.creditHours_$eq(creditHours - group.creditHours());
                g.theoreticalHours_$eq(theoreticalHours - group.theoreticalHours());
                g.practicalHours_$eq(practicalHours - group.practicalHours());
            });
            return;
        }
        if (group.givenName().nonEmpty() || group.credits() > 0.0) {
            if (group.parent().nonEmpty()) {
                ((ExcelCourseGroup)group.parent().get()).updateCreditAndHours(Float$.MODULE$.float2double(credits), creditHours, theoreticalHours, practicalHours);
                return;
            }
            this.addError(row.getRowNum(), "\u627e\u4e0d\u5230" + group.typeName() + "(" + group.givenName() + ")\u7684\u4e0a\u7ea7\u7ec4");
            return;
        }
        group.updateCreditAndHours(Float$.MODULE$.float2double(credits), creditHours, theoreticalHours, practicalHours);
        if (group.typeName().contains("\u7efc\u5408\u7d20\u8d28\u5b9e\u8df5\u5fc5\u4fee\u8bfe")) {
            ((ExcelCourseGroup)group.parent().get()).updateCreditAndHours(Float$.MODULE$.float2double(credits), creditHours, theoreticalHours, practicalHours);
            return;
        }
        if (group.typeName().contains("\u65b9\u5411")) {
            ((ExcelCourseGroup)group.parent().get()).updateCreditAndHours(Float$.MODULE$.float2double(credits), creditHours, theoreticalHours, practicalHours);
            return;
        }
    }

    private void readLeafGroup(XSSFRow row, ExcelCourseGroup group) {
        String seq = this.getText(row.getCell(this.moduleSpan()));
        String groupNameText = this.getText(row.getCell(this.moduleSpan() + 1));
        if (Strings$.MODULE$.isBlank((CharSequence)groupNameText)) {
            return;
        }
        Tuple2<String, String> groupNames = this.processCourseName(groupNameText);
        float credits = this.getFloat(row.getCell(this.moduleSpan() + 3));
        int creditHours = this.getInt(row.getCell(this.moduleSpan() + 4));
        int theoreticalHours = this.getInt(row.getCell(this.moduleSpan() + 5));
        int practicalHours = this.getInt(row.getCell(this.moduleSpan() + 6));
        ExcelCourseGroup leaf = group.addGroup(LixinPlanExcelReader$.MODULE$.typeNameOf((String)groupNames._1()), (Option<String>)None$.MODULE$);
        if (leaf.typeName().endsWith("\u7c7b") && group.typeName().contains("\u901a\u8bc6\u81ea\u7531\u9009\u4fee\u8bfe")) {
            if ((int)group.credits() == 0) {
                group.credits_$eq(Float$.MODULE$.float2double(credits));
                group.creditHours_$eq(creditHours);
                group.theoreticalHours_$eq(theoreticalHours);
                group.practicalHours_$eq(practicalHours);
            }
            leaf.credits_$eq(0.0);
            leaf.creditHours_$eq(0);
            leaf.theoreticalHours_$eq(0);
            leaf.practicalHours_$eq(0);
        } else if (!leaf.typeName().contains("\u8de8\u5b66\u79d1")) {
            leaf.credits_$eq(Float$.MODULE$.float2double(credits));
            leaf.creditHours_$eq(creditHours);
            leaf.theoreticalHours_$eq(theoreticalHours);
            leaf.practicalHours_$eq(practicalHours);
        }
        leaf.terms_$eq(LixinPlanExcelReader$.MODULE$.toTerms(this.getText(row.getCell(this.moduleSpan() + 8))));
        leaf.departments_$eq((Option<String>)Option$.MODULE$.apply((Object)this.getText(row.getCell(this.lastColNum() - 1))));
        if (leaf.departments().contains((Object)"\u4fe1\u7ba1\u7b49")) {
            leaf.departments_$eq((Option<String>)Some$.MODULE$.apply((Object)"\u4fe1\u7ba1"));
        }
        leaf.remark_$eq((Option<String>)Option$.MODULE$.apply((Object)this.getText(row.getCell(this.lastColNum()))));
    }

    private ExcelPlanCourse readCourse(XSSFRow row) {
        int seq = this.getInt(row.getCell(this.moduleSpan()));
        String courseCode = this.getText(row.getCell(this.moduleSpan() + 1));
        if (courseCode != null) {
            String string = courseCode;
            String string2 = "210030410";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                courseCode = "210030210";
            }
            if (courseCode.contains("173690210") && courseCode.contains("173700210")) {
                courseCode = "173700210";
            }
        }
        Tuple2<String, String> courseNames = this.processCourseName(this.getText(row.getCell(this.moduleSpan() + 2)));
        String courseName = (String)courseNames._1();
        String courseNameEn = (String)courseNames._2();
        float credits = this.getFloat(row.getCell(this.moduleSpan() + 3));
        int creditHours = 0;
        int weeks = 0;
        String hours = this.getText(row.getCell(this.moduleSpan() + 4));
        if (hours != null && hours.contains("\u5468")) {
            String string = hours;
            String string3 = "\u6bcf\u5468";
            weeks = !(string != null ? !string.equals(string3) : string3 != null) ? 16 : StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(Strings$.MODULE$.replace(hours, "\u5468", "")));
        } else {
            creditHours = this.getInt(row.getCell(this.moduleSpan() + 4));
        }
        int theoreticalHours = this.getInt(row.getCell(this.moduleSpan() + 5));
        String practicalHoursText = this.getText(row.getCell(this.moduleSpan() + 6));
        int practicalHours = practicalHoursText != null && !practicalHoursText.contains("\u5468") ? this.getInt(row.getCell(this.moduleSpan() + 6)) : 0;
        String nature = this.getText(row.getCell(this.moduleSpan() + 7));
        String terms = this.getText(row.getCell(this.moduleSpan() + 8));
        String depart = this.getText(row.getCell(this.lastColNum() - 1));
        Option remark = Option$.MODULE$.apply((Object)this.getText(row.getCell(this.lastColNum())));
        return new ExcelPlanCourse(seq, courseCode, courseName, courseNameEn, Float$.MODULE$.float2double(credits), creditHours, weeks, theoreticalHours, practicalHours, nature, terms, depart, (Option<String>)remark);
    }

    public CellRangeAddress getMergeRegion(short rowIndex) {
        return (CellRangeAddress)this.regions().find((Function1 & Serializable)x -> x.getFirstRow() == x.getLastRow() && x.getFirstRow() == rowIndex && x.getFirstColumn() == 0).get();
    }

    public boolean isMergeRow(XSSFRow row) {
        short firstCollNum = row.getFirstCellNum();
        if (firstCollNum > -1) {
            short start = row.getFirstCellNum();
            Option region = this.regions().find((Function1 & Serializable)x -> x.getFirstRow() == x.getLastRow() && x.getFirstRow() == row.getRowNum() && x.getFirstColumn() == start && x.getLastColumn() == this.lastColNum());
            return region.nonEmpty();
        }
        return false;
    }

    public String getFirst(XSSFRow row, int startColumn) {
        if (row == null) {
            return null;
        }
        XSSFCell cell = null;
        int i = startColumn;
        while (i <= this.lastColNum()) {
            XSSFCell c;
            block7: {
                block6: {
                    c = row.getCell(i);
                    if (c == null) break block6;
                    CellType cellType = c.getCellType();
                    CellType cellType2 = CellType.BLANK;
                    if (cellType != null ? !cellType.equals(cellType2) : cellType2 != null) break block7;
                }
                ++i;
                continue;
            }
            cell = c;
            i = this.lastColNum() + 1;
        }
        if (cell == null) {
            return null;
        }
        return this.getText(cell);
    }

    public int getFirst$default$2() {
        return 0;
    }

    private Tuple2<String, String> processCourseName(String name) {
        String n = name.trim();
        String[] rs = Strings$.MODULE$.split(n = Strings$.MODULE$.replace(n, "\r", ""), "\n");
        if (rs.length == 2) {
            return Tuple2$.MODULE$.apply((Object)rs[0].trim(), (Object)rs[1].trim());
        }
        return Tuple2$.MODULE$.apply((Object)rs[0], (Object)"");
    }

    private String getText(XSSFCell cell) {
        if (cell == null) {
            return null;
        }
        Object t = CellOps$.MODULE$.getValue$extension(CellOps$.MODULE$.toCell((Cell)cell), DataType$.String);
        if (t != null) {
            return t.toString().trim();
        }
        return null;
    }

    private float getFloat(XSSFCell cell) {
        block6: {
            String v;
            block8: {
                block7: {
                    CellType cellType = cell.getCellType();
                    CellType cellType2 = CellType.BLANK;
                    if (!(cellType != null ? !cellType.equals(cellType2) : cellType2 != null)) {
                        return 0.0f;
                    }
                    CellType cellType3 = cell.getCellType();
                    CellType cellType4 = CellType.NUMERIC;
                    if (!(cellType3 != null ? !cellType3.equals(cellType4) : cellType4 != null)) {
                        return (float)cell.getNumericCellValue();
                    }
                    CellType cellType5 = cell.getCellType();
                    CellType cellType6 = CellType.STRING;
                    if (cellType5 != null ? !cellType5.equals(cellType6) : cellType6 != null) break block6;
                    v = cell.getStringCellValue();
                    if (Strings$.MODULE$.isEmpty((CharSequence)v)) break block7;
                    String string = v;
                    String string2 = "\u203b";
                    if (string != null ? !string.equals(string2) : string2 != null) break block8;
                }
                return 0.0f;
            }
            return StringOps$.MODULE$.toFloat$extension(Predef$.MODULE$.augmentString(v));
        }
        CellType cellType = cell.getCellType();
        CellType cellType7 = CellType.FORMULA;
        if (!(cellType != null ? !cellType.equals(cellType7) : cellType7 != null)) {
            double v = cell.getNumericCellValue();
            return (float)v;
        }
        throw new RuntimeException("cannot read cell of type " + cell.getCellType());
    }

    private int getInt(XSSFCell cell) {
        block11: {
            String v;
            block13: {
                block12: {
                    block10: {
                        block9: {
                            if (cell == null) break block9;
                            CellType cellType = cell.getCellType();
                            CellType cellType2 = CellType.BLANK;
                            if (cellType != null ? !cellType.equals(cellType2) : cellType2 != null) break block10;
                        }
                        return 0;
                    }
                    CellType cellType = cell.getCellType();
                    CellType cellType3 = CellType.NUMERIC;
                    if (!(cellType != null ? !cellType.equals(cellType3) : cellType3 != null)) {
                        return (int)cell.getNumericCellValue();
                    }
                    CellType cellType4 = cell.getCellType();
                    CellType cellType5 = CellType.STRING;
                    if (cellType4 != null ? !cellType4.equals(cellType5) : cellType5 != null) break block11;
                    v = cell.getStringCellValue();
                    if (Strings$.MODULE$.isBlank((CharSequence)v)) break block12;
                    String string = v;
                    String string2 = "\u203b";
                    if (string != null ? !string.equals(string2) : string2 != null) break block13;
                }
                return 0;
            }
            return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(v));
        }
        CellType cellType = cell.getCellType();
        CellType cellType6 = CellType.FORMULA;
        if (!(cellType != null ? !cellType.equals(cellType6) : cellType6 != null)) {
            Object n = CellOps$.MODULE$.getValue$extension(CellOps$.MODULE$.toCell((Cell)cell));
            if (n == null || Strings$.MODULE$.isBlank((CharSequence)n.toString().trim())) {
                return 0;
            }
            return Predef$.MODULE$.double2Double(StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(n.toString()))).intValue();
        }
        throw new RuntimeException("cannot read cell of type " + cell.getCellType());
    }

    private static final /* synthetic */ void process$$anonfun$1$$anonfun$1(XSSFRow row$1, String[] groupNames$1, BooleanRef groupNameOccured$1, int i) {
        XSSFCell cell = row$1.getCell(i);
        CellType cellType = cell.getCellType();
        CellType cellType2 = CellType.BLANK;
        if (cellType == null ? cellType2 != null : !cellType.equals(cellType2)) {
            groupNames$1[i] = cell.getStringCellValue();
            groupNameOccured$1.elem = true;
            return;
        }
        if (groupNameOccured$1.elem) {
            groupNames$1[i] = null;
            return;
        }
    }

    private static final String process$$anonfun$1$$anonfun$2(ExcelPlanCourse pc$1) {
        return "reading " + pc$1;
    }

    private static final /* synthetic */ ArrayBuffer addCluster$$anonfun$1(List codes$1, String name$1, List seqs$1, List credits$1, List terms$1, ExcelPlanCourse pc$2, ExcelCourseGroup group$2, int i) {
        String c = (String)codes$1.apply(i);
        ExcelPlanCourse newpc = new ExcelPlanCourse(i, c, name$1 + seqs$1.apply(i), null, Float$.MODULE$.float2double(BoxesRunTime.unboxToFloat((Object)credits$1.apply(i))), (int)(BoxesRunTime.unboxToFloat((Object)credits$1.apply(i)) * (float)16), 0, 0, 0, "\u5fc5\u4fee", terms$1.apply(i).toString() + "\u957f", null, pc$2.remark());
        return group$2.courses().addOne((Object)newpc);
    }

    public static class ExcelCourseGroup {
        private final String indexno;
        private final String typeName;
        private final Option givenName;
        private Option parent;
        private double credits;
        private int creditHours;
        private int theoreticalHours;
        private int practicalHours;
        private final ArrayBuffer courses;
        private ArrayBuffer children;
        private Terms terms;
        private Option weeks;
        private String termCredits;
        private Option stage;
        private Option departments;
        private Option remark;

        public ExcelCourseGroup(String indexno, String typeName, Option<String> givenName) {
            this.indexno = indexno;
            this.typeName = typeName;
            this.givenName = givenName;
            this.parent = None$.MODULE$;
            this.courses = new ArrayBuffer();
            this.children = new ArrayBuffer();
            this.terms = Terms$.MODULE$.empty();
            this.weeks = None$.MODULE$;
            this.termCredits = "0,0,0,0,0,0,0,0";
            this.stage = None$.MODULE$;
            this.departments = None$.MODULE$;
            this.remark = None$.MODULE$;
        }

        public String indexno() {
            return this.indexno;
        }

        public String typeName() {
            return this.typeName;
        }

        public Option<String> givenName() {
            return this.givenName;
        }

        public Option<ExcelCourseGroup> parent() {
            return this.parent;
        }

        public void parent_$eq(Option<ExcelCourseGroup> x$1) {
            this.parent = x$1;
        }

        public double credits() {
            return this.credits;
        }

        public void credits_$eq(double x$1) {
            this.credits = x$1;
        }

        public int creditHours() {
            return this.creditHours;
        }

        public void creditHours_$eq(int x$1) {
            this.creditHours = x$1;
        }

        public int theoreticalHours() {
            return this.theoreticalHours;
        }

        public void theoreticalHours_$eq(int x$1) {
            this.theoreticalHours = x$1;
        }

        public int practicalHours() {
            return this.practicalHours;
        }

        public void practicalHours_$eq(int x$1) {
            this.practicalHours = x$1;
        }

        public ArrayBuffer<ExcelPlanCourse> courses() {
            return this.courses;
        }

        public ArrayBuffer<ExcelCourseGroup> children() {
            return this.children;
        }

        public void children_$eq(ArrayBuffer<ExcelCourseGroup> x$1) {
            this.children = x$1;
        }

        public Terms terms() {
            return this.terms;
        }

        public void terms_$eq(Terms x$1) {
            this.terms = x$1;
        }

        public Option<Object> weeks() {
            return this.weeks;
        }

        public void weeks_$eq(Option<Object> x$1) {
            this.weeks = x$1;
        }

        public String termCredits() {
            return this.termCredits;
        }

        public void termCredits_$eq(String x$1) {
            this.termCredits = x$1;
        }

        public Option<CalendarStage> stage() {
            return this.stage;
        }

        public void stage_$eq(Option<CalendarStage> x$1) {
            this.stage = x$1;
        }

        public Option<String> departments() {
            return this.departments;
        }

        public void departments_$eq(Option<String> x$1) {
            this.departments = x$1;
        }

        public Option<String> remark() {
            return this.remark;
        }

        public void remark_$eq(Option<String> x$1) {
            this.remark = x$1;
        }

        public int rankId() {
            if (this.typeName().contains("\u5fc5") || this.typeName().contains("\u77ed\u5b66\u6bb5") && this.typeName().contains("\u7efc\u5408\u7d20\u8d28\u5b9e\u8df5") || this.typeName().contains("\u7efc\u5408\u80fd\u529b\u7d20\u8d28\u6d4b\u8bc4")) {
                return CourseRank$.MODULE$.Compulsory();
            }
            if (this.typeName().contains("\u9650")) {
                return CourseRank$.MODULE$.DesignatedSelective();
            }
            if (this.typeName().contains("\u81ea\u7531") || this.typeName().contains("\u9009\u4fee")) {
                return CourseRank$.MODULE$.FreeSelective();
            }
            if (this.typeName().contains("\u77ed\u5b66\u6bb5") && this.typeName().contains("\u4e13\u4e1a\u4e0e\u521b\u65b0\u5b9e\u8df5")) {
                return CourseRank$.MODULE$.FreeSelective();
            }
            if (this.parent().nonEmpty()) {
                return ((ExcelCourseGroup)this.parent().get()).rankId();
            }
            return 0;
        }

        public String toString() {
            return Tuple6$.MODULE$.apply((Object)this.typeName(), this.givenName(), (Object)BoxesRunTime.boxToDouble((double)this.credits()), (Object)BoxesRunTime.boxToInteger((int)this.creditHours()), (Object)BoxesRunTime.boxToInteger((int)this.theoreticalHours()), (Object)BoxesRunTime.boxToInteger((int)this.practicalHours())).toString();
        }

        public Option<ExcelCourseGroup> findGroup(String name, Option<String> givenName) {
            return this.children().find(arg_0 -> LixinPlanExcelReader$.org$openurp$edu$program$service$LixinPlanExcelReader$ExcelCourseGroup$$_$findGroup$$anonfun$1(name, givenName, arg_0));
        }

        public ExcelCourseGroup addGroup(String typeName, Option<String> givenName) {
            if (((String)givenName.getOrElse(LixinPlanExcelReader$::org$openurp$edu$program$service$LixinPlanExcelReader$ExcelCourseGroup$$_$addGroup$$anonfun$1)).contains("\u636e\u8de8\u5b66\u79d1\u8de8\u4e13\u4e1a\u9009\u4fee") || typeName.contains("\u636e\u8de8\u5b66\u79d1\u8de8\u4e13\u4e1a\u9009\u4fee")) {
                return this;
            }
            Option<ExcelCourseGroup> option = this.findGroup(typeName, givenName);
            if (None$.MODULE$.equals(option)) {
                Option<String> option2;
                String string = typeName;
                String string2 = this.typeName();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    Option<String> option3 = givenName;
                    Option<String> option4 = this.givenName();
                    if (!(option3 != null ? !option3.equals(option4) : option4 != null)) {
                        return this;
                    }
                }
                if (None$.MODULE$.equals(option2 = givenName)) {
                    ExcelCourseGroup child = new ExcelCourseGroup(this.newChildIndexno(), typeName, givenName);
                    child.stage_$eq(this.stage());
                    child.parent_$eq((Option<ExcelCourseGroup>)Some$.MODULE$.apply((Object)this));
                    this.children().addOne((Object)child);
                    return child;
                }
                if (option2 instanceof Some) {
                    String gn = (String)((Some)option2).value();
                    String string3 = this.typeName();
                    String string4 = typeName;
                    if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                        ExcelCourseGroup child = new ExcelCourseGroup(this.newChildIndexno(), typeName, givenName);
                        child.stage_$eq(this.stage());
                        child.parent_$eq((Option<ExcelCourseGroup>)Some$.MODULE$.apply((Object)this));
                        this.children().addOne((Object)child);
                        return child;
                    }
                    return this.addGroup(typeName, (Option<String>)None$.MODULE$).addGroup(typeName, givenName);
                }
                throw new MatchError(option2);
            }
            if (option instanceof Some) {
                ExcelCourseGroup g = (ExcelCourseGroup)((Some)option).value();
                return g;
            }
            throw new MatchError(option);
        }

        public String newChildIndexno() {
            return this.indexno() + "." + (this.children().size() + 1);
        }

        public void updateCreditAndHours(double credits, int creditHours, int theoreticalHours, int practicalHours) {
            this.credits_$eq(credits);
            this.creditHours_$eq(creditHours);
            this.theoreticalHours_$eq(theoreticalHours);
            this.practicalHours_$eq(practicalHours);
        }
    }

    public static class ExcelPlan {
        private final String name;
        private String department;
        private double credits;
        private int creditHours;
        private int theoreticalHours;
        private int practicalHours;
        private ArrayBuffer groups;
        private Map tags;
        private boolean ignoreCreditHours;

        public ExcelPlan(String name) {
            this.name = name;
            this.groups = new ArrayBuffer();
            this.tags = Collections$.MODULE$.newMap();
            this.ignoreCreditHours = true;
        }

        public String name() {
            return this.name;
        }

        public String department() {
            return this.department;
        }

        public void department_$eq(String x$1) {
            this.department = x$1;
        }

        public double credits() {
            return this.credits;
        }

        public void credits_$eq(double x$1) {
            this.credits = x$1;
        }

        public int creditHours() {
            return this.creditHours;
        }

        public void creditHours_$eq(int x$1) {
            this.creditHours = x$1;
        }

        public int theoreticalHours() {
            return this.theoreticalHours;
        }

        public void theoreticalHours_$eq(int x$1) {
            this.theoreticalHours = x$1;
        }

        public int practicalHours() {
            return this.practicalHours;
        }

        public void practicalHours_$eq(int x$1) {
            this.practicalHours = x$1;
        }

        public ArrayBuffer<ExcelCourseGroup> groups() {
            return this.groups;
        }

        public void groups_$eq(ArrayBuffer<ExcelCourseGroup> x$1) {
            this.groups = x$1;
        }

        public Map<String, Set<String>> tags() {
            return this.tags;
        }

        public void tags_$eq(Map<String, Set<String>> x$1) {
            this.tags = x$1;
        }

        public boolean ignoreCreditHours() {
            return this.ignoreCreditHours;
        }

        public void ignoreCreditHours_$eq(boolean x$1) {
            this.ignoreCreditHours = x$1;
        }

        public void buildTags() {
            this.groups().foreach((Function1)(JProcedure1 & Serializable)g -> this.buildTags((ExcelCourseGroup)g));
        }

        public void buildTags(ExcelCourseGroup group) {
            group.courses().foreach((Function1)(JProcedure1 & Serializable)c -> c.remark().foreach((Function1)(JProcedure1 & Serializable)r -> {
                Object object = Predef$.MODULE$.refArrayOps((Object[])Strings$.MODULE$.split(r, new char[]{',', '\uff0c', ';', '\uff1b', ' '}));
                ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)r1 -> {
                    Object tagName = r1;
                    if (((String)tagName).contains("\u7279\u8272\u8bfe\u7a0b")) {
                        tagName = "\u7279\u5b9a\u9886\u57df\u7279\u8272\u8bfe\u7a0b";
                    }
                    if (((String)tagName).contains("\u4e13\u4e1a\u6838\u5fc3")) {
                        tagName = "\u4e13\u4e1a\u6838\u5fc3\u8bfe\u7a0b";
                    }
                    if (((String)tagName).contains("\u4e13\u4e1a\u7efc\u5408\u5b9e\u9a8c\u8bfe")) {
                        tagName = "\u4e13\u4e1a\u7efc\u5408\u5b9e\u9a8c\u8bfe";
                    }
                    if (((String)tagName).contains("\u72ec\u7acb\u8bbe\u7f6e") && ((String)tagName).contains("\u5b9e\u9a8c")) {
                        tagName = "\u72ec\u7acb\u8bbe\u7f6e\u5b9e\u9a8c\u8bfe";
                    }
                    if ((((String)tagName).endsWith("\u8bfe") || ((String)tagName).endsWith("\u8bfe\u7a0b")) && !((String)tagName).contains("\u9009\u8bfe")) {
                        if (((String)tagName).endsWith("\u8bfe")) {
                            tagName = (String)tagName + "\u7a0b";
                        }
                        Set cs = (Set)this.tags().getOrElseUpdate(tagName, LixinPlanExcelReader$::org$openurp$edu$program$service$LixinPlanExcelReader$ExcelPlan$$_$_$$anonfun$2);
                        cs.addOne((Object)c.courseCode());
                        return;
                    }
                });
            }));
            group.children().foreach((Function1)(JProcedure1 & Serializable)child -> this.buildTags((ExcelCourseGroup)child));
        }

        public MajorPlan convert(Program program, EntityDao entityDao, Buffer<String> messages) {
            MajorPlan majorPlan = new MajorPlan();
            majorPlan.program_$eq(program);
            this.groups().foreach((Function1)(JProcedure1 & Serializable)g -> this.convertGroup((ExcelCourseGroup)g, program, entityDao, messages).foreach(arg_0 -> LixinPlanExcelReader$.org$openurp$edu$program$service$LixinPlanExcelReader$ExcelPlan$$_$convert$$anonfun$1$$anonfun$1(majorPlan, arg_0)));
            this.buildTags();
            scala.collection.immutable.Map programCourseTags = ((IterableOnceOps)entityDao.getAll(ProgramCourseTag.class).map(LixinPlanExcelReader$::org$openurp$edu$program$service$LixinPlanExcelReader$ExcelPlan$$_$_$$anonfun$3)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            scala.collection.immutable.Map courseTags = ((IterableOnceOps)entityDao.getAll(CourseTag.class).map(LixinPlanExcelReader$::org$openurp$edu$program$service$LixinPlanExcelReader$ExcelPlan$$_$_$$anonfun$4)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Buffer labels = Collections$.MODULE$.newBuffer();
            this.tags().foreach((Function1)((JProcedure1 & Serializable)arg_0 -> LixinPlanExcelReader$.org$openurp$edu$program$service$LixinPlanExcelReader$ExcelPlan$$_$convert$$anonfun$2(entityDao, program, programCourseTags, labels, courseTags, messages, arg_0)));
            if (labels.nonEmpty()) {
                labels.foreach((Function1)((JProcedure1 & Serializable)arg_0 -> LixinPlanExcelReader$.org$openurp$edu$program$service$LixinPlanExcelReader$ExcelPlan$$_$convert$$anonfun$3(program, arg_0)));
                Buffer droped = (Buffer)program.labels().filter(arg_0 -> LixinPlanExcelReader$.org$openurp$edu$program$service$LixinPlanExcelReader$ExcelPlan$$_$_$$anonfun$5(labels, arg_0));
                program.labels().subtractAll((IterableOnce)droped);
            }
            return majorPlan;
        }

        private Option<String> convertRemark(Option<String> remark) {
            Option<String> option = remark;
            if (None$.MODULE$.equals(option)) {
                return None$.MODULE$;
            }
            if (option instanceof Some) {
                String r;
                String r1 = r = (String)((Some)option).value();
                r1 = Strings$.MODULE$.replace(r1, "\u8003\u8bd51", "");
                r1 = Strings$.MODULE$.replace(r1, "\u8003\u8bd52", "");
                r1 = Strings$.MODULE$.replace(r1, "\u8003\u8bd53", "");
                r1 = Strings$.MODULE$.replace(r1, "\u8003\u8bd54", "");
                r1 = Strings$.MODULE$.replace(r1, "\u8003\u8bd55", "");
                r1 = Strings$.MODULE$.replace(r1, "\u8003\u8bd56", "");
                r1 = Strings$.MODULE$.replace(r1, "\u8003\u8bd57", "");
                r1 = Strings$.MODULE$.replace(r1, "\u8003\u8bd58", "");
                r1 = Strings$.MODULE$.replace(r1, "\u8003\u8bd5", "");
                r1 = Strings$.MODULE$.replace(r1, "\u8003\u67e51", "");
                r1 = Strings$.MODULE$.replace(r1, "\u8003\u67e52", "");
                r1 = Strings$.MODULE$.replace(r1, "\u8003\u67e53", "");
                r1 = Strings$.MODULE$.replace(r1, "\u8003\u67e54", "");
                r1 = Strings$.MODULE$.replace(r1, "\u8003\u67e55", "");
                r1 = Strings$.MODULE$.replace(r1, "\u8003\u67e56", "");
                r1 = Strings$.MODULE$.replace(r1, "\u8003\u67e57", "");
                r1 = Strings$.MODULE$.replace(r1, "\u8003\u67e58", "");
                r1 = Strings$.MODULE$.replace(r1, "\u8003\u67e5", "");
                r1 = Strings$.MODULE$.replace(r1, "\u4e13\u4e1a\u7efc\u5408\u5b9e\u9a8c\u8bfe", "");
                r1 = Strings$.MODULE$.replace(r1, "\u72ec\u7acb\u8bbe\u7f6e\u5b9e\u9a8c\u8bfe", "");
                r1 = Strings$.MODULE$.replace(r1, "\u4e13\u4e1a\u6838\u5fc3\u8bfe\u7a0b", "");
                r1 = Strings$.MODULE$.replace(r1, "\u4e13\u4e1a\u7efc\u5408\u5b9e\u9a8c\u8bfe", "");
                r1 = Strings$.MODULE$.replace(r1, "\u72ec\u7acb\u8bbe\u7f6e\u7684\u5b9e\u9a8c\u8bfe", "");
                r1 = Strings$.MODULE$.replace(r1, "\u4e13\u4e1a\u6838\u5fc3", "");
                r1 = Strings$.MODULE$.replace(r1, "\u7279\u8272\u8bfe\u7a0b", "");
                r1 = Strings$.MODULE$.replace(r1, "\u7279\u5b9a\u9886\u57df\u7279\u8272\u8bfe\u7a0b", "");
                r1 = Strings$.MODULE$.replace(r1, "\u8de8\u5b66\u79d1\u878d\u5408\u8bfe\u7a0b", "");
                r1 = Strings$.MODULE$.replace(r1, "\u4e13\u4e1a\u6570\u667a\u5316\u8bfe\u7a0b", "");
                r1 = Strings$.MODULE$.replace(r1, "\u53cc\u8bc1\u878d\u901a\u8bfe\u7a0b", "");
                r1 = Strings$.MODULE$.replace(r1, "\u4e13\u521b\u878d\u5408\u8bfe\u7a0b", "");
                r1 = Strings$.MODULE$.replace(r1, "\u72ec\u7acb\u8bbe\u7f6e\u7684\u5b9e\u9a8c\u8bfe", "");
                r1 = Strings$.MODULE$.replace(r1, "\u4e13\u4e1a\u6838\u5fc3", "");
                r1 = Strings$.MODULE$.replace(r1, "\r", "");
                if ((r1 = Strings$.MODULE$.replace(r1, "\n", "")).startsWith(",") || r1.startsWith("\uff0c")) {
                    r1 = r1.substring(1);
                }
                if (Strings$.MODULE$.isBlank((CharSequence)r1)) {
                    return None$.MODULE$;
                }
                return Some$.MODULE$.apply((Object)r1);
            }
            throw new MatchError(option);
        }

        private Option<MajorCourseGroup> convertGroup(ExcelCourseGroup g, Program program, EntityDao entityDao, Buffer<String> messages) {
            MajorCourseGroup courseGroup = new MajorCourseGroup();
            Option option = entityDao.findBy(CourseType.class, "name", (Object)g.typeName()).headOption();
            if (None$.MODULE$.equals(option)) {
                messages.addOne((Object)("\u9519\u8bef\u7684\u8bfe\u7a0b\u5206\u7ec4:" + g.typeName()));
                return None$.MODULE$;
            }
            if (option instanceof Some) {
                CourseType courseType = (CourseType)((Some)option).value();
                courseGroup.credits_$eq(Int$.MODULE$.int2float((int)g.credits()));
                courseGroup.termCredits_$eq(g.termCredits());
                courseGroup.terms_$eq(g.terms());
                courseGroup.creditHours_$eq(g.creditHours());
                courseGroup.hourRatios_$eq("1:" + g.theoreticalHours() + ",9:" + g.practicalHours());
                courseGroup.weeks_$eq(g.weeks());
                courseGroup.stage_$eq(g.stage());
                courseGroup.indexno_$eq(g.indexno());
                courseGroup.courseType_$eq(courseType);
                courseGroup.givenName_$eq(g.givenName());
                courseGroup.departments_$eq(g.departments());
                courseGroup.remark_$eq(g.remark());
                courseGroup.rank_$eq((Option)(g.rankId() > 0 ? Some$.MODULE$.apply((Object)new CourseRank(g.rankId())) : None$.MODULE$));
                courseGroup.stage_$eq(g.stage());
                g.children().foreach((Function1)(JProcedure1 & Serializable)c -> this.convertGroup((ExcelCourseGroup)c, program, entityDao, messages).foreach((Function1)((JProcedure1 & Serializable)arg_0 -> LixinPlanExcelReader$.org$openurp$edu$program$service$LixinPlanExcelReader$ExcelPlan$$_$convertGroup$$anonfun$1$$anonfun$1(courseGroup, arg_0))));
                IntRef i = IntRef.create((int)1);
                g.courses().foreach((Function1 & Serializable)c -> {
                    MajorPlanCourse pc = new MajorPlanCourse();
                    Object[] objectArray = new Tuple2[2];
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"project");
                    objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)program.project());
                    String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"code");
                    objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)c.courseCode());
                    Option course = entityDao.findBy(Course.class, (Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).headOption();
                    Option option = course;
                    if (None$.MODULE$.equals(option)) {
                        return messages.addOne((Object)("\u9519\u8bef\u7684\u8bfe\u7a0b\u4ee3\u7801:" + c.courseCode()));
                    }
                    if (option instanceof Some) {
                        Course cc = (Course)((Some)option).value();
                        pc.idx_$eq((short)i$1.elem);
                        pc.course_$eq(cc);
                        pc.terms_$eq(c.toTerms());
                        pc.remark_$eq(this.convertRemark(c.remark()));
                        pc.termText_$eq((Option)Some$.MODULE$.apply((Object)c.terms()));
                        pc.compulsory_$eq(c.nature() != null && c.nature().contains("\u5fc5"));
                        if ((int)cc.defaultCredits() != (int)c.credits()) {
                            messages.addOne((Object)("\u9519\u8bef\u7684\u8bfe\u7a0b\u5b66\u5206:" + cc.code() + " " + cc.name() + " \u7684\u5b66\u5206\u4e3a" + cc.defaultCredits() + " excel\u4e2d\u4e3a" + c.credits()));
                        }
                        if (!this.ignoreCreditHours() && !LixinPlanExcelReader$.MODULE$.fixedCourseCodes().contains((Object)cc.code())) {
                            CourseJournal cj = cc.getJournal(program.grade());
                            cj.creditHours_$eq(c.creditHours());
                            cj.updateHour(new TeachingNature(1), c.theoreticalHours());
                            cj.updateHour(new TeachingNature(9), c.practicalHours());
                            cj.weeks_$eq((Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)c.weeks())));
                            if (c.remark() != null) {
                                if (((String)c.remark().getOrElse(LixinPlanExcelReader$::org$openurp$edu$program$service$LixinPlanExcelReader$ExcelPlan$$_$convertGroup$$anonfun$2$$anonfun$1)).contains("\u8003\u8bd5")) {
                                    cj.examMode_$eq(new ExamMode(1));
                                } else if (((String)c.remark().getOrElse(LixinPlanExcelReader$::org$openurp$edu$program$service$LixinPlanExcelReader$ExcelPlan$$_$convertGroup$$anonfun$2$$anonfun$2)).contains("\u8003\u67e5")) {
                                    cj.examMode_$eq(new ExamMode(2));
                                }
                            }
                            entityDao.saveOrUpdate((Object)cj, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CourseJournal[0]));
                            entityDao.saveOrUpdate((Iterable)cj.hours());
                        }
                        courseGroup.addCourse((AbstractPlanCourse)pc);
                        ++i$1.elem;
                        return BoxedUnit.UNIT;
                    }
                    throw new MatchError((Object)option);
                });
                return Some$.MODULE$.apply((Object)courseGroup);
            }
            throw new MatchError((Object)option);
        }
    }

    public static class ExcelPlanCourse {
        private final int seq;
        private final String courseCode;
        private final String courseName;
        private final String courseNameEn;
        private final double credits;
        private final int creditHours;
        private final int weeks;
        private final int theoreticalHours;
        private final int practicalHours;
        private final String nature;
        private final String terms;
        private final String depart;
        private Option remark;

        public ExcelPlanCourse(int seq, String courseCode, String courseName, String courseNameEn, double credits, int creditHours, int weeks, int theoreticalHours, int practicalHours, String nature, String terms, String depart, Option<String> remark) {
            this.seq = seq;
            this.courseCode = courseCode;
            this.courseName = courseName;
            this.courseNameEn = courseNameEn;
            this.credits = credits;
            this.creditHours = creditHours;
            this.weeks = weeks;
            this.theoreticalHours = theoreticalHours;
            this.practicalHours = practicalHours;
            this.nature = nature;
            this.terms = terms;
            this.depart = depart;
            this.remark = remark;
        }

        public int seq() {
            return this.seq;
        }

        public String courseCode() {
            return this.courseCode;
        }

        public String courseName() {
            return this.courseName;
        }

        public String courseNameEn() {
            return this.courseNameEn;
        }

        public double credits() {
            return this.credits;
        }

        public int creditHours() {
            return this.creditHours;
        }

        public int weeks() {
            return this.weeks;
        }

        public int theoreticalHours() {
            return this.theoreticalHours;
        }

        public int practicalHours() {
            return this.practicalHours;
        }

        public String nature() {
            return this.nature;
        }

        public String terms() {
            return this.terms;
        }

        public String depart() {
            return this.depart;
        }

        public Option<String> remark() {
            return this.remark;
        }

        public void remark_$eq(Option<String> x$1) {
            this.remark = x$1;
        }

        public Terms toTerms() {
            return LixinPlanExcelReader$.MODULE$.toTerms(this.terms());
        }

        public String toString() {
            return Tuple12$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.seq()), (Object)this.courseCode(), (Object)this.courseName(), (Object)this.courseNameEn(), (Object)BoxesRunTime.boxToDouble((double)this.credits()), (Object)BoxesRunTime.boxToInteger((int)this.creditHours()), (Object)BoxesRunTime.boxToInteger((int)this.theoreticalHours()), (Object)BoxesRunTime.boxToInteger((int)this.practicalHours()), (Object)this.nature(), (Object)this.terms(), (Object)this.depart(), this.remark()).toString();
        }
    }
}

