/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.web.action.major;

import com.google.gson.Gson;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.util.HashMap;
import org.beangle.commons.collection.Collections$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.Entity;
import org.beangle.webmvc.To;
import org.beangle.webmvc.annotation.mapping;
import org.beangle.webmvc.annotation.param;
import org.beangle.webmvc.context.ActionContext$;
import org.beangle.webmvc.support.action.EntityAction;
import org.beangle.webmvc.support.action.RestfulAction;
import org.beangle.webmvc.view.View;
import org.openurp.base.edu.model.Course;
import org.openurp.base.edu.model.Direction;
import org.openurp.base.edu.model.Major;
import org.openurp.base.model.AuditStatus;
import org.openurp.base.model.AuditStatus$;
import org.openurp.base.model.Project;
import org.openurp.base.service.ProjectConfigService;
import org.openurp.base.service.SemesterService;
import org.openurp.base.std.model.Grade;
import org.openurp.code.edu.model.Certificate;
import org.openurp.code.edu.model.CourseType;
import org.openurp.code.edu.model.Degree;
import org.openurp.code.edu.model.EducationLevel;
import org.openurp.code.edu.model.EducationType;
import org.openurp.code.service.CodeService;
import org.openurp.code.std.model.StdType;
import org.openurp.edu.program.model.AbstractCoursePlan;
import org.openurp.edu.program.model.CoursePlan;
import org.openurp.edu.program.model.ExecutivePlan;
import org.openurp.edu.program.model.MajorPlan;
import org.openurp.edu.program.model.Program;
import org.openurp.edu.program.model.ProgramCourseLabel;
import org.openurp.edu.program.model.ProgramDoc;
import org.openurp.edu.program.model.ProgramPrerequisite;
import org.openurp.edu.program.service.CoursePlanService;
import org.openurp.edu.program.service.ProgramNamingHelper;
import org.openurp.edu.program.web.action.major.ReviseAction;
import org.openurp.edu.program.web.helper.GradeHelper;
import org.openurp.edu.program.web.helper.MajorPlanCompareHelper;
import org.openurp.edu.program.web.helper.ProgramInfoHelper;
import org.openurp.starter.web.support.ProjectSupport;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class AdminAction
extends RestfulAction<Program>
implements ProjectSupport {
    private CodeService codeService;
    private ProjectConfigService configService;
    private SemesterService semesterService;
    private CoursePlanService planService;

    public AdminAction() {
        ProjectSupport.$init$((ProjectSupport)this);
    }

    public CodeService codeService() {
        return this.codeService;
    }

    public ProjectConfigService configService() {
        return this.configService;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void codeService_$eq(CodeService x$1) {
        this.codeService = x$1;
    }

    public void configService_$eq(ProjectConfigService x$1) {
        this.configService = x$1;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public CoursePlanService planService() {
        return this.planService;
    }

    public void planService_$eq(CoursePlanService x$1) {
        this.planService = x$1;
    }

    public void indexSetting() {
        LazyRef lazyRef = new LazyRef();
        Seq departmentList = this.getDeparts(this.project$1(lazyRef));
        this.put("departments", departmentList);
        this.put("levels", this.project$1(lazyRef).levels());
        this.put("educationTypes", this.getCodes(EducationType.class, this.project$1(lazyRef)));
        this.put("stdTypes", this.getCodes(StdType.class, this.project$1(lazyRef)));
        OqlBuilder query = OqlBuilder$.MODULE$.from(Major.class, "m");
        query.where("m.project=:project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.project$1(lazyRef)}));
        query.where("exists(from m.journals as mj where mj.depart in(:departs))", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{departmentList}));
        query.orderBy("m.code");
        Seq majors = this.entityDao().search((QueryBuilder)query);
        this.put("majors", majors);
        this.put("statuses", new .colon.colon((Object)AuditStatus$.Submited, (List)new .colon.colon((Object)AuditStatus$.PassedByDepart, (List)new .colon.colon((Object)AuditStatus$.RejectedByDepart, (List)new .colon.colon((Object)AuditStatus$.Passed, (List)new .colon.colon((Object)AuditStatus$.Rejected, (List)Nil$.MODULE$))))));
        super.indexSetting();
    }

    public OqlBuilder<Program> getQueryBuilder() {
        OqlBuilder q = EntityAction.getQueryBuilder$((EntityAction)this);
        Project project = this.getProject();
        this.put("displayEducationType", BoxesRunTime.boxToBoolean((project.eduTypes().size() > 1 ? 1 : 0) != 0));
        this.queryByDepart(q, "program.department");
        this.getBoolean("fake.valid").foreach((Function1 & Serializable)active -> AdminAction.getQueryBuilder$$anonfun$1(q, BoxesRunTime.unboxToBoolean((Object)active)));
        return (OqlBuilder)q.where("program.project=:project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project}));
    }

    public void editSetting(Program program) {
        LazyRef lazyRef = new LazyRef();
        Seq departs = this.getDeparts(this.project$2(lazyRef));
        OqlBuilder query = OqlBuilder$.MODULE$.from(Major.class, "m");
        query.where("m.project=:project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.project$2(lazyRef)}));
        query.where("exists(from m.journals as mj where mj.depart in(:departs))", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{departs}));
        query.orderBy("m.code");
        Seq majors = this.entityDao().search((QueryBuilder)query);
        OqlBuilder query2 = OqlBuilder$.MODULE$.from(Direction.class, "m");
        query2.where("m.project=:project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.project$2(lazyRef)}));
        query2.where("exists(from m.journals as mj where mj.depart in(:departs))", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{departs}));
        query2.orderBy("m.code");
        Seq directions = this.entityDao().search((QueryBuilder)query2);
        this.put("grades", new GradeHelper(this.entityDao()).getGrades(this.project$2(lazyRef)));
        this.put("departs", departs);
        this.put("majors", majors);
        this.put("directions", directions);
        this.put("project", this.project$2(lazyRef));
        if (program.persisted()) {
            MajorPlan majorPlan;
            this.put("docs", this.entityDao().findBy(ProgramDoc.class, "program", (Object)program));
            boolean hasDegreeCourse = program.degreeCourses().nonEmpty();
            boolean degreeGpaSupport = BoxesRunTime.unboxToBoolean((Object)this.getConfig("edu.program.degree_gpa_supported", BoxesRunTime.boxToBoolean((boolean)false), this.project$2(lazyRef)));
            boolean degreeCourseSupport = hasDegreeCourse;
            if (!degreeCourseSupport) {
                degreeCourseSupport = BoxesRunTime.unboxToBoolean((Object)this.getConfig("edu.program.degree_course_supported", BoxesRunTime.boxToBoolean((boolean)false), this.project$2(lazyRef)));
            }
            this.put("degreeCourseSupport", BoxesRunTime.boxToBoolean((boolean)degreeCourseSupport));
            this.put("degreeGpaSupport", BoxesRunTime.boxToBoolean((boolean)degreeGpaSupport));
            Option option = this.entityDao().findBy(MajorPlan.class, "program", (Object)program).headOption();
            if (option instanceof Some) {
                MajorPlan plan;
                majorPlan = plan = (MajorPlan)((Some)option).value();
            } else if (None$.MODULE$.equals(option)) {
                MajorPlan plan = new MajorPlan(program);
                this.entityDao().saveOrUpdate((Object)plan, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MajorPlan[0]));
                majorPlan = plan;
            } else {
                throw new MatchError((Object)option);
            }
            MajorPlan plan = majorPlan;
            this.put("plan", plan);
            if (degreeCourseSupport) {
                Set planCourses = Collections$.MODULE$.newSet();
                plan.groups().foreach((Function1)(JProcedure1 & Serializable)cg -> cg.planCourses().foreach((Function1 & Serializable)pc -> planCourses.add((Object)pc.course())));
                this.put("degreeCourses", planCourses);
            }
        }
        this.put("degrees", this.getCodes(Degree.class, this.project$2(lazyRef)));
        this.put("certificates", this.getCodes(Certificate.class, this.project$2(lazyRef)));
        super.editSetting((Entity)program);
    }

    public View saveAndRedirect(Program program) {
        boolean autoname = this.getBoolean("autoname", true);
        if (autoname) {
            program.name_$eq(new ProgramNamingHelper(this.entityDao()).name(program.grade(), program.major(), (Option<Direction>)program.direction()));
        }
        program.stdTypes().clear();
        Seq stdTypes = this.entityDao().find(StdType.class, (Iterable)this.getIntIds("stdType"));
        program.stdTypes().addAll((IterableOnce)stdTypes);
        program.degreeCourses().clear();
        program.degreeCourses().addAll((IterableOnce)this.entityDao().find(Course.class, (Iterable)this.getLongIds("degreeCourse")));
        program.updatedAt_$eq(Instant.now());
        program.project_$eq(this.getProject());
        program.degreeCertificates().clear();
        program.degreeCertificates().addAll((IterableOnce)this.entityDao().find(Certificate.class, (Iterable)this.getIntIds("degreeCertificate")));
        this.entityDao().saveOrUpdate((Object)program, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Program[0]));
        Option option = this.getLong("copyFrom.id");
        if (option instanceof Some) {
            long id = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            Program copyForm = (Program)this.entityDao().get(Program.class, (Object)BoxesRunTime.boxToLong((long)id));
            this.entityDao().findBy(MajorPlan.class, "program", (Object)copyForm).foreach((Function1)(JProcedure1 & Serializable)p -> {
                if (this.entityDao().findBy(MajorPlan.class, "program", (Object)program).isEmpty()) {
                    MajorPlan plan = new MajorPlan(program, (AbstractCoursePlan)p);
                    this.entityDao().saveOrUpdate((Object)plan, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MajorPlan[0]));
                    return;
                }
            });
            this.entityDao().findBy(ProgramDoc.class, "program", (Object)copyForm).foreach((Function1)(JProcedure1 & Serializable)d -> {
                ProgramDoc doc = new ProgramDoc(program, d);
                this.entityDao().saveOrUpdate((Object)doc, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ProgramDoc[0]));
            });
            this.entityDao().findBy(ProgramPrerequisite.class, "program", (Object)copyForm).foreach((Function1)(JProcedure1 & Serializable)d -> {
                ProgramPrerequisite pp = new ProgramPrerequisite(program, d.course(), d.prerequisite());
                this.entityDao().saveOrUpdate((Object)pp, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ProgramPrerequisite[0]));
            });
            this.entityDao().findBy(ProgramCourseLabel.class, "program", (Object)copyForm).foreach((Function1)(JProcedure1 & Serializable)d -> {
                ProgramCourseLabel pcl = new ProgramCourseLabel(program, d.course(), d.tag());
                this.entityDao().saveOrUpdate((Object)pcl, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ProgramCourseLabel[0]));
            });
        } else if (None$.MODULE$.equals(option)) {
            if (this.entityDao().findBy(MajorPlan.class, "program", (Object)program).isEmpty()) {
                MajorPlan plan = new MajorPlan(program);
                this.entityDao().saveOrUpdate((Object)plan, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MajorPlan[0]));
            }
        } else {
            throw new MatchError((Object)option);
        }
        return super.saveAndRedirect((Entity)program);
    }

    public View duration() {
        HttpServletResponse response2 = ActionContext$.MODULE$.current().response();
        long majorId = BoxesRunTime.unboxToLong((Object)this.get("majorId", BoxesRunTime.boxToLong((long)0L)));
        int levelId = BoxesRunTime.unboxToInt((Object)this.get("levelId", BoxesRunTime.boxToInteger((int)0)));
        LocalDate start = (LocalDate)this.getDate("start").get();
        ObjectRef duration = ObjectRef.create((Object)None$.MODULE$);
        this.entityDao().find(Major.class, (Object)BoxesRunTime.boxToLong((long)majorId)).foreach((Function1)(JProcedure1 & Serializable)major -> major.schoolLengths().find((Function1 & Serializable)x -> BoxesRunTime.unboxToInt((Object)x.level().id()) == levelId).foreach((Function1)(JProcedure1 & Serializable)s -> {
            duration$2.elem = Some$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)s.normal()));
        }));
        if (((Option)duration.elem).isEmpty()) {
            duration.elem = Some$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)4.0f));
        }
        float d = BoxesRunTime.unboxToFloat((Object)((Option)duration.elem).get());
        int mnum = (int)(d * (float)12);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("endOn", start.plusMonths(Int$.MODULE$.int2long(mnum)).toString());
        result.put("duration", BoxesRunTime.boxToFloat((float)d));
        response2.setContentType("text/plain;charset=UTF-8");
        response2.getWriter().write(new Gson().toJson(result));
        response2.getWriter().close();
        return null;
    }

    @mapping(value="{id}")
    public View info(@param(value="id") String id) {
        Program program = (Program)this.entityDao().get(Program.class, (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(id))));
        ProgramInfoHelper helper = new ProgramInfoHelper(this.entityDao(), this.configService(), this.codeService());
        helper.prepareData(program);
        return this.forward(this.forward$default$1());
    }

    public View report() {
        return this.redirect((To)this.to(ReviseAction.class, "report", "program.id=" + this.getLongId("program")), "");
    }

    public View audit() {
        Seq programs = this.entityDao().find(Program.class, (Iterable)this.getLongIds("program"));
        boolean passed = this.getBoolean("passed", false);
        programs.foreach((Function1)(JProcedure1 & Serializable)program -> {
            AuditStatus status = passed ? AuditStatus$.Passed : AuditStatus$.Rejected;
            program.status_$eq(status);
        });
        this.entityDao().saveOrUpdate((Iterable)programs);
        return this.redirect("search", "\u5ba1\u6838\u6210\u529f");
    }

    public View gen() {
        Seq programs = this.entityDao().find(Program.class, (Iterable)this.getLongIds("program"));
        boolean force = this.getBoolean("force", false);
        programs.foreach((Function1)(JProcedure1 & Serializable)program -> this.entityDao().findBy(MajorPlan.class, "program", program).foreach((Function1)(JProcedure1 & Serializable)majorPlan -> {
            Seq eps = this.entityDao().findBy(ExecutivePlan.class, "program", program);
            if (eps.isEmpty()) {
                ExecutivePlan ep = new ExecutivePlan((AbstractCoursePlan)majorPlan);
                this.entityDao().saveOrUpdate((Object)ep, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ExecutivePlan[0]));
                return;
            }
        }));
        return this.redirect("search", "\u751f\u6210\u6210\u529f");
    }

    public View removeAndRedirect(Seq<Program> programs) {
        Seq removables = (Seq)programs.filter((Function1 & Serializable)_$2 -> {
            AuditStatus auditStatus = _$2.status();
            AuditStatus auditStatus2 = AuditStatus$.Passed;
            return auditStatus == null ? auditStatus2 != null : !auditStatus.equals(auditStatus2);
        });
        Seq docs = this.entityDao().findBy(ProgramDoc.class, "program", (Object)removables);
        Seq plans = this.entityDao().findBy(MajorPlan.class, "program", (Object)removables);
        this.entityDao().remove((Iterable)docs);
        this.entityDao().remove((Iterable)plans);
        return super.removeAndRedirect(removables);
    }

    public View copyPrompt() {
        LazyRef lazyRef = new LazyRef();
        Seq departs = this.getDeparts(this.project$3(lazyRef));
        OqlBuilder query = OqlBuilder$.MODULE$.from(Major.class, "m");
        query.where("m.project=:project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.project$3(lazyRef)}));
        query.where("exists(from m.journals as mj where mj.depart in(:departs))", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{departs}));
        query.orderBy("m.code");
        Seq majors = this.entityDao().search((QueryBuilder)query);
        OqlBuilder query2 = OqlBuilder$.MODULE$.from(Direction.class, "m");
        query2.where("m.project=:project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.project$3(lazyRef)}));
        query2.where("exists(from m.journals as mj where mj.depart in(:departs))", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{departs}));
        query2.orderBy("m.code");
        Seq directions = this.entityDao().search((QueryBuilder)query2);
        this.put("grades", new GradeHelper(this.entityDao()).getGrades(this.project$3(lazyRef)));
        this.put("departs", departs);
        this.put("majors", majors);
        this.put("directions", directions);
        this.put("project", this.project$3(lazyRef));
        this.put("degrees", this.getCodes(Degree.class, this.project$3(lazyRef)));
        this.put("certificates", this.getCodes(Certificate.class, this.project$3(lazyRef)));
        Program copyFrom = (Program)this.entityDao().get(Program.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("program")));
        this.put("program", new Program(copyFrom));
        this.put("copyFrom", copyFrom);
        return this.forward(this.forward$default$1());
    }

    public View restat() {
        Seq programs = this.entityDao().find(Program.class, (Iterable)this.getLongIds("program"));
        programs.foreach((Function1)(JProcedure1 & Serializable)program -> this.entityDao().findBy(MajorPlan.class, "program", program).foreach((Function1 & Serializable)plan -> this.planService().statPlanCredits((CoursePlan)plan)));
        return this.redirect("search", "\u7edf\u8ba1\u6210\u529f");
    }

    public View compare() {
        LazyRef lazyRef = new LazyRef();
        Seq<Grade> grades = new GradeHelper(this.entityDao()).getGrades(this.project$4(lazyRef));
        this.put("grades", grades);
        this.put("levels", this.project$4(lazyRef).levels());
        this.put("allCourseTypes", this.getCodes(CourseType.class, this.project$4(lazyRef)));
        Grade grade = (Grade)this.getLong("grade.id").map((Function1 & Serializable)id -> this.$anonfun$2(BoxesRunTime.unboxToLong((Object)id))).getOrElse(() -> AdminAction.$anonfun$3(grades));
        EducationLevel level = (EducationLevel)this.getInt("level.id").map((Function1 & Serializable)id -> this.$anonfun$4(BoxesRunTime.unboxToInt((Object)id))).getOrElse(() -> this.$anonfun$5(lazyRef));
        this.put("grade", grade);
        this.put("level", level);
        List courseTypeIds = this.getIntIds("courseType");
        if (courseTypeIds.nonEmpty()) {
            OqlBuilder q = OqlBuilder$.MODULE$.from(MajorPlan.class, "plan");
            q.where("plan.program.grade=:grade", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{grade}));
            q.where("plan.program.project=:project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.project$4(lazyRef)}));
            q.where("plan.program.level=:level", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{level}));
            q.orderBy("plan.program.department.code,plan.program.major.name");
            Seq plans = this.entityDao().search((QueryBuilder)q);
            this.put("plans", plans);
            this.put("departPlans", plans.groupBy((Function1 & Serializable)_$3 -> _$3.program().department()));
            Seq courseTypes = this.entityDao().find(CourseType.class, (Iterable)courseTypeIds);
            this.put("courseTypes", courseTypes);
            this.put("compareHelper", new MajorPlanCompareHelper((Iterable<CourseType>)courseTypes));
        } else {
            this.put("courseTypes", package$.MODULE$.List().empty());
        }
        return this.forward(this.forward$default$1());
    }

    private final Project project$lzyINIT1$1(LazyRef project$lzy1$1) {
        Project project;
        LazyRef lazyRef = project$lzy1$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy1$1.initialized() ? project$lzy1$1.value() : project$lzy1$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$1(LazyRef project$lzy1$2) {
        return (Project)(project$lzy1$2.initialized() ? project$lzy1$2.value() : this.project$lzyINIT1$1(project$lzy1$2));
    }

    private static final /* synthetic */ OqlBuilder getQueryBuilder$$anonfun$1(OqlBuilder q$1, boolean active) {
        if (active) {
            return (OqlBuilder)q$1.where("(" + q$1.alias() + ".endOn >= :now)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        }
        return (OqlBuilder)q$1.where(" (" + q$1.alias() + ".endOn <= :now)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
    }

    private final Project project$lzyINIT2$1(LazyRef project$lzy2$1) {
        Project project;
        LazyRef lazyRef = project$lzy2$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy2$1.initialized() ? project$lzy2$1.value() : project$lzy2$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$2(LazyRef project$lzy2$2) {
        return (Project)(project$lzy2$2.initialized() ? project$lzy2$2.value() : this.project$lzyINIT2$1(project$lzy2$2));
    }

    private final Project project$lzyINIT3$1(LazyRef project$lzy3$1) {
        Project project;
        LazyRef lazyRef = project$lzy3$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy3$1.initialized() ? project$lzy3$1.value() : project$lzy3$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$3(LazyRef project$lzy3$2) {
        return (Project)(project$lzy3$2.initialized() ? project$lzy3$2.value() : this.project$lzyINIT3$1(project$lzy3$2));
    }

    private final Project project$lzyINIT4$1(LazyRef project$lzy4$1) {
        Project project;
        LazyRef lazyRef = project$lzy4$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy4$1.initialized() ? project$lzy4$1.value() : project$lzy4$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$4(LazyRef project$lzy4$2) {
        return (Project)(project$lzy4$2.initialized() ? project$lzy4$2.value() : this.project$lzyINIT4$1(project$lzy4$2));
    }

    private final /* synthetic */ Grade $anonfun$2(long id) {
        return (Grade)this.entityDao().get(Grade.class, (Object)BoxesRunTime.boxToLong((long)id));
    }

    private static final Grade $anonfun$3(Seq grades$1) {
        return (Grade)grades$1.head();
    }

    private final /* synthetic */ EducationLevel $anonfun$4(int id) {
        return (EducationLevel)this.entityDao().get(EducationLevel.class, (Object)BoxesRunTime.boxToInteger((int)id));
    }

    private final EducationLevel $anonfun$5(LazyRef project$lzy4$3) {
        return (EducationLevel)this.project$4(project$lzy4$3).levels().head();
    }
}

