/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.web.helper;

import java.util.Locale;
import org.beangle.commons.lang.Locales$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.text.seq.MultiLevelSeqGenerator;
import org.beangle.commons.text.seq.RomanSeqStyle;
import org.beangle.commons.text.seq.SeqNumStyle;
import org.beangle.commons.text.seq.SeqNumStyle$;
import org.beangle.commons.text.seq.SeqPattern;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.ems.app.Ems$;
import org.beangle.webmvc.context.ActionContext$;
import org.openurp.base.model.Department;
import org.openurp.base.model.Project;
import org.openurp.base.service.Feature;
import org.openurp.base.service.ProjectConfigService;
import org.openurp.base.std.model.Grade;
import org.openurp.code.Code;
import org.openurp.code.edu.model.ProgramCourseTag;
import org.openurp.code.edu.model.TeachingNature;
import org.openurp.code.service.CodeService;
import org.openurp.edu.program.model.CoursePlan;
import org.openurp.edu.program.model.CreditHours$;
import org.openurp.edu.program.model.MajorPlan;
import org.openurp.edu.program.model.Program;
import org.openurp.edu.program.model.ProgramDoc;
import org.openurp.edu.program.service.PlanCategoryStat;
import org.openurp.edu.program.service.PlanCategoryStat$;
import org.openurp.edu.program.service.PlanCourseCluster;
import org.openurp.edu.program.service.PlanGroupStat;
import org.openurp.edu.program.service.PlanGroupStat$;
import org.openurp.edu.program.service.PlanRender$;
import org.openurp.edu.program.service.TermHelper;
import org.openurp.edu.service.Features;
import org.openurp.starter.web.helper.ProjectProfile$;
import scala.Option;
import scala.Option$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;

public class ProgramReportHelper {
    private final EntityDao entityDao;
    private final ProjectConfigService configService;
    private final CodeService codeService;

    public ProgramReportHelper(EntityDao entityDao, ProjectConfigService configService, CodeService codeService) {
        this.entityDao = entityDao;
        this.configService = configService;
        this.codeService = codeService;
    }

    public void prepareData(Program program) {
        LazyRef lazyRef = new LazyRef();
        this.put("program", program);
        MajorPlan plan = (MajorPlan)this.entityDao.findBy(MajorPlan.class, "program", (Object)program).head();
        this.put("plan", plan);
        Option doc = this.entityDao.findBy(ProgramDoc.class, "program", (Object)program).headOption();
        this.put("doc", doc);
        if (doc.nonEmpty()) {
            SeqPattern topSeq = null;
            Locale locale = ((ProgramDoc)Option$.MODULE$.option2Iterable(doc).head()).docLocale();
            Locale locale2 = Locales$.MODULE$.chinese();
            topSeq = !(locale != null ? !((Object)locale).equals(locale2) : locale2 != null) ? new SeqPattern((SeqNumStyle)SeqNumStyle$.MODULE$.HANZI(), "{1}") : new SeqPattern((SeqNumStyle)new RomanSeqStyle(), "{1}");
            this.put("topSeq", topSeq);
        }
        this.put("displayCreditHour", this.getConfig(Features.Program$.MODULE$.DisplayCreditHour(), ProgramReportHelper.project$2(lazyRef, program)));
        this.put("enableLinkCourseInfo", this.getConfig(Features.Program$.MODULE$.LinkCourseEnabled(), ProgramReportHelper.project$2(lazyRef, program)));
        this.put("ems_base", Ems$.MODULE$.base());
        ProjectProfile$.MODULE$.set(ProgramReportHelper.project$2(lazyRef, program));
        Seq<TeachingNature> natures = this.getCodes(TeachingNature.class, ProgramReportHelper.project$2(lazyRef, program));
        this.put("natures", natures);
        this.put("tags", this.getCodes(ProgramCourseTag.class, ProgramReportHelper.project$2(lazyRef, program)));
        this.put("cluster", new PlanCourseCluster());
        this.put("termHelper", new TermHelper());
        this.put("planRender", PlanRender$.MODULE$);
        PlanCategoryStat stat = PlanCategoryStat$.MODULE$.stat((CoursePlan)plan, natures);
        this.put("stat", stat);
        PlanGroupStat planGroupStat = PlanGroupStat$.MODULE$.stat((CoursePlan)plan, natures);
        if (plan.creditHours() == 0 || Strings$.MODULE$.isEmpty((CharSequence)plan.hourRatios())) {
            plan.creditHours_$eq(planGroupStat.creditHours());
            plan.credits_$eq(planGroupStat.credits());
            plan.program().credits_$eq(plan.credits());
            plan.hourRatios_$eq(CreditHours$.MODULE$.toRatios((Map)planGroupStat.hours()));
            this.entityDao.saveOrUpdate((Object)plan, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MajorPlan[0]));
            this.entityDao.saveOrUpdate((Object)plan.program(), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Program[0]));
        }
        MultiLevelSeqGenerator sg = new MultiLevelSeqGenerator();
        sg.add(new SeqPattern((SeqNumStyle)SeqNumStyle$.MODULE$.HANZI(), "{1}"));
        sg.add(new SeqPattern((SeqNumStyle)SeqNumStyle$.MODULE$.HANZI(), "({2})"));
        sg.add(new SeqPattern((SeqNumStyle)SeqNumStyle$.MODULE$.ARABIC(), "{3}"));
        sg.add(new SeqPattern((SeqNumStyle)SeqNumStyle$.MODULE$.ARABIC(), "{3}.{4}"));
        sg.add(new SeqPattern((SeqNumStyle)SeqNumStyle$.MODULE$.ARABIC(), "{3}.{4}.{5}"));
        sg.add(new SeqPattern((SeqNumStyle)SeqNumStyle$.MODULE$.ARABIC(), "{3}.{4}.{5}.{6}"));
        sg.add(new SeqPattern((SeqNumStyle)SeqNumStyle$.MODULE$.ARABIC(), "{3}.{4}.{5}.{6}.{7}"));
        sg.add(new SeqPattern((SeqNumStyle)SeqNumStyle$.MODULE$.ARABIC(), "{3}.{4}.{5}.{6}.{7}.{8}"));
        sg.add(new SeqPattern((SeqNumStyle)SeqNumStyle$.MODULE$.ARABIC(), "{3}.{4}.{5}.{6}.{7}.{8}.{9}"));
        this.put("seqGenerator", sg);
    }

    public void prepareData(Project project, Grade grade, Department depart) {
        ProjectProfile$.MODULE$.set(project);
        OqlBuilder query = OqlBuilder$.MODULE$.from(MajorPlan.class, "plan");
        query.where("plan.program.project=:project", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project}));
        query.where("plan.program.department=:depart", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{depart}));
        query.where("plan.program.grade=:grade", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{grade}));
        scala.collection.immutable.Seq plans = this.entityDao.search((QueryBuilder)query);
        this.put("plans", plans);
        this.put("displayCreditHour", this.getConfig(Features.Program$.MODULE$.DisplayCreditHour(), ProgramReportHelper.p$1(project)));
        this.put("enableLinkCourseInfo", this.getConfig(Features.Program$.MODULE$.LinkCourseEnabled(), ProgramReportHelper.p$1(project)));
        this.put("ems_base", Ems$.MODULE$.base());
        Seq<TeachingNature> natures = this.getCodes(TeachingNature.class, ProgramReportHelper.p$1(project));
        this.put("natures", natures);
        this.put("tags", this.getCodes(ProgramCourseTag.class, ProgramReportHelper.p$1(project)));
        this.put("cluster", new PlanCourseCluster());
        this.put("termHelper", new TermHelper());
        this.put("planRender", PlanRender$.MODULE$);
    }

    public <T extends Code> Seq<T> getCodes(Class<T> clazz, Project project) {
        return this.codeService.get(clazz);
    }

    public Object getConfig(Feature f, Project project) {
        return this.configService.get(project, f, ClassTag$.MODULE$.Any());
    }

    private void put(String name, Object v) {
        ActionContext$.MODULE$.current().attribute(name, v);
    }

    private static final Project project$lzyINIT1$1(LazyRef project$lzy1$1, Program program$1) {
        Project project;
        LazyRef lazyRef = project$lzy1$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy1$1.initialized() ? project$lzy1$1.value() : project$lzy1$1.initialize((Object)program$1.project()));
        }
        return project;
    }

    private static final Project project$2(LazyRef project$lzy1$2, Program program$2) {
        return (Project)(project$lzy1$2.initialized() ? project$lzy1$2.value() : ProgramReportHelper.project$lzyINIT1$1(project$lzy1$2, program$2));
    }

    private static final Project p$1(Project project$1) {
        return project$1;
    }
}

