[#ftl]

[#-- 获得一个courseGroup的最深层次，自己的层次为1 --]
[#function myMaxDepth courseGroup]
    [#local max_level = 0 /]
    [#list courseGroup.children! as child]
        [#local t_level = myMaxDepth(child) /]
        [#if t_level > max_level]
            [#local max_level = t_level /]
        [/#if]
    [/#list]
    [#return max_level + 1 /]
[/#function]
[#-- 获得一个plan的课程组的最深层次 --]
[#function planMaxDepth plan]
    [#local max_level = 0 /]
    [#list plan.topGroups! as group]
        [#local t_level = myMaxDepth(group) /]
        [#if t_level > max_level]
            [#local max_level = t_level /]
        [/#if]
    [/#list]
    [#return max_level /]
[/#function]

[#-- 是叶子节点，叶子节点就是课程或没有课程的课程组 --]
[#function isLeaf obj]
    [#if obj.course??]    [#-- 是planCourse --]
        [#return true /]
    [#else]                [#-- 是courseGroup --]
        [#if (obj.children?size == 0) && (obj.planCourses?size == 0)]
            [#return true /]
        [/#if]
    [/#if]
    [#return false /]
[/#function]

[#function isLeafGroup obj]
    [#if (obj.children?size == 0) && (obj.planCourses?size == 0)]
        [#return true /]
    [/#if]
    [#return false /]
[/#function]

[#-- 一个课程组的最深的叶子处于第几层 --]
[#function myLeafMaxLevel courseGroup]
    [#if isLeafGroup(courseGroup)]    [#-- 如果是叶子节点 --]
        [#return 1 /]
    [/#if]
    [#if !courseGroup.children?? || courseGroup.children?size == 0] [#-- 不是叶子节点，但是也没有子课程组 --]
        [#return 2 /]
    [/#if]

    [#local max_level = 0 /]
    [#list courseGroup.children! as child]
        [#local t_level = myLeafMaxLevel(child) /]
        [#if t_level > max_level]
            [#local max_level = t_level /]
        [/#if]
    [/#list]
    [#return max_level + 1 /]
[/#function]

[#-- 一个培养计划的最深的叶子处于第几层 --]
[#function planLeafMaxLevel plan]
    [#local max_level = 0 /]
    [#list plan.topGroups! as group]
        [#local t_level = myLeafMaxLevel(group) /]
        [#if t_level > max_level]
            [#local max_level = t_level /]
        [/#if]
    [/#list]
    [#return max_level /]
[/#function]

[#-- 获得当前courseGroup的顶端courseGroup --]
[#function getTopCourseGroup group]
    [#if group.parent??]
        [#return getTopCourseGroup(group.parent) /]
    [#else]
        [#return group /]
    [/#if]
[/#function]

[#-- 获得一个courseGroup在自己的树里在第几层次 --]
[#function myCurrentLevel group]
    [#if group.parent??]
        [#return 1 + myCurrentLevel(group.parent) /]
    [#else]
        [#return 1 /]
    [/#if]
[/#function]

[#macro planMainTitle plan]${plan.program.department.name}&nbsp;${plan.program.major.name}专业[/#macro]
[#macro planSubTitle plan]${("("+ plan.program.direction.name + ")&nbsp;")!}&nbsp; ${plan.program.level.name}&nbsp;培养方案&nbsp;(${plan.program.grade.code})[/#macro]
