/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.web.action.major;

import jakarta.servlet.http.Part;
import java.io.InputStream;
import java.io.Serializable;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.collection.Order$;
import org.beangle.commons.collection.Properties;
import org.beangle.commons.collection.page.PageLimit;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.lang.time.WeekState$;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.LongId;
import org.beangle.data.model.NumId;
import org.beangle.ems.app.Ems$;
import org.beangle.webmvc.annotation.mapping;
import org.beangle.webmvc.annotation.param;
import org.beangle.webmvc.annotation.response;
import org.beangle.webmvc.context.ActionMessages;
import org.beangle.webmvc.support.ActionSupport;
import org.beangle.webmvc.support.EntitySupport;
import org.beangle.webmvc.support.action.EntityAction;
import org.beangle.webmvc.view.View;
import org.openurp.base.edu.model.Course;
import org.openurp.base.edu.model.Major;
import org.openurp.base.edu.model.Terms$;
import org.openurp.base.model.CalendarStage;
import org.openurp.base.model.Department;
import org.openurp.base.model.EduLevelBased;
import org.openurp.base.model.Project;
import org.openurp.base.service.ProjectConfigService;
import org.openurp.base.service.SemesterService;
import org.openurp.base.std.model.Grade;
import org.openurp.code.edu.model.CourseRank;
import org.openurp.code.edu.model.CourseRank$;
import org.openurp.code.edu.model.CourseType;
import org.openurp.code.edu.model.EducationLevel;
import org.openurp.code.edu.model.ProgramCourseTag;
import org.openurp.code.edu.model.TeachingNature;
import org.openurp.code.service.CodeService;
import org.openurp.edu.clazz.domain.WeekTimeBuilder$;
import org.openurp.edu.program.model.AbstractPlanCourse;
import org.openurp.edu.program.model.CourseGroup;
import org.openurp.edu.program.model.CoursePlan;
import org.openurp.edu.program.model.MajorCourseGroup;
import org.openurp.edu.program.model.MajorPlan;
import org.openurp.edu.program.model.MajorPlanCourse;
import org.openurp.edu.program.model.PlanCourse;
import org.openurp.edu.program.model.Program;
import org.openurp.edu.program.model.ProgramCourseLabel;
import org.openurp.edu.program.service.CoursePlanService;
import org.openurp.edu.program.service.PlanExcelReader;
import org.openurp.edu.program.service.ProgramChecker;
import org.openurp.edu.program.service.checkers.EnNameChecker;
import org.openurp.edu.program.util.PlanMerger$;
import org.openurp.edu.program.util.TermHelper$;
import org.openurp.edu.service.Features;
import org.openurp.starter.web.support.ProjectSupport;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Short$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Set;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class PlanAction
extends ActionSupport
implements EntityAction<MajorPlan>,
ProjectSupport {
    private Class entityClass;
    private CodeService codeService;
    private ProjectConfigService configService;
    private SemesterService semesterService;
    private ProgramChecker programChecker;
    private CoursePlanService planService;
    private EntityDao entityDao;
    private PlanExcelReader planExcelReader;

    public PlanAction() {
        EntitySupport.$init$((EntitySupport)this);
        ProjectSupport.$init$((ProjectSupport)this);
        Statics.releaseFence();
    }

    public Class entityClass() {
        return this.entityClass;
    }

    public void org$beangle$webmvc$support$EntitySupport$_setter_$entityClass_$eq(Class x$0) {
        this.entityClass = x$0;
    }

    public CodeService codeService() {
        return this.codeService;
    }

    public ProjectConfigService configService() {
        return this.configService;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void codeService_$eq(CodeService x$1) {
        this.codeService = x$1;
    }

    public void configService_$eq(ProjectConfigService x$1) {
        this.configService = x$1;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public ProgramChecker programChecker() {
        return this.programChecker;
    }

    public void programChecker_$eq(ProgramChecker x$1) {
        this.programChecker = x$1;
    }

    public CoursePlanService planService() {
        return this.planService;
    }

    public void planService_$eq(CoursePlanService x$1) {
        this.planService = x$1;
    }

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public PlanExcelReader planExcelReader() {
        return this.planExcelReader;
    }

    public void planExcelReader_$eq(PlanExcelReader x$1) {
        this.planExcelReader = x$1;
    }

    public View groups() {
        MajorPlan plan = (MajorPlan)this.entityDao().get(MajorPlan.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("plan")));
        this.getLong("courseGroup.id").foreach((Function1)(JFunction1.mcVJ.sp & Serializable)groupId -> this.put("activeGroup", this.entityDao().get(MajorCourseGroup.class, (Object)BoxesRunTime.boxToLong((long)groupId))));
        this.put("plan", plan);
        this.put("program", plan.program());
        this.put("stages", this.entityDao().findBy(CalendarStage.class, "school", (Object)plan.program().project().school()));
        return this.forward(this.forward$default$1());
    }

    public View editGroup() {
        MajorCourseGroup majorCourseGroup;
        LazyRef lazyRef = new LazyRef();
        long planId = this.getLongId("plan");
        MajorPlan plan = (MajorPlan)this.entityDao().get(MajorPlan.class, (Object)BoxesRunTime.boxToLong((long)planId));
        Seq unusedCourseTypeList = this.getCodes(CourseType.class, PlanAction.project$1(lazyRef, plan));
        Option option = this.getLong("courseGroup.id");
        if (None$.MODULE$.equals(option)) {
            MajorCourseGroup ng = new MajorCourseGroup();
            ng.indexno_$eq("99");
            majorCourseGroup = ng;
        } else if (option instanceof Some) {
            long gid = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            majorCourseGroup = (MajorCourseGroup)this.entityDao().get(MajorCourseGroup.class, (Object)BoxesRunTime.boxToLong((long)gid));
        } else {
            throw new MatchError((Object)option);
        }
        MajorCourseGroup group = majorCourseGroup;
        this.put("courseGroup", group);
        Map termCredits = Collections$.MODULE$.newMap();
        Object[] termCreditArray = Strings$.MODULE$.split(group.termCredits());
        Object object = Predef$.MODULE$.refArrayOps(termCreditArray);
        ArrayOps$.MODULE$.indices$extension(object).foreach(arg_0 -> PlanAction.editGroup$$anonfun$adapted$1(termCredits, (String[])termCreditArray, arg_0));
        this.put("unusedCourseTypeList", unusedCourseTypeList);
        this.put("parentCourseGroupList", plan.groups());
        this.put("termCredits", termCredits);
        this.put("ranks", this.getCodes(CourseRank.class, PlanAction.project$1(lazyRef, plan)));
        this.put("teachingNatures", this.getCodes(TeachingNature.class, PlanAction.project$1(lazyRef, plan)));
        this.put("stages", this.entityDao().getAll(CalendarStage.class));
        this.put("plan", plan);
        return this.forward(this.forward$default$1());
    }

    public View saveGroup() {
        LazyRef lazyRef = new LazyRef();
        MajorPlan plan = (MajorPlan)this.entityDao().get(MajorPlan.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("plan")));
        MajorCourseGroup group = (MajorCourseGroup)this.populateEntity(MajorCourseGroup.class, "courseGroup");
        CourseGroup oldParent = (CourseGroup)group.parent().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Option parentId = this.getLong("newParentId");
        CourseGroup parent = null;
        int index = this.getInt("index", 0);
        if (parentId.nonEmpty()) {
            parent = (CourseGroup)this.entityDao().get(MajorCourseGroup.class, parentId.get());
            if (index == 99) {
                index = parent.children().size() + 1;
            }
        } else if (index == 99) {
            index = plan.topGroups().size() + 1;
        }
        if (group.rank().nonEmpty() && BoxesRunTime.unboxToInt((Object)((NumId)group.rank().get()).id()) != CourseRank$.MODULE$.Compulsory()) {
            ObjectRef terms = ObjectRef.create((Object)",");
            ObjectRef termCredits = ObjectRef.create((Object)",");
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), Short$.MODULE$.short2int(plan.program().startTerm())).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                termCredits$2.elem = (String)termCredits$2.elem + "0,";
            });
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(Predef$.MODULE$.short2Short(plan.program().startTerm()).intValue()), Short$.MODULE$.short2int(plan.program().endTerm())).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                if (this.getBoolean("term_" + i, false)) {
                    terms$1.elem = (String)terms$1.elem + (i + ",");
                }
                termCredits$3.elem = (String)termCredits$3.elem + ((String)this.get("credit_" + i, "") + ",");
            });
            group.termCredits_$eq((String)termCredits.elem);
            group.terms_$eq(Terms$.MODULE$.apply((String)terms.elem));
            Seq teachingNatures = this.getCodes(TeachingNature.class, PlanAction.project$2(lazyRef, plan));
            Map hours = Collections$.MODULE$.newMap();
            teachingNatures.foreach((Function1)(JProcedure1 & Serializable)ht -> this.getInt("creditHour" + ht.id()).foreach((Function1 & Serializable)creditHour -> hours.put((Object)ht, (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)creditHour)))));
            group.hourRatios_$eq(((IterableOnceOps)((IterableOnceOps)hours.map((Function1 & Serializable)x -> ((NumId)x._1()).id() + ":" + x._2())).toSeq().sorted((Ordering)Ordering.String$.MODULE$)).mkString(","));
        } else {
            if (group.hourRatios() == null) {
                group.hourRatios_$eq("");
            }
            if (Strings$.MODULE$.isBlank((CharSequence)group.termCredits())) {
                ObjectRef termCredits = ObjectRef.create((Object)",");
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), Short$.MODULE$.short2int(plan.program().startTerm())).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                    termCredits$4.elem = (String)termCredits$4.elem + "0,";
                });
                RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(Predef$.MODULE$.short2Short(plan.program().startTerm()).intValue()), Short$.MODULE$.short2int(plan.program().endTerm())).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                    termCredits$5.elem = (String)termCredits$5.elem + "0,";
                });
                group.termCredits_$eq((String)termCredits.elem);
            }
        }
        if (group.persisted()) {
            if (parent != null && oldParent != null && BoxesRunTime.unboxToLong((Object)parentId.get()) != BoxesRunTime.unboxToLong((Object)oldParent.id()) || parent == null && oldParent != null || parent != null && oldParent == null || index != group.index()) {
                this.planService().move((CourseGroup)group, parent, index);
            } else {
                this.entityDao().saveOrUpdate((Object)group, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MajorCourseGroup[0]));
            }
        } else {
            group.indexno_$eq("--");
            this.planService().addCourseGroupToPlan((CourseGroup)group, parent, (CoursePlan)plan);
            this.planService().move((CourseGroup)group, parent, index);
        }
        this.planService().statPlanCredits((CoursePlan)plan);
        String target = this.getBoolean("toGroups", false) ? "groups" : "edit";
        return this.redirect(target, "plan.id=" + plan.id() + "&courseGroup.id=" + group.id(), "info.save.success");
    }

    public View removeGroup() {
        MajorCourseGroup group = (MajorCourseGroup)this.entityDao().get(MajorCourseGroup.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("courseGroup")));
        MajorPlan plan = (MajorPlan)group.plan();
        plan.groups().subtractOne((Object)group);
        group.parent().foreach((Function1 & Serializable)p -> ((MajorCourseGroup)p).children().subtractOne((Object)group));
        group.parent_$eq((Option)None$.MODULE$);
        this.entityDao().saveOrUpdate((Object)plan, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MajorPlan[0]));
        this.planService().statPlanCredits((CoursePlan)plan);
        if (this.getBoolean("toGroups", false)) {
            return this.redirect("groups", "plan.id=" + plan.id(), "info.remove.success");
        }
        return this.redirect("edit", "plan.id=" + plan.id(), "info.remove.success");
    }

    public View groupCourses() {
        LazyRef lazyRef = new LazyRef();
        MajorCourseGroup group = (MajorCourseGroup)this.entityDao().get(MajorCourseGroup.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("courseGroup")));
        this.put("plan", group.plan());
        this.put("courseGroup", group);
        this.put("departments", this.project$3(lazyRef).departments());
        this.put("stages", this.entityDao().getAll(CalendarStage.class));
        this.put("termHelper", TermHelper$.MODULE$);
        this.put("weekstateBuilder", WeekTimeBuilder$.MODULE$);
        return this.forward(this.forward$default$1());
    }

    public View courses() {
        MajorPlan plan = (MajorPlan)this.entityDao().get(MajorPlan.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("plan")));
        Program program = plan.program();
        OqlBuilder query = OqlBuilder$.MODULE$.from(Course.class, "course");
        String q = (String)this.get("q", "");
        if (Strings$.MODULE$.isNotEmpty((CharSequence)q)) {
            query.where("course.code like :q or course.name like :q ", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"%" + q + "%"}));
        }
        query.where("course.project =:project", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{program.project()})).where("course.beginOn <= :endOn", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{program.endOn()})).where("course.endOn is null or :beginOn <= course.endOn", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{program.beginOn()}));
        PageLimit limit = this.getPageLimit();
        query.orderBy((String)this.get(Order$.MODULE$.OrderStr(), "course.name"));
        query.limit(limit.pageIndex(), 10);
        this.put("courseList", this.entityDao().search((QueryBuilder)query));
        this.put("plan", plan);
        return this.forward(this.forward$default$1());
    }

    public View importData() {
        MajorPlan plan = (MajorPlan)this.entityDao().get(MajorPlan.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("plan")));
        Iterable parts = this.getAll("plan_file", Part.class, ClassTag$.MODULE$.apply(Part.class));
        if (parts.nonEmpty() && ((Part)parts.head()).getSize() > 0L) {
            InputStream is = ((Part)parts.head()).getInputStream();
            Tuple2 data = this.planExcelReader().process(plan.program(), is);
            MajorPlan newPlan = (MajorPlan)data._1();
            Iterable messages = (Iterable)data._2();
            PlanMerger$.MODULE$.merge(newPlan, plan);
            plan.credits_$eq(BoxesRunTime.unboxToFloat((Object)((IterableOnceOps)plan.topGroups().map((Function1 & Serializable)_$5 -> _$5.credits())).sum((Numeric)Numeric.FloatIsFractional$.MODULE$)));
            plan.program().credits_$eq(plan.credits());
            this.entityDao().saveOrUpdate((Object)plan, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new LongId[]{plan.program()}));
            this.planService().statPlanCredits((CoursePlan)plan);
            messages.foreach((Function1)(JProcedure1 & Serializable)m -> Predef$.MODULE$.println(m));
        }
        return this.redirect("edit", "&program.id=" + plan.program().id(), "\u5bfc\u5165\u6210\u529f");
    }

    @mapping(value="{id}")
    public View info(@param(value="id") String id) {
        LazyRef lazyRef = new LazyRef();
        MajorPlan plan = (MajorPlan)this.entityDao().get(MajorPlan.class, (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(id))));
        this.put("plan", plan);
        this.put("displayCreditHour", this.getConfig(Features.Program$.MODULE$.DisplayCreditHour(), PlanAction.project$4(lazyRef, plan)));
        this.put("enableLinkCourseInfo", this.getConfig(Features.Program$.MODULE$.LinkCourseEnabled(), PlanAction.project$4(lazyRef, plan)));
        Seq natures = this.getCodes(TeachingNature.class, PlanAction.project$4(lazyRef, plan));
        this.put("natures", natures);
        this.put("tags", this.getCodes(ProgramCourseTag.class, PlanAction.project$4(lazyRef, plan)));
        this.put("ems_base", Ems$.MODULE$.base());
        return this.forward("info");
    }

    public View restat() {
        MajorPlan plan = (MajorPlan)this.entityDao().get(MajorPlan.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("plan")));
        this.planService().statPlanCredits((CoursePlan)plan);
        return this.redirect("edit", "plan.id=" + plan.id(), "\u7edf\u8ba1\u6210\u529f");
    }

    public View edit() {
        LazyRef lazyRef = new LazyRef();
        MajorPlan plan = (MajorPlan)this.entityDao().get(MajorPlan.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("plan")));
        this.put("plan", plan);
        this.put("displayCreditHour", this.getConfig(Features.Program$.MODULE$.DisplayCreditHour(), PlanAction.project$5(lazyRef, plan)));
        this.put("enableLinkCourseInfo", this.getConfig(Features.Program$.MODULE$.LinkCourseEnabled(), PlanAction.project$5(lazyRef, plan)));
        this.put("natures", this.getCodes(TeachingNature.class, PlanAction.project$5(lazyRef, plan)));
        this.put("tags", this.getCodes(ProgramCourseTag.class, PlanAction.project$5(lazyRef, plan)));
        this.put("termHelper", TermHelper$.MODULE$);
        this.put("ems_base", Ems$.MODULE$.base());
        this.put("isAdmin", BoxesRunTime.boxToBoolean((this.getDeparts(PlanAction.project$5(lazyRef, plan)).size() > 2 ? 1 : 0) != 0));
        return this.forward(this.forward$default$1());
    }

    @response
    public String updateLabel() {
        ProgramCourseTag tag = (ProgramCourseTag)this.entityDao().get(ProgramCourseTag.class, (Object)BoxesRunTime.boxToInteger((int)this.getIntId("tag")));
        Program program = (Program)this.entityDao().get(Program.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("program")));
        Buffer labels = (Buffer)program.labels().filter((Function1 & Serializable)_$6 -> {
            ProgramCourseTag programCourseTag = _$6.tag();
            ProgramCourseTag programCourseTag2 = tag;
            return !(programCourseTag != null ? !programCourseTag.equals(programCourseTag2) : programCourseTag2 != null);
        });
        scala.collection.immutable.Seq courses = this.entityDao().find(Course.class, (Iterable)this.getLongIds("course"));
        Buffer removed = (Buffer)labels.filter((Function1 & Serializable)x -> !courses.contains((Object)x.course()));
        program.labels().subtractAll((IterableOnce)removed);
        courses.foreach((Function1)(JProcedure1 & Serializable)c -> {
            if (!labels.exists((Function1 & Serializable)_$7 -> {
                Course course = _$7.course();
                Course course2 = c;
                return !(course != null ? !course.equals(course2) : course2 != null);
            })) {
                program.labels().addOne((Object)new ProgramCourseLabel(program, c, tag));
                return;
            }
        });
        this.entityDao().saveOrUpdate((Object)program, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Program[0]));
        this.entityDao().findBy(MajorPlan.class, "program", (Object)program).foreach((Function1)(JProcedure1 & Serializable)plan -> {
            scala.collection.immutable.Set allCourses = ((IterableOnceOps)plan.planCourses().map((Function1 & Serializable)_$8 -> _$8.course())).toSet();
            Buffer obsolete = (Buffer)program.labels().filter((Function1 & Serializable)x -> !allCourses.contains((Object)x.course()));
            program.labels().subtractAll((IterableOnce)obsolete);
            this.entityDao().saveOrUpdate((Object)program, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Program[0]));
        });
        return "ok";
    }

    @response
    public Properties validate() {
        MajorPlan plan = (MajorPlan)this.entityDao().get(MajorPlan.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("plan")));
        Program program = plan.program();
        scala.collection.immutable.Seq errors = this.programChecker().check(program);
        ActionMessages msg = new ActionMessages();
        if (program.labels().isEmpty()) {
            msg.errors().addOne((Object)"\u4e13\u4e1a\u6838\u5fc3\u8bfe\u7a0b\u5c1a\u672a\u6807\u8bb0");
        }
        msg.errors().addAll((IterableOnce)errors);
        Properties properties = new Properties();
        properties.put((Object)"errors", (Object)msg.errors());
        properties.put((Object)"messages", (Object)msg.messages());
        return properties;
    }

    public View saveCourse() {
        String target;
        MajorCourseGroup group = (MajorCourseGroup)this.entityDao().get(MajorCourseGroup.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("planCourse.group")));
        CoursePlan plan = group.plan();
        MajorPlanCourse planCourse = (MajorPlanCourse)this.populateEntity(MajorPlanCourse.class, "planCourse");
        Option isCompulsory = this.getBoolean("planCourse.compulsory");
        if (isCompulsory.isEmpty()) {
            planCourse.compulsory_$eq(false);
            group.rank().foreach((Function1)(JProcedure1 & Serializable)r -> planCourse.compulsory_$eq(r.compulsory()));
        }
        String terms = (String)this.get("planCourse.terms", "");
        planCourse.terms_$eq(Terms$.MODULE$.apply(terms));
        if (planCourse.weekstate() == null) {
            planCourse.weekstate_$eq(WeekState$.MODULE$.Zero());
        }
        String extra = "&courseGroup.id=" + group.id() + "&plan.id=" + plan.id() + "&program.id=" + plan.program().id();
        String string = target = this.getBoolean("toGroups", false) ? "groups" : "edit";
        if (planCourse.persisted()) {
            if (group.planCourses().exists((Function1 & Serializable)x -> {
                Course course = x.course();
                Course course2 = planCourse.course();
                return !(course != null ? !course.equals(course2) : course2 != null) && BoxesRunTime.unboxToLong((Object)planCourse.id()) != BoxesRunTime.unboxToLong((Object)x.id());
            })) {
                return this.redirect(target, extra, "\u8bfe\u7a0b\u91cd\u590d");
            }
            this.planService().updatePlanCourse((PlanCourse)planCourse, (CourseGroup)group);
        } else {
            if (group.planCourses().exists((Function1 & Serializable)_$9 -> {
                Course course = _$9.course();
                Course course2 = planCourse.course();
                return !(course != null ? !course.equals(course2) : course2 != null);
            })) {
                return this.redirect(target, extra, "\u8bfe\u7a0b\u91cd\u590d");
            }
            this.planService().addPlanCourse((PlanCourse)planCourse, (CourseGroup)group);
        }
        return this.redirect(target, extra, "info.save.success");
    }

    public View removeCourse() {
        scala.collection.immutable.Seq planCourses = this.entityDao().find(MajorPlanCourse.class, (Iterable)this.getLongIds("planCourse"));
        planCourses.foreach((Function1)(JProcedure1 & Serializable)pc -> this.planService().removePlanCourse((PlanCourse)pc, pc.group()));
        CourseGroup group = ((AbstractPlanCourse)planCourses.head()).group();
        this.planService().statPlanCredits(group.plan());
        String target = this.getBoolean("toGroups", false) ? "groups" : "edit";
        return this.redirect(target, "plan.id=" + group.plan().id() + "&courseGroup.id=" + group.id(), "info.save.success");
    }

    public View batchAddForm() {
        MajorCourseGroup group = (MajorCourseGroup)this.entityDao().get(MajorCourseGroup.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("courseGroup")));
        this.put("courseGroup", group);
        this.put("plan", group.plan());
        String codes = (String)this.get("courseCodes", "");
        codes = codes.replaceAll("[\\s;\uff0c\uff1b]", ",").replaceAll(",,", ",");
        if (Strings$.MODULE$.isNotBlank((CharSequence)codes)) {
            Object[] objectArray = new Tuple2[2];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"code");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Strings$.MODULE$.split(codes));
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"project");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)this.getProject());
            scala.collection.immutable.Seq courses = this.entityDao().findBy(Course.class, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            this.put("courses", courses);
        }
        return this.forward(this.forward$default$1());
    }

    public View batchAddCourses() {
        List courseIds = this.getLongIds("course");
        MajorCourseGroup group = (MajorCourseGroup)this.entityDao().get(MajorCourseGroup.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("courseGroup")));
        CoursePlan plan = group.plan();
        IntRef errorNum = IntRef.create((int)0);
        scala.collection.immutable.Set allCourses = ((IterableOnceOps)plan.planCourses().map((Function1 & Serializable)_$10 -> _$10.course())).toSet();
        courseIds.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)courseId -> {
            MajorPlanCourse planCourse = new MajorPlanCourse();
            String terms = (String)this.get("course." + courseId + ".terms", "");
            planCourse.terms_$eq(Terms$.MODULE$.apply(terms));
            planCourse.suggestTerms_$eq(Terms$.MODULE$.empty());
            planCourse.group_$eq((CourseGroup)group);
            Course course = (Course)this.entityDao().get(Course.class, (Object)BoxesRunTime.boxToLong((long)courseId));
            planCourse.course_$eq(course);
            if (allCourses.contains((Object)planCourse.course())) {
                ++errorNum$1.elem;
                return;
            }
            this.planService().addPlanCourse((PlanCourse)planCourse, (CourseGroup)group);
        });
        this.entityDao().saveOrUpdate((Object)plan, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CoursePlan[0]));
        this.planService().statPlanCredits(plan);
        String extra = "&courseGroup.id=" + group.id() + "&plan.id=" + plan.id();
        return this.redirect("groups", extra, "\u6dfb\u52a0 " + courseIds.length() + " \u6210\u529f " + (courseIds.length() - errorNum.elem) + " \u5931\u8d25 " + errorNum.elem);
    }

    public View batchEditForm() {
        MajorCourseGroup group = (MajorCourseGroup)this.entityDao().get(MajorCourseGroup.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("courseGroup")));
        this.put("courseGroup", group);
        this.put("plan", group.plan());
        scala.collection.immutable.Seq planCourses = this.entityDao().find(MajorPlanCourse.class, (Iterable)this.getLongIds("planCourse"));
        this.put("planCourses", planCourses);
        return this.forward(this.forward$default$1());
    }

    public View batchEditCourses() {
        scala.collection.immutable.Seq planCourses = this.entityDao().find(MajorPlanCourse.class, (Iterable)this.getLongIds("planCourse"));
        MajorCourseGroup group = (MajorCourseGroup)this.entityDao().get(MajorCourseGroup.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("courseGroup")));
        CoursePlan plan = group.plan();
        boolean errorNum = false;
        scala.collection.immutable.Set allCourses = ((IterableOnceOps)plan.planCourses().map((Function1 & Serializable)_$11 -> _$11.course())).toSet();
        planCourses.foreach((Function1)(JProcedure1 & Serializable)pc -> {
            String terms = (String)this.get("planCourse." + pc.id() + ".terms", "");
            pc.terms_$eq(Terms$.MODULE$.apply(terms));
        });
        this.entityDao().saveOrUpdate((Object)plan, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CoursePlan[0]));
        this.planService().statPlanCredits(plan);
        String extra = "&courseGroup.id=" + group.id() + "&plan.id=" + plan.id();
        return this.redirect("groups", extra, "\u4fee\u6539\u6210\u529f");
    }

    public View diffIndex() {
        LazyRef lazyRef = new LazyRef();
        OqlBuilder q = OqlBuilder$.MODULE$.from(Program.class, "program");
        q.where("program.project=:project", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.project$6(lazyRef)}));
        this.queryByDepart(q, "program.department");
        q.orderBy("program.grade.beginIn desc,program.department.code,program.major.name");
        scala.collection.immutable.Seq plans = this.entityDao().search((QueryBuilder)q);
        scala.collection.immutable.Seq lefts = plans.toSeq();
        ObjectRef rights = ObjectRef.create((Object)plans.toSeq());
        this.getLong("right.grade.id").foreach((Function1)(JFunction1.mcVJ.sp & Serializable)gradeId -> {
            rights$1.elem = (scala.collection.immutable.Seq)((scala.collection.immutable.Seq)rights$1.elem).filter((Function1 & Serializable)_$12 -> BoxesRunTime.unboxToLong((Object)_$12.grade().id()) == gradeId);
        });
        ObjectRef right = ObjectRef.create((Object)((scala.collection.immutable.Seq)rights.elem).headOption());
        this.getLong("right.id").foreach((Function1)(JFunction1.mcVJ.sp & Serializable)id -> {
            right$1.elem = ((scala.collection.immutable.Seq)rights$2.elem).find((Function1 & Serializable)_$13 -> BoxesRunTime.unboxToLong((Object)_$13.id()) == id);
        });
        ObjectRef left = ObjectRef.create((Object)None$.MODULE$);
        this.get("left.id").foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            String string = x$1;
            if ("last".equals(string)) {
                if (((Option)right$2.elem).nonEmpty()) {
                    scala.collection.immutable.Seq sameMajors = (scala.collection.immutable.Seq)lefts.filter((Function1 & Serializable)x -> {
                        Department department = x.department();
                        Department department2 = ((Program)((Option)right$3.elem).get()).department();
                        if (department == null) {
                            if (department2 != null) {
                                return false;
                            }
                        } else if (!department.equals(department2)) return false;
                        EducationLevel educationLevel = x.level();
                        EducationLevel educationLevel2 = ((EduLevelBased)((Option)right$3.elem).get()).level();
                        if (educationLevel == null) {
                            if (educationLevel2 != null) {
                                return false;
                            }
                        } else if (!educationLevel.equals(educationLevel2)) return false;
                        Major major = x.major();
                        Major major2 = ((Program)((Option)right$3.elem).get()).major();
                        if (major == null) {
                            if (major2 != null) {
                                return false;
                            }
                        } else if (!major.equals(major2)) return false;
                        Option option = x.direction();
                        Option option2 = ((Program)((Option)right$3.elem).get()).direction();
                        if (option == null) {
                            if (option2 != null) {
                                return false;
                            }
                        } else if (!option.equals(option2)) return false;
                        if (((Option)right$3.elem).contains(x)) return false;
                        if (!x.grade().beginIn().isBefore(((Program)((Option)right$3.elem).get()).grade().beginIn())) return false;
                        return true;
                    });
                    left$1.elem = ((IterableOps)((SeqOps)sameMajors.sortBy((Function1 & Serializable)_$14 -> _$14.grade().beginIn(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).reverse()).headOption();
                    return;
                }
                return;
            }
            String i = string;
            String id = string;
            left$1.elem = lefts.find((Function1 & Serializable)_$15 -> {
                String string = _$15.id().toString();
                String string2 = id;
                return !(string != null ? !string.equals(string2) : string2 != null);
            });
        });
        this.put("lefts", lefts);
        this.put("rights", (scala.collection.immutable.Seq)rights.elem);
        this.put("left", (Option)left.elem);
        this.put("right", (Option)right.elem);
        return this.forward(this.forward$default$1());
    }

    public View diff() {
        MajorPlan left = (MajorPlan)this.entityDao().findBy(MajorPlan.class, "program.id", (Object)BoxesRunTime.boxToLong((long)this.getLongId("left"))).head();
        MajorPlan right = (MajorPlan)this.entityDao().findBy(MajorPlan.class, "program.id", (Object)BoxesRunTime.boxToLong((long)this.getLongId("right"))).head();
        this.put("left", left);
        this.put("right", right);
        this.put("diffResults", this.planService().diff((CoursePlan)left, (CoursePlan)right));
        this.put("termHelper", TermHelper$.MODULE$);
        return this.forward(this.forward$default$1());
    }

    public View spellCheck() {
        LazyRef lazyRef = new LazyRef();
        Department depart = (Department)this.entityDao().get(Department.class, (Object)BoxesRunTime.boxToInteger((int)this.getIntId("department")));
        Grade grade = (Grade)this.entityDao().get(Grade.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("grade")));
        OqlBuilder q = OqlBuilder$.MODULE$.from(MajorPlan.class, "plan");
        q.where("plan.program.project=:project", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.project$7(lazyRef)}));
        q.where("plan.program.grade=:grade", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{grade}));
        q.where("plan.program.department=:department", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{depart}));
        scala.collection.immutable.Seq plans = this.entityDao().search((QueryBuilder)q);
        Set journals = Collections$.MODULE$.newSet();
        plans.foreach((Function1)(JProcedure1 & Serializable)plan -> plan.groups().foreach((Function1)(JProcedure1 & Serializable)g -> g.planCourses().foreach((Function1 & Serializable)pc -> (Set)journals.addOne((Object)pc.journal()))));
        EnNameChecker checker = new EnNameChecker();
        scala.collection.immutable.Map rs = checker.check((Iterable)journals);
        this.put("depart", depart);
        this.put("grade", grade);
        this.put("journals", rs.keys());
        this.put("results", rs);
        return this.forward(this.forward$default$1());
    }

    private static final Project project$lzyINIT1$1(LazyRef project$lzy1$1, MajorPlan plan$1) {
        Project project;
        LazyRef lazyRef = project$lzy1$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy1$1.initialized() ? project$lzy1$1.value() : project$lzy1$1.initialize((Object)plan$1.program().project()));
        }
        return project;
    }

    private static final Project project$1(LazyRef project$lzy1$2, MajorPlan plan$2) {
        return (Project)(project$lzy1$2.initialized() ? project$lzy1$2.value() : PlanAction.project$lzyINIT1$1(project$lzy1$2, plan$2));
    }

    private static /* bridge */ /* synthetic */ Option editGroup$$anonfun$adapted$1(Map termCredits$6, String[] termCreditArray$2, Object i) {
        return termCredits$6.put((Object)Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)i) + 1), (Object)termCreditArray$2[BoxesRunTime.unboxToInt((Object)i)]);
    }

    private static final Project project$lzyINIT2$1(LazyRef project$lzy2$1, MajorPlan plan$3) {
        Project project;
        LazyRef lazyRef = project$lzy2$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy2$1.initialized() ? project$lzy2$1.value() : project$lzy2$1.initialize((Object)plan$3.program().project()));
        }
        return project;
    }

    private static final Project project$2(LazyRef project$lzy2$2, MajorPlan plan$4) {
        return (Project)(project$lzy2$2.initialized() ? project$lzy2$2.value() : PlanAction.project$lzyINIT2$1(project$lzy2$2, plan$4));
    }

    private final Project project$lzyINIT3$1(LazyRef project$lzy3$1) {
        Project project;
        LazyRef lazyRef = project$lzy3$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy3$1.initialized() ? project$lzy3$1.value() : project$lzy3$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$3(LazyRef project$lzy3$2) {
        return (Project)(project$lzy3$2.initialized() ? project$lzy3$2.value() : this.project$lzyINIT3$1(project$lzy3$2));
    }

    private static final Project project$lzyINIT4$1(LazyRef project$lzy4$1, MajorPlan plan$5) {
        Project project;
        LazyRef lazyRef = project$lzy4$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy4$1.initialized() ? project$lzy4$1.value() : project$lzy4$1.initialize((Object)plan$5.program().project()));
        }
        return project;
    }

    private static final Project project$4(LazyRef project$lzy4$2, MajorPlan plan$6) {
        return (Project)(project$lzy4$2.initialized() ? project$lzy4$2.value() : PlanAction.project$lzyINIT4$1(project$lzy4$2, plan$6));
    }

    private static final Project project$lzyINIT5$1(LazyRef project$lzy5$1, MajorPlan plan$7) {
        Project project;
        LazyRef lazyRef = project$lzy5$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy5$1.initialized() ? project$lzy5$1.value() : project$lzy5$1.initialize((Object)plan$7.program().project()));
        }
        return project;
    }

    private static final Project project$5(LazyRef project$lzy5$2, MajorPlan plan$8) {
        return (Project)(project$lzy5$2.initialized() ? project$lzy5$2.value() : PlanAction.project$lzyINIT5$1(project$lzy5$2, plan$8));
    }

    private final Project project$lzyINIT6$1(LazyRef project$lzy6$1) {
        Project project;
        LazyRef lazyRef = project$lzy6$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy6$1.initialized() ? project$lzy6$1.value() : project$lzy6$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$6(LazyRef project$lzy6$2) {
        return (Project)(project$lzy6$2.initialized() ? project$lzy6$2.value() : this.project$lzyINIT6$1(project$lzy6$2));
    }

    private final Project project$lzyINIT7$1(LazyRef project$lzy7$1) {
        Project project;
        LazyRef lazyRef = project$lzy7$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy7$1.initialized() ? project$lzy7$1.value() : project$lzy7$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$7(LazyRef project$lzy7$2) {
        return (Project)(project$lzy7$2.initialized() ? project$lzy7$2.value() : this.project$lzyINIT7$1(project$lzy7$2));
    }
}

