/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.spa.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import org.beangle.commons.io.IOs$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.lang.time.Stopwatch;
import org.beangle.commons.logging.Logger$;
import org.beangle.commons.logging.Logging;
import org.beangle.doc.pdf.SPD$;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;
import org.openurp.edu.spa.client.CardDriver;
import org.openurp.edu.spa.client.CardDriver$;
import org.openurp.edu.spa.client.Config;
import org.openurp.edu.spa.client.Daemon$;
import org.openurp.edu.spa.client.Printer;
import org.openurp.edu.spa.client.Printer$;
import org.openurp.edu.spa.client.PrinterListener;
import org.openurp.edu.spa.client.Process$;
import org.openurp.edu.spa.client.Request;
import org.openurp.edu.spa.client.Request$;
import org.openurp.edu.spa.client.Response;
import org.openurp.edu.spa.client.Response$;
import org.openurp.edu.spa.client.Response$Status$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005Mv!\u0002\u000f\u001e\u0011\u0003Ac!\u0002\u0016\u001e\u0011\u0003Y\u0003\"\u0002\u001f\u0002\t\u0003i\u0004\"\u0002 \u0002\t\u0003y\u0004\"B*\u0002\t\u0007!f\u0001\u0002\u0016\u001e\u0001iC\u0001bY\u0003\u0003\u0002\u0003\u0006I\u0001\u001a\u0005\tO\u0016\u0011\t\u0011)A\u0005Q\")A(\u0002C\u0001a\"9A/\u0002a\u0001\n\u0003)\bbB=\u0006\u0001\u0004%\tA\u001f\u0005\u0007{\u0016\u0001\u000b\u0015\u0002<\t\u000fy,\u0001\u0019!C\u0001\u007f\"I\u0011QB\u0003A\u0002\u0013\u0005\u0011q\u0002\u0005\t\u0003')\u0001\u0015)\u0003\u0002\u0002!I\u0011QC\u0003A\u0002\u0013\u0005\u0011q\u0003\u0005\n\u0003C)\u0001\u0019!C\u0001\u0003GA\u0001\"a\n\u0006A\u0003&\u0011\u0011\u0004\u0005\u0007y\u0015!\t!!\u000b\t\u000f\u00055R\u0001\"\u0003\u00020!9\u0011\u0011G\u0003\u0005B\u0005M\u0002bBA#\u000b\u0011\u0005\u0011q\t\u0005\b\u0003\u0017*A\u0011AA'\u0011\u001d\ty&\u0002C\u0001\u0003CBq!a\u001a\u0006\t\u0003\nI\u0007C\u0004\u0002|\u0015!\t%! \t\u000f\u0005MU\u0001\"\u0011\u0002\u0016\"9\u0011qV\u0003\u0005B\u0005E\u0016A\u0002#bK6|gN\u0003\u0002\u001f?\u000511\r\\5f]RT!\u0001I\u0011\u0002\u0007M\u0004\u0018M\u0003\u0002#G\u0005\u0019Q\rZ;\u000b\u0005\u0011*\u0013aB8qK:,(\u000f\u001d\u0006\u0002M\u0005\u0019qN]4\u0004\u0001A\u0011\u0011&A\u0007\u0002;\t1A)Y3n_:\u001c2!\u0001\u00173!\ti\u0003'D\u0001/\u0015\u0005y\u0013!B:dC2\f\u0017BA\u0019/\u0005\u0019\te.\u001f*fMB\u00111GO\u0007\u0002i)\u0011QGN\u0001\bY><w-\u001b8h\u0015\t9\u0004(A\u0004d_6lwN\\:\u000b\u0005e*\u0013a\u00022fC:<G.Z\u0005\u0003wQ\u0012q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002Q\u0005!Q.Y5o)\t\u00015\t\u0005\u0002.\u0003&\u0011!I\f\u0002\u0005+:LG\u000fC\u0003E\u0007\u0001\u0007Q)\u0001\u0003be\u001e\u001c\bcA\u0017G\u0011&\u0011qI\f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u0013Bs!A\u0013(\u0011\u0005-sS\"\u0001'\u000b\u00055;\u0013A\u0002\u001fs_>$h(\u0003\u0002P]\u00051\u0001K]3eK\u001aL!!\u0015*\u0003\rM#(/\u001b8h\u0015\tye&A\bsKN\u0004xN\\:feM#(/\u001b8h)\tAU\u000bC\u0003W\t\u0001\u0007q+A\u0002sKN\u0004\"!\u000b-\n\u0005ek\"\u0001\u0003*fgB|gn]3\u0014\u0007\u0015Y&\u0007\u0005\u0002]C6\tQL\u0003\u0002_?\u000611/\u001a:wKJT!\u0001Y\u0013\u0002\u001d)\fg/Y0xK\n\u001cxnY6fi&\u0011!-\u0018\u0002\u0010/\u0016\u00147k\\2lKR\u001cVM\u001d<fe\u000611m\u001c8gS\u001e\u0004\"!K3\n\u0005\u0019l\"AB\"p]\u001aLw-A\u0004bI\u0012\u0014Xm]:\u0011\u0005%tW\"\u00016\u000b\u0005-d\u0017a\u00018fi*\tQ.\u0001\u0003kCZ\f\u0017BA8k\u0005EIe.\u001a;T_\u000e\\W\r^!eIJ,7o\u001d\u000b\u0004cJ\u001c\bCA\u0015\u0006\u0011\u0015\u0019\u0007\u00021\u0001e\u0011\u00159\u0007\u00021\u0001i\u0003!\u0001(/\u001b8uS:<W#\u0001<\u0011\u00055:\u0018B\u0001=/\u0005\u001d\u0011un\u001c7fC:\fA\u0002\u001d:j]RLgnZ0%KF$\"\u0001Q>\t\u000fqT\u0011\u0011!a\u0001m\u0006\u0019\u0001\u0010J\u0019\u0002\u0013A\u0014\u0018N\u001c;j]\u001e\u0004\u0013a\u00029sS:$XM]\u000b\u0003\u0003\u0003\u0001R!LA\u0002\u0003\u000fI1!!\u0002/\u0005\u0019y\u0005\u000f^5p]B\u0019\u0011&!\u0003\n\u0007\u0005-QDA\u0004Qe&tG/\u001a:\u0002\u0017A\u0014\u0018N\u001c;fe~#S-\u001d\u000b\u0004\u0001\u0006E\u0001\u0002\u0003?\u000e\u0003\u0003\u0005\r!!\u0001\u0002\u0011A\u0014\u0018N\u001c;fe\u0002\n!bY1sI\u0012\u0013\u0018N^3s+\t\tI\u0002E\u0003.\u0003\u0007\tY\u0002E\u0002*\u0003;I1!a\b\u001e\u0005)\u0019\u0015M\u001d3Ee&4XM]\u0001\u000fG\u0006\u0014H\r\u0012:jm\u0016\u0014x\fJ3r)\r\u0001\u0015Q\u0005\u0005\tyB\t\t\u00111\u0001\u0002\u001a\u0005Y1-\u0019:e\tJLg/\u001a:!)\r\t\u00181\u0006\u0005\u0006GJ\u0001\r\u0001Z\u0001\u0013M&tG\rR3gCVdG\u000f\u0015:j]R,'\u000fF\u0001w\u0003%yg.T3tg\u0006<W\rF\u0003A\u0003k\t\t\u0005C\u0004\u00028Q\u0001\r!!\u000f\u0002\t\r|gN\u001c\t\u0005\u0003w\ti$D\u0001`\u0013\r\tyd\u0018\u0002\n/\u0016\u00147k\\2lKRDa!a\u0011\u0015\u0001\u0004A\u0015\u0001\u00022pIf\faa\u001d;biV\u001cHc\u0001!\u0002J!9\u0011qG\u000bA\u0002\u0005e\u0012!\u00029sS:$Hc\u0002!\u0002P\u0005E\u0013Q\u000b\u0005\b\u0003o1\u0002\u0019AA\u001d\u0011\u0019\t\u0019F\u0006a\u0001\u0011\u0006\u0019QO\u001d7\t\u000f\u0005]c\u00031\u0001\u0002Z\u00051\u0001/\u0019:b[N\u0004R!SA.\u0011\"K1!!\u0018S\u0005\ri\u0015\r]\u0001\u0004a\u0006LH#\u0002!\u0002d\u0005\u0015\u0004bBA\u001c/\u0001\u0007\u0011\u0011\b\u0005\b\u0003/:\u0002\u0019AA-\u0003\u0019ygn\u00149f]R)\u0001)a\u001b\u0002n!9\u0011q\u0007\rA\u0002\u0005e\u0002bBA81\u0001\u0007\u0011\u0011O\u0001\nQ\u0006tGm\u001d5bW\u0016\u0004B!a\u001d\u0002x5\u0011\u0011Q\u000f\u0006\u0004\u0003_z\u0016\u0002BA=\u0003k\u0012qb\u00117jK:$\b*\u00198eg\"\f7.Z\u0001\b_:\u001cEn\\:f)%\u0001\u0015qPAA\u0003\u0017\u000by\tC\u0004\u00028e\u0001\r!!\u000f\t\u000f\u0005\r\u0015\u00041\u0001\u0002\u0006\u0006!1m\u001c3f!\ri\u0013qQ\u0005\u0004\u0003\u0013s#aA%oi\"1\u0011QR\rA\u0002!\u000baA]3bg>t\u0007BBAI3\u0001\u0007a/\u0001\u0004sK6|G/Z\u0001\b_:,%O]8s)\u0015\u0001\u0015qSAM\u0011\u001d\t9D\u0007a\u0001\u0003sAq!a'\u001b\u0001\u0004\ti*A\u0001f!\u0011\ty*!+\u000f\t\u0005\u0005\u0016Q\u0015\b\u0004\u0017\u0006\r\u0016\"A\u0018\n\u0007\u0005\u001df&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005-\u0016Q\u0016\u0002\n\u000bb\u001cW\r\u001d;j_:T1!a*/\u0003\u001dygn\u0015;beR$\u0012\u0001\u0011")
public class Daemon
extends WebSocketServer
implements Logging {
    private final Config config;
    private boolean printing;
    private Option<Printer> printer;
    private Option<CardDriver> cardDriver;
    private Logger logger;

    public static String response2String(Response response) {
        return Daemon$.MODULE$.response2String(response);
    }

    public static void main(String[] stringArray) {
        Daemon$.MODULE$.main(stringArray);
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public boolean printing() {
        return this.printing;
    }

    public void printing_$eq(boolean x$1) {
        this.printing = x$1;
    }

    public Option<Printer> printer() {
        return this.printer;
    }

    public void printer_$eq(Option<Printer> x$1) {
        this.printer = x$1;
    }

    public Option<CardDriver> cardDriver() {
        return this.cardDriver;
    }

    public void cardDriver_$eq(Option<CardDriver> x$1) {
        this.cardDriver = x$1;
    }

    private boolean findDefaultPrinter() {
        PrintService service = PrintServiceLookup.lookupDefaultPrintService();
        Printer p = Printer$.MODULE$.apply(service, this.config);
        if (Strings$.MODULE$.isNotEmpty((CharSequence)p.name())) {
            this.printer_$eq((Option<Printer>)new Some((Object)p));
            service.addPrintServiceAttributeListener(new PrinterListener(p));
        }
        if (this.printer().isEmpty()) {
            Logger$.MODULE$.error$extension(this.logger(), (Function0 & Serializable)() -> "Cannot find default printer");
        } else {
            Logger$.MODULE$.info$extension(this.logger(), (Function0 & Serializable)() -> new StringBuilder(21).append("Find default printer:").append(this.printer().get()).toString());
        }
        return this.printer().isDefined();
    }

    public void onMessage(WebSocket conn, String body) {
        block5: {
            try {
                Request request = Request$.MODULE$.from(body);
                String string = request.command();
                String string2 = Request$.MODULE$.Print();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    this.print(conn, (String)request.params().apply((Object)"url"), request.params());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                String string4 = Request$.MODULE$.Status();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    this.status(conn);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                String string6 = Request$.MODULE$.CardPay();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    this.pay(conn, request.params());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public void status(WebSocket conn) {
        Option<Printer> option = this.printer();
        if (None$.MODULE$.equals(option)) {
            conn.send(Daemon$.MODULE$.response2String(Response$.MODULE$.status(Response$Status$.MODULE$.Error(), "\u6ca1\u6709\u627e\u5230\u6253\u5370\u673a")));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (option instanceof Some) {
            String string;
            Some some = (Some)option;
            Printer p = (Printer)some.value();
            Option<CardDriver> option2 = this.cardDriver();
            if (None$.MODULE$.equals(option2)) {
                string = new StringBuilder(10).append("{printer:").append(p.toString()).append("}").toString();
            } else if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                CardDriver driver = (CardDriver)some2.value();
                string = new StringBuilder(22).append("{printer:").append(p.toString()).append(",cardDriver:").append(driver.statusInfo()).append("}").toString();
            } else {
                throw new MatchError(option2);
            }
            String rs = string;
            conn.send(Daemon$.MODULE$.response2String(Response$.MODULE$.status(Response$Status$.MODULE$.Ok(), rs)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    public void print(WebSocket conn, String url, Map<String, String> params) {
        block19: {
            block18: {
                block21: {
                    block20: {
                        if (this.printing()) break block20;
                        String string = url;
                        String string2 = "";
                        if ((string == null ? string2 != null : !string.equals(string2)) && url != null) break block21;
                    }
                    conn.send(Daemon$.MODULE$.response2String(Response$.MODULE$.print(Response$Status$.MODULE$.Busy(), "\u4e0a\u4e00\u4e2a\u6253\u5370\u8fd8\u672a\u7ed3\u675f...")));
                    conn.close();
                    return;
                }
                if (this.printer().isEmpty() && !this.findDefaultPrinter()) {
                    conn.send(Daemon$.MODULE$.response2String(Response$.MODULE$.print(Response$Status$.MODULE$.NoPrint(), "\u6ca1\u6709\u914d\u7f6e\u9ed8\u8ba4\u6253\u5370\u673a")));
                    conn.close();
                    return;
                }
                Stopwatch watch = new Stopwatch(true);
                this.printing_$eq(true);
                try {
                    try {
                        File file = this.config.temp(url);
                        FileOutputStream fos = new FileOutputStream(file);
                        InputStream in = null;
                        if (url.startsWith("http")) {
                            Logger$.MODULE$.info$extension(this.logger(), (Function0 & Serializable)() -> new StringBuilder(11).append("dowloading ").append(url).toString());
                            in = new URL(url).openStream();
                        } else {
                            File originFile = new File(url);
                            if (!originFile.exists()) {
                                conn.send(Daemon$.MODULE$.response2String(Response$.MODULE$.print(Response$Status$.MODULE$.PrintFail(), new StringBuilder(10).append("\u6253\u5370\u5931\u8d25:\u627e\u4e0d\u5230\u6587\u4ef6").append(url).toString())));
                                this.printing_$eq(false);
                                break block18;
                            }
                            in = new FileInputStream(originFile);
                        }
                        IOs$.MODULE$.copy(in, (OutputStream)fos);
                        IOs$.MODULE$.close((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{in, fos}));
                        if (file.exists()) {
                            File pdf = new File(new StringBuilder(8).append(file.getParent()).append(File.separator).append("temp.pdf").toString());
                            boolean pdfconverted = SPD$.MODULE$.convertFile(file, pdf, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"orientation"), params.getOrElse((Object)"orientation", (Function0 & Serializable)() -> "Portrait"))})));
                            if (!pdfconverted) {
                                Logger$.MODULE$.error$extension(this.logger(), (Function0 & Serializable)() -> "\u751f\u6210pdf\u5931\u8d25");
                                conn.send(Daemon$.MODULE$.response2String(Response$.MODULE$.print(Response$Status$.MODULE$.Error(), "\u751f\u6210pdf\u5931\u8d25")));
                            } else {
                                Tuple2<Object, String> rs = Process$.MODULE$.exec(this.config, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.config.script("print"), new StringBuilder(2).append("\"").append(((Printer)this.printer().get()).name()).append("\"").toString(), new StringBuilder(2).append("\"").append(pdf.getAbsolutePath()).append("\"").toString()}));
                                if (0 == rs._1$mcI$sp()) {
                                    Logger$.MODULE$.info$extension(this.logger(), (Function0 & Serializable)() -> new StringBuilder(9).append("\u6253\u5370\u6210\u529f:").append(url).append(",\u7528\u65f6:").append(watch).toString());
                                    conn.send(Daemon$.MODULE$.response2String(Response$.MODULE$.print(Response$Status$.MODULE$.Ok(), "\u6253\u5370\u6210\u529f")));
                                } else {
                                    conn.send(Daemon$.MODULE$.response2String(Response$.MODULE$.print(Response$Status$.MODULE$.PrintFail(), new StringBuilder(5).append("\u6253\u5370\u5931\u8d25:").append(rs._2()).toString())));
                                }
                            }
                            break block19;
                        }
                        conn.send(Daemon$.MODULE$.response2String(Response$.MODULE$.print(Response$Status$.MODULE$.NoFile(), "\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25")));
                        Logger$.MODULE$.info$extension(this.logger(), (Function0 & Serializable)() -> new StringBuilder(7).append("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25:").append(url).toString());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        conn.send(Daemon$.MODULE$.response2String(Response$.MODULE$.print(Response$Status$.MODULE$.Error(), new StringBuilder(5).append("\u6253\u5370\u9519\u8bef:").append(e.getMessage()).toString())));
                    }
                    break block19;
                }
                finally {
                    this.printing_$eq(false);
                    conn.close();
                }
            }
            return;
        }
    }

    public void pay(WebSocket conn, Map<String, String> params) {
        Option<CardDriver> option = this.cardDriver();
        if (None$.MODULE$.equals(option)) {
            conn.send(Daemon$.MODULE$.response2String(Response$.MODULE$.pay(Response$Status$.MODULE$.Error(), "\u7f3a\u5c11\u5361\u9a71\u52a8")));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            CardDriver driver = (CardDriver)some.value();
            Response rs = driver.pay(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)params.getOrElse((Object)"price", (Function0 & Serializable)() -> "0"))));
            conn.send(rs.toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    public void onOpen(WebSocket conn, ClientHandshake handshake) {
    }

    public void onClose(WebSocket conn, int code, String reason, boolean remote) {
    }

    public void onError(WebSocket conn, Exception e) {
        conn.send(Daemon$.MODULE$.response2String(Response$.MODULE$.status(Response$Status$.MODULE$.Error(), new StringBuilder(7).append("\u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38:").append(e.getMessage()).toString())));
        e.printStackTrace();
    }

    public void onStart() {
        Logger$.MODULE$.info$extension(this.logger(), (Function0 & Serializable)() -> new StringBuilder(32).append("Openurp spa client started on ").append(this.getAddress().getHostName()).append(":").append(this.getPort()).append(".").toString());
    }

    public Daemon(Config config, InetSocketAddress address) {
        this.config = config;
        super(address);
        Logging.$init$((Logging)this);
        this.printing = false;
        this.printer = None$.MODULE$;
        this.cardDriver = None$.MODULE$;
        Statics.releaseFence();
    }

    public Daemon(Config config) {
        this(config, new InetSocketAddress(InetAddress.getByName("localhost"), config.port()));
        this.cardDriver_$eq((Option<CardDriver>)config.cardDriver().map((Function1 & Serializable)x$1 -> CardDriver$.MODULE$.newDriver((String)x$1, config.cardDriverParams())));
        this.findDefaultPrinter();
    }
}

