      Date.prototype.pattern=function(fmt) {
      var o = {
      "M+" : this.getMonth()+1, //月份
      "d+" : this.getDate(), //日
      "h+" : this.getHours()%12 == 0 ? 12 : this.getHours()%12, //小时
      "H+" : this.getHours(), //小时
      "m+" : this.getMinutes(), //分
      "s+" : this.getSeconds(), //秒
      "q+" : Math.floor((this.getMonth()+3)/3), //季度
      "S" : this.getMilliseconds() //毫秒
      };
      var week = {
      "0" : "/u65e5",
      "1" : "/u4e00",
      "2" : "/u4e8c",
      "3" : "/u4e09",
      "4" : "/u56db",
      "5" : "/u4e94",
      "6" : "/u516d"
      };
      if(/(y+)/.test(fmt)){
          fmt=fmt.replace(RegExp.$1, (this.getFullYear()+"").substr(4 - RegExp.$1.length));
      }
      if(/(E+)/.test(fmt)){
          fmt=fmt.replace(RegExp.$1, ((RegExp.$1.length>1) ? (RegExp.$1.length>2 ? "/u661f/u671f" : "/u5468") : "")+week[this.getDay()+""]);
      }
      for(var k in o){
          if(new RegExp("("+ k +")").test(fmt)){
              fmt = fmt.replace(RegExp.$1, (RegExp.$1.length==1) ? (o[k]) : (("00"+ o[k]).substr((""+ o[k]).length)));
          }
      }
      return fmt;
  }

function SpaClient(docTypes,currentDocType,refreshInterval,spaUrl,urp_sid,logoutUrl){
  this.socket=null;
  this.connected=false;
  this.printer=null;
  this.refreshInterval=refreshInterval;
  this.idleTime=refreshInterval*37;
  this.docTypes=docTypes
  this.currentDocType=currentDocType;
  this.spaUrl=spaUrl;
  this.urp_sid=urp_sid;
  this.callbackUrl=this.spaUrl+"/print";
  this.logout=function (){
    document.location=logoutUrl;
  }
  this.socketPort=8888;

  var self=this;
  this.resetIdleTime=function(){
    this.idleTime=refreshInterval*37;
  }

  this.initSocket =function(){
    try{
      var socket = new WebSocket('ws://localhost:'+this.socketPort);
      // 监听消息
      socket.onmessage = function(event) {
        var retData=event.data.toString();
        if(retData.indexOf('name')>0){
          eval("var rs = "+retData)
          try{
            self.printer=rs.message
            self.notify(self.printerInfo()+(new Date()).pattern("HH:mm:ss"));
          }catch(e){
            self.notify(retData);
          }
        }else{
          try{
            eval("var rs = "+retData)
            if(rs.message){
              alert(rs.message);
            }else{
              alert(retData);
            }
          }catch(e){
            alert(retData);
            self.notify(retData);
          }
        }
      };
      // 监听Socket的关闭
      socket.onclose = function(event) {
        self.notify("无法连接本机打印服务");
        self.close();
        self.initSocket();
      };
      socket.onerror = function(event) {
        self.notify("无法连接本机打印服务");
        self.close();
        self.initSocket();
      };
      socket.onopen = function(event) {
        self.connected=true;
        self.notify("本地打印服务连接成功 "+(new Date()).pattern("HH:mm:ss"));
        self.send('Status');
      };
      this.socket=socket;
    }catch(e){
      self.notify("无法连接本机打印服务"+e);
    }
  }

  this.notify=function (msg){
    document.getElementById("notification").innerHTML=msg;
  }

  this.close=function(){
    this.socket=null;
    this.connected=false;
  }

  this.getSocket=function(){
    if(!this.connected || null==this.socket){
      this.initSocket();
    }
    return this.socket;
  }

  this.send=function(message){
    if(this.connected){
      this.getSocket().send(message);
    }else{
      self.notify("本地打印服务尚未连接 "+(new Date()).pattern("HH:mm:ss"));
    }
  }

  this.printerInfo=function(){
    var desc="打印机:"+this.printer.name
    desc +=" 状态:"+this.printer.status
    desc +=" 彩色支持:"+this.printer.properties['color-supported'];
    return desc;
  }

  this.changeDoc=function(btn,code){
    this.currentDocType=code;
    jQuery('#doc_btn_group > button').removeClass('btn-success');
    jQuery(btn).addClass("btn-success");
    document.getElementById('doc_notice').innerHTML=this.docTypes[code].notice;
    var url = this.docTypes[code].url;
    if(url.indexOf(".pdf") > 0){
      document.getElementById('doc_content').src= this.spaUrl + '/view?docType='+code;
    }else{
      document.getElementById('doc_content').src= url;
    }
    this.resetIdleTime();
  }

  this.refresh=function(){
    this.send('Status');
    this.idleTime -= refreshInterval;
    document.getElementById('time_countdown').innerHTML=this.idleTime+"s";
    if(this.idleTime <= 0 && this.logout){
      this.logout();
    }
  }

  this.docUrl=function(){
    var sep="?"
    var doc_url=this.docTypes[this.currentDocType].url;
    if(doc_url.indexOf("?")>0){
      sep="&"
    }
    doc_url = doc_url + sep+"URP_SID="+this.urp_sid;
    return doc_url;
  }

  this.print=function(){
    this.resetIdleTime();
    if(this.connected && this.printer.status =="Idle"){
        document.getElementById("print_button").disabled=true;
        document.getElementById("notification").value="";
        this.send("Print,url="+this.docUrl());
        setTimeout("document.getElementById('print_button').disabled=false",2000);
        $.post(this.callbackUrl+"?docType="+this.currentDocType);
        alert("正在打印，请稍后");
        return true;
    }else{
        self.notify("打印机没有处于空闲状态,请稍等 "+(new Date()).pattern("HH:mm:ss"));
        alert("打印服务连接故障或者打印机没有处于空闲。");
        return false;
    }
  }
}