/*
 * OpenURP, Agile University Resource Planning Solution.
 *
 * Copyright © 2014, The OpenURP Software.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.spa.web.action.admin

import org.beangle.commons.lang.Strings
import org.beangle.data.dao.OqlBuilder
import org.beangle.webmvc.api.view.View
import org.beangle.webmvc.entity.action.RestfulAction
import org.openurp.edu.spa.model.{DocType, PrintLog}

class DocTypeStatAction extends RestfulAction[PrintLog] {

  override def index(): View = {
    val builder = OqlBuilder.from(classOf[PrintLog], "pr")
    builder.select("extract(year from pr.updatedAt) ,count(*) as num")
    builder.groupBy("extract(year from pr.updatedAt)")
    builder.orderBy("extract(year from pr.updatedAt) desc")
    val datas = entityDao.search(builder).asInstanceOf[Seq[Array[Any]]]

    put("datas", datas)
    forward()
  }

  def chart(): View = {
    val builder = OqlBuilder.from(classOf[PrintLog], "pr")
    builder.select("pr.docType.id ,count(*) as num")
    getInt("year").foreach(year => {
      builder.where("extract(year from pr.updatedAt)=:year", year)
    })
    builder.groupBy("pr.docType.id")
    builder.orderBy("pr.docType.id")
    val datas = entityDao.search(builder).asInstanceOf[Seq[Any]]
    val docTypes = entityDao.search(OqlBuilder.from(classOf[DocType], "dt").where("dt.enabled = true"))
    val docTypeMap = docTypes.map { dc => (dc.id.toString, dc.name) }.toMap
    val names = for (data <- datas) yield docTypeMap.get(data.asInstanceOf[Array[Any]](0).toString).getOrElse("")
    val values = for (data <- datas) yield data.asInstanceOf[Array[Any]](1)
    put("names", names)
    put("values", values)
    forward()
  }

}
