/*
 * OpenURP, Agile University Resource Planning Solution.
 *
 * Copyright © 2014, The OpenURP Software.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.spa.web.action.student

import javax.servlet.http.{HttpServletRequest, HttpServletResponse}
import org.beangle.commons.lang.Strings
import org.beangle.commons.web.url.UrlBuilder
import org.beangle.commons.web.util.CookieUtils
import org.beangle.security.Securities
import org.beangle.security.context.SecurityContext
import org.beangle.security.realm.cas.CasConfig
import org.beangle.webmvc.api.action.ActionSupport
import org.beangle.webmvc.api.context.ActionContext
import org.beangle.webmvc.api.view.View

class IndexAction extends ActionSupport {

  var casConfig: CasConfig = _

  def index(): View = {
    if (Securities.user == SecurityContext.Anonymous) {
      val req = ActionContext.current.request
      put("thisUrl", UrlBuilder.url(req))
      put("casConfig", casConfig)
      put("logoutUrl", casConfig.casServer + casConfig.logoutUri)
      forward()
    } else {
      redirect(to(classOf[DocAction], "index"), "登录成功")
    }
  }

  def logout(): View = {
    var url = UrlBuilder(ActionContext.current.request).buildUrl()
    url = Strings.replace(url, "/logout", "/index")
    var logoutUrl = cleanup(casConfig, ActionContext.current.request, ActionContext.current.response)
    logoutUrl = logoutUrl + "?service=" + url
    redirect(to(logoutUrl), null)
  }

  private def cleanup(casConfig: CasConfig, request: HttpServletRequest, response: HttpServletResponse): String = {
    val cookies = request.getCookies
    val contextPath = if (!request.getContextPath.endsWith("/")) request.getContextPath + "/" else request.getContextPath
    if (cookies != null) {
      var i = 0
      while (i < cookies.length) {
        val c = cookies(i)
        if (c.getMaxAge < 0) {
          val domain = c.getDomain
          if (null == domain || domain == request.getServerName) {
            CookieUtils.deleteCookie(response, c, contextPath)
          }
        }
        i += 1
      }
    }
    casConfig.casServer + casConfig.logoutUri
  }
}
