[@b.head/]
<style>
  .doc_container{
    min_height:300px;
  }
  .doc_button{
   border-radius: 24px;
  }
</style>
<div class="container">
 <div class="row">
   <div class="col-md-9" id="doc_notice">${docTypes?first.notice!}</div>
   <div class="col-md-3">
    <div style="float:right">
欢迎：${user.name}<span style="font-size:0.8em">(${user.code})</span>
<span id="time_countdown"></span>
 <img src="${b.static_url('openurp-edu-spa','images/exit.png')}" height="60px" onclick="spa_client.logout()">
    </div>
   </div>
 </div>

 <div class="row">
   <div class="col-md-9 doc_container">
   <iframe width="100%" frameborder="1"  id="doc_content" style="height:231mm" scrolling="auto" ></iframe>
   </div>
   <div class="col-md-3">

   <div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title">
            可打印文档
        </h3>
    </div>
    <div class="panel-body"  id="doc_btn_group">
    [#list docTypes as docType]
     <button type="button" id="docType_btn_${docType_index}" class="btn btn-secondary [#if docType_index=0]btn-success[/#if] doc_button" onclick="spa_client.changeDoc(this,'${docType.code}')">
     ${docType.name}
     [#if ((configs.get(docType).price)!0) > 0]
       ${configs.get(docType).price/100}元
       [#if (frees.get(docType)!0) > 0]<span class="badge badge-success">免费${frees.get(docType)!0}张</span>[/#if]
     [/#if]
      </button>
    [/#list]
    </div>
   </div>

<div class="panel panel-default">
    <div class="panel-body">
        <input type="image" id="print_button" src="${b.static_url('openurp-edu-spa','images/printer.png')}" class="img-responsive center-block" onclick="printIt()"/>
    </div>
</div>

   <div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title">
            最近打印
        </h3>
    </div>
    <div class="panel-body">
    <ul>
    [#assign i=0]
    [#list printLogs as pr]
     [#if i = 10] [#break/][/#if]
     [#assign i = i + 1]
     <li>${pr.docType.name} ${pr.updatedAt?string("MM-dd HH:mm")}</li>
    [/#list]
   </ul>
    </div>
   </div>

   <div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title">
            一体机状态
        </h3>
    </div>
    <div class="panel-body" id="notification">
    </div>
   </div>

   </div>
 </div>
</div>
[#--
<script src="${b.static_url('openurp-edu-spa','js/spa.js')}"></script>
--]
<script>

      Date.prototype.pattern=function(fmt) {
      var o = {
      "M+" : this.getMonth()+1, //月份
      "d+" : this.getDate(), //日
      "h+" : this.getHours()%12 == 0 ? 12 : this.getHours()%12, //小时
      "H+" : this.getHours(), //小时
      "m+" : this.getMinutes(), //分
      "s+" : this.getSeconds(), //秒
      "q+" : Math.floor((this.getMonth()+3)/3), //季度
      "S" : this.getMilliseconds() //毫秒
      };
      var week = {
      "0" : "/u65e5",
      "1" : "/u4e00",
      "2" : "/u4e8c",
      "3" : "/u4e09",
      "4" : "/u56db",
      "5" : "/u4e94",
      "6" : "/u516d"
      };
      if(/(y+)/.test(fmt)){
          fmt=fmt.replace(RegExp.$1, (this.getFullYear()+"").substr(4 - RegExp.$1.length));
      }
      if(/(E+)/.test(fmt)){
          fmt=fmt.replace(RegExp.$1, ((RegExp.$1.length>1) ? (RegExp.$1.length>2 ? "/u661f/u671f" : "/u5468") : "")+week[this.getDay()+""]);
      }
      for(var k in o){
          if(new RegExp("("+ k +")").test(fmt)){
              fmt = fmt.replace(RegExp.$1, (RegExp.$1.length==1) ? (o[k]) : (("00"+ o[k]).substr((""+ o[k]).length)));
          }
      }
      return fmt;
  }

function SpaClient(docTypes,currentDocType,refreshInterval,spaUrl,urp_sid,logoutUrl){
  this.socket=null;
  this.connected=false;
  this.printer=null;
  this.refreshInterval=refreshInterval;
  this.idleTime=refreshInterval*37;
  this.docTypes=docTypes
  this.currentDocType=currentDocType;
  this.spaUrl=spaUrl;
  this.urp_sid=urp_sid;
  this.printHtml=false;
  this.callbackUrl=this.spaUrl+"/print";
  this.logoutUrl=logoutUrl;
  this.logout=function (){
    var sep="?"
    if(this.logoutUrl.indexOf('?')>-1){
       sep="&"
    }
    document.location=this.logoutUrl + sep + "_t=" + (new Date()).getTime();
  }
  this.socketPort=8888;

  var client=this;
  this.resetIdleTime=function(){
    this.idleTime=refreshInterval*37;
  }

  this.initSocket =function(){
    try{
      var socket = new WebSocket('ws://localhost:'+this.socketPort);
      // 监听消息
      socket.onmessage = function(event) {
        var retData=event.data.toString();
        try{
          eval("var rs = "+retData)
          if(rs.command=="Status"){
              client.printer=rs.message.printer
              if(rs.message.cardDriver){
                client.cardDriver=rs.message.cardDriver;
              }
              client.notify(client.statusInfo()+(new Date()).pattern("HH:mm:ss"));
          } else if(rs.command=="CardPay"){
               if(rs.status==0){
                  var doc = printingDocs.pop();
                  client.doPrint(doc,rs.message,doc.price);
               }else{
                  alert(rs.message);
                  client.notify(rs.message);
               }
            }else{
                if(rs.message){
                  alert(rs.message);
                }else{
                  alert(retData);
                }
            }
          }catch(e){
            alert(retData);
            client.notify(retData);
          }
      };
      // 监听Socket的关闭
      socket.onclose = function(event) {
        client.notify("无法连接本机打印服务");
        client.close();
        client.initSocket();
      };
      socket.onerror = function(event) {
        client.notify("无法连接本机打印服务");
        client.close();
        client.initSocket();
      };
      socket.onopen = function(event) {
        client.connected=true;
        client.notify("本地打印服务连接成功 "+(new Date()).pattern("HH:mm:ss"));
        client.send('Status');
      };
      this.socket=socket;
    }catch(e){
      client.notify("无法连接本机打印服务"+e);
    }
  }

  this.notify=function (msg){
    document.getElementById("notification").innerHTML=msg;
  }

  this.close=function(){
    this.socket=null;
    this.connected=false;
  }

  this.getSocket=function(){
    if(!this.connected || null==this.socket){
      this.initSocket();
    }
    return this.socket;
  }

  this.send=function(message){
    if(this.connected){
      this.getSocket().send(message);
    }else{
      client.notify("本地打印服务尚未连接 "+(new Date()).pattern("HH:mm:ss"));
    }
  }

  this.isPrinterReady = function(){
     if(null==this.printer) return false;
     return (this.printer.status =="Idle" || this.printer.status =="Unknown" || this.printer.status =="Warmup");
  }

  this.isDeviceReady = function(){
    var cardDriverReady=true;
    if(this.cardDriver){
       cardDriverReady = (this.cardDriver.status=="Ok")
    }
    return this.connected && this.isPrinterReady() && cardDriverReady;
  }

  this.statusInfo=function(){
    var desc="打印机:"+this.printer.name
    if(!this.isPrinterReady()){
      desc +=" 状态:<font color='red'>"+this.printer.status + "</font>"
    }else{
      desc +=" 状态:"+this.printer.status
    }

    if(this.cardDriver){
      if( this.cardDriver.status == "Ok"){
        desc +="<br>读卡器:就绪<br>";
      }else{
        desc +=("<br>读卡器:<font color='red'>异常</font> "+ JSON.stringify(this.cardDriver)+"<br>")
      }
    }
    return desc;
  }

  this.changeDoc=function(btn,code){
    this.currentDocType=code;
    var doc=this.docTypes[code];
    jQuery('#doc_btn_group > button').removeClass('btn-success');
    jQuery(btn).addClass("btn-success");
    document.getElementById('doc_notice').innerHTML=doc.notice;
    var url = doc.url;
    if(url.indexOf(".pdf") > 0){
      document.getElementById('doc_content').src= this.spaUrl + '/view?docType='+code;
    }else{
      document.getElementById('doc_content').src= doc.docUrl(this.urp_sid);
    }
    this.resetIdleTime();
  }

  this.refresh=function(){
    this.send('Status');
    this.idleTime -= refreshInterval;
    document.getElementById('time_countdown').innerHTML=this.idleTime+"s";
    if(this.idleTime <= 0 && this.logout){
      this.logout();
    }
  }

  var printingDocs=[]

  this.payAndPrint=function(doc){
     try{
       alert("请放校园卡");
       printingDocs.unshift(doc);
       this.send('CardPay,price='+doc.price);
     }catch(e){
      alert(e);
    }
  }

  this.doPrint = function(doc,remark,payed){
    document.getElementById("print_button").disabled=true;
    document.getElementById("notification").value="";
    if(this.printHtml){
      window.frames[0].print();
    }else{
      if(!remark) remark="";
      if(payed>0 && !remark){
        alert("无支付内容,打印任务取消");
        return;
      }
      this.send("Print,url="+doc.docUrl(this.urp_sid)+",orientation="+doc.orientation);
      setTimeout("document.getElementById('print_button').disabled=false",2000);
      $.post(this.callbackUrl+"?docType="+doc.code+"&payed="+payed+"&remark="+encodeURIComponent(remark));
      alert("正在打印，请稍后");
    }
  }

  this.print=function(){
    this.resetIdleTime();
    if(this.isDeviceReady()){
        var doc=this.docTypes[this.currentDocType]
        if(doc.price>0){
           if(doc.frees <= 0){
             this.payAndPrint(doc);
             return;
           }else{
             doc.frees -= 1;
             this.doPrint(doc,0);
           }
        }else{
           this.doPrint(doc,0);
        }
        return true;
    }else{
        client.notify("系统故障:"+this.statusInfo()+",请稍等 "+(new Date()).pattern("HH:mm:ss"));
        alert("打印服务连接故障或者打印机没有处于空闲。");
        return false;
    }
  }
}

  function Doc(code,url,notice,orientation,frees,price){
     this.code=code;
     this.url=url;
     this.notice=notice;
     this.orientation=orientation;
     this.frees=frees;
     this.price=price;

     if(this.url.startsWith("{origin}")){
       this.url=this.url.replace("{origin}",window.location.origin);
     }

     this.docUrl=function(urp_sid){
         var sep="?"
         var doc_url=this.url;
         if(doc_url.indexOf("?")>0){
           sep="&"
         }
         doc_url = doc_url + sep+"URP_SID="+urp_sid;
         return doc_url;
       }
  }
  var docs={}
  [#list docTypes as docType]
  docs['${docType.code}']=new Doc('${docType.code}','${docType.url?js_string}','${(docType.notice!)?js_string}',"${docType.orientation}",${frees.get(docType)!0},${(configs.get(docType).price)!0});
  [/#list]

  var spaUrl=this.location.origin+"${b.url('doc')}"
  spaUrl=spaUrl.substring(0,spaUrl.lastIndexOf("/index"))

  var spa_client = new SpaClient(docs,'${docTypes?first.code}',5,spaUrl,"${URP_SID}","${b.url('index!logout')}");
  spa_client.initSocket();
  setInterval("spa_client.refresh()",5*1000);
  spa_client.changeDoc(document.getElementById('docType_btn_0'),'${docTypes?first.code}');
  function printIt(){
    spa_client.print();
  }
</script>
[@b.foot/]
