/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.std.course.web.action;

import java.io.Serializable;
import org.beangle.commons.logging.Logging;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.LongId;
import org.beangle.data.model.pojo.DateRange;
import org.beangle.ems.app.Ems$;
import org.beangle.web.action.support.MessageSupport;
import org.beangle.web.action.support.ParamSupport;
import org.beangle.web.action.support.RouteSupport;
import org.beangle.web.action.support.ServletSupport;
import org.beangle.web.action.view.View;
import org.openurp.base.edu.model.TimeSetting;
import org.openurp.base.edu.service.TimeSettingService;
import org.openurp.base.model.Project;
import org.openurp.base.model.Semester;
import org.openurp.base.service.SemesterService;
import org.openurp.base.std.model.Squad;
import org.openurp.base.std.model.Student;
import org.openurp.base.std.model.StudentState;
import org.openurp.edu.clazz.config.ScheduleSetting;
import org.openurp.edu.clazz.domain.ClazzProvider;
import org.openurp.edu.clazz.domain.WeekTimeBuilder$;
import org.openurp.edu.std.app.model.Features$;
import org.openurp.edu.std.course.web.helper.CourseTable;
import org.openurp.edu.std.course.web.helper.CourseTableSetting;
import org.openurp.edu.std.course.web.support.StdProjectSupport;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some$;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class CoursetableAction
implements MessageSupport,
RouteSupport,
ParamSupport,
Logging,
ServletSupport,
StdProjectSupport {
    private Logger logger;
    private EntityDao entityDao;
    private ClazzProvider clazzProvider;
    private SemesterService semesterService;
    private TimeSettingService timeSettingService;

    public CoursetableAction() {
        Logging.$init$((Logging)this);
        Statics.releaseFence();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public ClazzProvider clazzProvider() {
        return this.clazzProvider;
    }

    public void clazzProvider_$eq(ClazzProvider x$1) {
        this.clazzProvider = x$1;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public TimeSettingService timeSettingService() {
        return this.timeSettingService;
    }

    public void timeSettingService_$eq(TimeSettingService x$1) {
        this.timeSettingService = x$1;
    }

    public View projectIndex() {
        Student student;
        Project project = this.getCurrentProject();
        Student std = this.getCurrentStudent();
        Semester semester = this.getSemester(this.semesterService());
        TimeSetting timeSetting = this.timeSettingService().get(std.project(), semester, (Option)Some$.MODULE$.apply((Object)((StudentState)std.state().get()).campus()));
        this.put("std", (Object)std);
        this.put("project", (Object)project);
        this.put("semester", (Object)semester);
        String weekIndex = (String)this.get("weekIndex", (Object)"*");
        CourseTableSetting setting = new CourseTableSetting(semester, (String)this.get("setting.category", (Object)"std"));
        OqlBuilder ssQuery = OqlBuilder$.MODULE$.from(ScheduleSetting.class, "ss");
        ssQuery.where("ss.project=:project and ss.semester=:semester", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project, semester}));
        ScheduleSetting ss = (ScheduleSetting)this.entityDao().search((QueryBuilder)ssQuery).headOption().getOrElse(CoursetableAction::$anonfun$1);
        setting.weektimes_$eq(WeekTimeBuilder$.MODULE$.build(semester, weekIndex));
        this.put("weekIndex", (Object)weekIndex);
        String string = setting.category();
        if ("std".equals(string)) {
            student = std;
        } else if ("squad".equals(string)) {
            student = (DateRange)((StudentState)std.state().get()).squad().get();
        } else {
            throw new MatchError((Object)string);
        }
        LongId resource = (LongId)student;
        CourseTable courseTable = this.buildCourseTable((Object)resource, setting, timeSetting, ss);
        this.put("table", (Object)courseTable);
        this.put("setting", (Object)setting);
        this.put("ems", (Object)Ems$.MODULE$);
        this.put("enableLinkCourseInfo", (Object)BoxesRunTime.boxToBoolean((boolean)Features$.MODULE$.EnableLinkCourseInfo()));
        return this.forward("projectIndex");
    }

    private CourseTable buildCourseTable(Object resource, CourseTableSetting setting, TimeSetting ts, ScheduleSetting ss) {
        Seq seq;
        CourseTable table = new CourseTable(setting.semester(), resource, setting.category());
        table.timeSetting_$eq(ts);
        Object object = resource;
        if (object instanceof Student) {
            Student std = (Student)object;
            Seq takers = this.clazzProvider().getStdClazzes(setting.semester(), std);
            Map takerMap = ((IterableOnceOps)takers.map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply((Object)x.clazz(), x))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            this.put("takerMap", (Object)takerMap);
            seq = (Seq)takers.map((Function1 & Serializable)_$5 -> _$5.clazz());
        } else if (object instanceof Squad) {
            Squad squad = (Squad)object;
            seq = this.clazzProvider().getSquadClazzes(setting.semester(), squad);
        } else {
            throw new MatchError(object);
        }
        Seq clazzes = seq;
        if (ss.timePublished()) {
            table.setClazzes(clazzes, setting.weektimes());
        } else {
            table.setClazzes(clazzes);
        }
        table.placePublished_$eq(ss.placePublished());
        table.timePublished_$eq(ss.timePublished());
        return table;
    }

    private static final ScheduleSetting $anonfun$1() {
        return new ScheduleSetting();
    }
}

