/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.std.course.web.support;

import java.io.Serializable;
import java.time.LocalDate;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.model.NumId;
import org.beangle.security.Securities$;
import org.beangle.web.action.support.ActionSupport;
import org.beangle.web.action.support.ServletSupport;
import org.beangle.web.action.view.View;
import org.openurp.base.model.Project;
import org.openurp.base.model.ProjectBased;
import org.openurp.base.model.Semester;
import org.openurp.base.service.SemesterService;
import org.openurp.base.std.model.Student;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public interface StdProjectSupport
extends ActionSupport,
ServletSupport {
    public EntityDao entityDao();

    public View projectIndex();

    public static View index$(StdProjectSupport $this) {
        return $this.index();
    }

    default public View index() {
        View view;
        Seq<Student> stds = this.getStudents();
        if (stds.size() == 1) {
            this.request().setAttribute("student", stds.head());
            this.request().setAttribute("project", (Object)((ProjectBased)stds.head()).project());
            view = this.projectIndex();
        } else {
            if (stds.nonEmpty()) {
                Seq projects = (Seq)stds.map((Function1 & Serializable)_$1 -> _$1.project());
                this.put("projects", projects);
                this.put("defaultProjectId", BoxesRunTime.boxToInteger((int)this.getInt("projectId", BoxesRunTime.unboxToInt((Object)((NumId)projects.head()).id()))));
            } else {
                this.put("projects", package$.MODULE$.List().empty());
                this.put("defaultProjectId", BoxesRunTime.boxToInteger((int)0));
            }
            view = this.forward(this.forward$default$1());
        }
        return view;
    }

    public static Seq getStudents$(StdProjectSupport $this) {
        return $this.getStudents();
    }

    default public Seq<Student> getStudents() {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"user.code");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Securities$.MODULE$.user());
        return this.entityDao().findBy(Student.class, (Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    public static Semester getSemester$(StdProjectSupport $this, SemesterService semesterService) {
        return $this.getSemester(semesterService);
    }

    default public Semester getSemester(SemesterService semesterService) {
        Semester semester;
        Option option = this.getInt("semester.id");
        if (None$.MODULE$.equals(option)) {
            semester = semesterService.get(this.getCurrentProject(), LocalDate.now());
        } else if (option instanceof Some) {
            int id = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)id));
        } else {
            throw new MatchError((Object)option);
        }
        return semester;
    }

    public static Project getCurrentProject$(StdProjectSupport $this) {
        return $this.getCurrentProject();
    }

    default public Project getCurrentProject() {
        Project project;
        Object project2 = this.request().getAttribute("project");
        if (project2 != null) {
            project = (Project)project2;
        } else {
            Option option = this.getInt("projectId");
            if (option instanceof Some) {
                int projectId = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                project = (Project)this.entityDao().get(Project.class, (Object)BoxesRunTime.boxToInteger((int)projectId));
            } else if (None$.MODULE$.equals(option)) {
                project = null;
            } else {
                throw new MatchError((Object)option);
            }
        }
        return project;
    }

    public static Student getCurrentStudent$(StdProjectSupport $this) {
        return $this.getCurrentStudent();
    }

    default public Student getCurrentStudent() {
        Student student;
        Object std = this.request().getAttribute("student");
        if (std != null) {
            student = (Student)std;
        } else {
            Project project = this.getCurrentProject();
            Object[] objectArray = new Tuple2[2];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"project");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)project);
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"user.code");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Securities$.MODULE$.user());
            Seq stds = this.entityDao().findBy(Student.class, (Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            student = (Student)stds.head();
        }
        return student;
    }
}

