/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.std.course.web.action;

import java.io.Serializable;
import java.time.Instant;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.config.property.PropertyConfig;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.logging.Logging;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.security.Securities$;
import org.beangle.web.action.support.EntitySupport;
import org.beangle.web.action.view.View;
import org.beangle.webmvc.support.action.EntityAction;
import org.openurp.base.edu.model.Course;
import org.openurp.base.model.Project;
import org.openurp.base.model.Semester;
import org.openurp.base.std.model.Student;
import org.openurp.base.std.model.StudentState;
import org.openurp.code.service.CodeService;
import org.openurp.edu.grade.domain.CourseGradeProvider;
import org.openurp.edu.program.domain.AlternativeCourseProvider;
import org.openurp.edu.program.domain.CoursePlanProvider;
import org.openurp.edu.program.model.SharePlan;
import org.openurp.edu.program.model.StdAlternativeCourse;
import org.openurp.edu.std.app.model.AlternativeApply;
import org.openurp.edu.std.course.web.support.StdProjectSupport;
import org.slf4j.Logger;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.mutable.Set;
import scala.math.Ordering;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public class AlternativeAction
implements EntityAction<AlternativeApply>,
StdProjectSupport {
    private Class entityType;
    private Logger logger;
    private EntityDao entityDao;
    private PropertyConfig config;
    private CoursePlanProvider coursePlanProvider;
    private AlternativeCourseProvider alternativeCourseProvider;
    private CourseGradeProvider courseGradeProvider;
    private CodeService codeService;

    public AlternativeAction() {
        EntitySupport.$init$((EntitySupport)this);
        Logging.$init$((Logging)this);
        EntityAction.$init$((EntityAction)this);
        Statics.releaseFence();
    }

    public Class entityType() {
        return this.entityType;
    }

    public void org$beangle$web$action$support$EntitySupport$_setter_$entityType_$eq(Class x$0) {
        this.entityType = x$0;
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public PropertyConfig config() {
        return this.config;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public void config_$eq(PropertyConfig x$1) {
        this.config = x$1;
    }

    public CoursePlanProvider coursePlanProvider() {
        return this.coursePlanProvider;
    }

    public void coursePlanProvider_$eq(CoursePlanProvider x$1) {
        this.coursePlanProvider = x$1;
    }

    public AlternativeCourseProvider alternativeCourseProvider() {
        return this.alternativeCourseProvider;
    }

    public void alternativeCourseProvider_$eq(AlternativeCourseProvider x$1) {
        this.alternativeCourseProvider = x$1;
    }

    public CourseGradeProvider courseGradeProvider() {
        return this.courseGradeProvider;
    }

    public void courseGradeProvider_$eq(CourseGradeProvider x$1) {
        this.courseGradeProvider = x$1;
    }

    public CodeService codeService() {
        return this.codeService;
    }

    public void codeService_$eq(CodeService x$1) {
        this.codeService = x$1;
    }

    public View projectIndex() {
        Student me = this.getCurrentStudent();
        OqlBuilder builder = (OqlBuilder)OqlBuilder$.MODULE$.from(AlternativeApply.class, "apply").where("apply.std=:std", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{me}));
        this.put("applies", (Object)this.entityDao().search((QueryBuilder)builder));
        return this.forward("projectIndex");
    }

    public View applyForm() {
        Student std = this.getCurrentStudent();
        this.put("std", (Object)std);
        this.put("planCourses", (Object)this.planCourses(std));
        this.put("gradeCourses", (Object)this.gradeCourses(std));
        return this.forward(this.forward$default$1());
    }

    private Seq<Course> planCourses(Student std) {
        Set courses = Collections$.MODULE$.newSet();
        this.coursePlanProvider().getCoursePlan(std).foreach((Function1)(JProcedure1 & Serializable)plan -> plan.groups().foreach((Function1)(JProcedure1 & Serializable)courseGroup -> courseGroup.planCourses().foreach((Function1 & Serializable)planCourse -> courses.add((Object)planCourse.course()))));
        OqlBuilder spQuery = OqlBuilder$.MODULE$.from(SharePlan.class, "sp");
        spQuery.where("sp.project=:project and sp.level=:level", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std.project(), std.level().toLevel()}));
        spQuery.where(":grade between sp.fromGrade and sp.toGrade", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{((StudentState)std.state().get()).grade()}));
        this.entityDao().search((QueryBuilder)spQuery).foreach((Function1)(JProcedure1 & Serializable)sp -> sp.groups().foreach((Function1)(JProcedure1 & Serializable)cg -> cg.planCourses().foreach((Function1 & Serializable)planCourse -> courses.add((Object)planCourse.course()))));
        return (Seq)courses.toBuffer().sortBy((Function1 & Serializable)_$5 -> _$5.name(), (Ordering)Ordering.String$.MODULE$);
    }

    public Seq<Course> gradeCourses(Student std) {
        return (Seq)((SeqOps)this.courseGradeProvider().getPublished(std, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Semester[0])).map((Function1 & Serializable)_$6 -> _$6.course())).distinct();
    }

    public View doApply() {
        View view;
        Object object = new Object();
        try {
            AlternativeApply apply = (AlternativeApply)this.populateEntity(AlternativeApply.class, "apply");
            apply.std_$eq(this.getCurrentStudent());
            Project project = this.getCurrentProject();
            String originIdStr = (String)this.get("originIds", (Object)"");
            String substituteIdStr = (String)this.get("substituteIds", (Object)"");
            this.fillCourse(project, apply.olds(), originIdStr);
            this.fillCourse(project, apply.news(), substituteIdStr);
            long stdCourseSubId = 0L;
            if (apply.persisted()) {
                stdCourseSubId = BoxesRunTime.unboxToLong((Object)apply.id());
            }
            if (apply.olds().isEmpty() || apply.news().isEmpty()) {
                view = this.redirect("index", "\u4fdd\u5b58\u5931\u8d25");
            } else {
                scala.collection.immutable.Seq stdAlternativeCourses;
                OqlBuilder builder = OqlBuilder$.MODULE$.from(StdAlternativeCourse.class, "stdAlternativeCourse");
                builder.where("stdAlternativeCourse.std.id=:stdId", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{apply.std().id()})).where("stdAlternativeCourse.std.project= :project", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project}));
                if (stdCourseSubId != 0L) {
                    builder.where("stdAlternativeCourse.id !=:stdCourseSubId", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)stdCourseSubId)}));
                }
                if ((stdAlternativeCourses = this.entityDao().search((QueryBuilder)builder)).nonEmpty()) {
                    stdAlternativeCourses.foreach((Function1)(JProcedure1 & Serializable)stdCourseSub -> {
                        Set set = stdCourseSub.olds();
                        Set set2 = apply.olds();
                        if (!(set != null ? !set.equals(set2) : set2 != null)) {
                            Set set3 = stdCourseSub.news();
                            Set set4 = apply.news();
                            if (!(set3 != null ? !set3.equals(set4) : set4 != null)) {
                                throw new NonLocalReturnControl(object, (Object)this.redirect("index", "\u8be5\u66ff\u4ee3\u8bfe\u7a0b\u7ec4\u5408\u5df2\u5b58\u5728!"));
                            }
                        }
                    });
                }
                apply.updatedAt_$eq(Instant.now());
                if (this.isDoubleAlternativeCourse(apply)) {
                    this.entityDao().saveOrUpdate((Object)apply, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlternativeApply[0]));
                    view = this.redirect("index", "info.save.success");
                } else {
                    view = this.redirect("index", "\u539f\u8bfe\u7a0b\u4e0e\u66ff\u4ee3\u8bfe\u7a0b\u4e00\u6837!");
                }
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                view = (View)ex.value();
            }
            throw ex;
        }
        return view;
    }

    private void fillCourse(Project project, Set<Course> courses, String courseCodeSeq) {
        Object[] courseCodes = Strings$.MODULE$.split(courseCodeSeq, ",");
        courses.clear();
        if (courseCodes != null) {
            Object object = Predef$.MODULE$.refArrayOps(courseCodes);
            ArrayOps$.MODULE$.indices$extension(object).foreach(arg_0 -> this.fillCourse$$anonfun$adapted$1(project, courses, (String[])courseCodes, arg_0));
        }
    }

    private boolean isDoubleAlternativeCourse(AlternativeApply apply) {
        BooleanRef bool = BooleanRef.create((boolean)false);
        Set courseOrigins = apply.olds();
        Set courseSubstitutes = apply.news();
        courseOrigins.foreach((Function1)(JProcedure1 & Serializable)Origin -> {
            if (!courseSubstitutes.contains(Origin)) {
                boolean bl;
                bool$1.elem = bl = true;
            }
        });
        courseSubstitutes.foreach((Function1)(JProcedure1 & Serializable)Substitute -> {
            if (!courseOrigins.contains(Substitute)) {
                boolean bl;
                bool$2.elem = bl = true;
            }
        });
        return bool.elem;
    }

    public View remove() {
        long id = this.longId("apply");
        AlternativeApply apply = (AlternativeApply)this.entityDao().get(AlternativeApply.class, (Object)BoxesRunTime.boxToLong((long)id));
        if (apply.approved().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
            return this.redirect("index", "\u4e0d\u80fd\u5220\u9664\u5df2\u7ecf\u5ba1\u6838\u901a\u8fc7\u7684\u7533\u8bf7");
        }
        String me = Securities$.MODULE$.user();
        String string = apply.std().user().code();
        String string2 = me;
        if (string == null ? string2 != null : !string.equals(string2)) {
            return this.redirect("index", "\u4e0d\u80fd\u5220\u9664\u522b\u4eba\u7684\u7533\u8bf7");
        }
        this.entityDao().remove((Object)apply, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlternativeApply[0]));
        return this.redirect("index", "\u6210\u529f\u5220\u9664\u7533\u8bf7");
    }

    private final /* synthetic */ Set fillCourse$$anonfun$1(Project project$1, Set courses$7, String[] courseCodes$1, int i) {
        OqlBuilder oqlBuilder = OqlBuilder$.MODULE$.from(Course.class, "course");
        OqlBuilder query = (OqlBuilder)oqlBuilder.cacheable(oqlBuilder.cacheable$default$1()).where("course.id = :id", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(courseCodes$1[i])))})).where("course.project = :project", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project$1}));
        return (Set)courses$7.$plus$plus$eq((IterableOnce)this.entityDao().search((QueryBuilder)query));
    }
}

