/*
 * OpenURP, Agile Development Scaffold and Toolkit
 *
 * Copyright (c) 2014-2015, OpenURP Software.
 *
 * OpenURP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OpenURP is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenURP.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.std

import org.openurp.edu.base.code.AdmissionWay
import org.openurp.code.geo.Division
import org.beangle.data.model.Entity
import org.openurp.code.person.RegisterCategory
import org.openurp.edu.base.Student

/**
 * 招生信息
 */
trait StdAdmission extends Entity[java.lang.Long] {

   /** 学生 */
  var std:Student=_

  /** 准考证号 */
  var ticketNo:String=_

  /** 入学方式 */
  var admissionWay:AdmissionWay=_

  /** 报考省市 */
  var province:String=_
  
  /** 是否预科生 */
  var preparatory:Boolean=_

  /** 入学前户口所在区划 */
  var formerDivision:Division=_

  /** 入学后户口所在区划 */
  var currentDivision:Division=_

  /** 原户口性质 */
  var registerCategory:RegisterCategory=_
}