/*
 * OpenURP, Agile Development Scaffold and Toolkit
 *
 * Copyright (c) 2014-2015, OpenURP Software.
 *
 * OpenURP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OpenURP is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenURP.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.teach.code.model

import org.beangle.data.model.annotation.code
import org.openurp.code.BaseCodeBean
import org.openurp.edu.teach.code._

class ElectionModeBean extends BaseCodeBean with ElectionMode

class ExamFormBean extends BaseCodeBean with ExamForm

class TeachLangTypeBean extends BaseCodeBean with TeachLangType


/**
 * 考试类型
 *
 * @author 塞外狂人
 * @author chaostone
 * @since 2005-9-7
 */
class ExamTypeBean extends BaseCodeBean with ExamType {

  def this(id: Integer, code: String, name: String, enName: String) {
    this()
    this.id = id
    this.code = code
    this.name = name
    this.enName = enName
  }
}

/**
 * 修课类别
 * （重修、增修、免修不免试、主修，选修）
 *
 * @author chaostone
 * @since 2005-12-2
 */
class CourseTakeTypeBean extends BaseCodeBean with CourseTakeType {

  def this(id: Integer, code: String, name: String, enName: String) {
    this()
    this.id = id
    this.code = code
    this.name = name
    this.enName = enName
  }
}

/**
 * 成绩类型
 *
 * @author chaostone
 * @since 2005-9-7
 */
class GradeTypeBean extends BaseCodeBean with GradeType {

  def this(id: Integer) {
    this()
    this.id = id
  }

  def this(id: Integer, code: String, name: String, enName: String) {
    this()
    this.id = id
    this.code = code
    this.name = name
    this.enName = enName
  }
}

/**
 * 教学任务标签
 */
class LessonTagBean extends BaseCodeBean with LessonTag
