/*
 * OpenURP, Agile Development Scaffold and Toolkit
 *
 * Copyright (c) 2014-2015, OpenURP Software.
 *
 * OpenURP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OpenURP is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenURP.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.teach.code

import org.openurp.code.BaseCode
import org.beangle.data.model.annotation.code

/**
 * 授课语言类型
 */
@code("school")
trait TeachLangType extends BaseCode

object ElectionMode {
  /**
   * 指定
   */
  val ASSIGEND: Integer = 1

  /**
   * 自选
   */
  val SELF: Integer = 2
}

@code("school")
trait ElectionMode extends BaseCode {

}
/**
 *
 * 考试形式：开卷/闭卷
 */
@code("school")
trait ExamForm extends BaseCode


object ExamType {

  /** 期末考试 */
  val Final = 1

  /** 期中考试 */
  val Midterm = 2

  /** 补考 */
  val Makeup = 3

  /** 缓考 */
  val Delay = 4

}
/**
 * 考试类型
 */
@code("school")
trait ExamType extends BaseCode {
  var gradeType: GradeType = _
  def delay: Boolean = {
    id == 4
  }

}

/**
 * 修课类别
 * （重修、增修、免修不免试、主修，选修）
 *
 * @author chaostone
 */
@code("school")
trait CourseTakeType extends BaseCode {
  /** 是否重修 */
  var retake: Boolean = _
  /** 是否考核 */
  var exam: Boolean = _

}

object CourseTakeType {

  /**
   * 正常修读
   */
  val NORMAL = 1;

  /**
   * 重修
   */
  val RESTUDY = 3;

  /**
   * 免修不免考
   */
  val REEXAM = 4;

  /**
   * 免修
   */
  val UNTAKE = 5;

}

/**
 * 成绩类型
 *
 * @author chaostone
 */
@code("school")
trait GradeType extends BaseCode {
  def isGa: Boolean = {
    id == GradeType.EndGa || id == GradeType.MakeupGa || id == GradeType.DelayGa
  }
}

object GradeType {
  val Final = Integer.valueOf(0)

  val Middle = Integer.valueOf(1)
  val End = Integer.valueOf(2)
  val Usual = Integer.valueOf(3)
  val Makeup = Integer.valueOf(4)
  val Delay = Integer.valueOf(6)

  val EndGa = Integer.valueOf(7)
  val DelayGa = Integer.valueOf(8)
  val MakeupGa = Integer.valueOf(9)
}


/**
 * 教学任务标签
 */
@code("school")
trait LessonTag extends BaseCode

object LessonTag {
  val GuapaiId = 1

  val ElectableId = 2
}

