/*
 * OpenURP, Agile Development Scaffold and Toolkit
 *
 * Copyright (c) 2014-2015, OpenURP Software.
 *
 * OpenURP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OpenURP is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenURP.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.teach.exam

import org.beangle.data.model.LongIdEntity
import org.openurp.base.{ Department, Room }
import org.openurp.edu.base.Teacher
import org.beangle.commons.lang.time.HourMinute
import java.sql.Date
import org.openurp.base.Semester
import scala.collection.mutable.ListBuffer
import scala.collection.mutable.Buffer
import org.openurp.edu.teach.lesson.Lesson

/**
 * 考场
 *
 * @author chaostone
 */
trait ExamRoom extends LongIdEntity {

  var semester: Semester = _

  var examOn: Date = _

  var beginAt: HourMinute = _

  var endAt: HourMinute = _

  var room: Room = _

  /**
   * 主考教师
   */
  var examiner: Teacher = _

  /**
   * 主考教师院系
   */
  var department: Department = _

  /**
   * 考试活动
   */
  var activities: Buffer[ExamActivity] = new ListBuffer[ExamActivity]

  /**
   * 监考信息
   */
  var monitors: Buffer[ExamMonitor] = new ListBuffer[ExamMonitor]

  var roomApplyId: java.lang.Long = _

  def lessons: Set[Lesson] = {
    activities.map(a => a.lesson).toSet
  }
}
