/*
 * OpenURP, Agile Development Scaffold and Toolkit
 *
 * Copyright (c) 2014-2015, OpenURP Software.
 *
 * OpenURP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OpenURP is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenURP.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.teach.exam.model

import org.openurp.edu.teach.exam.ExamTake
import org.openurp.base.Department
import org.openurp.edu.teach.exam.ExamActivity
import org.beangle.data.model.bean.LongIdBean
import org.openurp.base.Room
import org.openurp.edu.teach.exam.ExamMonitor
import org.openurp.edu.teach.exam.ExamRoom
import scala.collection.mutable.Buffer
import org.openurp.hr.base.Staff

class ExamActivityBean extends LongIdBean with ExamActivity

/**
 * 监考信息
 *
 * @author chaostone
 */
class ExamMonitorBean extends LongIdBean with ExamMonitor {
  def this(examRoom: ExamRoom, staff: Staff, department: Department) {
    this()
    this.staff = staff
    this.examRoom = examRoom
    this.department = department
  }
}


/**
 * 考场
 *
 * @author chaostone
 */
class ExamRoomBean extends LongIdBean with ExamRoom {

  def this(activity: ExamActivity, room: Room) {
    this()
    this.room = room
    this.activities += activity
    activity.rooms.asInstanceOf[Buffer[ExamRoom]] += this
  }

}


class ExamTakeBean extends LongIdBean with ExamTake