/*
 * OpenURP, Agile Development Scaffold and Toolkit
 *
 * Copyright (c) 2014-2015, OpenURP Software.
 *
 * OpenURP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OpenURP is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenURP.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.teach.grade.model

import java.{ util => ju }

import org.beangle.data.model.annotation.{ code, config }
import org.beangle.data.model.bean.LongIdBean
import org.openurp.base.Semester
import org.openurp.edu.base.ProjectBased
import org.openurp.edu.teach.code.GradeType

@config
class GradeInputSwitch extends LongIdBean with ProjectBased {

  /**
   * 教学日历
   */
  var semester: Semester = _

  /**
   * 开始时间
   */
  var startAt: ju.Date = _

  /**
   * 关闭时间
   */

  var endAt: ju.Date = _

  /**
   * 允许录入成绩类型
   */
  var types = new collection.mutable.HashSet[GradeType]

  /**
   * 成绩录入开关
   */

  var opened: Boolean = _

  /**
   * 备注
   */

  var remark: String = _

  /**
   * 检查该开关是否开放
   */
  def checkOpen(date: ju.Date): Boolean = {
    if (null == startAt || null == endAt) {
      return false
    }
    if (date.after(endAt) || startAt.after(date)) {
      false
    } else {
      opened
    }
  }

  def isOpen: Boolean = checkOpen(new ju.Date())
}