/*
 * OpenURP, Agile Development Scaffold and Toolkit
 *
 * Copyright (c) 2014-2015, OpenURP Software.
 *
 * OpenURP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OpenURP is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenURP.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.teach.lesson

import org.beangle.data.model.{ Component, LongIdEntity }
import org.openurp.base.code.RoomType
import org.openurp.edu.teach.schedule.CourseActivity
import org.beangle.commons.lang.time.WeekState

/**
 * 课程安排概要信息
 * </p>
 * 课程安排的总课时应该为<code>Course.period</code>规定的的总学时。
 * 教学任务可以从[startWeek,endWeek]进行自定义安排，安排的课时统计为:period.
 * 周数和周课时可以从这三个数字中算出。
 *
 * @composed 1 has * CourseActivity
 * @author chaostone
 * @since 2005-11-15
 */
trait CourseSchedule extends Component with Serializable with Cloneable with LongIdEntity {

  /**
   * 所属教学任务
   */
  @scala.beans.BeanProperty
  var lesson: Lesson = _

  /** 起始周 */
  var startWeek: Int = _

  /** 结束周 */
  var endWeek: Int = _

  /** 已安排课时 */
  var period: Int = _
  /**
   * 周状态
   */
  var weekState: WeekState = _

  /** 具体排课结果 */
  var activities: collection.mutable.Set[CourseActivity] = _

  /** 教室类型 */
  var roomType: RoomType = _

  /** 发布状态 **/
  var published: Boolean = _

}