/*
 * OpenURP, Agile Development Scaffold and Toolkit
 *
 * Copyright (c) 2014-2015, OpenURP Software.
 *
 * OpenURP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OpenURP is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenURP.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.teach.lesson

import org.beangle.data.model.IntIdEntity
import org.beangle.data.model.YearId
import org.openurp.edu.teach.lesson.LessonLimitMeta.Operators._

/**
 * 选课限制条件项
 *
 */
trait LessonLimitItem extends IntIdEntity with Cloneable with YearId  {

  /** 限制具体项目 */
  var meta: LessonLimitMeta.LimitMeta = _

  /** 所在限制组 */
  var group: LessonLimitGroup = _

  /** 操作符 */
  var operator: Operator = _

  /** 限制内容 */
  var content: String = _

  def year = group.year

}