/*
 * OpenURP, Agile Development Scaffold and Toolkit
 *
 * Copyright (c) 2014-2015, OpenURP Software.
 *
 * OpenURP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OpenURP is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenURP.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.teach.lesson

import scala.collection.mutable.Buffer
import org.beangle.data.model.{ Component, Named }
import org.openurp.base.Department
import org.openurp.edu.teach.exam.ExamTake
import org.beangle.commons.collection.Collections
import scala.beans.BeanProperty
/**
 * 教学任务中的教学班
 * </p>
 * 教学班中规定了教学任务的主要开课对象.<br>
 * name为教学班的名字，他不等同于教学班的名称.当只有一个行政班级是两者相同，没有班级时，为课程的名字.<br>
 * 教学班合班时，名字用","串起来.当超过固定宽度时，采用缩略标记法---后面追加"...".<br>
 * planStdCount为教学班级的计划人数，对应着行政班级的人数之和.计划人数可以在教学任务管理中进行修改.<br>
 * 在自动生成时为对应行政班级的人数，若没有行政班级则默认为0.手工添加班级时，将自动计算行政班的人数总和，<br>
 * 已确定计划人数. 计划人数主要主要在排课中使用.<br>
 * stdCount为教学班中的实际人数，对应着courseTakes中的size.<br>
 * courseTakes为实际上课的学生修读这门课修读信息.<br>
 *
 * @depend - - - Lesson
 * @composed 1 has * CourseTake
 * @composed 1 has * ExamTake
 * @see  org.openurp.edu.teach.lesson.CourseTake<br>
 */

trait TeachClass extends Cloneable with Component with Named {


  /** 教学班全名 */
  var fullname: String = _

  @BeanProperty /** 教学任务 */
  var lesson: Lesson = _

  /** 入学年份 */
  var grade: String = _

  /** 学生所在部门 */
  var depart: Department = _

  /** 学生人数 */
  var stdCount: Int = _

  /** 最大人数 */
  var limitCount: Int = _

  /**
   * 是否锁定人数上限
   */
  var limitLocked: Boolean = false

  /**
   * 保留人数<br>
   * 一个任务的真实的人数上限 = limitCount - reservedCount
   */
  var reservedCount: Int = _

  /** 上课名单 */
  var courseTakes = Collections.newBuffer[CourseTake]

  /**
   * 考试名单
   */
  var examTakes: collection.mutable.Set[ExamTake] = _

  /**
   * 限制条件组
   */
  var limitGroups = Collections.newBuffer[LessonLimitGroup]

}