/*
 * OpenURP, Agile Development Scaffold and Toolkit
 *
 * Copyright (c) 2014-2015, OpenURP Software.
 *
 * OpenURP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OpenURP is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenURP.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.teach.plan

import org.beangle.data.model.{ LongIdEntity, Updated }
import org.openurp.base.Department
import org.openurp.code.edu.Education
import org.openurp.edu.base.{ Direction, Major, Project, Student }
import org.openurp.edu.base.code.StdType
import org.openurp.edu.base.Course

/**
 * 课程替代关系.
 *
 * @author new
 */
trait CourseSubstitution extends LongIdEntity with Updated {

  def origins: collection.Set[Course]

  def substitutes: collection.Set[Course]

}

/**
 * 专业替代课程.
 */
trait MajorCourseSubstitution extends CourseSubstitution {

  /**
   * 获取学历层次
   */
  def education: Education

  /**
   * 年级.
   */
  def grade: String

  /**
   * 适用专业.
   */
  def major: Major

  /**
   * 适用方向.
   */
  def direction: Direction

  /**
   * 学生类别
   */
  def stdType: StdType

  /**
   * 项目
   */
  def project: Project

  /**
   * 院系
   */
  def department: Department

}

/**
 * 学生替代课程.
 */
trait StdCourseSubstitution extends CourseSubstitution {

  /**
   * 获取学生
   */
  def std: Student
}
