/*
 * OpenURP, Agile Development Scaffold and Toolkit
 *
 * Copyright (c) 2014-2015, OpenURP Software.
 *
 * OpenURP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OpenURP is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenURP.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.teach.plan

import org.beangle.data.model.LongIdEntity
import org.openurp.base.Department
import org.openurp.edu.base.Course

/**
 * 培养计划中的课程.<br>
 * 具体体现了课程、开课和审核要求三部分.
 *
 * @author chaostone
 */
trait PlanCourse extends LongIdEntity {

  /**
   * 查询课程.
   */
  def course: Course

  /**
   * 课程开设的学期.<br>
   * 格式一般为数字或者汉字，例如：5,6或者春、秋、春秋.
   */
  def terms: String

  /**
   * 开课院系.
   */
  def department: Department

  /**
   * 备注
   */
  def remark: String

  /**
   * 课程组
   */
  def group: CourseGroup

  /**
   * 课程是否必修.
   */
  def compulsory: Boolean
}
