/*
 * OpenURP, Agile Development Scaffold and Toolkit
 *
 * Copyright (c) 2014-2015, OpenURP Software.
 *
 * OpenURP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OpenURP is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenURP.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.teach.plan

import org.beangle.commons.lang.Strings

object Terms {

  /**
   * 确定是不是不定开课学期的
   * @param term
   */
  def isUnplanned(term: String): Boolean = {
    Strings.contains(term, "*") || "春秋" == term
  }

  /**
   * 根据开课学期字符串来判断是否在这个学期开课
   *
   * @param terms     开课学期字符串
   * @param term     某个学期
   * @return
   */
  def matches(terms: String, term: Int): Boolean = {
    if (Strings.isEmpty(terms) || isUnplanned(terms)) return false
    if (terms == "春") return (term % 2 == 0)
    if (terms == "秋") return (term % 1 == 0)
    val termNumber = Strings.splitToInt(terms)
    termNumber.exists(_ == term)
  }

}
