/*
 * OpenURP, Agile Development Scaffold and Toolkit
 *
 * Copyright (c) 2014-2015, OpenURP Software.
 *
 * OpenURP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OpenURP is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenURP.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.teach.plan.model

import org.beangle.data.model.bean.LongIdBean
import org.openurp.base.Department
import org.openurp.edu.base.Course
import org.openurp.edu.base.code.ExamMode
import org.openurp.edu.teach.plan.{ CourseGroup, PlanCourse }

/**
 * 抽象计划内课程
 * </p>
 *
 * @author chaostone
 * @since 2009
 */
abstract class AbstractPlanCourse extends LongIdBean with PlanCourse with Cloneable {
  /**
   * 课程组
   */
  var group: CourseGroup = _
  /**
   * 课程
   */
  var course: Course = _

  /**
   * 开课学期
   */
  var terms: String = _

  /**
   * 是否必修
   */
  var compulsory: Boolean = _

  /**
   * 开课部门
   */
  var department: Department = _

  /**
   * 开课部门
   */
  var examMode: ExamMode = _

  /**
   * 备注
   */
  var remark: String = _
}
