/*
 * OpenURP, Agile Development Scaffold and Toolkit
 *
 * Copyright (c) 2014-2015, OpenURP Software.
 *
 * OpenURP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OpenURP is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenURP.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.teach.plan.model

import org.beangle.data.model.bean.LongIdBean
import org.openurp.edu.base.{ Direction, Program }
import org.openurp.edu.teach.plan.{ MajorCourseGroup, MajorPlan }

/**
 * @author chaostone
 */
class MajorPlanBean extends LongIdBean with AbstractCoursePlan with MajorPlan {

  /**
   * 培养方案
   */
  var program: Program = _

  override def toString(): String = {
    "MajorPlanBean [program=" + program + ", startTerm=" +
      startTerm +
      ", endTerm=" +
      endTerm +
      "]"
  }
}

/**
 * 专业计划课程组.
 *   @author chaostone
 */
class MajorCourseGroupBean extends AbstractCourseGroup with MajorCourseGroup {

  /**
   * 自定义别名
   */
  var alias: String = _

  /**
   * 该组针对的专业方向
   */
  var direction: Direction = _

  def getName: String = {
    val sb = new StringBuilder()
    if (null != courseType) sb.append(courseType.name)
    if (null != alias) sb.append(" ").append(alias)
    sb.toString
  }

  override def toString(): String = {
    "MajorPlanCourseGroupBean [alias=" + alias + ", direction=" +
      direction +
      ", parent=" +
      parent +
      ", courseType=" +
      courseType +
      "]"
  }
}
/**
 * 专业计划课程
 *
 */
class MajorPlanCourseBean extends AbstractPlanCourse {

  override def toString(): String = {
    "MajorPlanCourseBean [courseGroup=" + group + ", course=" +
      course +
      ", terms=" +
      terms +
      ", compulsory=" +
      compulsory +
      ", department=" +
      department +
      ", examMode=" +
      examMode +
      "]"
  }
}
