/*
 * OpenURP, Agile Development Scaffold and Toolkit
 *
 * Copyright (c) 2014-2015, OpenURP Software.
 *
 * OpenURP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OpenURP is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenURP.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.teach.plan.model

import org.beangle.data.model.bean.{IntIdBean, LongIdBean}
import org.openurp.code.edu.{Education, Language}
import org.openurp.edu.base.Project
import org.openurp.edu.teach.plan.{ShareCourseGroup, SharePlan, SharePlanCourse}

/**
 * 公共共享计划
 *
 * @author chaostone
 */
class SharePlanBean extends LongIdBean with AbstractCoursePlan with SharePlan with Cloneable {

  /**适用年级*/
  var grades: String = _

}

/**
 * 公共共享课程组(默认实现)
 */
class ShareCourseGroupBean extends LongIdBean with AbstractCourseGroup with ShareCourseGroup {

  /**
   * 对应外语语种
   */
  var language: Language = _

}

/**
 * 公共共享课程组课程
 *
 * @author chaostone
 */
class SharePlanCourseBean extends AbstractPlanCourse with SharePlanCourse
