/*
 * OpenURP, Agile Development Scaffold and Toolkit
 *
 * Copyright (c) 2014-2015, OpenURP Software.
 *
 * OpenURP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OpenURP is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenURP.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.teach.planaudit

import org.openurp.edu.base.code.CourseType
import org.beangle.data.model.LongIdEntity
import scala.collection.mutable.Buffer

trait GroupAuditResult extends LongIdEntity {

  def courseType: CourseType

  def courseType_=(courseType: CourseType): Unit

  def groupNum: Short

  def groupNum_=(num: Short): Unit

  def auditStat: AuditStat

  def auditStat_=(auditStat: AuditStat): Unit

  def courseResults: Buffer[CourseAuditResult]

  def courseResults_=(planCourseAuditResults: Buffer[CourseAuditResult]): Unit

  def children: Buffer[GroupAuditResult]

  def children_=(children: Buffer[GroupAuditResult]): Unit

  def parent: GroupAuditResult

  def parent_=(parent: GroupAuditResult): Unit

  def addCourseResult(rs: CourseAuditResult): Unit

  def updateCourseResult(rs: CourseAuditResult): Unit

  def addChild(gr: GroupAuditResult): Unit

  def removeChild(gr: GroupAuditResult): Unit

  def passed: Boolean

  def passed_=(passed: Boolean): Unit

  def checkPassed(isRecursive: Boolean): Unit

  def planResult: PlanAuditResult

  def planResult_=(planResult: PlanAuditResult): Unit

  def name : String

  def attachTo(planResult: PlanAuditResult): Unit

  def detach(): Unit
}
