/*
 * OpenURP, Agile Development Scaffold and Toolkit
 *
 * Copyright (c) 2014-2015, OpenURP Software.
 *
 * OpenURP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OpenURP is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenURP.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.teach.planaudit.adapters

import org.openurp.edu.base.code.CourseType
import org.openurp.edu.teach.planaudit.model.GroupAuditResultBean
import org.openurp.edu.teach.planaudit.PlanAuditResult
import org.openurp.edu.teach.planaudit.CourseAuditResult
import org.openurp.edu.teach.planaudit.AuditStat
import org.beangle.data.model.bean.LongIdBean
import org.openurp.edu.teach.planaudit.GroupAuditResult
import scala.collection.mutable.Buffer

class GroupResultAdapter(var result: PlanAuditResult) extends LongIdBean with GroupAuditResult {

  def removeChild(gr: GroupAuditResult) {
  }

  def addChild(gr: GroupAuditResult) {
  }

  def auditStat: AuditStat = result.auditStat

  def attachTo(planResult: PlanAuditResult) {
  }

  def detach {
  }

  def addCourseResult(courseResult: CourseAuditResult) {
  }

  def updateCourseResult(rs: CourseAuditResult) {
  }

  def children: Buffer[GroupAuditResult] = {
    val rs = new collection.mutable.ListBuffer[GroupAuditResult]
    rs ++= result.topGroupResults
    rs
  }

  def checkPassed {
    GroupAuditResultBean.checkPassed(this, false)
  }

  def checkPassed(isRecursive: Boolean) {
    GroupAuditResultBean.checkPassed(this, isRecursive)
  }

  def name: String = "计划"

  def courseResults: Buffer[CourseAuditResult] = collection.mutable.ListBuffer.empty

  def courseType: CourseType = null

  def groupNum: Short = {
    -1
  }

  def parent: GroupAuditResult = null

  def planResult: PlanAuditResult = result

  def passed: Boolean = result.passed

  def passed_=(passed: Boolean) {
    result.passed = passed
  }

  def auditStat_=(auditStat: AuditStat) {
    result.auditStat = auditStat
  }

  def children_=(children: Buffer[GroupAuditResult]) {
  }

  def courseResults_=(planCourseAuditResults: Buffer[CourseAuditResult]) {
  }

  def courseType_=(courseType: CourseType) {
  }

  def groupNum_=(num: Short) {
  }

  def parent_=(parent: GroupAuditResult) {
  }

  def planResult_=(planResult: PlanAuditResult) {
  }
}
