/*
 * OpenURP, Agile Development Scaffold and Toolkit
 *
 * Copyright (c) 2014-2015, OpenURP Software.
 *
 * OpenURP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OpenURP is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenURP.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.teach.grade.course.model

import org.openurp.base.model.Semester
import org.openurp.edu.base.ProjectBased
import org.openurp.edu.base.code.model.{ CourseType, ExamMode, ScoreMarkStyle }
import org.openurp.edu.base.model.{ Course, Student }
import org.openurp.edu.teach.code.model.{ CourseTakeType, GradeType }
import org.openurp.edu.teach.lesson.model.Lesson
import org.beangle.data.model.LongId
import scala.collection.mutable.ListBuffer
import scala.collection.mutable.Buffer
import org.openurp.edu.teach.grade.model.Grade

/**
 * 课程成绩
 * </p>
 * 学生因上课取得的成绩，业务唯一主键为[学生、项目、培养类型、学期、课程]。
 * </p>
 * 课程成绩由多个考试成绩组成，一般为平时、期末、补考、缓考、总评等成绩成分。
 *
 * @depend - - - Lesson
 * @depend - - - Course
 * @depend - - - CourseType
 * @depend - - - CourseTakeType
 * @composed 1 has * ExamGrade
 * @depend - - - Project
 * @depend - - - Education
 * @author chaostone
 * @since 2006
 */

class CourseGrade extends LongId with ProjectBased with Grade {
  /**
   * 设置学生
   */
  var std: Student = _
  /**
   * 设置课程
   */
  var course: Course = _
  /**
   * 获得修读类别
   */
  var courseTakeType: CourseTakeType = _
  /**
   * 学期
   */
  var semester: Semester = _
  /**
   * 任务序号
   */
  var lessonNo: String = _
  /**
   * 课程类别
   */
  var courseType: CourseType = _
  /**
   * 设置绩点
   */
  var gp: java.lang.Float = _

  var bonus: java.lang.Float = _

  /**
   * 总评成绩
   */
  var gaGrades: Buffer[GaGrade] = new ListBuffer[GaGrade]
  /**
   * 考核成绩
   */
  var examGrades: Buffer[ExamGrade] = new ListBuffer[ExamGrade]
  /**
   * 得到指定的考试成绩
   */
  def getGrade(gradeType: GradeType): Grade = {
    if (gradeType.isGa) gaGrades.find(eg => eg.gradeType == gradeType).orNull
    else examGrades.find(eg => eg.gradeType == gradeType).orNull
  }

  def getGrade(gradeTypeId: Integer): Grade = {
    getGrade(new GradeType(gradeTypeId))
  }
  /**
   * 考核方式
   */
  var examMode: ExamMode = _
  /**
   * 备注
   */
  var remark: String = _
  var score: java.lang.Float = _
  var scoreText: String = _
  var passed: Boolean = _
  var status: Int = _
  var markStyle: ScoreMarkStyle = _
  var operator: String = _
  var lesson: Lesson = _

  def gradeType: GradeType = {
    new GradeType(GradeType.Final)
  }
  // 大的成绩放前面
  override def compare(grade: Grade): Int = {
    if (null == score) return 1
    else if (null == grade.score) return -1
    return grade.score.compareTo(score)
  }
}