/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.teaching.web.action;

import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Locale;
import org.beangle.commons.codec.digest.Digests$;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.ClassLoaders$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.lang.time.HourMinute;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.Entity;
import org.beangle.data.transfer.Format$;
import org.beangle.data.transfer.exporter.ExcelTemplateExporter;
import org.beangle.data.transfer.exporter.ExportContext;
import org.beangle.data.transfer.exporter.Exporter;
import org.beangle.ems.app.Ems$;
import org.beangle.ems.app.EmsApp$;
import org.beangle.security.Securities$;
import org.beangle.template.freemarker.ProfileTemplateLoader$;
import org.beangle.web.action.context.ActionContext$;
import org.beangle.web.action.context.Params$;
import org.beangle.web.action.support.ActionSupport;
import org.beangle.web.action.view.Status$;
import org.beangle.web.action.view.View;
import org.beangle.web.servlet.util.RequestUtils$;
import org.beangle.webmvc.support.helper.PopulateHelper$;
import org.openurp.base.edu.model.Course;
import org.openurp.base.hr.model.Teacher;
import org.openurp.base.model.User;
import org.openurp.base.service.Features;
import org.openurp.base.service.ProjectConfigService;
import org.openurp.base.std.model.Student;
import org.openurp.base.std.model.StudentState;
import org.openurp.code.edu.model.TeachingMethod;
import org.openurp.code.edu.model.TeachingMethod$;
import org.openurp.code.edu.model.TeachingNature;
import org.openurp.code.edu.model.TeachingNature$;
import org.openurp.edu.attendance.model.StdLeaveLesson;
import org.openurp.edu.clazz.config.ScheduleSetting;
import org.openurp.edu.clazz.domain.ClazzProvider;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.clazz.model.ClazzActivity;
import org.openurp.edu.clazz.model.ClazzBulletin;
import org.openurp.edu.clazz.model.ClazzMaterial;
import org.openurp.edu.clazz.model.ClazzNotice;
import org.openurp.edu.clazz.model.ClazzNoticeFile;
import org.openurp.edu.clazz.model.Lesson;
import org.openurp.edu.clazz.model.TeachingPlan;
import org.openurp.edu.clazz.service.ClazzMaterialService;
import org.openurp.edu.schedule.service.ScheduleDigestor$;
import org.openurp.edu.teaching.web.action.StdLeaveStat;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashSet;
import scala.math.Ordered;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class ClazzAction
extends ActionSupport {
    private EntityDao entityDao;
    private ClazzProvider clazzProvider;
    private ProjectConfigService configService;
    private ClazzMaterialService clazzMaterialService;

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public ClazzProvider clazzProvider() {
        return this.clazzProvider;
    }

    public void clazzProvider_$eq(ClazzProvider x$1) {
        this.clazzProvider = x$1;
    }

    public ProjectConfigService configService() {
        return this.configService;
    }

    public void configService_$eq(ProjectConfigService x$1) {
        this.configService = x$1;
    }

    public ClazzMaterialService clazzMaterialService() {
        return this.clazzMaterialService;
    }

    public void clazzMaterialService_$eq(ClazzMaterialService x$1) {
        this.clazzMaterialService = x$1;
    }

    public View index() {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"staff.code");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Securities$.MODULE$.user());
        Teacher teacher = (Teacher)this.entityDao().findBy(Teacher.class, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).head();
        Clazz clazz = this.getClazz(teacher);
        OqlBuilder query = OqlBuilder$.MODULE$.from(ScheduleSetting.class, "setting");
        query.where("setting.project =:project", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{clazz.project()}));
        query.where("setting.semester =:semester", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{clazz.semester()}));
        query.cacheable(query.cacheable$default$1());
        ScheduleSetting setting = (ScheduleSetting)this.entityDao().search((QueryBuilder)query).headOption().getOrElse(ClazzAction::$anonfun$1);
        this.put("setting", setting);
        Map avatarUrls = ((IterableOnceOps)clazz.teachers().map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply(x.id(), (Object)(Ems$.MODULE$.api() + "/platform/user/avatars/" + Digests$.MODULE$.md5Hex(x.code()) + ".jpg")))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.put("avatarUrls", avatarUrls);
        this.put("clazzes", this.clazzProvider().getClazzes(clazz.semester(), teacher, clazz.project()));
        this.put("tutorSupported", this.configService().get(clazz.project(), Features.Std$.MODULE$.TutorSupported()));
        Buffer lessons = Collections$.MODULE$.newBuffer();
        clazz.schedule().activities().foreach((Function1)(JProcedure1 & Serializable)a -> a.time().dates().foreach((Function1 & Serializable)d -> {
            Instant s1 = d.atTime(a.time().beginAt().hour(), a.time().beginAt().minute()).atZone(ZoneId.systemDefault()).toInstant();
            Instant s2 = d.atTime(a.time().endAt().hour(), a.time().endAt().minute()).atZone(ZoneId.systemDefault()).toInstant();
            return (Buffer)lessons.addOne((Object)Tuple2$.MODULE$.apply((Object)s1, (Object)s2));
        }));
        if (lessons.nonEmpty()) {
            OqlBuilder q1 = OqlBuilder$.MODULE$.from(StdLeaveLesson.class, "sll");
            q1.where("sll.clazz=:clazz", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{clazz}));
            q1.orderBy("sll.std.code,sll.lessonOn");
            scala.collection.immutable.Seq stdLeaveLessons = this.entityDao().search((QueryBuilder)q1);
            scala.collection.immutable.Iterable stdLeaveStats = (scala.collection.immutable.Iterable)stdLeaveLessons.groupBy((Function1 & Serializable)x -> x.std()).map((Function1 & Serializable)x -> new StdLeaveStat((Student)x._1(), (Seq<StdLeaveLesson>)((Seq)x._2())));
            this.put("stdLeaveStats", stdLeaveStats.toBuffer().sortBy((Function1 & Serializable)_$5 -> _$5.std().code(), (Ordering)Ordering.String$.MODULE$));
        }
        return this.forward(this.forward$default$1());
    }

    private Clazz getClazz(Teacher teacher) {
        Clazz clazz = (Clazz)this.entityDao().get(Clazz.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("clazz")));
        if (clazz != null && clazz.teachers().contains((Object)teacher)) {
            this.put("clazz", clazz);
        }
        return clazz;
    }

    public View notices() {
        long clazzId = BoxesRunTime.unboxToLong((Object)this.getLong("clazz.id").getOrElse(ClazzAction::$anonfun$5));
        OqlBuilder query = OqlBuilder$.MODULE$.from(ClazzNotice.class, "notice");
        query.where("notice.clazz.id=:clazzId", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)clazzId)}));
        this.put("notices", this.entityDao().search((QueryBuilder)query));
        this.put("clazzId", BoxesRunTime.boxToLong((long)clazzId));
        return this.forward(this.forward$default$1());
    }

    public View saveNotice() {
        ClazzNotice clazzNotice;
        Option option = this.getLong("notice.id");
        if (None$.MODULE$.equals(option)) {
            clazzNotice = (ClazzNotice)PopulateHelper$.MODULE$.populate(ClazzNotice.class, "notice");
        } else if (option instanceof Some) {
            long id = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            ClazzNotice notice = (ClazzNotice)this.entityDao().get(ClazzNotice.class, (Object)BoxesRunTime.boxToLong((long)id));
            clazzNotice = (ClazzNotice)PopulateHelper$.MODULE$.populate((Entity)notice, Params$.MODULE$.sub("notice"));
        } else {
            throw new MatchError((Object)option);
        }
        ClazzNotice notice = clazzNotice;
        notice.updatedAt_$eq(Instant.now());
        Clazz clazz = (Clazz)this.entityDao().get(Clazz.class, this.getLong("notice.clazz.id").getOrElse(ClazzAction::$anonfun$6));
        notice.clazz_$eq(clazz);
        notice.updatedBy_$eq((User)this.entityDao().findBy(User.class, "code", package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Securities$.MODULE$.user()}))).head());
        this.entityDao().saveOrUpdate((Object)notice, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClazzNotice[0]));
        Iterable parts = this.getAll("attachment", Part.class, ClassTag$.MODULE$.apply(Part.class));
        parts.foreach((Function1)(JProcedure1 & Serializable)part -> {
            if (part.getSize() > 0L) {
                this.clazzMaterialService().createNoticeFile(notice, part.getInputStream(), part.getSubmittedFileName());
                return;
            }
        });
        return this.redirect("notices", "clazz.id=" + notice.clazz().id(), "info.save.success");
    }

    public View removeNotice() {
        LongRef clazzId = LongRef.create((long)0L);
        this.getLong("notice.id").foreach((Function1)(JFunction1.mcVJ.sp & Serializable)noticeId -> {
            ClazzNotice notice = (ClazzNotice)this.entityDao().get(ClazzNotice.class, (Object)BoxesRunTime.boxToLong((long)noticeId));
            if (notice.clazz().teachers().exists((Function1 & Serializable)x -> {
                String string = x.code();
                String string2 = Securities$.MODULE$.user();
                return !(string != null ? !string.equals(string2) : string2 != null);
            })) {
                long l;
                clazzId$1.elem = l = BoxesRunTime.unboxToLong((Object)notice.clazz().id());
                notice.files().foreach((Function1 & Serializable)f -> EmsApp$.MODULE$.getBlobRepository(true).remove(f.filePath()));
                this.entityDao().remove((Object)notice, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClazzNotice[0]));
                return;
            }
        });
        return this.redirect("notices", "clazz.id=" + clazzId.elem, "info.remove.success");
    }

    public View materials() {
        long clazzId = BoxesRunTime.unboxToLong((Object)this.getLong("clazz.id").getOrElse(ClazzAction::$anonfun$7));
        OqlBuilder query = OqlBuilder$.MODULE$.from(ClazzMaterial.class, "notice");
        query.where("notice.clazz.id=:clazzId", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)clazzId)}));
        this.put("materials", this.entityDao().search((QueryBuilder)query));
        this.put("clazzId", BoxesRunTime.boxToLong((long)clazzId));
        return this.forward(this.forward$default$1());
    }

    public View saveMaterial() {
        Clazz clazz = (Clazz)this.entityDao().get(Clazz.class, this.getLong("material.clazz.id").getOrElse(ClazzAction::$anonfun$8));
        Iterable parts = this.getAll("attachment", Part.class, ClassTag$.MODULE$.apply(Part.class));
        None$ in = None$.MODULE$;
        None$ fileName = None$.MODULE$;
        if (parts.nonEmpty() && ((Part)parts.head()).getSize() > 0L) {
            Part part = (Part)parts.head();
            in = Some$.MODULE$.apply((Object)part.getInputStream());
            fileName = Some$.MODULE$.apply((Object)part.getSubmittedFileName());
        }
        this.clazzMaterialService().createMaterial(clazz, (String)this.get("material.name").get(), this.get("material.url"), (Option)in, (Option)fileName);
        return this.redirect("materials", "clazz.id=" + clazz.id(), "info.save.success");
    }

    public View removeMaterial() {
        LongRef clazzId = LongRef.create((long)0L);
        this.getLong("material.id").foreach((Function1)(JFunction1.mcVJ.sp & Serializable)materialId -> {
            ClazzMaterial material = (ClazzMaterial)this.entityDao().get(ClazzMaterial.class, (Object)BoxesRunTime.boxToLong((long)materialId));
            if (material.clazz().teachers().exists((Function1 & Serializable)x -> {
                String string = x.code();
                String string2 = Securities$.MODULE$.user();
                return !(string != null ? !string.equals(string2) : string2 != null);
            })) {
                long l;
                material.filePath().foreach((Function1 & Serializable)p -> EmsApp$.MODULE$.getBlobRepository(true).remove(p));
                clazzId$2.elem = l = BoxesRunTime.unboxToLong((Object)material.clazz().id());
                this.entityDao().remove((Object)material, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClazzMaterial[0]));
                return;
            }
        });
        return this.redirect("materials", "clazz.id=" + clazzId.elem, "info.remove.success");
    }

    public View download() {
        long noticeFileId = BoxesRunTime.unboxToLong((Object)this.getLong("noticeFile.id").getOrElse(ClazzAction::$anonfun$9));
        long materialId = BoxesRunTime.unboxToLong((Object)this.getLong("material.id").getOrElse(ClazzAction::$anonfun$10));
        long bulletinId = BoxesRunTime.unboxToLong((Object)this.getLong("bulletin.id").getOrElse(ClazzAction::$anonfun$11));
        if (noticeFileId > 0L) {
            ClazzNoticeFile noticeFile = (ClazzNoticeFile)this.entityDao().get(ClazzNoticeFile.class, (Object)BoxesRunTime.boxToLong((long)noticeFileId));
            Option path = EmsApp$.MODULE$.getBlobRepository(true).url(noticeFile.filePath());
            return this.redirect(this.to(((URL)path.get()).toString()), "x");
        }
        if (materialId > 0L) {
            ClazzMaterial material = (ClazzMaterial)this.entityDao().get(ClazzMaterial.class, (Object)BoxesRunTime.boxToLong((long)materialId));
            Option option = material.filePath();
            if (None$.MODULE$.equals(option)) {
                return Status$.MODULE$.NotFound();
            }
            if (option instanceof Some) {
                String p = (String)((Some)option).value();
                Option path = EmsApp$.MODULE$.getBlobRepository(true).url(p);
                return this.redirect(this.to(((URL)path.get()).toString()), "x");
            }
            throw new MatchError((Object)option);
        }
        ClazzBulletin bulletin = (ClazzBulletin)this.entityDao().get(ClazzBulletin.class, (Object)BoxesRunTime.boxToLong((long)bulletinId));
        Option option = bulletin.contactQrcodePath();
        if (None$.MODULE$.equals(option)) {
            return Status$.MODULE$.NotFound();
        }
        if (option instanceof Some) {
            String p = (String)((Some)option).value();
            Option path = EmsApp$.MODULE$.getBlobRepository(true).url(p);
            return this.redirect(this.to(((URL)path.get()).toString()), "x");
        }
        throw new MatchError((Object)option);
    }

    public View rollbook() {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"staff.code");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Securities$.MODULE$.user());
        Teacher teacher = (Teacher)this.entityDao().findBy(Teacher.class, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).head();
        Clazz clazz = this.getClazz(teacher);
        boolean toSheet = this.getBoolean("excel", false);
        if (toSheet) {
            ExportContext context = new ExportContext(Format$.Xlsx);
            HttpServletResponse response = ActionContext$.MODULE$.current().response();
            context.exporter_$eq((Exporter)new ExcelTemplateExporter());
            context.template_$eq((URL)ClassLoaders$.MODULE$.getResource("org/openurp/edu/teaching/components/rollbook.xlsx", ClassLoaders$.MODULE$.getResource$default$2()).get());
            RequestUtils$.MODULE$.setContentDisposition(response, clazz.crn() + "\u70b9\u540d\u518c.xlsx");
            Buffer stds = (Buffer)((SeqOps)clazz.enrollment().courseTakers().map((Function1 & Serializable)_$6 -> _$6.std())).sortBy((Function1 & Serializable)_$7 -> _$7.code(), (Ordering)Ordering.String$.MODULE$);
            HashMap directions = new HashMap();
            HashMap tutors = new HashMap();
            stds.foreach((Function1)(JProcedure1 & Serializable)std -> ((StudentState)std.state().get()).direction().foreach((Function1 & Serializable)d -> directions.put(std, d.name())));
            stds.foreach((Function1)(JProcedure1 & Serializable)std -> std.tutor().foreach((Function1 & Serializable)t -> tutors.put(std, t.name())));
            Course course = clazz.course();
            HashSet usedCredits = new HashSet();
            Buffer cls = (Buffer)course.levels().filter((Function1 & Serializable)_$8 -> _$8.credits().nonEmpty());
            Object creditText = ((IterableOnceOps)cls.map((Function1 & Serializable)cl -> {
                usedCredits.$plus$eq(cl.credits().get());
                return cl.level().name() + cl.credits().get() + "\u5206";
            })).mkString(",");
            if (!usedCredits.contains((Object)BoxesRunTime.boxToFloat((float)course.defaultCredits()))) {
                creditText = BoxesRunTime.boxToFloat((float)course.defaultCredits()).toString() + " " + (String)creditText;
            }
            creditText = Strings$.MODULE$.replace((String)creditText, ".0", "");
            context.put("teacherName", (Object)((IterableOnceOps)clazz.teachers().map((Function1 & Serializable)_$9 -> _$9.name())).mkString(","));
            context.put("clazz", (Object)clazz);
            context.put("stds", (Object)stds);
            context.put("creditText", creditText);
            context.put("directions", directions);
            context.put("tutors", tutors);
            context.writeTo((OutputStream)response.getOutputStream());
            return Status$.MODULE$.Ok();
        }
        this.put("schedule", ScheduleDigestor$.MODULE$.digest(clazz, ":day :units :weeks :room"));
        ProfileTemplateLoader$.MODULE$.setProfile(clazz.project().id());
        return this.forward(this.forward$default$1());
    }

    public View bulletin() {
        this.put("bulletin", this.getBulletin());
        return this.forward(this.forward$default$1());
    }

    public View editBulletin() {
        ClazzBulletin bulletin = (ClazzBulletin)this.getBulletin().getOrElse(ClazzAction::$anonfun$16);
        this.put("bulletin", bulletin);
        return this.forward(this.forward$default$1());
    }

    public View saveBulletin() {
        ClazzBulletin bulletin = (ClazzBulletin)this.getBulletin().getOrElse(ClazzAction::$anonfun$17);
        Clazz clazz = (Clazz)ActionContext$.MODULE$.current().attribute("clazz");
        bulletin.clazz_$eq(clazz);
        bulletin.contents_$eq(this.get("bulletin.contents"));
        bulletin.contactQrcodePath_$eq(this.get("bulletin.contactQrcodePath"));
        this.entityDao().saveOrUpdate((Object)bulletin, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClazzBulletin[0]));
        Iterable parts = this.getAll("attachment", Part.class, ClassTag$.MODULE$.apply(Part.class));
        if (parts.nonEmpty() && ((Part)parts.head()).getSize() > 0L) {
            Part part = (Part)parts.head();
            this.clazzMaterialService().createBulletinFile(bulletin, part.getInputStream(), part.getSubmittedFileName());
        }
        return this.redirect("bulletin", "clazz.id=" + bulletin.clazz().id(), "info.save.success");
    }

    public View removeBulletin() {
        ClazzBulletin bulletin = (ClazzBulletin)this.getBulletin().getOrElse(ClazzAction::$anonfun$18);
        if (bulletin.persisted()) {
            bulletin.contactQrcodePath().foreach((Function1 & Serializable)p -> EmsApp$.MODULE$.getBlobRepository(true).remove(p));
            this.entityDao().remove((Object)bulletin, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClazzBulletin[0]));
        }
        return this.redirect("bulletin", "clazz.id=" + bulletin.clazz().id(), "info.remove.success");
    }

    public View teachingPlan() {
        this.put("plan", this.getTeachingPlan());
        return this.forward(this.forward$default$1());
    }

    public View editTeachingPlan() {
        TeachingPlan tp = (TeachingPlan)this.getTeachingPlan().getOrElse(ClazzAction::$anonfun$19);
        Clazz clazz = (Clazz)ActionContext$.MODULE$.current().attribute("clazz");
        if (!tp.persisted()) {
            tp.clazz_$eq(clazz);
            tp.docLocale_$eq(Locale.SIMPLIFIED_CHINESE);
            tp.semester_$eq(clazz.semester());
            tp.updatedAt_$eq(Instant.now());
            ObjectRef times = ObjectRef.create((Object)Collections$.MODULE$.newBuffer());
            clazz.schedule().activities().foreach((Function1)(JProcedure1 & Serializable)s -> s.time().dates().foreach((Function1 & Serializable)d -> (Buffer)((Buffer)times$2.elem).addOne((Object)new LessonTime((LocalDate)d, (ClazzActivity)s))));
            Map grouped = ((Buffer)times.elem).groupBy((Function1 & Serializable)_$10 -> _$10.openOn());
            Buffer mergedTimes = Collections$.MODULE$.newBuffer();
            grouped.foreach((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    LocalDate d = (LocalDate)tuple2._1();
                    Buffer tl = (Buffer)tuple2._2();
                    LessonTime head = (LessonTime)tl.head();
                    ((IterableOnceOps)tl.tail()).foreach((Function1)(JProcedure1 & Serializable)t -> head.merge((LessonTime)t));
                    return (Buffer)mergedTimes.addOne((Object)head);
                }
                throw new MatchError((Object)tuple2);
            });
            IntRef i = IntRef.create((int)1);
            Buffer buffer = (Buffer)mergedTimes.sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
            times.elem = buffer;
            buffer = null;
            ((Buffer)times.elem).foreach((Function1 & Serializable)time -> {
                int n;
                Lesson lesson = new Lesson();
                lesson.openOn_$eq(time.openOn());
                lesson.beginAt_$eq(time.beginAt());
                lesson.endAt_$eq(time.endAt());
                lesson.places_$eq(time.places());
                lesson.plan_$eq(tp);
                lesson.units_$eq(((IterableOnceOps)time.units().toBuffer().sorted((Ordering)Ordering.Int$.MODULE$)).mkString(","));
                lesson.idx_$eq(i$1.elem);
                i$1.elem = n = i$1.elem + 1;
                lesson.teachingNature_$eq((TeachingNature)this.entityDao().get(TeachingNature.class, (Object)BoxesRunTime.boxToInteger((int)TeachingNature$.MODULE$.Theory())));
                lesson.teachingMethod_$eq((TeachingMethod)this.entityDao().get(TeachingMethod.class, (Object)BoxesRunTime.boxToInteger((int)TeachingMethod$.MODULE$.Offline())));
                lesson.contents_$eq(" ");
                return (Buffer)tp.lessons().$plus$eq((Object)lesson);
            });
            if (((Buffer)times.elem).nonEmpty()) {
                this.entityDao().saveOrUpdate((Object)tp, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TeachingPlan[0]));
            }
        }
        this.put("plan", tp);
        return this.forward(this.forward$default$1());
    }

    public View saveTeachingPlan() {
        TeachingPlan plan = (TeachingPlan)this.getTeachingPlan().get();
        plan.lessons().foreach((Function1)(JProcedure1 & Serializable)lesson -> {
            String contents = (String)this.get("lesson" + lesson.id() + ".contents", "");
            if (Strings$.MODULE$.isEmpty((CharSequence)contents)) {
                contents = " ";
            }
            lesson.contents_$eq(contents);
            lesson.places_$eq(this.get("lesson" + lesson.id() + ".places"));
        });
        this.entityDao().saveOrUpdate((Object)plan, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TeachingPlan[0]));
        return this.redirect("teachingPlan", "clazz.id=" + plan.clazz().id(), "info.save.success");
    }

    public View removeTeachingPlan() {
        Option<TeachingPlan> plan = this.getTeachingPlan();
        Clazz clazz = (Clazz)ActionContext$.MODULE$.current().attribute("clazz");
        plan.foreach((Function1)(JProcedure1 & Serializable)p -> this.entityDao().remove(p, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TeachingPlan[0])));
        return this.redirect("teachingPlan", "clazz.id=" + clazz.id(), "info.remove.success");
    }

    private Option<TeachingPlan> getTeachingPlan() {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"staff.code");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Securities$.MODULE$.user());
        Teacher teacher = (Teacher)this.entityDao().findBy(Teacher.class, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).head();
        Clazz clazz = this.getClazz(teacher);
        this.put("clazz", clazz);
        this.put("teacher", teacher);
        OqlBuilder query = OqlBuilder$.MODULE$.from(TeachingPlan.class, "plan");
        query.where("plan.clazz=:clazz", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{clazz}));
        return this.entityDao().search((QueryBuilder)query).headOption();
    }

    private Option<ClazzBulletin> getBulletin() {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"staff.code");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Securities$.MODULE$.user());
        Teacher teacher = (Teacher)this.entityDao().findBy(Teacher.class, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).head();
        Clazz clazz = this.getClazz(teacher);
        this.put("clazz", clazz);
        this.put("teacher", teacher);
        OqlBuilder query = OqlBuilder$.MODULE$.from(ClazzBulletin.class, "bulletin");
        query.where("bulletin.clazz=:clazz", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{clazz}));
        return this.entityDao().search((QueryBuilder)query).headOption();
    }

    private static final ScheduleSetting $anonfun$1() {
        return new ScheduleSetting();
    }

    private static final long $anonfun$5() {
        return 0L;
    }

    private static final long $anonfun$6() {
        return 0L;
    }

    private static final long $anonfun$7() {
        return 0L;
    }

    private static final long $anonfun$8() {
        return 0L;
    }

    private static final long $anonfun$9() {
        return 0L;
    }

    private static final long $anonfun$10() {
        return 0L;
    }

    private static final long $anonfun$11() {
        return 0L;
    }

    private static final ClazzBulletin $anonfun$16() {
        return new ClazzBulletin();
    }

    private static final ClazzBulletin $anonfun$17() {
        return new ClazzBulletin();
    }

    private static final ClazzBulletin $anonfun$18() {
        return new ClazzBulletin();
    }

    private static final TeachingPlan $anonfun$19() {
        return new TeachingPlan();
    }

    public class LessonTime
    implements Ordered<LessonTime> {
        private LocalDate openOn;
        private HourMinute beginAt;
        private HourMinute endAt;
        private Option places;
        private HashSet units;

        public LessonTime() {
            if (ClazzAction.this == null) {
                throw new NullPointerException();
            }
            Ordered.$init$((Ordered)this);
            this.places = None$.MODULE$;
            this.units = new HashSet();
        }

        public LocalDate openOn() {
            return this.openOn;
        }

        public void openOn_$eq(LocalDate x$1) {
            this.openOn = x$1;
        }

        public HourMinute beginAt() {
            return this.beginAt;
        }

        public void beginAt_$eq(HourMinute x$1) {
            this.beginAt = x$1;
        }

        public HourMinute endAt() {
            return this.endAt;
        }

        public void endAt_$eq(HourMinute x$1) {
            this.endAt = x$1;
        }

        public Option<String> places() {
            return this.places;
        }

        public void places_$eq(Option<String> x$1) {
            this.places = x$1;
        }

        public HashSet<Object> units() {
            return this.units;
        }

        public void units_$eq(HashSet<Object> x$1) {
            this.units = x$1;
        }

        public int compare(LessonTime that) {
            return (this.openOn().toString() + this.beginAt().toString()).compareTo(that.openOn().toString() + that.beginAt().toString());
        }

        public LessonTime(LocalDate d, ClazzActivity ca) {
            this();
            this.openOn_$eq(d);
            this.beginAt_$eq(ca.time().beginAt());
            this.endAt_$eq(ca.time().endAt());
            this.places_$eq((Option<String>)ca.places());
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper((int)ca.beginUnit()), (int)ca.endUnit()).foreach((Function1 & Serializable)u -> this.$init$$$anonfun$1(BoxesRunTime.unboxToInt((Object)u)));
        }

        public void merge(LessonTime that) {
            if (this.beginAt().$greater((Object)that.beginAt())) {
                this.beginAt_$eq(that.beginAt());
            }
            if (this.endAt().$less((Object)that.endAt())) {
                this.endAt_$eq(that.endAt());
            }
            this.units().$plus$plus$eq(that.units());
        }

        public final /* synthetic */ ClazzAction org$openurp$edu$teaching$web$action$ClazzAction$LessonTime$$$outer() {
            return ClazzAction.this;
        }

        private final /* synthetic */ HashSet $init$$$anonfun$1(int u) {
            return this.units().addOne((Object)BoxesRunTime.boxToInteger((int)u));
        }
    }
}

