/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.teaching.web.helper;

import java.io.Serializable;
import org.beangle.commons.collection.Collections$;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.openurp.base.hr.model.Teacher;
import org.openurp.base.model.Project;
import org.openurp.base.model.Semester;
import org.openurp.base.std.model.Student;
import org.openurp.edu.clazz.config.ScheduleSetting;
import org.openurp.edu.clazz.domain.ClazzProvider;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.clazz.model.MiniClazz;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Growable;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class OccupyHelper {
    private final EntityDao entityDao;
    private final ClazzProvider clazzProvider;
    private int maxWeekday;
    private int maxUnit;

    public OccupyHelper(EntityDao entityDao, ClazzProvider clazzProvider) {
        this.entityDao = entityDao;
        this.clazzProvider = clazzProvider;
        this.maxWeekday = 5;
        this.maxUnit = 0;
    }

    public int maxWeekday() {
        return this.maxWeekday;
    }

    public void maxWeekday_$eq(int x$1) {
        this.maxWeekday = x$1;
    }

    public int maxUnit() {
        return this.maxUnit;
    }

    public void maxUnit_$eq(int x$1) {
        this.maxUnit = x$1;
    }

    public Map<String, String> merge(Map<String, String> m1, Map<String, String> m2) {
        HashMap rs = new HashMap();
        rs.addAll(m1);
        m2.foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                Option option = rs.get((Object)k);
                if (None$.MODULE$.equals(option)) {
                    return rs.put((Object)k, (Object)v);
                }
                if (option instanceof Some) {
                    String v2 = (String)((Some)option).value();
                    String string = v;
                    String string2 = v2;
                    if (string == null ? string2 != null : !string.equals(string2)) {
                        rs.put((Object)k, (Object)(v + " " + v2));
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                throw new MatchError((Object)option);
            }
            throw new MatchError((Object)tuple2);
        });
        return rs;
    }

    public Map<String, String> getTeacherMiniOccupy(Project project, Semester semester, Teacher teacher) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(MiniClazz.class, "clazz");
        query.where("clazz.semester=:semester", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
        query.where("clazz.teacher=:me", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{teacher}));
        Seq clazzes = this.entityDao.search((QueryBuilder)query);
        scala.collection.mutable.Map miniOccupyMap = Collections$.MODULE$.newMap();
        clazzes.foreach((Function1)(JProcedure1 & Serializable)clazz -> clazz.activities().foreach((Function1)(JProcedure1 & Serializable)a -> {
            int weekdayId = a.time().weekday().id();
            if (weekdayId > this.maxWeekday()) {
                this.maxWeekday_$eq(weekdayId);
            }
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(Predef$.MODULE$.short2Short(a.beginUnit()).intValue()), Predef$.MODULE$.short2Short(a.endUnit()).intValue()).foreach((Function1 & Serializable)u -> this.getTeacherMiniOccupy$$anonfun$1$$anonfun$1$$anonfun$1(miniOccupyMap, weekdayId, clazz, BoxesRunTime.unboxToInt((Object)u)));
        }));
        return (Map)miniOccupyMap.map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply(x._1(), (Object)((IterableOnceOps)((IterableOps)x._2()).map((Function1 & Serializable)_$1 -> _$1.name())).mkString(",")));
    }

    public Map<String, String> getTeacherCourseOccupy(Project project, Semester semester, Teacher teacher) {
        scala.collection.mutable.Map occupyMap = Collections$.MODULE$.newMap();
        ScheduleSetting scheduleSetting = this.getScheduleSetting(project, semester);
        if (scheduleSetting.timePublished()) {
            this.clazzProvider.getClazzes(semester, teacher, project).foreach((Function1)(JProcedure1 & Serializable)clazz -> clazz.schedule().activities().foreach((Function1)(JProcedure1 & Serializable)a -> {
                int weekdayId = a.time().weekday().id();
                if (weekdayId > this.maxWeekday()) {
                    this.maxWeekday_$eq(weekdayId);
                }
                RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(Predef$.MODULE$.short2Short(a.beginUnit()).intValue()), Predef$.MODULE$.short2Short(a.endUnit()).intValue()).foreach((Function1 & Serializable)u -> this.getTeacherCourseOccupy$$anonfun$1$$anonfun$1$$anonfun$1(occupyMap, weekdayId, clazz, BoxesRunTime.unboxToInt((Object)u)));
            }));
        }
        return (Map)occupyMap.map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply(x._1(), (Object)((IterableOnceOps)((IterableOps)x._2()).map((Function1 & Serializable)_$2 -> _$2.name())).mkString(",")));
    }

    public Map<String, String> getStudentOccupy(Student std, Semester semester) {
        scala.collection.mutable.Map occupyMap = Collections$.MODULE$.newMap();
        ScheduleSetting scheduleSetting = this.getScheduleSetting(std.project(), semester);
        if (scheduleSetting.timePublished()) {
            this.clazzProvider.getClazzes(semester, std).foreach((Function1)(JProcedure1 & Serializable)ct -> {
                Clazz clazz = ct.clazz();
                clazz.schedule().activities().foreach((Function1)(JProcedure1 & Serializable)a -> {
                    int weekdayId = a.time().weekday().id();
                    if (weekdayId > this.maxWeekday()) {
                        this.maxWeekday_$eq(weekdayId);
                    }
                    RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(Predef$.MODULE$.short2Short(a.beginUnit()).intValue()), Predef$.MODULE$.short2Short(a.endUnit()).intValue()).foreach((Function1 & Serializable)u -> this.getStudentOccupy$$anonfun$1$$anonfun$1$$anonfun$1(occupyMap, weekdayId, clazz, BoxesRunTime.unboxToInt((Object)u)));
                });
            });
        }
        return (Map)occupyMap.map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply(x._1(), (Object)((IterableOnceOps)((IterableOps)x._2()).map((Function1 & Serializable)_$3 -> _$3.name())).mkString(",")));
    }

    private ScheduleSetting getScheduleSetting(Project project, Semester semester) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(ScheduleSetting.class, "setting");
        query.where("setting.project = :project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project}));
        query.where("setting.semester =:semester", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
        query.cacheable(query.cacheable$default$1());
        Option option = this.entityDao.search((QueryBuilder)query).headOption();
        if (None$.MODULE$.equals(option)) {
            ScheduleSetting ns = new ScheduleSetting();
            ns.placePublished_$eq(true);
            ns.timePublished_$eq(true);
            return ns;
        }
        if (option instanceof Some) {
            ScheduleSetting s = (ScheduleSetting)((Some)option).value();
            return s;
        }
        throw new MatchError((Object)option);
    }

    private static final Set getTeacherMiniOccupy$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1() {
        return new HashSet();
    }

    private final /* synthetic */ Set getTeacherMiniOccupy$$anonfun$1$$anonfun$1$$anonfun$1(scala.collection.mutable.Map miniOccupyMap$3, int weekdayId$1, MiniClazz clazz$2, int u) {
        if (u > this.maxUnit()) {
            this.maxUnit_$eq(u);
        }
        return (Set)((Growable)miniOccupyMap$3.getOrElseUpdate((Object)(weekdayId$1 + "_" + u), OccupyHelper::getTeacherMiniOccupy$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1)).addAll((IterableOnce)clazz$2.stds());
    }

    private static final Set getTeacherCourseOccupy$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1() {
        return new HashSet();
    }

    private final /* synthetic */ Set getTeacherCourseOccupy$$anonfun$1$$anonfun$1$$anonfun$1(scala.collection.mutable.Map occupyMap$3, int weekdayId$2, Clazz clazz$4, int u) {
        if (u > this.maxUnit()) {
            this.maxUnit_$eq(u);
        }
        return (Set)((Growable)occupyMap$3.getOrElseUpdate((Object)(weekdayId$2 + "_" + u), OccupyHelper::getTeacherCourseOccupy$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1)).addOne((Object)clazz$4.course());
    }

    private static final Set getStudentOccupy$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1() {
        return new HashSet();
    }

    private final /* synthetic */ Set getStudentOccupy$$anonfun$1$$anonfun$1$$anonfun$1(scala.collection.mutable.Map occupyMap$6, int weekdayId$3, Clazz clazz$6, int u) {
        if (u > this.maxUnit()) {
            this.maxUnit_$eq(u);
        }
        return (Set)((Growable)occupyMap$6.getOrElseUpdate((Object)(weekdayId$3 + "_" + u), OccupyHelper::getStudentOccupy$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1)).addOne((Object)clazz$6.course());
    }
}

