/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.teaching.web.action;

import java.io.Serializable;
import org.beangle.commons.bean.orderings.CollatorOrdering;
import org.beangle.commons.bean.orderings.CollatorOrdering$;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.lang.time.WeekDay$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.ems.app.Ems$;
import org.beangle.ems.app.web.WebBusinessLogger;
import org.beangle.webmvc.context.ActionContext$;
import org.beangle.webmvc.support.helper.QueryHelper$;
import org.beangle.webmvc.view.View;
import org.openurp.base.edu.model.Course;
import org.openurp.base.edu.model.CourseUnit;
import org.openurp.base.edu.model.TimeSetting;
import org.openurp.base.edu.service.TimeSettingService;
import org.openurp.base.hr.model.Teacher;
import org.openurp.base.model.Project;
import org.openurp.base.model.Semester;
import org.openurp.base.model.User;
import org.openurp.base.std.model.Student;
import org.openurp.edu.clazz.domain.ClazzProvider;
import org.openurp.edu.clazz.domain.WeekTimeBuilder;
import org.openurp.edu.clazz.domain.WeekTimeBuilder$;
import org.openurp.edu.clazz.model.MiniClazz;
import org.openurp.edu.clazz.model.MiniClazzActivity;
import org.openurp.edu.teaching.web.helper.MiniClazzOccupyHelper;
import org.openurp.starter.web.support.TeacherSupport;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class MiniCoachAction
extends TeacherSupport {
    private WebBusinessLogger businessLogger;
    private TimeSettingService timeSettingServie;
    private ClazzProvider clazzProvider;

    public WebBusinessLogger businessLogger() {
        return this.businessLogger;
    }

    public void businessLogger_$eq(WebBusinessLogger x$1) {
        this.businessLogger = x$1;
    }

    public TimeSettingService timeSettingServie() {
        return this.timeSettingServie;
    }

    public void timeSettingServie_$eq(TimeSettingService x$1) {
        this.timeSettingServie = x$1;
    }

    public ClazzProvider clazzProvider() {
        return this.clazzProvider;
    }

    public void clazzProvider_$eq(ClazzProvider x$1) {
        this.clazzProvider = x$1;
    }

    public View projectIndex(Teacher teacher, Project project) {
        Semester semester = this.getSemester();
        Teacher teacher2 = this.getTeacher();
        this.put("semester", semester);
        this.put("teacher", teacher2);
        User me = this.getUser();
        OqlBuilder q = OqlBuilder$.MODULE$.from(MiniClazzActivity.class.getName(), "activity");
        q.where("activity.miniClazz.semester=:semester", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
        q.where("activity.coach1 = :me or activity.coach2 = :me", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{me}));
        q.select("distinct activity.miniClazz");
        Seq clazzes = this.entityDao().search((QueryBuilder)q);
        Seq stds = (Seq)clazzes.flatMap((Function1 & Serializable)_$4 -> _$4.stds());
        this.put("stds", stds.sortBy((Function1 & Serializable)x -> x.grade().code() + x.name(), (Ordering)Ordering.String$.MODULE$));
        this.put("clazzes", clazzes.sortBy((Function1 & Serializable)x -> {
            Student std = (Student)x.stds().head();
            return std.grade().code() + std.name();
        }, (Ordering)new CollatorOrdering(true, CollatorOrdering$.MODULE$.$lessinit$greater$default$2())));
        MiniClazzOccupyHelper occupyHelper = new MiniClazzOccupyHelper(this.entityDao(), null);
        this.put("occupyMap", occupyHelper.getCoachMiniOccupy(me, (Iterable<MiniClazz>)clazzes));
        this.put("maxWeekday", BoxesRunTime.boxToInteger((int)occupyHelper.maxWeekday()));
        this.put("maxUnit", BoxesRunTime.boxToInteger((int)occupyHelper.maxUnit()));
        TimeSetting setting = this.timeSettingServie().get(project, semester, (Option)None$.MODULE$);
        this.put("units", setting.units().sortBy((Function1 & Serializable)_$5 -> _$5.beginAt(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())));
        this.put("EmsApi", Ems$.MODULE$.api());
        this.put("me", me);
        return this.forward(this.forward$default$1());
    }

    public View search() {
        Semester semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)this.getIntId("semester")));
        OqlBuilder q = OqlBuilder$.MODULE$.from(MiniClazz.class, "miniClazz");
        q.where("miniClazz.semester=:semester", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
        q.where("miniClazz.coachHours < :maxCoachHour", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)36)}));
        QueryHelper$.MODULE$.populate(q);
        QueryHelper$.MODULE$.sort(q);
        q.tailOrder("miniClazz.id");
        q.limit(QueryHelper$.MODULE$.pageLimit());
        this.get("stdCodeName").foreach((Function1)(JProcedure1 & Serializable)name -> {
            if (Strings$.MODULE$.isNotBlank((CharSequence)name)) {
                q.where("exists(from miniClazz.stds as std where std.name like :name or std.code like :name)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"%" + name.trim() + "%"}));
                return;
            }
        });
        Seq clazzes = this.entityDao().search((QueryBuilder)q);
        this.put("semester", semester);
        this.put("clazzes", clazzes);
        return this.forward(this.forward$default$1());
    }

    public View edit() {
        Student std = (Student)this.entityDao().get(Student.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("std")));
        Course course = (Course)this.entityDao().get(Course.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("course")));
        Semester semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)this.getIntId("semester")));
        ObjectRef activity = ObjectRef.create((Object)new MiniClazzActivity());
        OqlBuilder query = OqlBuilder$.MODULE$.from(MiniClazz.class, "clazz");
        query.where("clazz.semester=:semester and clazz.course=:course", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester, course}));
        query.where("exists(from clazz.stds std where std.id=:stdId)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std.id()}));
        MiniClazz clazz = (MiniClazz)this.entityDao().search((QueryBuilder)query).head();
        this.put("clazz", clazz);
        this.get("unit").foreach((Function1)(JProcedure1 & Serializable)u -> {
            Set activities = (Set)clazz.activities().filter((Function1 & Serializable)x -> {
                String string = x.time().weekday().id() + "_" + x.beginUnit() + "_" + x.endUnit();
                String string2 = u;
                return !(string != null ? !string.equals(string2) : string2 != null);
            });
            if (activities.nonEmpty()) {
                activity$1.elem = (MiniClazzActivity)activities.head();
            }
            this.put("unit", u);
        });
        this.put("std", std);
        this.put("semester", semester);
        this.put("course", course);
        TimeSetting setting = this.timeSettingServie().get(std.project(), semester, (Option)None$.MODULE$);
        this.put("setting", setting);
        this.put("units", setting.units().sortBy((Function1 & Serializable)_$6 -> _$6.beginAt(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())));
        Project project = std.project();
        User me = this.getUser();
        MiniClazzOccupyHelper occupyHelper = new MiniClazzOccupyHelper(this.entityDao(), this.clazzProvider());
        Map<String, String> miniOccupy = occupyHelper.getCoachMiniOccupy(project, semester, me);
        if (!((MiniClazzActivity)activity.elem).persisted() || ((MiniClazzActivity)activity.elem).coach1().isEmpty() && ((MiniClazzActivity)activity.elem).coach2().isEmpty()) {
            ((MiniClazzActivity)activity.elem).coach1_$eq((Option)Some$.MODULE$.apply((Object)me));
        }
        this.put("teacherOccupyMap", miniOccupy);
        this.put("stdOccupyMap", occupyHelper.getStudentOccupy(std, semester));
        this.put("maxWeekday", BoxesRunTime.boxToInteger((int)occupyHelper.maxWeekday()));
        this.put("maxUnit", BoxesRunTime.boxToInteger((int)occupyHelper.maxUnit()));
        this.put("teacher", me);
        this.put("activity", (MiniClazzActivity)activity.elem);
        return this.forward(this.forward$default$1());
    }

    public View remove() {
        User me = this.getUser();
        MiniClazz clazz = (MiniClazz)this.entityDao().get(MiniClazz.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("clazz")));
        Iterable<MiniClazzActivity> my = this.getMyCoachActivities(clazz, (Option<String>)this.get("unit"), me);
        if (my.isEmpty()) {
            Iterable<MiniClazzActivity> coachs = this.getCoachActivities(clazz, (Option<String>)this.get("unit"), me);
            coachs.foreach((Function1)(JProcedure1 & Serializable)a -> {
                if (a.coach1().contains((Object)me)) {
                    a.coach1_$eq((Option)None$.MODULE$);
                }
                if (a.coach2().contains((Object)me)) {
                    a.coach2_$eq((Option)None$.MODULE$);
                    return;
                }
            });
            this.entityDao().saveOrUpdate((Object)clazz, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MiniClazz[0]));
            this.businessLogger().info("\u5220\u9664\u4e86" + clazz.crn() + "\u7684\u827a\u672f\u8f85\u5bfc\u8001\u5e08", clazz.id(), (Object)ActionContext$.MODULE$.current().params());
        } else {
            clazz.activities().subtractAll(my);
            this.entityDao().saveOrUpdate((Object)clazz, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MiniClazz[0]));
            this.businessLogger().info("\u5220\u9664\u4e86" + clazz.crn() + "\u7684\u827a\u672f\u8f85\u5bfc\u5b89\u6392", clazz.id(), (Object)ActionContext$.MODULE$.current().params());
        }
        return this.redirect("index", "\u5220\u9664\u6210\u529f");
    }

    private Iterable<MiniClazzActivity> getCoachActivities(MiniClazz clazz, Option<String> unit, User coach) {
        Set hasMe = (Set)clazz.activities().filter((Function1 & Serializable)a -> a.coach1().contains((Object)coach) || a.coach2().contains((Object)coach));
        Option<String> option = unit;
        if (option instanceof Some) {
            String u = (String)((Some)option).value();
            return (Set)hasMe.filter((Function1 & Serializable)x -> {
                String string = x.time().weekday().id() + "_" + x.beginUnit() + "_" + x.endUnit();
                String string2 = u;
                return !(string != null ? !string.equals(string2) : string2 != null);
            });
        }
        if (None$.MODULE$.equals(option)) {
            return hasMe;
        }
        throw new MatchError(option);
    }

    private Iterable<MiniClazzActivity> getMyCoachActivities(MiniClazz clazz, Option<String> unit, User coach) {
        Set hasMe = (Set)clazz.activities().filter((Function1 & Serializable)a -> a.coach1().contains((Object)coach) || a.coach2().contains((Object)coach));
        Set my = (Set)hasMe.filter((Function1 & Serializable)_$7 -> _$7.teacher().isEmpty());
        Option<String> option = unit;
        if (option instanceof Some) {
            String u = (String)((Some)option).value();
            return (Set)my.filter((Function1 & Serializable)x -> {
                String string = x.time().weekday().id() + "_" + x.beginUnit() + "_" + x.endUnit();
                String string2 = u;
                return !(string != null ? !string.equals(string2) : string2 != null);
            });
        }
        if (None$.MODULE$.equals(option)) {
            return my;
        }
        throw new MatchError(option);
    }

    public View save() {
        User me = this.getUser();
        Student std = (Student)this.entityDao().get(Student.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("std")));
        Course course = (Course)this.entityDao().get(Course.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("course")));
        Semester semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)this.getIntId("semester")));
        Some coach1 = Some$.MODULE$.apply((Object)me);
        Option coach2 = this.getLong("coach2.id").map((Function1 & Serializable)id -> this.$anonfun$6(BoxesRunTime.unboxToLong((Object)id)));
        OqlBuilder query = OqlBuilder$.MODULE$.from(MiniClazz.class, "clazz");
        query.where("clazz.semester=:semester and clazz.course=:course", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester, course}));
        query.where("exists(from clazz.stds std where std.id=:stdId)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std.id()}));
        MiniClazz clazz = (MiniClazz)this.entityDao().search((QueryBuilder)query).head();
        Option option = this.getInt("weekday");
        if (option instanceof Some) {
            int weekday = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            int weekday2 = this.getInt("weekday", 1);
            CourseUnit beginUnit = (CourseUnit)this.entityDao().get(CourseUnit.class, (Object)BoxesRunTime.boxToInteger((int)this.getInt("beginUnit", 0)));
            CourseUnit endUnit = (CourseUnit)this.entityDao().get(CourseUnit.class, (Object)BoxesRunTime.boxToInteger((int)this.getInt("endUnit", 0)));
            String unit = (String)this.get("unit", weekday2 + "_" + beginUnit.indexno() + "_" + endUnit.indexno());
            Set activities = (Set)clazz.activities().filter((Function1 & Serializable)x -> {
                String string = x.time().weekday().id() + "_" + x.beginUnit() + "_" + x.endUnit();
                String string2 = unit;
                return !(string != null ? !string.equals(string2) : string2 != null);
            });
            Iterator itor = activities.iterator();
            Option places = this.get("places");
            WeekTimeBuilder builder = WeekTimeBuilder$.MODULE$.on(semester);
            Iterable times = builder.build(WeekDay$.MODULE$.of(weekday2), (Iterable)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 17));
            Buffer newActivities = Collections$.MODULE$.newBuffer();
            times.foreach((Function1)(JProcedure1 & Serializable)time -> {
                MiniClazzActivity miniClazzActivity;
                time.beginAt_$eq(beginUnit.beginAt());
                time.endAt_$eq(endUnit.endAt());
                if (itor.hasNext()) {
                    miniClazzActivity = (MiniClazzActivity)itor.next();
                } else {
                    MiniClazzActivity nact = new MiniClazzActivity();
                    nact.miniClazz_$eq(clazz);
                    newActivities.addOne((Object)nact);
                    miniClazzActivity = nact;
                }
                MiniClazzActivity activity = miniClazzActivity;
                activity.time_$eq(time);
                activity.teacher_$eq((Option)None$.MODULE$);
                activity.coach1_$eq((Option)coach1);
                activity.coach2_$eq(coach2);
                activity.beginUnit_$eq((short)beginUnit.indexno());
                activity.endUnit_$eq((short)endUnit.indexno());
                activity.places_$eq(places);
            });
            clazz.activities().addAll((IterableOnce)newActivities);
            this.entityDao().saveOrUpdate((Object)clazz, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MiniClazz[0]));
            this.businessLogger().info("\u8bbe\u7f6e\u4e86" + std.name() + "\u7684\u827a\u672f\u8f85\u5bfc\u5b89\u6392", clazz.id(), (Object)ActionContext$.MODULE$.current().params());
        } else if (None$.MODULE$.equals(option)) {
            String unit = (String)this.get("unit").get();
            Set activities = (Set)clazz.activities().filter((Function1 & Serializable)x -> {
                String string = x.time().weekday().id() + "_" + x.beginUnit() + "_" + x.endUnit();
                String string2 = unit;
                return !(string != null ? !string.equals(string2) : string2 != null);
            });
            activities.foreach((Function1)(JProcedure1 & Serializable)activity -> {
                activity.coach1_$eq((Option)coach1);
                activity.coach2_$eq(coach2);
            });
            this.entityDao().saveOrUpdate((Object)clazz, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MiniClazz[0]));
            this.businessLogger().info("\u8bbe\u7f6e\u4e86" + std.name() + "\u7684\u827a\u672f\u8f85\u5bfc\u8001\u5e08", clazz.id(), (Object)ActionContext$.MODULE$.current().params());
        } else {
            throw new MatchError((Object)option);
        }
        return this.redirect("index", "\u4fdd\u5b58\u6210\u529f");
    }

    private final /* synthetic */ User $anonfun$6(long id) {
        return (User)this.entityDao().get(User.class, (Object)BoxesRunTime.boxToLong((long)id));
    }
}

