/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.teaching.web.action;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.beangle.webmvc.view.View;
import org.openurp.base.hr.model.Teacher;
import org.openurp.base.model.Project;
import org.openurp.base.model.Semester;
import org.openurp.code.edu.model.TeachingMethod;
import org.openurp.edu.clazz.domain.ClazzProvider;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.course.model.ClazzPlan;
import org.openurp.edu.course.model.Lesson;
import org.openurp.edu.schedule.service.LessonSchedule$;
import org.openurp.edu.schedule.service.ScheduleDigestor$;
import org.openurp.starter.web.support.TeacherSupport;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.math.Ordering$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyRef;

public class PlanAction
extends TeacherSupport {
    private ClazzProvider clazzProvider;

    public ClazzProvider clazzProvider() {
        return this.clazzProvider;
    }

    public void clazzProvider_$eq(ClazzProvider x$1) {
        this.clazzProvider = x$1;
    }

    public View projectIndex(Teacher teacher, Project project) {
        Semester semester = this.getSemester();
        this.put("semester", semester);
        scala.collection.immutable.Seq clazzes = this.clazzProvider().getClazzes(semester, teacher, project);
        scala.collection.immutable.Seq scheduled = (scala.collection.immutable.Seq)clazzes.filter((Function1 & Serializable)_$2 -> _$2.schedule().activities().nonEmpty());
        if (scheduled.nonEmpty()) {
            this.put("plans", this.entityDao().findBy(ClazzPlan.class, "clazz", (Object)scheduled).groupBy((Function1 & Serializable)_$3 -> _$3.clazz()));
        }
        this.put("clazzes", scheduled);
        return this.forward(this.forward$default$1());
    }

    public View clazz() {
        Clazz clazz = (Clazz)this.entityDao().get(Clazz.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("clazz")));
        scala.collection.immutable.Seq plans = this.entityDao().findBy(ClazzPlan.class, "clazz", (Object)clazz);
        if (plans.isEmpty()) {
            return this.redirect("edit", "&clazz.id=" + clazz.id());
        }
        this.put("plan", plans.head());
        return this.forward(this.forward$default$1());
    }

    public View edit() {
        LazyRef lazyRef = new LazyRef();
        Clazz clazz = (Clazz)this.entityDao().get(Clazz.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("clazz")));
        scala.collection.immutable.Seq plans = this.entityDao().findBy(ClazzPlan.class, "clazz", (Object)clazz);
        ClazzPlan plan = (ClazzPlan)plans.headOption().getOrElse(PlanAction::$anonfun$2);
        this.put("plan", plan);
        this.put("clazz", clazz);
        this.put("schedule_time", ScheduleDigestor$.MODULE$.digest(clazz, ":day :units :weeks"));
        this.put("schedule_space", ScheduleDigestor$.MODULE$.digest(clazz, ":room"));
        this.put("teachingForms", this.getCodes(TeachingMethod.class, PlanAction.project$1(lazyRef, clazz)));
        Semester semester = clazz.semester();
        LocalDateTime beginAt = semester.beginOn().atTime(LocalTime.MIN);
        LocalDateTime endAt = semester.endOn().atTime(LocalTime.MAX);
        Seq schedules = LessonSchedule$.MODULE$.convert((Iterable)clazz.schedule().activities(), beginAt, endAt);
        if (plan.lessons().isEmpty()) {
            IntRef idx = IntRef.create((int)0);
            ((IterableOnceOps)schedules.sortBy((Function1 & Serializable)_$4 -> _$4.date(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).foreach((Function1 & Serializable)schedule -> {
                ++idx$1.elem;
                Lesson lesson = new Lesson();
                lesson.plan_$eq(plan);
                lesson.idx_$eq(idx$1.elem);
                lesson.remark_$eq((Option)Some$.MODULE$.apply((Object)schedule.room()));
                return (Buffer)plan.lessons().addOne((Object)lesson);
            });
        }
        return this.forward(this.forward$default$1());
    }

    public View save() {
        Clazz clazz = (Clazz)this.entityDao().get(Clazz.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("clazz")));
        scala.collection.immutable.Seq plans = this.entityDao().findBy(ClazzPlan.class, "clazz", (Object)clazz);
        ClazzPlan plan = (ClazzPlan)plans.headOption().getOrElse(PlanAction::$anonfun$3);
        return this.forward(this.forward$default$1());
    }

    private static final Project project$lzyINIT1$1(LazyRef project$lzy1$1, Clazz clazz$1) {
        Project project;
        LazyRef lazyRef = project$lzy1$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy1$1.initialized() ? project$lzy1$1.value() : project$lzy1$1.initialize((Object)clazz$1.project()));
        }
        return project;
    }

    private static final Project project$1(LazyRef project$lzy1$2, Clazz clazz$2) {
        return (Project)(project$lzy1$2.initialized() ? project$lzy1$2.value() : PlanAction.project$lzyINIT1$1(project$lzy1$2, clazz$2));
    }

    private static final ClazzPlan $anonfun$2() {
        return new ClazzPlan();
    }

    private static final ClazzPlan $anonfun$3() {
        return new ClazzPlan();
    }
}

