/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.teaching.web.action;

import java.io.Serializable;
import java.time.LocalDate;
import org.beangle.commons.bean.orderings.CollatorOrdering;
import org.beangle.commons.bean.orderings.CollatorOrdering$;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.lang.time.WeekDay$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.ems.app.Ems$;
import org.beangle.ems.app.web.WebBusinessLogger;
import org.beangle.webmvc.context.ActionContext$;
import org.beangle.webmvc.view.View;
import org.openurp.base.edu.model.Course;
import org.openurp.base.edu.model.CourseUnit;
import org.openurp.base.edu.model.Terms;
import org.openurp.base.edu.model.Terms$;
import org.openurp.base.edu.model.TimeSetting;
import org.openurp.base.edu.service.TimeSettingService;
import org.openurp.base.hr.model.Teacher;
import org.openurp.base.model.Project;
import org.openurp.base.model.Semester;
import org.openurp.base.model.User;
import org.openurp.base.service.TermCalculator;
import org.openurp.base.std.model.Student;
import org.openurp.base.std.model.StudentTutor;
import org.openurp.edu.clazz.domain.ClazzProvider;
import org.openurp.edu.clazz.domain.WeekTimeBuilder;
import org.openurp.edu.clazz.domain.WeekTimeBuilder$;
import org.openurp.edu.clazz.model.MiniClazz;
import org.openurp.edu.clazz.model.MiniClazzActivity;
import org.openurp.edu.teaching.web.action.GuidanceCourseGroup;
import org.openurp.edu.teaching.web.helper.MiniClazzOccupyHelper;
import org.openurp.edu.teaching.web.helper.StudentStateHelper;
import org.openurp.starter.web.support.TeacherSupport;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class MiniAction
extends TeacherSupport {
    private WebBusinessLogger businessLogger;
    private TimeSettingService timeSettingServie;
    private ClazzProvider clazzProvider;

    public WebBusinessLogger businessLogger() {
        return this.businessLogger;
    }

    public void businessLogger_$eq(WebBusinessLogger x$1) {
        this.businessLogger = x$1;
    }

    public TimeSettingService timeSettingServie() {
        return this.timeSettingServie;
    }

    public void timeSettingServie_$eq(TimeSettingService x$1) {
        this.timeSettingServie = x$1;
    }

    public ClazzProvider clazzProvider() {
        return this.clazzProvider;
    }

    public void clazzProvider_$eq(ClazzProvider x$1) {
        this.clazzProvider = x$1;
    }

    public View projectIndex(Teacher teacher, Project project) {
        Semester semester = this.getSemester();
        Teacher teacher2 = this.getTeacher();
        this.put("semester", (Object)semester);
        this.put("teacher", (Object)teacher2);
        GuidanceCourseGroup group = this.getGuidanceGroup(project);
        this.put("group", (Object)group);
        scala.collection.immutable.Map clazzMap = Predef$.MODULE$.Map().empty();
        Seq stds = this.getStds(teacher2, semester);
        Set activeStds = Collections$.MODULE$.newSet();
        scala.collection.mutable.Map groupTerms = Collections$.MODULE$.newMap();
        TermCalculator termCalculator = new TermCalculator(project, semester, this.entityDao());
        stds.foreach((Function1)(JProcedure1 & Serializable)std -> {
            int term = this.calcTerm(std, semester);
            if (group.contains(term)) {
                groupTerms.put((Object)(std.id() + "_" + group.name()), (Object)BoxesRunTime.boxToInteger((int)term));
                activeStds.add(std);
                return;
            }
        });
        this.put("stds", activeStds.toSeq().sortBy((Function1 & Serializable)x -> x.grade().code() + x.name(), (Ordering)new CollatorOrdering(true, CollatorOrdering$.MODULE$.$lessinit$greater$default$2())));
        this.put("stdGroupTerms", (Object)groupTerms);
        if (stds.nonEmpty()) {
            OqlBuilder query = OqlBuilder$.MODULE$.from(MiniClazz.class, "clazz");
            query.where("clazz.semester=:semester", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
            query.where("clazz.teacher=:me", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{teacher2}));
            Seq clazzes = this.entityDao().search((QueryBuilder)query);
            clazzMap = (scala.collection.immutable.Map)clazzes.groupBy((Function1 & Serializable)_$4 -> _$4.course()).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Course c = (Course)tuple2._1();
                    Seq gs = (Seq)tuple2._2();
                    return Tuple2$.MODULE$.apply((Object)c, (Object)((IterableOps)gs.flatMap((Function1 & Serializable)clz -> (IterableOnce)clz.stds().map((Function1 & Serializable)_$5 -> Tuple2$.MODULE$.apply(_$5, clz)))).groupBy((Function1 & Serializable)_$6 -> (Student)_$6._1()).map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply(x._1(), ((Tuple2)((IterableOps)x._2()).head())._2())));
                }
                throw new MatchError((Object)tuple2);
            });
        }
        MiniClazzOccupyHelper occupyHelper = new MiniClazzOccupyHelper(this.entityDao(), this.clazzProvider());
        this.put("miniOccupyMap", (Object)occupyHelper.getTeacherMiniOccupy(project, semester, teacher2));
        this.put("occupyMap", (Object)occupyHelper.getTeacherCourseOccupy(project, semester, teacher2));
        this.put("maxWeekday", (Object)BoxesRunTime.boxToInteger((int)occupyHelper.maxWeekday()));
        this.put("maxUnit", (Object)BoxesRunTime.boxToInteger((int)occupyHelper.maxUnit()));
        this.put("clazzMap", (Object)clazzMap);
        this.put("EmsApi", (Object)Ems$.MODULE$.api());
        TimeSetting setting = this.timeSettingServie().get(project, semester, (Option)None$.MODULE$);
        this.put("units", setting.units().sortBy((Function1 & Serializable)_$7 -> _$7.beginAt(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())));
        this.put("studentStateHelper", (Object)new StudentStateHelper());
        return this.forward(this.forward$default$1());
    }

    public View edit() {
        Student std = (Student)this.entityDao().get(Student.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("std")));
        Course course = (Course)this.entityDao().get(Course.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("course")));
        Semester semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)this.getIntId("semester")));
        ObjectRef activity = ObjectRef.create((Object)new MiniClazzActivity());
        OqlBuilder query = OqlBuilder$.MODULE$.from(MiniClazz.class, "clazz");
        query.where("clazz.semester=:semester and clazz.course=:course", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester, course}));
        query.where("exists(from clazz.stds std where std.id=:stdId)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std.id()}));
        Option clazz = this.entityDao().search((QueryBuilder)query).headOption();
        this.put("clazz", (Object)clazz);
        clazz.foreach((Function1)(JProcedure1 & Serializable)clz -> this.get("unit").foreach((Function1)(JProcedure1 & Serializable)u -> {
            Set activities = (Set)clz.activities().filter((Function1 & Serializable)x -> {
                String string = x.time().weekday().id() + "_" + x.beginUnit() + "_" + x.endUnit();
                String string2 = u;
                return !(string != null ? !string.equals(string2) : string2 != null);
            });
            if (activities.nonEmpty()) {
                activity$1.elem = (MiniClazzActivity)activities.head();
            }
            this.put("unit", u);
        }));
        this.put("std", (Object)std);
        this.put("semester", (Object)semester);
        this.put("course", (Object)course);
        TimeSetting setting = this.timeSettingServie().get(std.project(), semester, (Option)None$.MODULE$);
        this.put("setting", (Object)setting);
        this.put("units", setting.units().sortBy((Function1 & Serializable)_$8 -> _$8.beginAt(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())));
        Project project = std.project();
        Teacher teacher = this.getTeacher();
        MiniClazzOccupyHelper occupyHelper = new MiniClazzOccupyHelper(this.entityDao(), this.clazzProvider());
        Map courseOccupy = occupyHelper.getTeacherCourseOccupy(project, semester, teacher);
        Map miniOccupy = occupyHelper.getTeacherMiniOccupy(project, semester, teacher);
        this.put("teacherOccupyMap", (Object)occupyHelper.mergeOccupy(courseOccupy, miniOccupy));
        this.put("stdOccupyMap", (Object)occupyHelper.getStudentOccupy(std, semester));
        this.put("maxWeekday", (Object)BoxesRunTime.boxToInteger((int)occupyHelper.maxWeekday()));
        this.put("maxUnit", (Object)BoxesRunTime.boxToInteger((int)occupyHelper.maxUnit()));
        this.put("teacher", (Object)teacher);
        this.put("activity", (Object)((MiniClazzActivity)activity.elem));
        return this.forward(this.forward$default$1());
    }

    public View remove() {
        Teacher me = this.getTeacher();
        MiniClazz clazz = (MiniClazz)this.entityDao().get(MiniClazz.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("clazz")));
        if (clazz.teacher().contains((Object)me)) {
            Option option = this.get("unit");
            if (None$.MODULE$.equals(option)) {
                this.entityDao().remove((Object)clazz, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MiniClazz[0]));
            } else if (option instanceof Some) {
                String unit = (String)((Some)option).value();
                clazz.activities().subtractAll((IterableOnce)clazz.activities().filter((Function1 & Serializable)x -> {
                    String string = x.time().weekday().id() + "_" + x.beginUnit() + "_" + x.endUnit();
                    String string2 = unit;
                    return !(string != null ? !string.equals(string2) : string2 != null);
                }));
                clazz.calcHours();
                this.entityDao().saveOrUpdate((Object)clazz, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MiniClazz[0]));
            } else {
                throw new MatchError((Object)option);
            }
            this.businessLogger().info("\u5220\u9664\u4e86" + clazz.crn() + "\u7684\u4e3b\u8bfe\u5b89\u6392", clazz.id(), (Object)ActionContext$.MODULE$.current().params());
        }
        return this.redirect("index", "\u5220\u9664\u6210\u529f");
    }

    public View save() {
        MiniClazz miniClazz;
        Teacher me = this.getTeacher();
        Student std = (Student)this.entityDao().get(Student.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("std")));
        Course course = (Course)this.entityDao().get(Course.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("course")));
        Semester semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)this.getIntId("semester")));
        Option coach1 = this.getLong("coach1.id").map((Function1 & Serializable)id -> this.$anonfun$2(BoxesRunTime.unboxToLong((Object)id)));
        Option coach2 = this.getLong("coach2.id").map((Function1 & Serializable)id -> this.$anonfun$3(BoxesRunTime.unboxToLong((Object)id)));
        OqlBuilder query = OqlBuilder$.MODULE$.from(MiniClazz.class, "clazz");
        query.where("clazz.semester=:semester and clazz.course=:course", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester, course}));
        query.where("exists(from clazz.stds std where std.id=:stdId)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std.id()}));
        Option option = this.entityDao().search((QueryBuilder)query).headOption();
        if (None$.MODULE$.equals(option)) {
            MiniClazz newClzz = new MiniClazz(std.code(), std.project(), semester, course);
            newClzz.stds().addOne((Object)std);
            newClzz.teachDepart_$eq(std.department());
            newClzz.teacher_$eq((Option)Some$.MODULE$.apply((Object)me));
            miniClazz = newClzz;
        } else if (option instanceof Some) {
            MiniClazz clz;
            miniClazz = clz = (MiniClazz)((Some)option).value();
        } else {
            throw new MatchError((Object)option);
        }
        MiniClazz clazz = miniClazz;
        int weekday = this.getInt("weekday", 1);
        CourseUnit beginUnit = (CourseUnit)this.entityDao().get(CourseUnit.class, (Object)BoxesRunTime.boxToInteger((int)this.getInt("beginUnit", 0)));
        CourseUnit endUnit = (CourseUnit)this.entityDao().get(CourseUnit.class, (Object)BoxesRunTime.boxToInteger((int)this.getInt("endUnit", 0)));
        String unit = (String)this.get("unit", (Object)(weekday + "_" + beginUnit.indexno() + "_" + endUnit.indexno()));
        Set activities = (Set)clazz.activities().filter((Function1 & Serializable)x -> {
            String string = x.time().weekday().id() + "_" + x.beginUnit() + "_" + x.endUnit();
            String string2 = unit;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
        Iterator itor = activities.iterator();
        Option places = this.get("places");
        WeekTimeBuilder builder = WeekTimeBuilder$.MODULE$.on(semester);
        Iterable times = builder.build(WeekDay$.MODULE$.of(weekday), (Iterable)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 18));
        Buffer newActivities = Collections$.MODULE$.newBuffer();
        times.foreach((Function1)(JProcedure1 & Serializable)time -> {
            MiniClazzActivity miniClazzActivity;
            time.beginAt_$eq(beginUnit.beginAt());
            time.endAt_$eq(endUnit.endAt());
            if (itor.hasNext()) {
                miniClazzActivity = (MiniClazzActivity)itor.next();
            } else {
                MiniClazzActivity nact = new MiniClazzActivity();
                nact.miniClazz_$eq(clazz);
                newActivities.addOne((Object)nact);
                miniClazzActivity = nact;
            }
            MiniClazzActivity activity = miniClazzActivity;
            activity.time_$eq(time);
            activity.teacher_$eq((Option)Some$.MODULE$.apply((Object)me));
            activity.coach1_$eq(coach1);
            activity.coach2_$eq(coach2);
            activity.beginUnit_$eq((short)beginUnit.indexno());
            activity.endUnit_$eq((short)endUnit.indexno());
            activity.places_$eq(places);
        });
        while (itor.hasNext()) {
            clazz.activities().subtractOne(itor.next());
        }
        clazz.activities().addAll((IterableOnce)newActivities);
        clazz.calcHours();
        clazz.teacher_$eq((Option)Some$.MODULE$.apply((Object)me));
        this.entityDao().saveOrUpdate((Object)clazz, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MiniClazz[0]));
        this.businessLogger().info("\u8bbe\u7f6e\u4e86" + std.name() + "\u7684\u4e3b\u8bfe\u5b89\u6392", clazz.id(), (Object)ActionContext$.MODULE$.current().params());
        return this.redirect("index", "\u4fdd\u5b58\u6210\u529f");
    }

    private int calcTerm(Student std, Semester semester) {
        Project project = std.project();
        if (!this.isStuding(std, semester.beginOn().plusDays(20L), semester.endOn().minusDays(20L))) {
            return 0;
        }
        Tuple2 sp2 = this.semesterService().get(project, std.beginOn(), semester.endOn());
        Buffer semesters = Collections$.MODULE$.newBuffer();
        semesters.$plus$plus$eq((IterableOnce)sp2._1());
        semesters.$plus$plus$eq((IterableOnce)sp2._2());
        IntRef notinschool = IntRef.create((int)0);
        semesters.foreach((Function1)(JProcedure1 & Serializable)s -> {
            LocalDate endOn;
            LocalDate beginOn = s.beginOn().plusDays(20L);
            if (!this.isStuding(std, beginOn, endOn = s.endOn().minusDays(20L))) {
                ++notinschool$1.elem;
                return;
            }
        });
        return semesters.size() - notinschool.elem;
    }

    private boolean isStuding(Student std, LocalDate beginOn, LocalDate endOn) {
        Buffer states = (Buffer)std.states().filter((Function1 & Serializable)x -> x.beginOn().isBefore(endOn) && beginOn.isBefore(x.endOn()));
        return states.exists((Function1 & Serializable)_$9 -> _$9.inschool());
    }

    private GuidanceCourseGroup getGuidanceGroup(Project project) {
        String courseTerms = (String)this.getConfig("edu.course.guidance_course_terms", (Object)"", project);
        if (Strings$.MODULE$.isBlank((CharSequence)courseTerms)) {
            return null;
        }
        courseTerms = Strings$.MODULE$.substringBetween(courseTerms, "{", "}");
        Buffer groups = Collections$.MODULE$.newBuffer();
        Object object = Predef$.MODULE$.refArrayOps((Object[])Strings$.MODULE$.split(courseTerms, ","));
        ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)group -> {
            String name = Strings$.MODULE$.substringBefore(group, ":");
            name = Strings$.MODULE$.replace(name, "'", "");
            name = Strings$.MODULE$.replace(name, "\"", "");
            String termList = Strings$.MODULE$.substringAfter(group, ":");
            termList = Strings$.MODULE$.replace(termList, "'", "");
            termList = Strings$.MODULE$.replace(termList, "\"", "");
            scala.collection.mutable.Map course2Term = Collections$.MODULE$.newMap();
            Object object = Predef$.MODULE$.refArrayOps((Object[])Strings$.MODULE$.split(termList, ";"));
            ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)courseTerm -> {
                String[] data = Strings$.MODULE$.split(courseTerm, "=");
                Course course = (Course)this.entityDao().get(Course.class, (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(data[0]))));
                Terms term = Terms$.MODULE$.apply(data[1]);
                return course2Term.put((Object)course, (Object)term);
            });
            if (name.contains("\u4e3b\u8bfe")) {
                groups.addOne((Object)new GuidanceCourseGroup(name, course2Term.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())));
                return;
            }
        });
        return (GuidanceCourseGroup)groups.head();
    }

    private Seq<Student> getStds(Teacher teacher, Semester semester) {
        OqlBuilder stdQuery = (OqlBuilder)OqlBuilder$.MODULE$.from(StudentTutor.class.getName(), "st").where("st.tutor=:me", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{teacher}));
        stdQuery.where("st.std.beginOn < :endOn and :beginOn < st.std.endOn", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester.endOn(), semester.beginOn()}));
        stdQuery.orderBy("st.std.state.grade.code,st.std.code");
        stdQuery.select("st.std");
        return this.entityDao().search((QueryBuilder)stdQuery);
    }

    private final /* synthetic */ User $anonfun$2(long id) {
        return (User)this.entityDao().get(User.class, (Object)BoxesRunTime.boxToLong((long)id));
    }

    private final /* synthetic */ User $anonfun$3(long id) {
        return (User)this.entityDao().get(User.class, (Object)BoxesRunTime.boxToLong((long)id));
    }
}

