/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.teaching.web.helper;

import java.io.Serializable;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.time.WeekTime;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.openurp.base.hr.model.Teacher;
import org.openurp.base.model.Project;
import org.openurp.base.model.Semester;
import org.openurp.base.model.User;
import org.openurp.base.std.model.Student;
import org.openurp.edu.clazz.config.ScheduleSetting;
import org.openurp.edu.clazz.domain.ClazzProvider;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.clazz.model.MiniClazz;
import org.openurp.edu.clazz.model.MiniClazzActivity;
import org.openurp.edu.teaching.web.helper.ActivityInfo;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Growable;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class MiniClazzOccupyHelper {
    private final EntityDao entityDao;
    private final ClazzProvider clazzProvider;
    private int maxWeekday;
    private int maxUnit;

    public MiniClazzOccupyHelper(EntityDao entityDao, ClazzProvider clazzProvider) {
        this.entityDao = entityDao;
        this.clazzProvider = clazzProvider;
        this.maxWeekday = 5;
        this.maxUnit = 0;
    }

    public int maxWeekday() {
        return this.maxWeekday;
    }

    public void maxWeekday_$eq(int x$1) {
        this.maxWeekday = x$1;
    }

    public int maxUnit() {
        return this.maxUnit;
    }

    public void maxUnit_$eq(int x$1) {
        this.maxUnit = x$1;
    }

    public Map<String, String> mergeOccupy(Map<String, String> m1, Map<String, String> m2) {
        HashMap rs = new HashMap();
        rs.addAll(m1);
        m2.foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                Option option = rs.get((Object)k);
                if (None$.MODULE$.equals(option)) {
                    return rs.put((Object)k, (Object)v);
                }
                if (option instanceof Some) {
                    String v2 = (String)((Some)option).value();
                    String string = v;
                    String string2 = v2;
                    if (string == null ? string2 != null : !string.equals(string2)) {
                        rs.put((Object)k, (Object)(v + " " + v2));
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                throw new MatchError((Object)option);
            }
            throw new MatchError((Object)tuple2);
        });
        return rs;
    }

    public Map<String, Seq<ActivityInfo>> mergeActivities(Map<String, Seq<ActivityInfo>> m1, Map<String, Seq<ActivityInfo>> m2) {
        HashMap rs = new HashMap();
        rs.addAll(m1);
        m2.foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                Seq v = (Seq)tuple2._2();
                Option option = rs.get((Object)k);
                if (None$.MODULE$.equals(option)) {
                    return rs.put((Object)k, (Object)v);
                }
                if (option instanceof Some) {
                    Seq v2 = (Seq)((Some)option).value();
                    Seq seq = v;
                    Seq seq2 = v2;
                    if (seq == null ? seq2 != null : !seq.equals(seq2)) {
                        rs.put((Object)k, v.$plus$plus((IterableOnce)v2));
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                throw new MatchError((Object)option);
            }
            throw new MatchError((Object)tuple2);
        });
        return rs;
    }

    public Map<String, String> getCoachMiniOccupy(Project project, Semester semester, User coach) {
        OqlBuilder q = OqlBuilder$.MODULE$.from(MiniClazzActivity.class.getName(), "activity");
        q.where("activity.miniClazz.semester=:semester", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
        q.where("activity.coach1 = :me or activity.coach2 = :me", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{coach}));
        q.select("distinct activity.miniClazz");
        return this.getCoachMiniOccupy(coach, (Iterable)this.entityDao.search((QueryBuilder)q));
    }

    public Map<String, String> getCoachMiniOccupy(User coach, Iterable<MiniClazz> clazzes) {
        Map activities = this.getCoachMiniActivities(coach, clazzes);
        return (Map)activities.map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply(x._1(), (Object)((IterableOnceOps)((IterableOps)x._2()).map((Function1 & Serializable)_$1 -> StringOps$.MODULE$.distinct$extension(Predef$.MODULE$.augmentString((String)_$1.comments().getOrElse(MiniClazzOccupyHelper::getCoachMiniOccupy$$anonfun$1$$anonfun$1$$anonfun$1))))).mkString(",")));
    }

    public Map<String, Seq<ActivityInfo>> getCoachMiniActivities(Project project, Semester semester, User coach) {
        OqlBuilder q = OqlBuilder$.MODULE$.from(MiniClazzActivity.class.getName(), "activity");
        q.where("activity.miniClazz.semester=:semester", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
        q.where("activity.coach1 = :me or activity.coach2 = :me", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{coach}));
        q.select("distinct activity.miniClazz");
        return this.getCoachMiniActivities(coach, (Iterable)this.entityDao.search((QueryBuilder)q));
    }

    public Map<String, Seq<ActivityInfo>> getCoachMiniActivities(User coach, Iterable<MiniClazz> clazzes) {
        Iterable activities = (Iterable)clazzes.flatMap((Function1 & Serializable)_$2 -> _$2.activities());
        scala.collection.mutable.Map activitiesMap = Collections$.MODULE$.newMap();
        activities.foreach((Function1)(JProcedure1 & Serializable)a -> {
            if (a.coach1().contains((Object)coach) || a.coach2().contains((Object)coach)) {
                int weekdayId = a.time().weekday().id();
                if (weekdayId > this.maxWeekday()) {
                    this.maxWeekday_$eq(weekdayId);
                }
                RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(Predef$.MODULE$.short2Short(a.beginUnit()).intValue()), Predef$.MODULE$.short2Short(a.endUnit()).intValue()).foreach((Function1 & Serializable)u -> this.getCoachMiniActivities$$anonfun$1$$anonfun$1(activitiesMap, weekdayId, a, BoxesRunTime.unboxToInt((Object)u)));
                return;
            }
        });
        return activitiesMap;
    }

    public Map<String, String> getTeacherMiniOccupy(Project project, Semester semester, Teacher teacher) {
        Map activities = this.getTeacherMiniActivities(project, semester, teacher);
        return (Map)activities.map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply(x._1(), (Object)((IterableOnceOps)((SeqOps)((IterableOps)x._2()).map((Function1 & Serializable)_$3 -> (String)_$3.comments().getOrElse(MiniClazzOccupyHelper::getTeacherMiniOccupy$$anonfun$1$$anonfun$1$$anonfun$1))).distinct()).mkString(",")));
    }

    public Map<String, Seq<ActivityInfo>> getTeacherMiniActivities(Project project, Semester semester, Teacher teacher) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(MiniClazz.class, "clazz");
        query.where("clazz.semester=:semester", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
        query.where("clazz.teacher=:me", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{teacher}));
        scala.collection.immutable.Seq clazzes = this.entityDao.search((QueryBuilder)query);
        scala.collection.mutable.Map activitiesMap = Collections$.MODULE$.newMap();
        clazzes.foreach((Function1)(JProcedure1 & Serializable)clazz -> clazz.activities().foreach((Function1)(JProcedure1 & Serializable)a -> {
            if (a.teacher().contains((Object)teacher)) {
                int weekdayId = a.time().weekday().id();
                if (weekdayId > this.maxWeekday()) {
                    this.maxWeekday_$eq(weekdayId);
                }
                RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(Predef$.MODULE$.short2Short(a.beginUnit()).intValue()), Predef$.MODULE$.short2Short(a.endUnit()).intValue()).foreach((Function1 & Serializable)u -> this.getTeacherMiniActivities$$anonfun$1$$anonfun$1$$anonfun$1(activitiesMap, weekdayId, a, BoxesRunTime.unboxToInt((Object)u)));
                return;
            }
        }));
        return activitiesMap;
    }

    public Map<String, String> getTeacherCourseOccupy(Project project, Semester semester, Teacher teacher) {
        scala.collection.mutable.Map occupyMap = Collections$.MODULE$.newMap();
        ScheduleSetting scheduleSetting = this.getScheduleSetting(project, semester);
        if (scheduleSetting.timePublished()) {
            this.clazzProvider.getClazzes(semester, teacher, project).foreach((Function1)(JProcedure1 & Serializable)clazz -> clazz.schedule().activities().foreach((Function1)(JProcedure1 & Serializable)a -> {
                int weekdayId = a.time().weekday().id();
                if (weekdayId > this.maxWeekday()) {
                    this.maxWeekday_$eq(weekdayId);
                }
                RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(Predef$.MODULE$.short2Short(a.beginUnit()).intValue()), Predef$.MODULE$.short2Short(a.endUnit()).intValue()).foreach((Function1 & Serializable)u -> this.getTeacherCourseOccupy$$anonfun$1$$anonfun$1$$anonfun$1(occupyMap, weekdayId, clazz, BoxesRunTime.unboxToInt((Object)u)));
            }));
        }
        return (Map)occupyMap.map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply(x._1(), (Object)((IterableOnceOps)((IterableOps)x._2()).map((Function1 & Serializable)_$4 -> _$4.name())).mkString(",")));
    }

    public Map<String, String> getStudentOccupy(Student std, Semester semester) {
        scala.collection.mutable.Map occupyMap = Collections$.MODULE$.newMap();
        ScheduleSetting scheduleSetting = this.getScheduleSetting(std.project(), semester);
        if (scheduleSetting.timePublished()) {
            this.clazzProvider.getClazzes(semester, std).foreach((Function1)(JProcedure1 & Serializable)ct -> {
                Clazz clazz = ct.clazz();
                clazz.schedule().activities().foreach((Function1)(JProcedure1 & Serializable)a -> {
                    int weekdayId = a.time().weekday().id();
                    if (weekdayId > this.maxWeekday()) {
                        this.maxWeekday_$eq(weekdayId);
                    }
                    RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(Predef$.MODULE$.short2Short(a.beginUnit()).intValue()), Predef$.MODULE$.short2Short(a.endUnit()).intValue()).foreach((Function1 & Serializable)u -> this.getStudentOccupy$$anonfun$1$$anonfun$1$$anonfun$1(occupyMap, weekdayId, clazz, BoxesRunTime.unboxToInt((Object)u)));
                });
            });
        }
        return (Map)occupyMap.map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply(x._1(), (Object)((IterableOnceOps)((IterableOps)x._2()).map((Function1 & Serializable)_$5 -> _$5.name())).mkString(",")));
    }

    private ScheduleSetting getScheduleSetting(Project project, Semester semester) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(ScheduleSetting.class, "setting");
        query.where("setting.project = :project", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project}));
        query.where("setting.semester =:semester", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
        query.cacheable(query.cacheable$default$1());
        Option option = this.entityDao.search((QueryBuilder)query).headOption();
        if (None$.MODULE$.equals(option)) {
            ScheduleSetting ns = new ScheduleSetting();
            ns.placePublished_$eq(true);
            ns.timePublished_$eq(true);
            return ns;
        }
        if (option instanceof Some) {
            ScheduleSetting s = (ScheduleSetting)((Some)option).value();
            return s;
        }
        throw new MatchError((Object)option);
    }

    private ActivityInfo newClazzActivity(MiniClazzActivity ma) {
        ActivityInfo na = new ActivityInfo();
        na.subject_$eq(ma.miniClazz().course().name());
        na.time_$eq(new WeekTime(ma.time()));
        na.places_$eq(ma.places());
        Iterable users = (Iterable)((IterableOps)Option$.MODULE$.option2Iterable(ma.teacher()).$plus$plus((IterableOnce)ma.coach1())).$plus$plus((IterableOnce)ma.coach2());
        na.users_$eq(Option$.MODULE$.apply((Object)((IterableOnceOps)users.map((Function1 & Serializable)_$6 -> _$6.name())).mkString(",")));
        na.comments_$eq(Option$.MODULE$.apply((Object)((IterableOnceOps)ma.miniClazz().stds().map((Function1 & Serializable)_$7 -> _$7.name())).mkString(",")));
        na.activityType_$eq("\u8f85\u5bfc");
        na.owner_$eq((Option)Some$.MODULE$.apply((Object)ma.miniClazz().id().toString()));
        return na;
    }

    private ActivityInfo newCoachActivity(MiniClazzActivity ma) {
        ActivityInfo na = new ActivityInfo();
        na.subject_$eq(ma.miniClazz().course().name());
        na.time_$eq(new WeekTime(ma.time()));
        na.places_$eq(ma.places());
        Iterable users = (Iterable)Option$.MODULE$.option2Iterable(ma.coach1()).$plus$plus((IterableOnce)ma.coach2());
        na.users_$eq(Option$.MODULE$.apply((Object)((IterableOnceOps)users.map((Function1 & Serializable)_$8 -> _$8.name())).mkString(",")));
        na.comments_$eq(Option$.MODULE$.apply((Object)((IterableOnceOps)ma.miniClazz().stds().map((Function1 & Serializable)_$9 -> _$9.name())).mkString(",")));
        na.activityType_$eq("\u4e0a\u8bfe");
        na.owner_$eq((Option)Some$.MODULE$.apply((Object)ma.miniClazz().id().toString()));
        return na;
    }

    private static final String getCoachMiniOccupy$$anonfun$1$$anonfun$1$$anonfun$1() {
        return "";
    }

    private static final Buffer getCoachMiniActivities$$anonfun$1$$anonfun$1$$anonfun$1() {
        return new ArrayBuffer();
    }

    private final /* synthetic */ Buffer getCoachMiniActivities$$anonfun$1$$anonfun$1(scala.collection.mutable.Map activitiesMap$2, int weekdayId$1, MiniClazzActivity a$1, int u) {
        if (u > this.maxUnit()) {
            this.maxUnit_$eq(u);
        }
        return (Buffer)((Growable)activitiesMap$2.getOrElseUpdate((Object)(weekdayId$1 + "_" + u), MiniClazzOccupyHelper::getCoachMiniActivities$$anonfun$1$$anonfun$1$$anonfun$1)).addOne((Object)this.newCoachActivity(a$1));
    }

    private static final String getTeacherMiniOccupy$$anonfun$1$$anonfun$1$$anonfun$1() {
        return "";
    }

    private static final Buffer getTeacherMiniActivities$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1() {
        return new ArrayBuffer();
    }

    private final /* synthetic */ Buffer getTeacherMiniActivities$$anonfun$1$$anonfun$1$$anonfun$1(scala.collection.mutable.Map activitiesMap$5, int weekdayId$2, MiniClazzActivity a$2, int u) {
        if (u > this.maxUnit()) {
            this.maxUnit_$eq(u);
        }
        return (Buffer)((Growable)activitiesMap$5.getOrElseUpdate((Object)(weekdayId$2 + "_" + u), MiniClazzOccupyHelper::getTeacherMiniActivities$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1)).addOne((Object)this.newClazzActivity(a$2));
    }

    private static final Set getTeacherCourseOccupy$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1() {
        return new HashSet();
    }

    private final /* synthetic */ Set getTeacherCourseOccupy$$anonfun$1$$anonfun$1$$anonfun$1(scala.collection.mutable.Map occupyMap$3, int weekdayId$3, Clazz clazz$2, int u) {
        if (u > this.maxUnit()) {
            this.maxUnit_$eq(u);
        }
        return (Set)((Growable)occupyMap$3.getOrElseUpdate((Object)(weekdayId$3 + "_" + u), MiniClazzOccupyHelper::getTeacherCourseOccupy$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1)).addOne((Object)clazz$2.course());
    }

    private static final Set getStudentOccupy$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1() {
        return new HashSet();
    }

    private final /* synthetic */ Set getStudentOccupy$$anonfun$1$$anonfun$1$$anonfun$1(scala.collection.mutable.Map occupyMap$6, int weekdayId$4, Clazz clazz$4, int u) {
        if (u > this.maxUnit()) {
            this.maxUnit_$eq(u);
        }
        return (Set)((Growable)occupyMap$6.getOrElseUpdate((Object)(weekdayId$4 + "_" + u), MiniClazzOccupyHelper::getStudentOccupy$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1)).addOne((Object)clazz$4.course());
    }
}

