/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.teaching.web.helper;

import java.io.Serializable;
import java.time.Instant;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.security.Securities$;
import org.beangle.web.action.context.ActionContext$;
import org.beangle.web.action.context.Params$;
import org.openurp.base.std.model.Student;
import org.openurp.code.edu.model.CourseTakeType$;
import org.openurp.code.edu.model.ExamStatus;
import org.openurp.code.edu.model.ExamStatus$;
import org.openurp.code.edu.model.ExamType;
import org.openurp.code.edu.model.GradeType;
import org.openurp.code.edu.model.GradeType$;
import org.openurp.code.edu.model.GradingMode;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.clazz.model.CourseTaker;
import org.openurp.edu.exam.model.ExamTaker;
import org.openurp.edu.grade.model.CourseGrade;
import org.openurp.edu.grade.model.CourseGrade$;
import org.openurp.edu.grade.model.CourseGradeState;
import org.openurp.edu.grade.model.ExamGrade;
import org.openurp.edu.grade.model.ExamGrade$;
import org.openurp.edu.grade.model.ExamGradeState;
import org.openurp.edu.grade.model.GaGrade;
import org.openurp.edu.grade.model.GradeState;
import org.openurp.edu.grade.service.ClazzGradeService;
import org.openurp.edu.grade.service.CourseGradeCalculator;
import org.openurp.edu.grade.service.GradingModeStrategy$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.math.Ordering;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class GradeInputHelper {
    private final EntityDao entityDao;
    private final CourseGradeCalculator calculator;
    private final ClazzGradeService clazzGradeService;

    public GradeInputHelper(EntityDao entityDao, CourseGradeCalculator calculator, ClazzGradeService clazzGradeService) {
        this.entityDao = entityDao;
        this.calculator = calculator;
        this.clazzGradeService = clazzGradeService;
    }

    private EntityDao entityDao() {
        return this.entityDao;
    }

    private CourseGradeCalculator calculator() {
        return this.calculator;
    }

    public ClazzGradeService clazzGradeService() {
        return this.clazzGradeService;
    }

    public Map<Student, CourseGrade> getGradeMap(Clazz clazz, boolean addEmpty) {
        return this.clazzGradeService().getGrades(clazz, (Iterable)clazz.enrollment().courseTakers(), addEmpty);
    }

    public List<CourseTaker> getCourseTakers(Clazz clazz) {
        return ((IterableOnceOps)clazz.enrollment().courseTakers().sortBy((Function1 & Serializable)_$1 -> _$1.std().code(), (Ordering)Ordering.String$.MODULE$)).toList();
    }

    public Map<Student, CourseGrade> putGradeMap(Clazz clazz, Iterable<CourseTaker> takers) {
        Iterable<CourseTaker> courseTakers = takers == null ? this.getCourseTakers(clazz) : takers;
        ActionContext$.MODULE$.current().attribute("courseTakers", courseTakers);
        Map gradeMap = this.clazzGradeService().getGrades(clazz, courseTakers, true);
        ActionContext$.MODULE$.current().attribute("gradeMap", (Object)gradeMap);
        return gradeMap;
    }

    public void buildGradeConfig(Clazz clazz, CourseGradeState gradeState, Iterable<GradeType> gradeTypes) {
        scala.collection.mutable.Map gradingModes = Collections$.MODULE$.newMap();
        Set examTypes = Collections$.MODULE$.newSet();
        gradeTypes.foreach((Function1)(JProcedure1 & Serializable)gradeType -> {
            GradeState gradeTypeState = gradeState.getState(gradeType);
            if (gradeTypeState != null) {
                GradingMode gradingMode = gradeTypeState.gradingMode();
                if (gradingMode == null) {
                    gradeTypeState.gradingMode_$eq(gradeState.gradingMode());
                }
                gradeType.examType().foreach((Function1 & Serializable)et -> examTypes.add(et));
                return;
            }
        });
        gradeState.examStates().foreach((Function1 & Serializable)gradeTypeState -> gradingModes.put((Object)gradeTypeState.gradeType().id().toString(), (Object)gradeTypeState.gradingMode()));
        ActionContext$.MODULE$.current().attribute("gradingModes", (Object)gradingModes);
        ActionContext$.MODULE$.current().attribute("stdExamTypeMap", this.getStdExamTypeMap(clazz, (scala.collection.immutable.Set<ExamType>)examTypes.toSet()));
    }

    public Map<String, ExamTaker> getStdExamTypeMap(Clazz clazz, scala.collection.immutable.Set<ExamType> examTypes) {
        if (Collections$.MODULE$.isEmpty((Iterable)clazz.enrollment().courseTakers()) || examTypes.isEmpty()) {
            return Predef$.MODULE$.Map().empty();
        }
        OqlBuilder query = (OqlBuilder)OqlBuilder$.MODULE$.from(ExamTaker.class, "examTaker").where("examTaker.clazz=:clazz", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{clazz}));
        query.where("examTaker.examType in (:examTypes)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{examTypes}));
        scala.collection.mutable.Map stdExamTypeMap = Collections$.MODULE$.newMap();
        Seq examTakers = this.entityDao().search((QueryBuilder)query);
        examTakers.foreach((Function1 & Serializable)examTaker -> stdExamTypeMap.put((Object)(examTaker.std().id().toString() + "_" + examTaker.examType().id()), examTaker));
        return stdExamTypeMap.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public boolean populatePercent(CourseGradeState gradeState, Iterable<GradeType> gradeTypes) {
        BooleanRef updatePercent = BooleanRef.create((boolean)false);
        gradeTypes.withFilter((Function1 & Serializable)gradeType -> !gradeType.isGa()).foreach((Function1)(JProcedure1 & Serializable)gradeType -> {
            String prefix = "examGradeState" + gradeType.id();
            Params$.MODULE$.getShort(prefix + ".scorePercent").foreach((Function1 & Serializable)v1 -> {
                this.populatePercent$$anonfun$2$$anonfun$1(gradeState, (GradeType)gradeType, updatePercent, prefix, BoxesRunTime.unboxToShort((Object)v1));
                return BoxedUnit.UNIT;
            });
        });
        return updatePercent.elem;
    }

    public CourseGrade build(Clazz clazz, CourseGradeState gradeState, Option<CourseGrade> existed, CourseTaker taker, Iterable<GradeType> gradeTypes, int status, Instant updatedAt) {
        CourseGrade courseGrade;
        if (BoxesRunTime.unboxToInt((Object)taker.takeType().id()) == CourseTakeType$.MODULE$.Auditor()) {
            return null;
        }
        String operator = Securities$.MODULE$.user();
        Option<CourseGrade> option = existed;
        if (None$.MODULE$.equals(option)) {
            courseGrade = this.buildNewCourseGrade(taker, gradeState, status, updatedAt);
        } else if (option instanceof Some) {
            CourseGrade exist = (CourseGrade)((Some)option).value();
            if (BoxesRunTime.unboxToInt((Object)exist.courseTakeType().id()) == CourseTakeType$.MODULE$.Exemption()) {
                exist.clazz_$eq((Option)Some$.MODULE$.apply((Object)clazz));
                exist.crn_$eq(clazz.crn());
                return exist;
            }
            if (taker != null) {
                exist.courseTakeType_$eq(taker.takeType());
            }
            exist.gradingMode_$eq(gradeState.gradingMode());
            courseGrade = exist;
        } else {
            throw new MatchError(option);
        }
        CourseGrade grade = courseGrade;
        Params$.MODULE$.get("courseGrade.remark" + taker.std().id()).foreach((Function1)(JProcedure1 & Serializable)r -> grade.remark_$eq((Option)Some$.MODULE$.apply(r)));
        grade.operator_$eq((Option)Some$.MODULE$.apply((Object)operator));
        grade.updatedAt_$eq(updatedAt);
        gradeTypes.foreach((Function1)(JProcedure1 & Serializable)gradeType -> {
            if (!gradeType.isGa()) {
                ExamGradeState egs = (ExamGradeState)gradeState.getState(gradeType);
                Option percent = Params$.MODULE$.getShort("personPercent_" + gradeType.id() + "_" + taker.std().id());
                if (percent.isEmpty() && egs.scorePercent().nonEmpty()) {
                    percent = egs.scorePercent();
                }
                this.buildExamGrade(grade, (GradeType)gradeType, egs.gradingMode(), taker, status, (Option<Object>)percent, updatedAt, operator);
                return;
            }
        });
        if (Collections$.MODULE$.isEmpty((Iterable)grade.examGrades())) {
            return null;
        }
        boolean hasMakeup = gradeTypes.exists((Function1 & Serializable)_$2 -> _$2.isMakeupOrDeplay());
        GaGrade gaGrade = hasMakeup ? this.calculator().calcMakeupDelayGa(grade, gradeState) : this.calculator().calcEndGa(grade, gradeState);
        grade.gaGrades().foreach((Function1)(JProcedure1 & Serializable)gg -> {
            if (gradeTypes.toSeq().contains((Object)gg.gradeType())) {
                if (gg.status() < status) {
                    gg.status_$eq(status);
                    return;
                }
                return;
            }
        });
        if (clazz.examMode() != null) {
            grade.examMode_$eq(clazz.examMode());
        }
        if (grade.status() < status) {
            grade.status_$eq(status);
        }
        return grade;
    }

    public void buildExamGrade(CourseGrade grade, GradeType gradeType, GradingMode gradingMode, CourseTaker taker, int status, Option<Object> percent, Instant updatedAt, String operator) {
        String scoreInputName = BoxesRunTime.unboxToLong((Object)taker.std().id()) + "_" + gradeType.id();
        String examScoreStr = (String)Params$.MODULE$.get(scoreInputName).getOrElse(GradeInputHelper::$anonfun$2);
        int examStatusId = BoxesRunTime.unboxToInt((Object)Params$.MODULE$.getInt(scoreInputName + "_examStatus").getOrElse(GradeInputHelper::$anonfun$3));
        if (Strings$.MODULE$.isBlank((CharSequence)examScoreStr) && ExamStatus$.MODULE$.Normal() == examStatusId && BoxesRunTime.unboxToInt((Object)gradeType.id()) != GradeType$.MODULE$.EndGa()) {
            ExamGrade examGrade = (ExamGrade)grade.getExamGrade(gradeType).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            if (examGrade != null) {
                grade.examGrades().$minus$eq((Object)examGrade);
            }
            return;
        }
        Option examScore = Params$.MODULE$.getFloat(scoreInputName);
        ExamStatus examStatus = null;
        if (status == 2 && Strings$.MODULE$.isEmpty((CharSequence)examScoreStr) && examStatusId == ExamStatus$.MODULE$.Normal()) {
            examStatusId = ExamStatus$.MODULE$.Absent();
        }
        examStatus = (ExamStatus)this.entityDao().get(ExamStatus.class, (Object)BoxesRunTime.boxToInteger((int)examStatusId));
        ExamGrade examGrade = (ExamGrade)grade.getExamGrade(gradeType).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (examGrade == null) {
            examGrade = ExamGrade$.MODULE$.apply(gradeType, examStatus, examScore);
            examGrade.gradingMode_$eq(gradingMode);
            examGrade.status_$eq(status);
            grade.addExamGrade(examGrade);
        }
        examGrade.status_$eq(status);
        grade.updatedAt_$eq(updatedAt);
        examGrade.scorePercent_$eq(percent);
        examGrade.examStatus_$eq(examStatus);
        this.calculator().updateScore(examGrade, examScore, gradingMode);
    }

    public CourseGrade buildNewCourseGrade(CourseTaker taker, CourseGradeState gradeState, int status, Instant updatedAt) {
        CourseGrade grade = CourseGrade$.MODULE$.apply(taker);
        grade.gradingMode_$eq(gradeState.gradingMode());
        grade.status_$eq(status);
        grade.updatedAt_$eq(updatedAt);
        return grade;
    }

    private final /* synthetic */ void populatePercent$$anonfun$2$$anonfun$1(CourseGradeState gradeState$3, GradeType gradeType$1, BooleanRef updatePercent$2, String prefix$1, short percent) {
        ExamGradeState egs = (ExamGradeState)GradingModeStrategy$.MODULE$.getOrCreateState(gradeState$3, gradeType$1);
        if (egs.scorePercent().isEmpty() || percent != BoxesRunTime.unboxToShort((Object)egs.scorePercent().get())) {
            boolean bl;
            egs.scorePercent_$eq((Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)percent)));
            updatePercent$2.elem = bl = true;
        }
        Params$.MODULE$.getInt(prefix$1 + ".gradingMode.id").foreach((Function1)(JFunction1.mcVI.sp & Serializable)examGradingModeId -> egs.gradingMode_$eq((GradingMode)this.entityDao().get(GradingMode.class, (Object)BoxesRunTime.boxToInteger((int)examGradingModeId))));
    }

    private static final String $anonfun$2() {
        return "";
    }

    private static final int $anonfun$3() {
        return ExamStatus$.MODULE$.Normal();
    }
}

